/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.peer.DialogPeer;
import sun.awt.AxBridgeHelper;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

class WDialogPeer
extends WWindowPeer
implements DialogPeer {
    ModalLock modalLock = new ModalLock();

    WDialogPeer(Dialog dialog) {
        super(dialog);
    }

    native void create(WComponentPeer var1);

    native void showModal();

    native void endModal();

    native void nativeModalBlock();

    native void nativeModalWakeup();

    void initialize() {
        super.initialize();
        Dialog dialog = (Dialog)this.target;
        if (dialog.getTitle() != null) {
            this.setTitle(dialog.getTitle());
        }
        this.setResizable(dialog.isResizable());
    }

    public void show() {
        Dialog dialog = (Dialog)this.target;
        if (dialog.isModal()) {
            this.showModal();
            WToolkit.getWToolkit().notifyModalityChange(1300);
            if (AxBridgeHelper.isAppMainThread()) {
                this.nativeModalBlock();
                return;
            }
            this.modalLock.waitModal();
            return;
        }
        super.show();
    }

    public void hide() {
        Dialog dialog = (Dialog)this.target;
        if (dialog.isModal()) {
            WToolkit.getWToolkit().notifyModalityChange(1301);
            this.endModal();
            this.modalLock.endModal();
            this.nativeModalWakeup();
            return;
        }
        super.hide();
    }

    public Dimension getMinimumSize() {
        return new Dimension(WWindowPeer.getSysMinWidth(), WWindowPeer.getSysMinHeight());
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.reshapeFrame(n, n2, n3, n4);
    }

    private void setDefaultColor(boolean bl) {
        SystemColor systemColor = bl ? SystemColor.control : SystemColor.window;
        ((Dialog)this.target).setBackground(systemColor);
    }

    class ModalLock {
        synchronized void waitModal() {
            try {
                this.wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        synchronized void endModal() {
            this.notifyAll();
        }

        ModalLock() {
            WDialogPeer.this = WDialogPeer.this;
        }
    }
}

