/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import sun.tools.asm.CatchData;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.Cover;
import sun.tools.asm.Instruction;
import sun.tools.asm.Label;
import sun.tools.asm.LocalVariable;
import sun.tools.asm.LocalVariableTable;
import sun.tools.asm.SwitchData;
import sun.tools.asm.TryData;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.javac.SourceClass;

public final class Assembler
implements Constants {
    static final int NOTREACHED = 0;
    static final int REACHED = 1;
    static final int NEEDED = 2;
    Label first = new Label();
    Instruction last = this.first;
    int maxdepth;
    int maxvar;
    int maxpc;
    static Vector TableLot = new Vector();
    static Vector SourceClassList = new Vector();
    static int count;
    static int countclass;
    static int countmeth;
    static Vector TmpCovTable;

    public void add(Instruction instruction) {
        if (instruction != null) {
            this.last.next = instruction;
            this.last = instruction;
        }
    }

    public void add(int n, int n2) {
        this.add(new Instruction(n, n2, null));
    }

    public void add(int n, int n2, Object object) {
        this.add(new Instruction(n, n2, object));
    }

    public void add(int n, int n2, Object object, boolean bl) {
        this.add(new Instruction(n, n2, object, bl));
    }

    public void add(boolean bl, int n, int n2, Object object) {
        this.add(new Instruction(bl, n, n2, object));
    }

    public void add(int n, int n2, boolean bl) {
        this.add(new Instruction(n, n2, bl));
    }

    void optimize(Environment environment, Label label) {
        label.pc = 1;
        Instruction instruction = label.next;
        while (instruction != null) {
            switch (instruction.pc) {
                case 0: {
                    instruction.optimize(environment);
                    instruction.pc = 1;
                    break;
                }
                case 1: {
                    return;
                }
            }
            switch (instruction.opc) {
                case -2: 
                case -1: {
                    if (instruction.pc != 1) break;
                    instruction.pc = 0;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.optimize(environment, (Label)instruction.value);
                    break;
                }
                case 167: {
                    this.optimize(environment, (Label)instruction.value);
                    return;
                }
                case 168: {
                    this.optimize(environment, (Label)instruction.value);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 170: 
                case 171: {
                    Object object = (SwitchData)instruction.value;
                    this.optimize(environment, ((SwitchData)object).defaultLabel);
                    Enumeration<Object> enumeration = ((SwitchData)object).tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.optimize(environment, (Label)enumeration.nextElement());
                    }
                    return;
                }
                case -3: {
                    Object object = (TryData)instruction.value;
                    ((TryData)object).getEndLabel().pc = 2;
                    Enumeration<Object> enumeration = ((TryData)object).catches.elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.optimize(environment, catchData.getLabel());
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    boolean eliminate() {
        boolean bl = false;
        Instruction instruction = this.first;
        Instruction instruction2 = this.first.next;
        while (instruction2 != null) {
            if (instruction2.pc != 0) {
                instruction.next = instruction2;
                instruction = instruction2;
                instruction2.pc = 0;
            } else {
                bl = true;
            }
            instruction2 = instruction2.next;
        }
        this.first.pc = 0;
        instruction.next = null;
        return bl;
    }

    public void optimize(Environment environment) {
        do {
            this.optimize(environment, this.first);
        } while (this.eliminate() && environment.optimize());
    }

    public void collect(Environment environment, FieldDefinition fieldDefinition, ConstantPool constantPool) {
        Object object;
        if (fieldDefinition != null && environment.debug() && fieldDefinition.getArguments() != null) {
            object = fieldDefinition.getArguments().elements();
            while (object.hasMoreElements()) {
                FieldDefinition fieldDefinition2 = (FieldDefinition)object.nextElement();
                constantPool.put(fieldDefinition2.getName().toString());
                constantPool.put(fieldDefinition2.getType().getTypeSignature());
            }
        }
        object = this.first;
        while (object != null) {
            ((Instruction)object).collect(constantPool);
            object = ((Instruction)object).next;
        }
    }

    void balance(Label label, int n) {
        Instruction instruction = label;
        while (instruction != null) {
            if ((n += instruction.balance()) < 0) {
                throw new CompilerError("stack under flow: " + instruction.toString() + " = " + n);
            }
            if (n > this.maxdepth) {
                this.maxdepth = n;
            }
            switch (instruction.opc) {
                case -1: {
                    label = instruction;
                    if (instruction.pc == 1) {
                        if (label.depth != n) {
                            throw new CompilerError("stack depth error " + n + "/" + label.depth + ": " + instruction.toString());
                        }
                        return;
                    }
                    label.pc = 1;
                    label.depth = n;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.balance((Label)instruction.value, n);
                    break;
                }
                case 167: {
                    this.balance((Label)instruction.value, n);
                    return;
                }
                case 168: {
                    this.balance((Label)instruction.value, n + 1);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    int n2 = (instruction.value instanceof Number ? ((Number)instruction.value).intValue() : ((LocalVariable)instruction.value).slot) + 1;
                    if (n2 <= this.maxvar) break;
                    this.maxvar = n2;
                    break;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    int n3 = (instruction.value instanceof Number ? ((Number)instruction.value).intValue() : ((LocalVariable)instruction.value).slot) + 2;
                    if (n3 <= this.maxvar) break;
                    this.maxvar = n3;
                    break;
                }
                case 132: {
                    int n4 = ((int[])instruction.value)[0] + 1;
                    if (n4 <= this.maxvar) break;
                    this.maxvar = n4 + 1;
                    break;
                }
                case 170: 
                case 171: {
                    SwitchData switchData = (SwitchData)instruction.value;
                    this.balance(switchData.defaultLabel, n);
                    Enumeration<Object> enumeration = switchData.tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.balance((Label)enumeration.nextElement(), n);
                    }
                    return;
                }
                case -3: {
                    TryData tryData = (TryData)instruction.value;
                    Enumeration<Object> enumeration = tryData.catches.elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.balance(catchData.getLabel(), n + 1);
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    public void write(Environment environment, DataOutputStream dataOutputStream, FieldDefinition fieldDefinition, ConstantPool constantPool) throws IOException {
        Constants constants;
        Object object;
        int n;
        if (fieldDefinition != null && fieldDefinition.getArguments() != null) {
            n = 0;
            Vector vector = fieldDefinition.getArguments();
            object = vector.elements();
            while (object.hasMoreElements()) {
                constants = (FieldDefinition)object.nextElement();
                n += ((FieldDefinition)constants).getType().stackSize();
            }
            this.maxvar = n;
        }
        try {
            this.balance(this.first, 0);
        }
        catch (CompilerError compilerError) {
            System.out.println("ERROR: " + compilerError);
            this.listing(System.out);
            throw compilerError;
        }
        n = 0;
        int n2 = 0;
        object = this.first;
        while (object != null) {
            ((Instruction)object).pc = n;
            n += ((Instruction)object).size(constantPool);
            if (((Instruction)object).opc == -3) {
                n2 += ((TryData)((Instruction)object).value).catches.size();
            }
            object = ((Instruction)object).next;
        }
        dataOutputStream.writeShort(this.maxdepth);
        dataOutputStream.writeShort(this.maxvar);
        this.maxpc = n;
        dataOutputStream.writeInt(this.maxpc);
        constants = this.first.next;
        while (constants != null) {
            ((Instruction)constants).write(dataOutputStream, constantPool);
            constants = ((Instruction)constants).next;
        }
        dataOutputStream.writeShort(n2);
        if (n2 > 0) {
            this.writeExceptions(environment, dataOutputStream, constantPool, this.first, this.last);
        }
    }

    void writeExceptions(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool, Instruction instruction, Instruction instruction2) throws IOException {
        Instruction instruction3 = instruction;
        while (instruction3 != instruction2.next) {
            if (instruction3.opc == -3) {
                TryData tryData = (TryData)instruction3.value;
                this.writeExceptions(environment, dataOutputStream, constantPool, instruction3.next, tryData.getEndLabel());
                Enumeration enumeration = tryData.catches.elements();
                while (enumeration.hasMoreElements()) {
                    CatchData catchData = (CatchData)enumeration.nextElement();
                    dataOutputStream.writeShort(instruction3.pc);
                    dataOutputStream.writeShort(tryData.getEndLabel().pc);
                    dataOutputStream.writeShort(catchData.getLabel().pc);
                    if (catchData.getType() != null) {
                        dataOutputStream.writeShort(constantPool.index(catchData.getType()));
                        continue;
                    }
                    dataOutputStream.writeShort(0);
                }
                instruction3 = tryData.getEndLabel();
            }
            instruction3 = instruction3.next;
        }
    }

    public void writeCoverageTable(Environment environment, ClassDefinition classDefinition, DataOutputStream dataOutputStream, ConstantPool constantPool, int n) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = ((SourceClass)classDefinition).getWhere();
        int[] nArray = new int[20];
        int n3 = 0;
        countmeth = count;
        Instruction instruction = this.first;
        while (instruction != null) {
            int n4;
            int n5 = instruction.where >> 18;
            if (n5 > 0 && instruction.opc != -1) {
                if (!bl2) {
                    if (n2 == instruction.where) {
                        TableLot.addElement(new Cover(2, n, instruction.pc));
                    } else {
                        TableLot.addElement(new Cover(1, n, instruction.pc));
                    }
                    ++count;
                    bl2 = true;
                }
                if (!bl && !instruction.flagNoCovered) {
                    boolean bl3 = false;
                    n4 = 0;
                    while (n4 < n3) {
                        if (nArray[n4] == instruction.where) {
                            bl3 = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl3) {
                        TableLot.addElement(new Cover(3, instruction.where, instruction.pc));
                        ++count;
                        bl = true;
                    }
                }
            }
            switch (instruction.opc) {
                case -1: {
                    bl = false;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    if (instruction.flagCondInverted) {
                        TableLot.addElement(new Cover(7, instruction.where, instruction.pc));
                        TableLot.addElement(new Cover(8, instruction.where, instruction.pc));
                    } else {
                        TableLot.addElement(new Cover(8, instruction.where, instruction.pc));
                        TableLot.addElement(new Cover(7, instruction.where, instruction.pc));
                    }
                    count += 2;
                    bl = false;
                    break;
                }
                case 167: {
                    bl = false;
                    break;
                }
                case -3: {
                    nArray[n3++] = instruction.where;
                    bl = false;
                    break;
                }
                case 170: {
                    SwitchData switchData = (SwitchData)instruction.value;
                    n4 = switchData.minValue;
                    while (n4 <= switchData.maxValue) {
                        TableLot.addElement(new Cover(5, switchData.whereCase(n4), instruction.pc));
                        ++count;
                        ++n4;
                    }
                    if (!switchData.getDefault()) {
                        TableLot.addElement(new Cover(6, instruction.where, instruction.pc));
                        ++count;
                    }
                    bl = false;
                    break;
                }
                case 171: {
                    SwitchData switchData = (SwitchData)instruction.value;
                    Enumeration enumeration = switchData.sortedKeys();
                    while (enumeration.hasMoreElements()) {
                        Integer n6 = (Integer)enumeration.nextElement();
                        TableLot.addElement(new Cover(5, switchData.whereCase(n6), instruction.pc));
                        ++count;
                    }
                    if (!switchData.getDefault()) {
                        TableLot.addElement(new Cover(6, instruction.where, instruction.pc));
                        ++count;
                    }
                    bl = false;
                    break;
                }
            }
            instruction = instruction.next;
        }
        dataOutputStream.writeShort(count - countmeth);
        int n7 = countmeth;
        while (n7 < count) {
            Cover cover = (Cover)TableLot.elementAt(n7);
            int n8 = cover.Addr >> 18;
            int n9 = cover.Addr << 14 >> 14;
            dataOutputStream.writeShort(cover.NumCommand);
            dataOutputStream.writeShort(cover.Type);
            dataOutputStream.writeInt(cover.Addr);
            ++n7;
        }
    }

    public void GenVecJCov(Environment environment, ClassDefinition classDefinition, long l) {
        String string = ((SourceClass)classDefinition).getAbsoluteName();
        String string2 = ((SourceClass)classDefinition).getName().toString();
        TmpCovTable.addElement("CLASS: " + string2);
        SourceClassList.addElement(string2);
        TmpCovTable.addElement("SRCFILE: " + string);
        TmpCovTable.addElement("TIMESTAMP: " + l);
        TmpCovTable.addElement("#flag\tline\tposition");
        int n = countclass;
        while (n < count) {
            Cover cover = (Cover)TableLot.elementAt(n);
            if (cover.Type != 5 || cover.Addr != 0) {
                int n2 = cover.Addr >> 18;
                int n3 = cover.Addr << 14 >> 14;
                TmpCovTable.addElement(new String(String.valueOf(cover.Type) + "\t" + n2 + "\t" + n3));
            }
            ++n;
        }
        countclass = 0;
        count = 0;
        TableLot.removeAllElements();
    }

    public void GenJCov(Environment environment) {
        try {
            Object object;
            Closeable closeable;
            File file = environment.getcovFile();
            if (file.exists()) {
                closeable = new DataInputStream(new FileInputStream(file));
                object = null;
                boolean bl = true;
                ((DataInputStream)closeable).readLine();
                while ((object = ((DataInputStream)closeable).readLine()) != null) {
                    if (((String)object).indexOf("CLASS: ") != -1) {
                        bl = true;
                        Enumeration enumeration = SourceClassList.elements();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            if (string.compareTo(((String)object).substring(7)) != 0) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (!bl) continue;
                    TmpCovTable.addElement(object);
                }
                ((FilterInputStream)closeable).close();
            }
            closeable = new PrintStream(new DataOutputStream(new FileOutputStream(file)));
            ((PrintStream)closeable).println("JCOV-DATA-FILE-VERSION: 1.0");
            object = TmpCovTable.elements();
            while (object.hasMoreElements()) {
                ((PrintStream)closeable).println(object.nextElement());
            }
            ((PrintStream)closeable).close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: " + fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            System.out.println("ERROR: " + iOException);
            return;
        }
    }

    public void writeLineNumberTable(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        int n = -1;
        int n2 = 0;
        Instruction instruction = this.first;
        while (instruction != null) {
            int n3 = instruction.where >> 18;
            if (n3 > 0 && n != n3) {
                n = n3;
                ++n2;
            }
            instruction = instruction.next;
        }
        n = -1;
        dataOutputStream.writeShort(n2);
        Instruction instruction2 = this.first;
        while (instruction2 != null) {
            int n4 = instruction2.where >> 18;
            if (n4 > 0 && n != n4) {
                n = n4;
                dataOutputStream.writeShort(instruction2.pc);
                dataOutputStream.writeShort(n);
            }
            instruction2 = instruction2.next;
        }
    }

    void flowFields(Environment environment, Label label, FieldDefinition[] fieldDefinitionArray) {
        if (label.locals != null) {
            FieldDefinition[] fieldDefinitionArray2 = label.locals;
            int n = 0;
            while (n < this.maxvar) {
                if (fieldDefinitionArray2[n] != fieldDefinitionArray[n]) {
                    fieldDefinitionArray2[n] = null;
                }
                ++n;
            }
            return;
        }
        label.locals = new FieldDefinition[this.maxvar];
        System.arraycopy(fieldDefinitionArray, 0, label.locals, 0, this.maxvar);
        FieldDefinition[] fieldDefinitionArray3 = new FieldDefinition[this.maxvar];
        System.arraycopy(fieldDefinitionArray, 0, fieldDefinitionArray3, 0, this.maxvar);
        fieldDefinitionArray = fieldDefinitionArray3;
        Instruction instruction = label.next;
        while (instruction != null) {
            switch (instruction.opc) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (!(instruction.value instanceof LocalVariable)) break;
                    Object object = (LocalVariable)instruction.value;
                    fieldDefinitionArray[((LocalVariable)object).slot] = ((LocalVariable)object).field;
                    break;
                }
                case -1: {
                    this.flowFields(environment, (Label)instruction, fieldDefinitionArray);
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 168: 
                case 198: 
                case 199: {
                    this.flowFields(environment, (Label)instruction.value, fieldDefinitionArray);
                    break;
                }
                case 167: {
                    this.flowFields(environment, (Label)instruction.value, fieldDefinitionArray);
                    return;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 170: 
                case 171: {
                    Object object = (SwitchData)instruction.value;
                    this.flowFields(environment, ((SwitchData)object).defaultLabel, fieldDefinitionArray);
                    Enumeration<Object> enumeration = ((SwitchData)object).tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.flowFields(environment, (Label)enumeration.nextElement(), fieldDefinitionArray);
                    }
                    return;
                }
                case -3: {
                    Object object = ((TryData)instruction.value).catches;
                    Enumeration<Object> enumeration = ((Vector)object).elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.flowFields(environment, catchData.getLabel(), fieldDefinitionArray);
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    public void writeLocalVariableTable(Environment environment, FieldDefinition fieldDefinition, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        FieldDefinition[] fieldDefinitionArray;
        Object object;
        Object object2;
        Object object3;
        FieldDefinition[] fieldDefinitionArray2 = new FieldDefinition[this.maxvar];
        int n = 0;
        if (fieldDefinition != null && fieldDefinition.getArguments() != null) {
            int n2 = 0;
            object3 = fieldDefinition.getArguments();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (FieldDefinition)object2.nextElement();
                fieldDefinitionArray2[n2] = object;
                n2 += ((FieldDefinition)object).getType().stackSize();
            }
        }
        this.flowFields(environment, this.first, fieldDefinitionArray2);
        LocalVariableTable localVariableTable = new LocalVariableTable();
        n = 0;
        while (n < this.maxvar) {
            fieldDefinitionArray2[n] = null;
            ++n;
        }
        if (fieldDefinition != null && fieldDefinition.getArguments() != null) {
            int n3 = 0;
            object2 = fieldDefinition.getArguments();
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                fieldDefinitionArray = (FieldDefinition[])object.nextElement();
                fieldDefinitionArray2[n3] = fieldDefinitionArray;
                localVariableTable.define((FieldDefinition)fieldDefinitionArray, n3, 0, this.maxpc);
                n3 += fieldDefinitionArray.getType().stackSize();
            }
        }
        object3 = new int[this.maxvar];
        object2 = this.first;
        while (object2 != null) {
            switch (((Instruction)object2).opc) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int n4;
                    if (!(((Instruction)object2).value instanceof LocalVariable)) break;
                    LocalVariable localVariable = (LocalVariable)((Instruction)object2).value;
                    int n5 = n4 = ((Instruction)object2).next != null ? ((Instruction)object2).next.pc : ((Instruction)object2).pc;
                    if (fieldDefinitionArray2[localVariable.slot] != null) {
                        localVariableTable.define(fieldDefinitionArray2[localVariable.slot], localVariable.slot, (int)object3[localVariable.slot], n4);
                    }
                    object3[localVariable.slot] = n4;
                    fieldDefinitionArray2[localVariable.slot] = localVariable.field;
                    break;
                }
                case -1: {
                    n = 0;
                    while (n < this.maxvar) {
                        if (fieldDefinitionArray2[n] != null) {
                            localVariableTable.define(fieldDefinitionArray2[n], n, (int)object3[n], ((Instruction)object2).pc);
                        }
                        ++n;
                    }
                    int n6 = ((Instruction)object2).pc;
                    fieldDefinitionArray = ((Label)object2).locals;
                    if (fieldDefinitionArray == null) {
                        n = 0;
                        while (n < this.maxvar) {
                            fieldDefinitionArray2[n] = null;
                            ++n;
                        }
                    } else {
                        System.arraycopy(fieldDefinitionArray, 0, fieldDefinitionArray2, 0, this.maxvar);
                    }
                    n = 0;
                    while (n < this.maxvar) {
                        object3[n] = n6;
                        ++n;
                    }
                    break;
                }
            }
            object2 = ((Instruction)object2).next;
        }
        n = 0;
        while (n < this.maxvar) {
            if (fieldDefinitionArray2[n] != null) {
                localVariableTable.define(fieldDefinitionArray2[n], n, (int)object3[n], this.maxpc);
            }
            ++n;
        }
        localVariableTable.write(environment, dataOutputStream, constantPool);
    }

    public boolean empty() {
        return this.first == this.last;
    }

    public void listing(PrintStream printStream) {
        printStream.println("-- listing --");
        Instruction instruction = this.first;
        while (instruction != null) {
            printStream.println(((Instruction)instruction).toString());
            instruction = instruction.next;
        }
    }

    static {
        TmpCovTable = new Vector();
    }
}

