/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.LocalVariable;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;

final class LocalVariableTable {
    LocalVariable[] locals = new LocalVariable[8];
    int len;

    void define(FieldDefinition fieldDefinition, int n, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        int n4 = 0;
        while (n4 < this.len) {
            if (this.locals[n4].field == fieldDefinition && this.locals[n4].slot == n && n2 <= this.locals[n4].to && n3 >= this.locals[n4].from) {
                this.locals[n4].from = Math.min(this.locals[n4].from, n2);
                this.locals[n4].to = Math.max(this.locals[n4].to, n3);
                return;
            }
            ++n4;
        }
        if (this.len == this.locals.length) {
            LocalVariable[] localVariableArray = new LocalVariable[this.len * 2];
            System.arraycopy(this.locals, 0, localVariableArray, 0, this.len);
            this.locals = localVariableArray;
        }
        this.locals[this.len++] = new LocalVariable(fieldDefinition, n, n2, n3);
    }

    private void trim_ranges() {
        int n = 0;
        while (n < this.len) {
            int n2 = n + 1;
            while (n2 < this.len) {
                if (this.locals[n].field.getName() == this.locals[n2].field.getName() && this.locals[n].from <= this.locals[n2].to && this.locals[n].to >= this.locals[n2].from) {
                    if (this.locals[n].slot < this.locals[n2].slot) {
                        if (this.locals[n].from < this.locals[n2].from) {
                            this.locals[n].to = Math.min(this.locals[n].to, this.locals[n2].from);
                        }
                    } else if (this.locals[n].slot > this.locals[n2].slot && this.locals[n].from > this.locals[n2].from) {
                        this.locals[n2].to = Math.min(this.locals[n2].to, this.locals[n].from);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    void write(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        this.trim_ranges();
        dataOutputStream.writeShort(this.len);
        int n = 0;
        while (n < this.len) {
            dataOutputStream.writeShort(this.locals[n].from);
            dataOutputStream.writeShort(this.locals[n].to - this.locals[n].from);
            dataOutputStream.writeShort(constantPool.index(this.locals[n].field.getName().toString()));
            dataOutputStream.writeShort(constantPool.index(this.locals[n].field.getType().getTypeSignature()));
            dataOutputStream.writeShort(this.locals[n].slot);
            ++n;
        }
    }

    LocalVariableTable() {
    }
}

