/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.debug.AgentConstants;
import sun.tools.debug.AgentOutputStream;
import sun.tools.debug.BreakpointHandler;
import sun.tools.debug.BreakpointQueue;
import sun.tools.debug.BreakpointSet;
import sun.tools.debug.CommandThread;
import sun.tools.debug.Field;
import sun.tools.debug.LineNumber;
import sun.tools.debug.MainThread;
import sun.tools.debug.ResponseStream;
import sun.tools.debug.StackFrame;
import sun.tools.debug.StepHandler;
import sun.tools.debug.ThreadList;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;
import sun.tools.java.Package;

class Agent
implements Runnable,
AgentConstants {
    static Agent the_Agent = null;
    ServerSocket socket;
    boolean useSockets;
    DataOutputStream asyncOutputStream;
    PipedInputStream cmdInputPipe;
    PipedOutputStream cmdOutputPipe;
    PipedOutputStream asyncOutputPipe;
    Hashtable objects;
    private BreakpointHandler bkptHandler;
    StepHandler stepHandler;
    private AgentOutputStream agentOut;
    static boolean runBegun;
    static Object runBegunLock;
    private DataOutputStream out;
    private ResponseStream outBuffer;
    private ClassPath sourcePath;
    private Object pipeLock = new Object();
    static boolean verbose;
    private ThreadList lastSuspended;
    volatile boolean debuggerTerminating = false;

    static String toHex(int n) {
        char[] cArray = new char[10];
        int n2 = 0;
        while (n2 < 10) {
            cArray[n2] = 48;
            ++n2;
        }
        cArray[1] = 120;
        int n3 = 9;
        while (n != 0) {
            int n4 = n & 0xF;
            cArray[n3] = (char)(n4 < 10 ? 48 + n4 : 97 + n4 - 10);
            n >>>= 4;
            --n3;
        }
        return new String(cArray);
    }

    private void dumpClasses() throws IOException {
        Agent.message("dumpClasses()");
        Enumeration<Object> enumeration = this.objects.elements();
        Vector vector = new Vector();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            try {
                Object v = enumeration.nextElement();
                if (v == null || !(v instanceof Class)) continue;
                vector.addElement(v);
                ++n;
            }
            catch (Exception exception) {
                Agent.error("dumpClasses() failed: " + exception.toString());
            }
        }
        this.out.writeInt(n);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.writeObject(enumeration.nextElement());
        }
    }

    private String cookieToString(int n) {
        int n2;
        int n3 = "23456789abcdefghijkmnpqrstuvwxyz".length();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(32);
        while (n > 0) {
            if (n < n3) {
                stringBuffer.append("23456789abcdefghijkmnpqrstuvwxyz".charAt(n));
                n = 0;
            } else {
                n2 = n % n3;
                n /= n3;
                stringBuffer.append("23456789abcdefghijkmnpqrstuvwxyz".charAt(n2));
            }
            ++n4;
        }
        if (n4 > 0) {
            n2 = stringBuffer.length();
            char[] cArray = new char[n2];
            int n5 = 0;
            while (n2-- > 0) {
                cArray[n2] = stringBuffer.charAt(n5++);
            }
            return String.valueOf(cArray);
        }
        return "0";
    }

    private String makePassword(int n) {
        if (n > 65535) {
            System.err.println("Invalid port number (" + n + ")???");
            System.exit(1);
        }
        int n2 = (int)(Math.round(Math.random() * 2048.0) % 2048L);
        int n3 = 0;
        int n4 = 3;
        int n5 = 0;
        while (n5 < 8) {
            int n6 = (n & n4) << n5 + 1;
            int n7 = (n2 & 1 << n5) << n5 * 2;
            n3 |= n6 | n7;
            n4 <<= 2;
            ++n5;
        }
        return this.cookieToString(n3 |= (n2 & 0x700) << 16);
    }

    Agent() {
        this.useSockets = false;
        the_Agent = this;
    }

    Agent(int n) {
        this.useSockets = true;
        the_Agent = this;
        int n2 = 0;
        while (true) {
            try {
                this.socket = new ServerSocket(n, 10);
                System.out.println("Agent password=" + this.makePassword(this.socket.getLocalPort()));
                return;
            }
            catch (Exception exception) {
                Agent.message("[Waiting to create port]\n");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (n2 >= 10) {
                    Agent.error("**Failed to create port\n");
                    return;
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    static void beginRun() {
        Object object = runBegunLock;
        synchronized (object) {
            runBegun = true;
            runBegunLock.notifyAll();
            return;
        }
    }

    static synchronized void connectToAgent(PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, PipedInputStream pipedInputStream2) throws IOException {
        if (the_Agent == null || Agent.the_Agent.useSockets) {
            throw new IllegalAccessError();
        }
        Agent.the_Agent.cmdInputPipe = new PipedInputStream(pipedOutputStream);
        Agent.the_Agent.cmdOutputPipe = new PipedOutputStream(pipedInputStream);
        Agent.the_Agent.asyncOutputPipe = new PipedOutputStream(pipedInputStream2);
        Object object = Agent.the_Agent.pipeLock;
        synchronized (object) {
            Agent.the_Agent.pipeLock.notifyAll();
            return;
        }
    }

    static boolean isDebuggable() {
        return the_Agent != null && !Agent.the_Agent.useSockets;
    }

    public void run() {
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        Socket socket = null;
        Socket socket2 = null;
        String string = System.getProperty("java.class.path");
        if (string == null) {
            string = ".";
        }
        this.sourcePath = new ClassPath(string);
        try {
            this.objects = new Hashtable();
            this.bkptHandler = new BreakpointHandler(this);
            this.bkptHandler.setPriority(9);
            this.stepHandler = new StepHandler(this, this.bkptHandler);
            this.stepHandler.start();
            this.bkptHandler.start();
            this.initAgent();
            Class<?> clazz = this.getClass();
            Object object = clazz;
            synchronized (object) {
                clazz.notifyAll();
            }
            Agent.initSystemThreadList();
            while (true) {
                Object object2;
                printStream = System.out;
                printStream2 = System.err;
                if (this.useSockets) {
                    socket = this.socket.accept();
                    Agent.message("cmd socket: " + socket.toString());
                    object = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                    this.outBuffer = new ResponseStream(socket.getOutputStream(), 8192);
                    this.out = new DataOutputStream(this.outBuffer);
                    socket2 = this.socket.accept();
                    this.asyncOutputStream = new DataOutputStream(new BufferedOutputStream(socket2.getOutputStream()));
                    this.agentOut = new AgentOutputStream(this.asyncOutputStream);
                    object2 = new BufferedOutputStream(this.agentOut, 128);
                    PrintStream printStream3 = new PrintStream((OutputStream)object2, true);
                    System.setOut(printStream3);
                    System.setErr(printStream3);
                } else {
                    try {
                        object2 = Agent.the_Agent.pipeLock;
                        synchronized (object2) {
                            Agent.the_Agent.pipeLock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    object = new DataInputStream(this.cmdInputPipe);
                    this.outBuffer = new ResponseStream(this.cmdOutputPipe, 8192);
                    this.out = new DataOutputStream(this.outBuffer);
                    this.asyncOutputStream = new DataOutputStream(this.asyncOutputPipe);
                    this.agentOut = new AgentOutputStream(this.asyncOutputStream);
                    object2 = new PrintStream(this.agentOut, true);
                    System.setOut((PrintStream)object2);
                    System.setErr((PrintStream)object2);
                }
                Agent.message("connection accepted");
                this.out.writeInt(3);
                try {
                    this.writeObject(Class.forName("java.lang.Object"));
                    this.writeObject(Class.forName("java.lang.Class"));
                    this.writeObject(Class.forName("java.lang.String"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.exit(1);
                }
                this.dumpClasses();
                this.writeObject(Thread.currentThread().getThreadGroup());
                this.out.flush();
                try {
                    int n = ((FilterInputStream)object).read();
                    while (n != -1) {
                        try {
                            this.handle(n, (DataInputStream)object, this.out);
                        }
                        catch (Throwable throwable) {
                            Agent.error(this.exceptionStackTrace(throwable));
                            this.outBuffer.reset();
                            this.out.writeInt(-2);
                            this.out.writeUTF(throwable.toString());
                        }
                        this.out.flush();
                        n = ((FilterInputStream)object).read();
                    }
                }
                catch (Exception exception) {
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    Agent.error(this.exceptionStackTrace(exception));
                }
                System.setOut(printStream);
                System.setErr(printStream2);
                Agent.message("connection closed");
            }
        }
        catch (ThreadDeath threadDeath) {
            System.setOut(printStream);
            System.setErr(printStream2);
            Agent.message("ThreadDeath caught.");
        }
        catch (IOException iOException) {
            System.setOut(printStream);
            System.setErr(printStream2);
            Agent.message("IOException caught.");
        }
        if (socket2 != null) {
            try {
                socket2.close();
            }
            catch (Exception exception) {}
        }
        if (socket != null) {
            try {
                socket.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public static synchronized native boolean systemThread(Thread var0);

    private static void initSystemThread(String string) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (!threadGroup.getName().equals("system")) {
            Agent.error("findThread called from wrong threadgroup");
            return;
        }
        Thread[] threadArray = new Thread[40];
        int n = threadGroup.enumerate(threadArray, false);
        int n2 = 0;
        while (n2 < n) {
            if (threadArray[n2].getName().equals(string)) {
                Agent.message("adding " + string + " to system thread list");
                Agent.addSystemThread(threadArray[n2]);
                return;
            }
            ++n2;
        }
        Agent.message(String.valueOf(string) + " not found in system threadgroup");
    }

    private static void initSystemThreadList() {
        Agent.initSystemThread("Idle thread");
        Agent.initSystemThread("Clock");
        Agent.initSystemThread("Debugger agent");
        Agent.initSystemThread("Breakpoint handler");
        Agent.initSystemThread("Step handler");
        Agent.initSystemThread("Finalizer thread");
    }

    public static synchronized native void addSystemThread(Thread var0);

    public static synchronized native void removeSystemThread(Thread var0);

    public static native void suspendListOfThreads(int var0, Thread[] var1);

    public static native void suspendSpecificThread(Thread var0);

    void suspendAllThreads() {
        Agent.message("suspendAllThreads()");
        ThreadList threadList = new ThreadList();
        BreakpointQueue breakpointQueue = BreakpointHandler.the_bkptQ;
        synchronized (breakpointQueue) {
            DataOutputStream dataOutputStream = this.asyncOutputStream;
            synchronized (dataOutputStream) {
                Agent.suspendListOfThreads(threadList.count, threadList.threads);
                this.lastSuspended = threadList;
            }
            return;
        }
    }

    void suspendSingleThread(Thread thread) {
        if (!Agent.systemThread(thread)) {
            BreakpointQueue breakpointQueue = BreakpointHandler.the_bkptQ;
            synchronized (breakpointQueue) {
                DataOutputStream dataOutputStream = this.asyncOutputStream;
                synchronized (dataOutputStream) {
                    Agent.suspendSpecificThread(thread);
                }
                return;
            }
        }
    }

    void resumeLastSuspendedThreads() {
        ThreadList threadList = this.lastSuspended;
        this.lastSuspended = null;
        if (threadList == null) {
            Agent.message("no last suspended to resume");
            return;
        }
        Agent.message("resumeLastSuspendedThreads()");
        int n = 0;
        while (n < threadList.count) {
            this.resumeThread(threadList.threads[n]);
            ++n;
        }
    }

    private void resumeThread(Thread thread) {
        if (!Agent.systemThread(thread)) {
            try {
                thread.resume();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("resume failed: " + illegalThreadStateException.getMessage());
                return;
            }
        }
    }

    int peekSafely(int n) {
        return this.peek(n);
    }

    private native int peek(int var1);

    native int getThreadStatus(Thread var1);

    native StackFrame getStackFrame(Thread var1, int var2);

    native Field[] getMethods(Class var1);

    native Field[] getFields(Class var1);

    native Class[] getClasses();

    native Object getSlotObject(Object var1, int var2);

    native int[] getSlotSignature(Class var1, int var2);

    native boolean getSlotBoolean(Object var1, int var2);

    native int getSlotInt(Object var1, int var2);

    native long getSlotLong(Object var1, int var2);

    native double getSlotDouble(Object var1, int var2);

    native Object[] getSlotArray(Object var1, int var2);

    native Object getStackObject(Thread var1, int var2, int var3);

    native boolean getStackBoolean(Thread var1, int var2, int var3);

    native int getStackInt(Thread var1, int var2, int var3);

    native long getStackLong(Thread var1, int var2, int var3);

    native float getStackFloat(Thread var1, int var2, int var3);

    native double getStackDouble(Thread var1, int var2, int var3);

    native Object[] getStackArray(Thread var1, int var2, int var3);

    native LineNumber lineno2pc(Class var1, int var2);

    native int pc2lineno(Class var1, int var2);

    native int method2pc(Class var1, int var2);

    native String exceptionStackTrace(Throwable var1);

    native void setSingleStep(Thread var1, boolean var2);

    native boolean getSingleStep(Thread var1);

    native void initAgent();

    native String getClassSourceName(Class var1);

    native int[] getLinenumbers(Class var1);

    native int getMethodLinenumber(Class var1, int var2);

    native void setSlotBoolean(Object var1, int var2, boolean var3);

    native void setSlotInt(Object var1, int var2, int var3);

    native void setSlotLong(Object var1, int var2, long var3);

    native void setSlotDouble(Object var1, int var2, double var3);

    native void setStackBoolean(Thread var1, int var2, int var3, boolean var4);

    native void setStackInt(Thread var1, int var2, int var3, int var4);

    native void setStackLong(Thread var1, int var2, int var3, long var4);

    native void setStackDouble(Thread var1, int var2, int var3, double var4);

    private Thread temporarySuspend(Thread thread) {
        if (Agent.systemThread(thread)) {
            return null;
        }
        int n = this.getThreadStatus(thread);
        if (n == 5 || n == 6) {
            return null;
        }
        this.suspendSingleThread(thread);
        return thread;
    }

    private void temporaryResume(Thread thread) {
        if (thread == null) {
            return;
        }
        try {
            thread.resume();
            return;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return;
        }
    }

    synchronized void handle(int n, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(n);
        switch (n) {
            case 49: {
                Class[] classArray = this.getClasses();
                dataOutputStream.writeInt(classArray.length);
                int n2 = 0;
                while (n2 < classArray.length) {
                    this.writeObject(classArray[n2]);
                    ++n2;
                }
                return;
            }
            case 20: {
                Class[] classArray;
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                dataOutputStream.writeUTF(clazz.getName());
                dataOutputStream.writeUTF(this.getClassSourceName(clazz));
                dataOutputStream.writeInt(clazz.isInterface() ? 1 : 0);
                this.writeObject(clazz.getSuperclass());
                this.writeObject(clazz.getClassLoader());
                try {
                    classArray = (Class[])this.spawnCommandThread(20, clazz);
                }
                catch (Throwable throwable) {
                    Agent.error("unexpected exception: " + throwable);
                    classArray = null;
                }
                if (classArray == null) {
                    dataOutputStream.writeInt(-1);
                    return;
                }
                dataOutputStream.writeInt(classArray.length);
                int n3 = 0;
                while (n3 < classArray.length) {
                    this.writeObject(classArray[n3]);
                    ++n3;
                }
                return;
            }
            case 21: {
                dataOutputStream.writeUTF(((Thread)this.objects.get(new Integer(dataInputStream.readInt()))).getName());
                return;
            }
            case 22: {
                String string = dataInputStream.readUTF();
                try {
                    Class clazz = (Class)this.spawnCommandThread(22, string);
                    this.writeObject(clazz);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Agent.message("no such class: " + string);
                    this.writeObject(null);
                    return;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Agent.message("no such class: " + string);
                    this.writeObject(null);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Agent.message("illegal class name: " + string);
                    this.writeObject(null);
                    return;
                }
                catch (Throwable throwable) {
                    Agent.error("unexpected exception: " + throwable);
                    this.writeObject(null);
                    return;
                }
            }
            case 31: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                int n4 = this.getThreadStatus(thread);
                Agent.message("thread " + thread + " status " + n4);
                dataOutputStream.writeInt(n4);
                return;
            }
            case 32: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                BreakpointQueue breakpointQueue = BreakpointHandler.the_bkptQ;
                synchronized (breakpointQueue) {
                    Thread thread2 = this.temporarySuspend(thread);
                    int n5 = thread.countStackFrames();
                    dataOutputStream.writeInt(n5);
                    int n6 = 0;
                    while (n6 < n5) {
                        StackFrame stackFrame = this.getStackFrame(thread, n6);
                        this.writeObject(stackFrame);
                        dataOutputStream.writeUTF(stackFrame.className);
                        dataOutputStream.writeUTF(stackFrame.methodName);
                        dataOutputStream.writeUTF(stackFrame.methodSignature);
                        dataOutputStream.writeInt(stackFrame.lineno);
                        dataOutputStream.writeInt(stackFrame.pc);
                        this.writeObject(stackFrame.clazz);
                        dataOutputStream.writeInt(stackFrame.localVariables.length);
                        int n7 = 0;
                        while (n7 < stackFrame.localVariables.length) {
                            Agent.message("lvar " + n7 + ": slot=" + stackFrame.localVariables[n7].slot + ", name=" + stackFrame.localVariables[n7].name + ", sig=" + stackFrame.localVariables[n7].signature + ", argument=" + stackFrame.localVariables[n7].methodArgument);
                            dataOutputStream.writeInt(stackFrame.localVariables[n7].slot);
                            dataOutputStream.writeUTF(stackFrame.localVariables[n7].name);
                            dataOutputStream.writeUTF(stackFrame.localVariables[n7].signature);
                            dataOutputStream.writeBoolean(stackFrame.localVariables[n7].methodArgument);
                            ++n7;
                        }
                        ++n6;
                    }
                    this.temporaryResume(thread2);
                    return;
                }
            }
            case 50: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                int n8 = dataInputStream.readInt();
                int n9 = dataInputStream.readInt();
                char c = dataInputStream.readChar();
                switch (c) {
                    case 'Z': {
                        this.write(this.getStackBoolean(thread, n8, n9));
                        return;
                    }
                    case 'B': {
                        this.write((byte)this.getStackInt(thread, n8, n9));
                        return;
                    }
                    case 'C': {
                        this.write((char)this.getStackInt(thread, n8, n9));
                        return;
                    }
                    case 'S': {
                        this.write((short)this.getStackInt(thread, n8, n9));
                        return;
                    }
                    case 'I': {
                        this.write(this.getStackInt(thread, n8, n9));
                        return;
                    }
                    case 'J': {
                        this.write(this.getStackLong(thread, n8, n9));
                        return;
                    }
                    case 'F': {
                        this.write(this.getStackFloat(thread, n8, n9));
                        return;
                    }
                    case 'D': {
                        this.write(this.getStackDouble(thread, n8, n9));
                        return;
                    }
                    case '[': {
                        Object[] objectArray = this.getStackArray(thread, n8, n9);
                        this.writeObject(objectArray);
                        return;
                    }
                    case 'L': {
                        this.writeObject(this.getStackObject(thread, n8, n9));
                        return;
                    }
                    case 'V': {
                        this.writeObject(null);
                        return;
                    }
                }
                String string = new String("bogus signature(" + c + ")");
                Agent.error(string);
                this.writeObject(string);
                return;
            }
            case 69: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                int n10 = dataInputStream.readInt();
                int n11 = dataInputStream.readInt();
                int n12 = dataInputStream.readInt();
                switch (n12) {
                    case 0: {
                        this.setStackBoolean(thread, n10, n11, dataInputStream.readBoolean());
                        return;
                    }
                    case 4: {
                        this.setStackInt(thread, n10, n11, dataInputStream.readInt());
                        return;
                    }
                    case 5: {
                        this.setStackLong(thread, n10, n11, dataInputStream.readLong());
                        return;
                    }
                    case 7: {
                        this.setStackDouble(thread, n10, n11, dataInputStream.readDouble());
                        return;
                    }
                }
                Agent.error("bogus type(" + n12 + ")");
                return;
            }
            case 23: {
                Object object;
                Hashtable hashtable;
                int n13 = dataInputStream.readInt();
                Hashtable hashtable2 = new Hashtable();
                int n14 = 0;
                while (n14 < n13) {
                    hashtable = this.objects.get(new Integer(dataInputStream.readInt()));
                    if (hashtable != null) {
                        hashtable2.put(new Integer(this.objectId(hashtable)), hashtable);
                    }
                    ++n14;
                }
                hashtable = new Hashtable();
                Enumeration<Object> enumeration = hashtable2.elements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    this.addReferences(hashtable, object);
                }
                dataOutputStream.flush();
                n = dataInputStream.read();
                dataOutputStream.writeInt(n);
                switch (n) {
                    case 24: {
                        try {
                            Object object2;
                            object = new Hashtable();
                            enumeration = this.objects.elements();
                            while (enumeration.hasMoreElements()) {
                                object2 = enumeration.nextElement();
                                ((Hashtable)object).put((Integer)new Integer(this.objectId(object2)), object2);
                            }
                            enumeration = this.objects.elements();
                            while (enumeration.hasMoreElements()) {
                                object2 = enumeration.nextElement();
                                Integer n15 = new Integer(this.objectId(object2));
                                if (hashtable.get(n15) != null) continue;
                                Agent.message("gc: freeing " + object2);
                                ((Hashtable)object).remove(n15);
                            }
                            this.objects.clear();
                            this.objects = object;
                            System.gc();
                            enumeration = this.objects.keys();
                            while (enumeration.hasMoreElements()) {
                                object2 = (Integer)enumeration.nextElement();
                                dataOutputStream.writeInt((Integer)object2);
                            }
                            dataOutputStream.writeInt(0);
                        }
                        catch (Exception exception) {
                            Agent.error("CMD_MARK_OBJECTS failed: " + exception.toString());
                        }
                        break;
                    }
                    default: {
                        Agent.error("mark objects command failed");
                    }
                }
                dataOutputStream.flush();
                return;
            }
            case 47: {
                ThreadGroup[] threadGroupArray = new ThreadGroup[1000];
                ThreadGroup threadGroup = (ThreadGroup)this.objects.get(new Integer(dataInputStream.readInt()));
                int n16 = 0;
                if (threadGroup == null) {
                    Agent.message("Getting all threadgroups");
                    threadGroup = Thread.currentThread().getThreadGroup();
                    n16 = threadGroup.enumerate(threadGroupArray);
                    dataOutputStream.writeInt(n16 + 1);
                    this.writeObject(threadGroup);
                } else {
                    Agent.message("Getting threadgroups for " + threadGroup.getName());
                    n16 = threadGroup.enumerate(threadGroupArray);
                    dataOutputStream.writeInt(n16);
                }
                int n17 = 0;
                while (n17 < n16) {
                    this.writeObject(threadGroupArray[n17]);
                    ++n17;
                }
                return;
            }
            case 48: {
                ThreadGroup threadGroup = (ThreadGroup)this.objects.get(new Integer(dataInputStream.readInt()));
                this.writeObject(threadGroup.getParent());
                dataOutputStream.writeUTF(threadGroup.getName());
                dataOutputStream.writeInt(threadGroup.getMaxPriority());
                dataOutputStream.writeBoolean(threadGroup.isDaemon());
                return;
            }
            case 25: {
                Thread[] threadArray = new Thread[2000];
                ThreadGroup threadGroup = (ThreadGroup)this.objects.get(new Integer(dataInputStream.readInt()));
                boolean bl = dataInputStream.readBoolean();
                Agent.message("Getting threads for " + threadGroup.getName());
                int n18 = threadGroup.enumerate(threadArray, bl);
                dataOutputStream.writeInt(n18);
                int n19 = 0;
                while (n19 < n18) {
                    this.writeObject(threadArray[n19]);
                    ++n19;
                }
                return;
            }
            case 26: {
                String[] stringArray = new String[dataInputStream.read() - 1];
                String string = dataInputStream.readUTF();
                new String("");
                int n20 = 0;
                while (n20 < stringArray.length) {
                    stringArray[n20] = dataInputStream.readUTF();
                    ++n20;
                }
                try {
                    Class<?> clazz = Class.forName(string);
                    ThreadGroup threadGroup = new ThreadGroup(String.valueOf(clazz.getName()) + ".main");
                    MainThread mainThread = new MainThread(this, threadGroup, clazz, stringArray);
                    this.writeObject(mainThread.getThreadGroup());
                    Agent.beginRun();
                    return;
                }
                catch (Exception exception) {
                    Agent.message(this.exceptionStackTrace(exception));
                    this.writeObject(null);
                    return;
                }
            }
            case 27: {
                this.suspendSingleThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 28: {
                this.resumeThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 29: {
                this.resumeLastSuspendedThreads();
                return;
            }
            case 30: {
                this.suspendAllThreads();
                return;
            }
            case 35: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                Field[] fieldArray = this.getFields(clazz);
                dataOutputStream.writeInt(fieldArray.length);
                int n21 = 0;
                while (n21 < fieldArray.length) {
                    dataOutputStream.writeInt(fieldArray[n21].slot);
                    dataOutputStream.writeUTF(fieldArray[n21].name);
                    dataOutputStream.writeUTF(fieldArray[n21].signature);
                    dataOutputStream.writeShort(fieldArray[n21].access);
                    this.writeObject(fieldArray[n21].clazz);
                    ++n21;
                }
                return;
            }
            case 36: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                Field[] fieldArray = this.getMethods(clazz);
                dataOutputStream.writeInt(fieldArray.length);
                int n22 = 0;
                while (n22 < fieldArray.length) {
                    dataOutputStream.writeInt(fieldArray[n22].slot);
                    dataOutputStream.writeUTF(fieldArray[n22].name);
                    dataOutputStream.writeUTF(fieldArray[n22].signature);
                    dataOutputStream.writeShort(fieldArray[n22].access);
                    this.writeObject(fieldArray[n22].clazz);
                    ++n22;
                }
                return;
            }
            case 40: {
                Object v = this.objects.get(new Integer(dataInputStream.readInt()));
                int n23 = dataInputStream.readInt();
                int n24 = dataInputStream.readInt();
                int n25 = dataInputStream.readInt();
                dataOutputStream.writeInt(n25 - n24 + 1);
                switch (n23) {
                    case 2: {
                        char[] cArray = (char[])v;
                        int n26 = n24;
                        while (n26 <= n25) {
                            this.write(cArray[n26]);
                            ++n26;
                        }
                        return;
                    }
                    case 1: {
                        byte[] byArray = (byte[])v;
                        int n27 = n24;
                        while (n27 <= n25) {
                            this.write(byArray[n27]);
                            ++n27;
                        }
                        return;
                    }
                    case 9: 
                    case 10: 
                    case 17: {
                        Object[] objectArray = (Object[])v;
                        int n28 = n24;
                        while (n28 <= n25) {
                            this.writeObject(objectArray[n28]);
                            ++n28;
                        }
                        return;
                    }
                    case 6: {
                        float[] fArray = (float[])v;
                        int n29 = n24;
                        while (n29 <= n25) {
                            this.write(fArray[n29]);
                            ++n29;
                        }
                        return;
                    }
                    case 7: {
                        double[] dArray = (double[])v;
                        int n30 = n24;
                        while (n30 <= n25) {
                            this.write(dArray[n30]);
                            ++n30;
                        }
                        return;
                    }
                    case 4: {
                        int[] nArray = (int[])v;
                        int n31 = n24;
                        while (n31 <= n25) {
                            this.write(nArray[n31]);
                            ++n31;
                        }
                        return;
                    }
                    case 5: {
                        long[] lArray = (long[])v;
                        int n32 = n24;
                        while (n32 <= n25) {
                            this.write(lArray[n32]);
                            ++n32;
                        }
                        return;
                    }
                    case 3: {
                        short[] sArray = (short[])v;
                        int n33 = n24;
                        while (n33 <= n25) {
                            this.write(sArray[n33]);
                            ++n33;
                        }
                        return;
                    }
                    case 0: {
                        boolean[] blArray = (boolean[])v;
                        int n34 = n24;
                        while (n34 <= n25) {
                            this.write(blArray[n34]);
                            ++n34;
                        }
                        return;
                    }
                }
                int n35 = n24;
                while (n35 <= n25) {
                    this.writeObject(null);
                    ++n35;
                }
                return;
            }
            case 38: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n36 = dataInputStream.readInt();
                int[] nArray = this.getSlotSignature(clazz, n36);
                if (nArray == null) {
                    dataOutputStream.writeInt(0);
                    return;
                }
                dataOutputStream.writeInt(nArray.length);
                int n37 = 0;
                while (n37 < nArray.length) {
                    dataOutputStream.writeInt(nArray[n37]);
                    ++n37;
                }
                return;
            }
            case 39: {
                Object v = this.objects.get(new Integer(dataInputStream.readInt()));
                int n38 = dataInputStream.readInt();
                int[] nArray = this.getSlotSignature(v instanceof Class ? (Class<?>)v : v.getClass(), n38);
                if (nArray == null) {
                    this.writeObject(new ArrayIndexOutOfBoundsException("invalid slot index " + n38));
                    return;
                }
                switch (nArray[0]) {
                    case 0: {
                        this.write(this.getSlotBoolean(v, n38));
                        return;
                    }
                    case 1: {
                        this.write((byte)this.getSlotInt(v, n38));
                        return;
                    }
                    case 2: {
                        this.write((char)this.getSlotInt(v, n38));
                        return;
                    }
                    case 3: {
                        this.write((short)this.getSlotInt(v, n38));
                        return;
                    }
                    case 4: {
                        this.write(this.getSlotInt(v, n38));
                        return;
                    }
                    case 5: {
                        this.write(this.getSlotLong(v, n38));
                        return;
                    }
                    case 6: {
                        this.write((float)this.getSlotDouble(v, n38));
                        return;
                    }
                    case 7: {
                        this.write(this.getSlotDouble(v, n38));
                        return;
                    }
                    case 9: {
                        Object[] objectArray = this.getSlotArray(v, n38);
                        this.writeObject(objectArray);
                        return;
                    }
                    case 16: 
                    case 17: {
                        Object object = this.getSlotObject(v, n38);
                        this.writeObject(object);
                        return;
                    }
                    case 11: {
                        this.writeObject(null);
                        return;
                    }
                }
                String string = new String("bogus signature(");
                int n39 = 0;
                while (n39 < nArray.length) {
                    string = string.concat(" " + new Integer(nArray[n39]).toString());
                    ++n39;
                }
                string = string.concat(" )");
                Agent.error(string);
                this.writeObject(string);
            }
            case 68: {
                Object v = this.objects.get(new Integer(dataInputStream.readInt()));
                int n38 = dataInputStream.readInt();
                int n40 = dataInputStream.readInt();
                switch (n40) {
                    case 0: {
                        this.setSlotBoolean(v, n38, dataInputStream.readBoolean());
                        return;
                    }
                    case 4: {
                        this.setSlotInt(v, n38, dataInputStream.readInt());
                        return;
                    }
                    case 5: {
                        this.setSlotLong(v, n38, dataInputStream.readLong());
                        return;
                    }
                    case 7: {
                        this.setSlotDouble(v, n38, dataInputStream.readDouble());
                        return;
                    }
                }
                Agent.error("bogus type(" + n40 + ")");
                return;
            }
            case 41: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n41 = dataInputStream.readInt();
                LineNumber lineNumber = this.lineno2pc(clazz, n41);
                String string = "";
                if (lineNumber == null) {
                    string = "No code at line " + n41 + ", or class is optimized.";
                } else {
                    try {
                        this.bkptHandler.addBreakpoint(clazz, lineNumber.startPC, 1, null);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 42: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n42 = dataInputStream.readInt();
                int n43 = this.method2pc(clazz, n42);
                Agent.message("method2pc(" + clazz.getName() + "," + n42 + ") = " + n43);
                String string = "";
                if (n43 == -1 || n43 == 0) {
                    string = "Can't breakpoint on native or abstract method";
                } else {
                    try {
                        this.bkptHandler.addBreakpoint(clazz, n43, 1, null);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 65: {
                BreakpointSet[] breakpointSetArray = this.bkptHandler.listBreakpoints();
                dataOutputStream.writeInt(breakpointSetArray.length);
                int n44 = 0;
                while (n44 < breakpointSetArray.length) {
                    dataOutputStream.writeUTF(String.valueOf(breakpointSetArray[n44].clazz.getName()) + ":" + this.pc2lineno(breakpointSetArray[n44].clazz, breakpointSetArray[n44].pc));
                    ++n44;
                }
                return;
            }
            case 43: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n45 = dataInputStream.readInt();
                Agent.message("clearing bkpt at " + clazz.getName() + ":" + n45);
                String string = "";
                if (n45 == -1) {
                    string = "No code at pc " + n45;
                } else {
                    try {
                        this.bkptHandler.deleteBreakpoint(clazz, n45);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 44: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n46 = dataInputStream.readInt();
                Agent.message("clearing bkpt at " + clazz.getName() + ":" + n46);
                LineNumber lineNumber = this.lineno2pc(clazz, n46);
                String string = "";
                if (lineNumber == null) {
                    string = "No code at line " + n46 + ", or class is optimized.";
                } else {
                    try {
                        this.bkptHandler.deleteBreakpoint(clazz, lineNumber.startPC);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 45: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n47 = dataInputStream.readInt();
                Agent.message("clearing bkpt at " + clazz.getName());
                int n48 = this.method2pc(clazz, n47);
                String string = "";
                if (n48 == -1) {
                    string = "Not a Java method";
                } else {
                    try {
                        this.bkptHandler.deleteBreakpoint(clazz, n48);
                    }
                    catch (Exception exception) {
                        Agent.message(this.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 53: {
                try {
                    Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                    this.bkptHandler.catchExceptionClass(clazz);
                    return;
                }
                catch (Exception exception) {
                    Agent.error("catchExceptionClass failed: " + exception);
                    return;
                }
            }
            case 54: {
                try {
                    Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                    this.bkptHandler.ignoreExceptionClass(clazz);
                    return;
                }
                catch (Exception exception) {
                    Agent.error("ignoreExceptionClass failed: " + exception);
                    return;
                }
            }
            case 55: {
                Class[] classArray = this.bkptHandler.getCatchList();
                dataOutputStream.writeInt(classArray.length);
                int n49 = 0;
                while (n49 < classArray.length) {
                    this.writeObject(classArray[n49]);
                    ++n49;
                }
                return;
            }
            case 56: {
                Thread thread = (Thread)this.objects.get(new Integer(dataInputStream.readInt()));
                thread.stop();
                Agent.message(String.valueOf(thread.getName()) + " stopped.");
                return;
            }
            case 57: {
                ThreadGroup threadGroup = (ThreadGroup)this.objects.get(new Integer(dataInputStream.readInt()));
                threadGroup.stop();
                Agent.message(String.valueOf(threadGroup.getName()) + " stopped.");
                return;
            }
            case 51: {
                verbose = dataInputStream.readBoolean();
                return;
            }
            case 34: {
                switch (dataInputStream.readInt()) {
                    case 2: {
                        dataOutputStream.writeInt((int)Runtime.getRuntime().freeMemory());
                        return;
                    }
                    case 1: {
                        dataOutputStream.writeInt((int)Runtime.getRuntime().totalMemory());
                        return;
                    }
                    case 3: {
                        Runtime.getRuntime().traceMethodCalls(dataInputStream.readInt() != 0);
                        return;
                    }
                    case 4: {
                        Runtime.getRuntime().traceInstructions(dataInputStream.readInt() != 0);
                        return;
                    }
                }
                return;
            }
            case 59: {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                int n50 = string2.lastIndexOf(46);
                String string3 = n50 >= 0 ? string2.substring(0, n50) : "";
                Package package_ = null;
                try {
                    package_ = new Package(this.sourcePath, Identifier.lookup(string3));
                }
                catch (Exception exception) {
                    Agent.message("cannot create a Package for " + string3);
                    dataOutputStream.writeInt(-1);
                    return;
                }
                ClassFile classFile = null;
                InputStream inputStream = null;
                try {
                    classFile = package_.getSourceFile(string);
                    if (classFile == null) {
                        Agent.message("no source " + string);
                        dataOutputStream.writeInt(-1);
                        return;
                    }
                    inputStream = classFile.getInputStream();
                }
                catch (Exception exception) {
                    Agent.message("cannot find " + string);
                    dataOutputStream.writeInt(-1);
                    return;
                }
                int n51 = (int)classFile.length();
                dataOutputStream.writeInt(n51);
                byte[] byArray = new byte[n51];
                try {
                    int n52 = 0;
                    int n53 = byArray.length;
                    while (n53 > 0) {
                        int n54 = inputStream.read(byArray, n52, n53);
                        if (n54 == -1) {
                            throw new IOException();
                        }
                        n52 += n54;
                        n53 -= n54;
                    }
                    dataOutputStream.write(byArray);
                }
                catch (IOException iOException) {
                    Agent.error("unable to read " + string);
                    return;
                }
                inputStream.close();
                return;
            }
            case 60: {
                Object v = this.objects.get(new Integer(dataInputStream.readInt()));
                String string = "";
                try {
                    string = (String)this.spawnCommandThread(60, v);
                }
                catch (Throwable throwable) {}
                dataOutputStream.writeUTF(string);
                return;
            }
            case 61: {
                dataOutputStream.writeUTF(this.sourcePath.toString());
                return;
            }
            case 62: {
                String string = dataInputStream.readUTF();
                if (string == null) {
                    string = ".";
                }
                this.sourcePath = new ClassPath(string);
                return;
            }
            case 63: {
                this.stepHandler.stepThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())), dataInputStream.readBoolean());
                return;
            }
            case 64: {
                this.stepHandler.stepNextThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 73: {
                this.stepHandler.stepOutThread((Thread)this.objects.get(new Integer(dataInputStream.readInt())));
                return;
            }
            case 70: {
                this.objects.remove(new Integer(dataInputStream.readInt()));
                return;
            }
            case 71: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int[] nArray = this.getLinenumbers(clazz);
                int n55 = nArray.length;
                dataOutputStream.writeInt(n55);
                int n56 = 0;
                while (n56 < n55) {
                    dataOutputStream.writeInt(nArray[n56]);
                    ++n56;
                }
                return;
            }
            case 72: {
                Class clazz = (Class)this.objects.get(new Integer(dataInputStream.readInt()));
                int n57 = dataInputStream.readInt();
                dataOutputStream.writeInt(this.getMethodLinenumber(clazz, n57));
                return;
            }
            case 58: {
                this.debuggerTerminating = true;
                if (this.lastSuspended != null) {
                    this.resumeLastSuspendedThreads();
                }
                System.exit(0);
            }
        }
        Agent.error("command not understood: " + n);
    }

    Object spawnCommandThread(int n, Object object) throws Throwable {
        CommandThread commandThread;
        CommandThread commandThread2 = commandThread = new CommandThread(n, object);
        synchronized (commandThread2) {
            commandThread.start();
            commandThread.wait(5000L);
            if (commandThread.complete) {
                if (commandThread.failure != null) {
                    throw commandThread.failure;
                }
                Object object2 = commandThread.result;
                Object var6_7 = null;
                return object2;
            }
            commandThread.cancel = true;
            Agent.error("operation failed to complete - deadlock avoided");
            Object var4_6 = null;
            Object var6_8 = null;
            return var4_6;
        }
    }

    /*
     * Exception decompiling
     */
    static void doAsyncCommand(CommandThread var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    native int objectId(Object var1);

    native void runMain(Class var1, String[] var2);

    void writeObject(Object object, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        if (object == null) {
            dataOutputStream.writeInt(17);
        } else if (object instanceof Class) {
            dataOutputStream.writeInt(16);
            n = this.objectId(object);
            this.objects.put(new Integer(n), object);
        } else if (object instanceof String) {
            dataOutputStream.writeInt(18);
            n = this.objectId(object);
            this.objects.put(new Integer(n), object);
        } else {
            if (object instanceof Thread) {
                dataOutputStream.writeInt(19);
            } else if (object instanceof ThreadGroup) {
                dataOutputStream.writeInt(15);
            } else if (object.getClass().isArray()) {
                dataOutputStream.writeInt(9);
                bl = true;
            } else {
                dataOutputStream.writeInt(17);
            }
            Class<?> clazz = object.getClass();
            n = this.objectId(clazz);
            this.objects.put(new Integer(n), clazz);
            dataOutputStream.writeInt(n);
            n = this.objectId(object);
            this.objects.put(new Integer(n), object);
        }
        dataOutputStream.writeInt(n);
        if (bl) {
            dataOutputStream.writeInt(Array.getLength(object));
        }
    }

    void writeObject(Object object) throws IOException {
        this.writeObject(object, this.out);
    }

    void write(boolean bl) throws IOException {
        this.out.writeInt(0);
        this.out.writeBoolean(bl);
    }

    void write(byte by) throws IOException {
        this.out.writeInt(1);
        this.out.writeByte(by);
    }

    void write(char c) throws IOException {
        this.out.writeInt(2);
        this.out.writeChar(c);
    }

    void write(short s) throws IOException {
        this.out.writeInt(3);
        this.out.writeShort(s);
    }

    void write(int n) throws IOException {
        this.out.writeInt(4);
        this.out.writeInt(n);
    }

    void write(long l) throws IOException {
        this.out.writeInt(5);
        this.out.writeLong(l);
    }

    void write(float f) throws IOException {
        this.out.writeInt(6);
        this.out.writeFloat(f);
    }

    void write(double d) throws IOException {
        this.out.writeInt(7);
        this.out.writeDouble(d);
    }

    void reportAppExit() {
        Agent.message("report application exit");
        try {
            DataOutputStream dataOutputStream = this.asyncOutputStream;
            synchronized (dataOutputStream) {
                this.asyncOutputStream.write(67);
                this.asyncOutputStream.flush();
                return;
            }
        }
        catch (IOException iOException) {
            Agent.message("unable to notify debugger");
            return;
        }
    }

    static void error(String string) {
        System.out.println("[Internal debug-agent error: " + string + "]");
    }

    static void message(String string) {
        if (verbose) {
            System.out.println("[debug agent: " + string + "]");
        }
    }

    public static void boot(int n) {
        Agent agent = new Agent(n);
        Thread thread = new Thread(agent);
        thread.setDaemon(true);
        thread.setName("Debugger agent");
        thread.setPriority(10);
        thread.start();
    }

    public static void debuggable_boot() {
        Agent agent = new Agent();
        Thread thread = new Thread(agent);
        thread.setDaemon(true);
        thread.setName("Debugger agent");
        thread.setPriority(10);
        thread.start();
    }

    private void addReferences(Hashtable hashtable, Object object) {
        if (object != null && hashtable.put(new Integer(this.objectId(object)), object) == null) {
            Agent.message("addref: " + object);
            this.addReferences(hashtable, object.getClass());
            if (object instanceof Class) {
                Class clazz = (Class)object;
                this.addReferences(hashtable, clazz.getSuperclass());
                Class<?>[] classArray = clazz.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    this.addReferences(hashtable, classArray[n]);
                    ++n;
                }
                this.addReferences(hashtable, clazz.getClassLoader());
            }
        }
    }

    static {
        runBegunLock = new Object();
        System.loadLibrary("agent");
    }
}

