/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import sun.tools.debug.Agent;
import sun.tools.debug.AgentConstants;
import sun.tools.debug.BreakpointQueue;
import sun.tools.debug.BreakpointSet;
import sun.tools.debug.LineNumber;

class BreakpointHandler
extends Thread
implements AgentConstants {
    static BreakpointQueue the_bkptQ;
    static Hashtable the_bkptHash;
    private Agent agent;
    private Hashtable catchHash;
    private Vector skipLines;
    static final boolean debug = false;

    native void setBreakpoint(int var1);

    native void clrBreakpoint(int var1);

    private synchronized void internalAddBreakpoint(Class clazz, int n) throws IOException {
        BreakpointSet breakpointSet = (BreakpointSet)the_bkptHash.get(new Integer(n));
        if (breakpointSet == null) {
            if (clazz == null) {
                throw new IOException("Invalid classObj in addBreakpoint");
            }
            try {
                this.setBreakpoint(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Invalid PC: " + illegalArgumentException.getMessage());
            }
        }
    }

    synchronized void addBreakpoint(Class clazz, int n, int n2, byte[] byArray) throws IOException {
        this.internalAddBreakpoint(clazz, n);
        BreakpointSet breakpointSet = new BreakpointSet(n, clazz, n2, byArray);
        the_bkptHash.put(new Integer(n), breakpointSet);
        if (byArray != null && byArray.length > 0) {
            breakpointSet.addCondition(byArray);
        }
    }

    synchronized void addScattershotBreakpoints(Class clazz, int[] nArray, Thread thread) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            this.internalAddBreakpoint(clazz, n2);
            BreakpointSet breakpointSet = new BreakpointSet(n2, clazz, 4, null);
            breakpointSet.setCohorts(nArray);
            breakpointSet.setThread(thread);
            the_bkptHash.put(new Integer(n2), breakpointSet);
            ++n;
        }
    }

    synchronized void deleteBreakpoint(Class clazz, int n) throws IOException {
        BreakpointSet breakpointSet = (BreakpointSet)the_bkptHash.get(new Integer(n));
        if (breakpointSet == null) {
            return;
        }
        try {
            this.clrBreakpoint(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Invalid PC: " + illegalArgumentException.getMessage());
        }
        the_bkptHash.remove(new Integer(n));
    }

    synchronized BreakpointSet[] listBreakpoints() {
        BreakpointSet[] breakpointSetArray = new BreakpointSet[the_bkptHash.size()];
        Enumeration enumeration = the_bkptHash.elements();
        int n = 0;
        while (n < breakpointSetArray.length) {
            try {
                breakpointSetArray[n] = (BreakpointSet)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                Agent.error("Internal error" + this.agent.exceptionStackTrace(noSuchElementException));
                return null;
            }
            ++n;
        }
        return breakpointSetArray;
    }

    synchronized void catchExceptionClass(Class clazz) {
        if (this.catchHash.get(clazz) == null) {
            this.catchHash.put(clazz, clazz);
        }
    }

    synchronized void ignoreExceptionClass(Class clazz) {
        this.catchHash.remove(clazz);
    }

    Class[] getCatchList() {
        Class[] classArray = new Class[this.catchHash.size()];
        Enumeration enumeration = this.catchHash.elements();
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = (Class)enumeration.nextElement();
            ++n;
        }
        return classArray;
    }

    void addSkipLine(LineNumber lineNumber) {
        this.skipLines.addElement(lineNumber);
    }

    void removeSkipLine(LineNumber lineNumber) {
        this.skipLines.removeElement(lineNumber);
    }

    boolean ignoreSingleStep(Thread thread, int n) {
        Enumeration enumeration = this.skipLines.elements();
        while (enumeration.hasMoreElements()) {
            LineNumber lineNumber = (LineNumber)enumeration.nextElement();
            if (lineNumber.thread != thread) continue;
            if (n >= lineNumber.startPC && n <= lineNumber.endPC) {
                return true;
            }
            this.removeSkipLine(lineNumber);
        }
        return false;
    }

    BreakpointHandler(Agent agent) {
        super("Breakpoint handler");
        the_bkptQ = new BreakpointQueue();
        BreakpointHandler.the_bkptQ.waiting_for_event = false;
        the_bkptHash = new Hashtable();
        this.catchHash = new Hashtable();
        this.skipLines = new Vector();
        this.agent = agent;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 25[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

