/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import sun.tools.debug.RemoteAgent;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteValue;

public class RemoteObject
extends RemoteValue {
    RemoteAgent agent;
    RemoteClass clazz;
    int id;

    RemoteObject(RemoteAgent remoteAgent, int n, RemoteClass remoteClass) {
        this(remoteAgent, 17, n, remoteClass);
    }

    RemoteObject(RemoteAgent remoteAgent, int n, int n2, RemoteClass remoteClass) {
        super(n);
        this.agent = remoteAgent;
        this.id = n2;
        this.clazz = remoteClass;
    }

    public String typeName() throws Exception {
        return "Object";
    }

    public final int getId() {
        return this.id;
    }

    public final RemoteClass getClazz() {
        return this.clazz;
    }

    public RemoteValue getFieldValue(int n) throws Exception {
        return this.clazz.getInstanceField(n).getValue(this.id);
    }

    public RemoteValue getFieldValue(String string) throws Exception {
        RemoteField remoteField = this.getField(string);
        if (remoteField == null) {
            return null;
        }
        return remoteField.getValue(this.id);
    }

    public RemoteField[] getFields() throws Exception {
        return this.clazz.getInstanceFields();
    }

    public RemoteField getField(int n) throws Exception {
        return this.clazz.getInstanceField(n);
    }

    public RemoteField getField(String string) throws Exception {
        RemoteField[] remoteFieldArray = this.clazz.getInstanceFields();
        int n = remoteFieldArray.length - 1;
        while (n >= 0) {
            if (string.equals(remoteFieldArray[n].getName())) {
                return remoteFieldArray[n];
            }
            --n;
        }
        return null;
    }

    public void setField(String string, boolean bl) throws Exception {
        RemoteField remoteField = this.getField(string);
        if (remoteField == null) {
            throw new IllegalAccessException(String.valueOf(string) + " is not an instance variable of " + this);
        }
        remoteField.setValue(this.id, bl);
    }

    public void setField(String string, int n) throws Exception {
        RemoteField remoteField = this.getField(string);
        if (remoteField == null) {
            throw new IllegalAccessException(String.valueOf(string) + " is not an instance variable of " + this);
        }
        remoteField.setValue(this.id, n);
    }

    public void setField(String string, char c) throws Exception {
        RemoteField remoteField = this.getField(string);
        if (remoteField == null) {
            throw new IllegalAccessException(String.valueOf(string) + " is not an instance variable of " + this);
        }
        remoteField.setValue(this.id, c);
    }

    public void setField(String string, long l) throws Exception {
        RemoteField remoteField = this.getField(string);
        if (remoteField == null) {
            throw new IllegalAccessException(String.valueOf(string) + " is not an instance variable of " + this);
        }
        remoteField.setValue(this.id, l);
    }

    public void setField(String string, float f) throws Exception {
        RemoteField remoteField = this.getField(string);
        if (remoteField == null) {
            throw new IllegalAccessException(String.valueOf(string) + " is not an instance variable of " + this);
        }
        remoteField.setValue(this.id, f);
    }

    public void setField(String string, double d) throws Exception {
        RemoteField remoteField = this.getField(string);
        if (remoteField == null) {
            throw new IllegalAccessException(String.valueOf(string) + " is not an instance variable of " + this);
        }
        remoteField.setValue(this.id, d);
    }

    public void setField(String string, RemoteObject remoteObject) throws Exception {
        throw new IllegalAccessException();
    }

    public void setField(int n, boolean bl) throws Exception {
        this.getField(n).setValue(this.id, bl);
    }

    public void setField(int n, int n2) throws Exception {
        this.getField(n).setValue(this.id, n2);
    }

    public void setField(int n, char c) throws Exception {
        this.getField(n).setValue(this.id, c);
    }

    public void setField(int n, long l) throws Exception {
        this.getField(n).setValue(this.id, l);
    }

    public void setField(int n, float f) throws Exception {
        this.getField(n).setValue(this.id, f);
    }

    public void setField(int n, double d) throws Exception {
        this.getField(n).setValue(this.id, d);
    }

    public void setField(int n, RemoteObject remoteObject) throws Exception {
        throw new IllegalAccessException();
    }

    public String description() {
        try {
            if (this.clazz == null) {
                return RemoteValue.toHex(this.id);
            }
            return "(" + this.getClazz().getName() + ")" + RemoteValue.toHex(this.id);
        }
        catch (Exception exception) {
            return "<communications error>";
        }
    }

    public String toString() {
        String string = this.agent.objectToString(this.id);
        if (string.length() > 0) {
            return string;
        }
        return this.description();
    }

    protected void finalize() throws Exception {
        if (this.id != -1) {
            this.agent.objectFinalize(this.id);
        }
    }

    protected void invalidate() {
        this.id = -1;
    }
}

