/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import sun.tools.debug.RemoteAgent;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteStackVariable;
import sun.tools.debug.RemoteThread;
import sun.tools.debug.RemoteValue;
import sun.tools.debug.StackFrame;

public class RemoteStackFrame
extends StackFrame {
    private RemoteObject idFrame;
    private RemoteAgent agent;
    private RemoteThread thread;
    private RemoteClass clazz;
    private int iFrame;

    RemoteStackFrame(RemoteObject remoteObject, RemoteThread remoteThread, int n, RemoteAgent remoteAgent) {
        this.idFrame = remoteObject;
        this.thread = remoteThread;
        this.iFrame = n;
        this.agent = remoteAgent;
    }

    public RemoteStackVariable getLocalVariable(String string) throws Exception {
        this.agent.message("getLocalVariable: name=" + string);
        this.agent.message("   stackframe=" + this.toString());
        this.agent.message("   " + this.localVariables.length + " local vars");
        int n = 0;
        while (n < this.localVariables.length) {
            this.agent.message("   trying " + this.localVariables[n].name);
            if (this.localVariables[n].name.equals(string)) {
                RemoteValue remoteValue = this.agent.getStackValue(this.thread.getId(), this.iFrame, this.localVariables[n].slot, this.localVariables[n].signature.charAt(0));
                return new RemoteStackVariable(this, this.localVariables[n].slot, string, this.localVariables[n].signature, this.localVariables[n].methodArgument, remoteValue);
            }
            ++n;
        }
        return null;
    }

    public RemoteStackVariable[] getLocalVariables() throws Exception {
        this.agent.message("getLocalVariables:");
        this.agent.message("   stackframe=" + this.toString());
        this.agent.message("   " + this.localVariables.length + " local vars");
        RemoteStackVariable[] remoteStackVariableArray = new RemoteStackVariable[this.localVariables.length];
        int n = 0;
        while (n < remoteStackVariableArray.length) {
            RemoteValue remoteValue = this.agent.getStackValue(this.thread.getId(), this.iFrame, this.localVariables[n].slot, this.localVariables[n].signature.charAt(0));
            remoteStackVariableArray[n] = new RemoteStackVariable(this, this.localVariables[n].slot, this.localVariables[n].name, this.localVariables[n].signature, this.localVariables[n].methodArgument, remoteValue);
            ++n;
        }
        return remoteStackVariableArray;
    }

    public int getLineNumber() {
        return this.lineno;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public int getPC() {
        return this.pc;
    }

    public RemoteClass getRemoteClass() {
        return this.clazz;
    }

    void setRemoteClass(RemoteClass remoteClass) {
        this.clazz = remoteClass;
    }

    void setVariable(int n, int n2) throws Exception {
        this.agent.setStackValue(this.thread.getId(), this.iFrame, n, n2);
    }

    void setVariable(int n, boolean bl) throws Exception {
        this.agent.setStackValue(this.thread.getId(), this.iFrame, n, bl);
    }

    void setVariable(int n, char c) throws Exception {
        this.agent.setStackValue(this.thread.getId(), this.iFrame, n, c);
    }

    void setVariable(int n, long l) throws Exception {
        this.agent.setStackValue(this.thread.getId(), this.iFrame, n, l);
    }

    void setVariable(int n, float f) throws Exception {
        this.agent.setStackValue(this.thread.getId(), this.iFrame, n, f);
    }

    void setVariable(int n, double d) throws Exception {
        this.agent.setStackValue(this.thread.getId(), this.iFrame, n, d);
    }
}

