/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.debug.Agent;
import sun.tools.debug.AgentConstants;
import sun.tools.debug.BreakpointHandler;
import sun.tools.debug.BreakpointQueue;
import sun.tools.debug.BreakpointSet;
import sun.tools.debug.Field;
import sun.tools.debug.LineNumber;
import sun.tools.debug.StackFrame;
import sun.tools.debug.StepConstants;
import sun.tools.debug.StepRequest;
import sun.tools.java.RuntimeConstants;

class StepHandler
extends Thread
implements StepConstants,
AgentConstants {
    private static final int opc_invokevirtual_quick = 214;
    private static final int opc_invokenonvirtual_quick = 215;
    private static final int opc_invokesuper_quick = 216;
    private static final int opc_invokestatic_quick = 217;
    private static final int opc_invokeinterface_quick = 218;
    private static final int opc_invokevirtualobject_quick = 219;
    private static final int opc_invokevirtual_quick_w = 226;
    private static final int opc_ldc_quick = 203;
    private static final int opc_ldc_w_quick = 204;
    private static final int opc_getfield_quick = 206;
    private static final int opc_putfield_quick = 207;
    private static final int opc_getfield2_quick = 208;
    private static final int opc_putfield2_quick = 209;
    private static final int opc_putstatic_quick = 211;
    private static final int opc_getstatic2_quick = 212;
    private static final int opc_putstatic2_quick = 213;
    private static final int opc_new_quick = 221;
    private static final int opc_anewarray_quick = 222;
    private static final int opc_multianewarray_quick = 223;
    private static final int opc_checkcast_quick = 224;
    private static final int opc_instanceof_quick = 225;
    private static final int opc_getfield_quick_w = 227;
    private static final int opc_putfield_quick_w = 228;
    private final int MIN_QUICK_OPCODE = 203;
    private final int MAX_QUICK_OPCODE = 228;
    private Agent agent;
    private BreakpointHandler bkptHandler;
    private BreakpointQueue event;
    private boolean waitingForBreak = false;
    private boolean exceptionOccurred = false;
    private boolean userMustSeeException = false;
    private boolean hitUserBreak = false;
    private boolean stepping = false;
    private static boolean[] invokeMap = new boolean[256];
    private static boolean[] branchMap;

    StepHandler(Agent agent, BreakpointHandler breakpointHandler) {
        super("Step handler");
        this.agent = agent;
        this.bkptHandler = breakpointHandler;
    }

    synchronized void stepThread(Thread thread, boolean bl) {
        this.requestStep(bl ? 1 : 0, 1, thread);
    }

    synchronized void stepNextThread(Thread thread) {
        this.requestStep(1, 0, thread);
    }

    synchronized void stepOutThread(Thread thread) {
        this.requestStep(0, 2, thread);
    }

    private synchronized void requestStep(int n, int n2, Thread thread) {
        if (this.stepping) {
            this.stepping = false;
            this.notify();
        }
        StepRequest.make(n, n2, thread);
    }

    synchronized boolean notifyBreak(BreakpointQueue breakpointQueue) {
        if (this.waitingForBreak) {
            this.event = (BreakpointQueue)breakpointQueue.clone();
            this.notify();
            return true;
        }
        return false;
    }

    synchronized boolean notifyException(BreakpointQueue breakpointQueue, boolean bl) {
        if (this.waitingForBreak) {
            this.event = (BreakpointQueue)breakpointQueue.clone();
            this.exceptionOccurred = true;
            this.userMustSeeException = bl;
            this.notify();
            return true;
        }
        return false;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    StepRequest stepRequest = this.waitForRequest();
                    if (stepRequest.depth == 2) {
                        this.stepOut(stepRequest.thread);
                        continue;
                    }
                    if (stepRequest.granularity == 1) {
                        this.stepLine(stepRequest.depth, stepRequest.thread);
                        continue;
                    }
                    this.stepInstruction(stepRequest.thread);
                }
            }
            catch (InterruptedException interruptedException) {
                Agent.message("Step interrupted");
                continue;
            }
            break;
        }
    }

    private StepRequest waitForRequest() {
        this.stepping = false;
        StepRequest stepRequest = StepRequest.get();
        this.stepping = true;
        return stepRequest;
    }

    synchronized void waitForBreak() throws InterruptedException {
        this.exceptionOccurred = false;
        this.event = null;
        this.waitingForBreak = true;
        Agent.message("waiting for break...");
        this.wait();
        this.waitingForBreak = false;
        if (!this.stepping) {
            throw new InterruptedException();
        }
        if (this.exceptionOccurred) {
            this.agent.suspendAllThreads();
        }
    }

    private boolean isInvokeOpcode(int n) {
        return invokeMap[n];
    }

    private boolean isBranchOpcode(int n) {
        return branchMap[n];
    }

    private boolean isReturnOpcode(int n) {
        return n == 177 || n == 176 || n == 172 || n == 173 || n == 174 || n == 175;
    }

    private int instructionLength(int n) {
        if (n < 203) {
            return RuntimeConstants.opcLengths[n];
        }
        if (n <= 228) {
            switch (n) {
                case 203: {
                    return 2;
                }
                case 218: {
                    return 5;
                }
                case 223: {
                    return 4;
                }
            }
            return 3;
        }
        throw new IllegalArgumentException("Invalid opcode");
    }

    private int getAbsolutePC(StackFrame stackFrame, int n) throws NoSuchMethodException {
        Field[] fieldArray = this.agent.getMethods(stackFrame.clazz);
        int n2 = -1;
        int n3 = 0;
        while (n3 < fieldArray.length) {
            if (stackFrame.methodName.equals(fieldArray[n3].name) && stackFrame.methodSignature.equals(fieldArray[n3].signature)) {
                n2 = fieldArray[n3].slot;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            throw new NoSuchMethodException("Could not find method " + stackFrame.methodName + stackFrame.methodSignature + " in class " + stackFrame.clazz.getName());
        }
        int n4 = this.agent.method2pc(stackFrame.clazz, n2);
        return n4 + n;
    }

    private int getReturnPC(StackFrame stackFrame) {
        int n = this.agent.peekSafely(stackFrame.pcAbsolute);
        if (this.isBranchOpcode(n)) {
            return -1;
        }
        return stackFrame.pcAbsolute + this.instructionLength(n);
    }

    private StackFrame[] getCurrentStackTrace(Thread thread) {
        int n = thread.countStackFrames();
        StackFrame[] stackFrameArray = new StackFrame[n];
        int n2 = 0;
        while (n2 < n) {
            stackFrameArray[n2] = this.agent.getStackFrame(thread, n2);
            ++n2;
        }
        return stackFrameArray;
    }

    private boolean frameEquals(StackFrame stackFrame, StackFrame stackFrame2, boolean bl) {
        return (!bl || stackFrame.pc == stackFrame2.pc) && stackFrame.lineno == stackFrame2.lineno && stackFrame.methodName.equals(stackFrame2.methodName) && stackFrame.methodSignature.equals(stackFrame2.methodSignature) && stackFrame.clazz == stackFrame2.clazz;
    }

    private boolean isExecutingLine(StackFrame[] stackFrameArray, StackFrame[] stackFrameArray2) {
        int n = stackFrameArray2.length - stackFrameArray.length;
        if (n < 0) {
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < stackFrameArray.length) {
            if (!this.frameEquals(stackFrameArray[n2], stackFrameArray2[n2 + n], bl)) {
                Agent.message("stacks don't match at level " + n2 + " " + stackFrameArray[n2].lineno + "-" + stackFrameArray2[n2 + n].lineno + " " + stackFrameArray[n2].methodName + "-" + stackFrameArray2[n2 + n].methodName + " " + stackFrameArray[n2].clazz + "-" + stackFrameArray2[n2 + n].clazz);
                return false;
            }
            bl = true;
            ++n2;
        }
        return true;
    }

    private boolean isWithinLine(StackFrame[] stackFrameArray, StackFrame[] stackFrameArray2) {
        if (stackFrameArray2.length != stackFrameArray.length) {
            return false;
        }
        return this.isExecutingLine(stackFrameArray, stackFrameArray2);
    }

    private StackFrame[] runOnceTo(int n, Class clazz, Thread thread) throws IOException, NoSuchMethodException, InterruptedException {
        int n2;
        StackFrame[] stackFrameArray = null;
        this.hitUserBreak = false;
        boolean bl = BreakpointHandler.the_bkptHash.containsKey(new Integer(n));
        try {
            if (!bl) {
                this.bkptHandler.addBreakpoint(clazz, n, 2, null);
                BreakpointSet breakpointSet = (BreakpointSet)BreakpointHandler.the_bkptHash.get(new Integer(n));
                breakpointSet.setThread(thread);
            } else {
                Agent.message("run-to breakpoint already there, not setting");
            }
            do {
                this.agent.resumeLastSuspendedThreads();
                this.waitForBreak();
                if (!this.exceptionOccurred || this.userMustSeeException || this.event.thread == thread) continue;
                Agent.message("run-to ignoring exception in another thread");
            } while (this.exceptionOccurred && !this.userMustSeeException && this.event.thread != thread);
            stackFrameArray = this.getCurrentStackTrace(this.event.thread);
            n2 = stackFrameArray[0].pcAbsolute;
        }
        finally {
            Object var8_8 = null;
            if (!bl && BreakpointHandler.the_bkptHash.containsKey(new Integer(n))) {
                Agent.message("removing run-to breakpoint");
                this.bkptHandler.deleteBreakpoint(clazz, n);
            }
        }
        boolean bl2 = this.hitUserBreak = !this.exceptionOccurred && (bl || n2 != n);
        if (this.hitUserBreak) {
            Agent.message("Hit a real user breakpoint.");
        }
        return stackFrameArray;
    }

    private StackFrame[] runTo(int n, Class clazz, Thread thread, int n2) throws IOException, NoSuchMethodException, InterruptedException {
        StackFrame[] stackFrameArray;
        StackFrame[] stackFrameArray2 = stackFrameArray = this.getCurrentStackTrace(thread);
        boolean bl = false;
        while (!bl) {
            stackFrameArray2 = this.runOnceTo(n, clazz, thread);
            int n3 = stackFrameArray2[0].pcAbsolute;
            if (this.exceptionOccurred && !this.userMustSeeException) {
                int n4 = this.event.catch_pc;
                Agent.message("exception (" + this.event.exception + ") at " + n3 + " (" + stackFrameArray2[0].pc + ") while running over, going to catch-pc = " + n4);
                stackFrameArray2 = this.runOnceTo(n4, stackFrameArray2[0].clazz, thread);
                n3 = stackFrameArray2[0].pcAbsolute;
                if (n3 != n4) {
                    Agent.message("couldn't get to catch pc");
                    bl = true;
                    continue;
                }
                if (this.isExecutingLine(stackFrameArray, stackFrameArray2) && stackFrameArray.length != stackFrameArray2.length) continue;
                Agent.message("catch pc is not within line, stopping");
                bl = true;
                continue;
            }
            if (this.exceptionOccurred || this.hitUserBreak) {
                bl = true;
                continue;
            }
            if (stackFrameArray2.length <= n2) {
                bl = true;
                continue;
            }
            Agent.message("debuggee is recursing. continuing...");
        }
        return stackFrameArray2;
    }

    private boolean runToReturn(StackFrame[] stackFrameArray, Thread thread) throws IOException, NoSuchMethodException, InterruptedException {
        StackFrame stackFrame;
        int n;
        boolean bl = false;
        if (stackFrameArray.length > 1 && (n = this.getReturnPC(stackFrame = stackFrameArray[1])) != -1) {
            StackFrame[] stackFrameArray2;
            Agent.message("At " + stackFrameArray[0].className + " line " + stackFrameArray[0].lineno + ": Stepping out from " + stackFrameArray[0].pcAbsolute + " (relative=" + stackFrameArray[0].pc + ") to " + stackFrame.className + "." + stackFrame.methodName + " address " + n);
            do {
                stackFrameArray2 = this.runTo(n, stackFrame.clazz, thread, stackFrameArray.length - 1);
            } while ((!this.exceptionOccurred || !this.userMustSeeException) && !this.hitUserBreak && stackFrameArray2.length >= stackFrameArray.length);
            bl = true;
        }
        return bl;
    }

    private void notifyRemoteDebugger() throws IOException {
        if (this.exceptionOccurred && this.userMustSeeException) {
            String string = this.event.catch_pc == 0 ? "Uncaught exception: " : "Exception: ";
            String string2 = this.agent.exceptionStackTrace(this.event.exception);
            string = string.concat(string2);
            DataOutputStream dataOutputStream = this.agent.asyncOutputStream;
            synchronized (dataOutputStream) {
                this.agent.asyncOutputStream.write(52);
                this.agent.writeObject(this.event.thread, this.agent.asyncOutputStream);
                this.agent.asyncOutputStream.writeUTF(string);
                this.agent.asyncOutputStream.flush();
                return;
            }
        }
        DataOutputStream dataOutputStream = this.agent.asyncOutputStream;
        synchronized (dataOutputStream) {
            this.agent.asyncOutputStream.write(46);
            this.agent.writeObject(this.event.thread, this.agent.asyncOutputStream);
            this.agent.asyncOutputStream.flush();
            return;
        }
    }

    private synchronized void internalStepInstruction(Thread thread) throws InterruptedException {
        try {
            this.hitUserBreak = false;
            do {
                this.agent.setSingleStep(thread, true);
                this.agent.resumeLastSuspendedThreads();
                this.waitForBreak();
            } while (this.exceptionOccurred && !this.userMustSeeException);
            if (BreakpointHandler.the_bkptHash.get(new Integer(this.event.pc)) != null) {
                this.hitUserBreak = true;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            this.agent.setSingleStep(thread, false);
            throw interruptedException;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            Agent.error("step failed: " + illegalThreadStateException.getMessage());
        }
    }

    private synchronized void stepLine(int n, Thread thread) throws InterruptedException {
        if (!Agent.systemThread(thread)) {
            Agent.message("next stepping " + thread.getName());
            try {
                boolean bl;
                boolean bl2;
                StackFrame[] stackFrameArray = this.getCurrentStackTrace(thread);
                LineNumber lineNumber = this.agent.lineno2pc(stackFrameArray[0].clazz, stackFrameArray[0].lineno);
                if (lineNumber == null || lineNumber.endPC == -1) {
                    Agent.message("no line information available, single-stepping.");
                    this.internalStepInstruction(thread);
                    this.notifyRemoteDebugger();
                    return;
                }
                StackFrame[] stackFrameArray2 = stackFrameArray;
                int n2 = stackFrameArray2[0].pcAbsolute;
                do {
                    int n3;
                    int n4;
                    if (this.isInvokeOpcode(n4 = this.agent.peekSafely(n2)) && n == 0) {
                        n3 = n2 + this.instructionLength(n4);
                        Class clazz = stackFrameArray2[0].clazz;
                        Agent.message("At " + stackFrameArray2[0].className + " line " + stackFrameArray2[0].lineno + ": running from " + n2 + " (relative=" + stackFrameArray2[0].pc + ", opcode=" + n4 + ") to " + n3);
                        stackFrameArray2 = this.runTo(n3, clazz, thread, stackFrameArray.length);
                        n2 = stackFrameArray2[0].pcAbsolute;
                    } else {
                        n3 = 0;
                        if (this.isReturnOpcode(n4) && n == 0) {
                            n3 = this.runToReturn(stackFrameArray2, thread) ? 1 : 0;
                        }
                        if (n3 != 0) {
                            stackFrameArray2 = this.getCurrentStackTrace(this.event.thread);
                            n2 = stackFrameArray2[0].pcAbsolute;
                        } else {
                            Agent.message("At " + stackFrameArray2[0].className + " line " + stackFrameArray2[0].lineno + ": stepping from " + n2 + " (relative=" + stackFrameArray2[0].pc + ", opcode=" + n4 + ")");
                            this.internalStepInstruction(thread);
                            stackFrameArray2 = this.getCurrentStackTrace(this.event.thread);
                            n2 = stackFrameArray2[0].pcAbsolute;
                            if (!(n != 0 || stackFrameArray.length >= stackFrameArray2.length || thread != this.event.thread || this.hitUserBreak || this.exceptionOccurred && this.userMustSeeException)) {
                                boolean bl3 = this.runToReturn(stackFrameArray2, thread);
                                if (bl3) {
                                    stackFrameArray2 = this.getCurrentStackTrace(this.event.thread);
                                    n2 = stackFrameArray2[0].pcAbsolute;
                                } else {
                                    Agent.message("At " + stackFrameArray2[0].className + " line " + stackFrameArray2[0].lineno + ": unexpectedly stepped into a method. Can't find a return address");
                                    break;
                                }
                            }
                        }
                    }
                    bl2 = n == 0 ? !this.isExecutingLine(stackFrameArray, stackFrameArray2) : !this.isWithinLine(stackFrameArray, stackFrameArray2);
                    boolean bl4 = bl = this.exceptionOccurred && this.userMustSeeException || this.hitUserBreak;
                } while (!bl2 && !bl);
                this.notifyRemoteDebugger();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("next step failed: " + illegalThreadStateException.getMessage());
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Agent.error("next step failed: " + noSuchMethodException.getMessage());
                return;
            }
            catch (IOException iOException) {
                Agent.error("next step failed: " + iOException.getMessage());
                return;
            }
        }
    }

    private synchronized void stepInstruction(Thread thread) throws InterruptedException {
        if (!Agent.systemThread(thread)) {
            Agent.message("stepping " + thread.getName());
            try {
                this.internalStepInstruction(thread);
                this.notifyRemoteDebugger();
                return;
            }
            catch (IOException iOException) {
                Agent.error("step failed: " + iOException.getMessage());
                return;
            }
        }
    }

    private synchronized void stepOut(Thread thread) throws InterruptedException {
        if (!Agent.systemThread(thread)) {
            Agent.message("stepping out " + thread.getName());
            try {
                StackFrame[] stackFrameArray = this.getCurrentStackTrace(thread);
                boolean bl = this.runToReturn(stackFrameArray, thread);
                if (!bl) {
                    Agent.message("Unable to step out; single stepping");
                    this.hitUserBreak = false;
                    this.internalStepInstruction(thread);
                }
                this.notifyRemoteDebugger();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("step out failed: " + illegalThreadStateException.getMessage());
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Agent.error("step out failed: " + noSuchMethodException.getMessage());
                return;
            }
            catch (IOException iOException) {
                Agent.error("step out failed: " + iOException.getMessage());
                return;
            }
        }
    }

    static {
        int n = 0;
        while (n < invokeMap.length) {
            StepHandler.invokeMap[n] = false;
            ++n;
        }
        StepHandler.invokeMap[182] = true;
        StepHandler.invokeMap[183] = true;
        StepHandler.invokeMap[184] = true;
        StepHandler.invokeMap[185] = true;
        StepHandler.invokeMap[214] = true;
        StepHandler.invokeMap[215] = true;
        StepHandler.invokeMap[216] = true;
        StepHandler.invokeMap[217] = true;
        StepHandler.invokeMap[218] = true;
        StepHandler.invokeMap[219] = true;
        StepHandler.invokeMap[226] = true;
        StepHandler.invokeMap[18] = true;
        StepHandler.invokeMap[19] = true;
        StepHandler.invokeMap[203] = true;
        StepHandler.invokeMap[204] = true;
        StepHandler.invokeMap[187] = true;
        StepHandler.invokeMap[189] = true;
        StepHandler.invokeMap[197] = true;
        StepHandler.invokeMap[192] = true;
        StepHandler.invokeMap[193] = true;
        StepHandler.invokeMap[178] = true;
        StepHandler.invokeMap[179] = true;
        StepHandler.invokeMap[180] = true;
        StepHandler.invokeMap[181] = true;
        StepHandler.invokeMap[206] = true;
        StepHandler.invokeMap[207] = true;
        StepHandler.invokeMap[208] = true;
        StepHandler.invokeMap[209] = true;
        StepHandler.invokeMap[211] = true;
        StepHandler.invokeMap[212] = true;
        StepHandler.invokeMap[213] = true;
        StepHandler.invokeMap[221] = true;
        StepHandler.invokeMap[222] = true;
        StepHandler.invokeMap[223] = true;
        StepHandler.invokeMap[224] = true;
        StepHandler.invokeMap[225] = true;
        StepHandler.invokeMap[227] = true;
        StepHandler.invokeMap[228] = true;
        branchMap = new boolean[256];
        n = 0;
        while (n < branchMap.length) {
            StepHandler.branchMap[n] = false;
            ++n;
        }
        StepHandler.branchMap[167] = true;
        StepHandler.branchMap[200] = true;
        StepHandler.branchMap[153] = true;
        StepHandler.branchMap[198] = true;
        StepHandler.branchMap[155] = true;
        StepHandler.branchMap[158] = true;
        StepHandler.branchMap[154] = true;
        StepHandler.branchMap[199] = true;
        StepHandler.branchMap[157] = true;
        StepHandler.branchMap[156] = true;
        StepHandler.branchMap[159] = true;
        StepHandler.branchMap[160] = true;
        StepHandler.branchMap[161] = true;
        StepHandler.branchMap[163] = true;
        StepHandler.branchMap[164] = true;
        StepHandler.branchMap[162] = true;
        StepHandler.branchMap[168] = true;
        StepHandler.branchMap[201] = true;
        StepHandler.branchMap[169] = true;
        StepHandler.branchMap[171] = true;
        StepHandler.branchMap[170] = true;
        StepHandler.branchMap[191] = true;
        StepHandler.branchMap[172] = true;
        StepHandler.branchMap[173] = true;
        StepHandler.branchMap[174] = true;
        StepHandler.branchMap[175] = true;
        StepHandler.branchMap[176] = true;
        StepHandler.branchMap[177] = true;
    }
}

