/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.tools.jar.CRC32OutputStream;
import sun.tools.jar.JarException;
import sun.tools.jar.Manifest;

public class Main {
    String program;
    PrintStream out;
    PrintStream err;
    String fname;
    String mname;
    String zname = "";
    String[] files;
    CRC32 crc32 = new CRC32();
    boolean cflag;
    boolean xflag;
    boolean tflag;
    boolean vflag;
    boolean flag0;
    boolean Mflag;
    static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final char SEPARATOR = File.separatorChar;

    public Main(PrintStream printStream, PrintStream printStream2, String string) {
        this.out = printStream;
        this.err = printStream2;
        this.program = string;
    }

    public synchronized boolean run(String[] stringArray) {
        boolean bl = true;
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        try {
            if (this.cflag) {
                FileOutputStream fileOutputStream;
                if (this.fname != null) {
                    fileOutputStream = new FileOutputStream(this.fname);
                    this.zname = this.fname.replace(File.separatorChar, '/');
                    if (this.zname.startsWith("./")) {
                        this.zname = this.zname.substring(2);
                    }
                } else {
                    fileOutputStream = new FileOutputStream(FileDescriptor.out);
                }
                Manifest manifest = null;
                if (!this.Mflag) {
                    if (this.mname != null) {
                        FileInputStream fileInputStream = new FileInputStream(this.mname);
                        manifest = new Manifest((InputStream)new BufferedInputStream(fileInputStream));
                    } else {
                        manifest = new Manifest(null);
                    }
                }
                this.create(new BufferedOutputStream(fileOutputStream), this.expand(this.files), manifest);
            } else if (this.xflag || this.tflag) {
                FileInputStream fileInputStream = this.fname != null ? new FileInputStream(this.fname) : new FileInputStream(FileDescriptor.in);
                if (this.xflag) {
                    this.extract(new BufferedInputStream(fileInputStream), this.files);
                } else {
                    this.list(new BufferedInputStream(fileInputStream), this.files);
                }
            }
        }
        catch (IOException iOException) {
            this.fatalError(iOException);
            bl = false;
        }
        catch (Error error) {
            error.printStackTrace();
            bl = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = false;
        }
        this.out.flush();
        this.err.flush();
        return bl;
    }

    boolean parseArgs(String[] stringArray) {
        int n = 1;
        try {
            String string = stringArray[0];
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            int n2 = 0;
            while (n2 < string.length()) {
                switch (string.charAt(n2)) {
                    case 'c': {
                        if (this.xflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.cflag = true;
                        break;
                    }
                    case 'x': {
                        if (this.cflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.xflag = true;
                        break;
                    }
                    case 't': {
                        if (this.cflag || this.xflag) {
                            this.usageError();
                            return false;
                        }
                        this.tflag = true;
                        break;
                    }
                    case 'M': {
                        this.Mflag = true;
                        break;
                    }
                    case 'v': {
                        this.vflag = true;
                        break;
                    }
                    case 'f': {
                        this.fname = stringArray[n++];
                        break;
                    }
                    case 'm': {
                        this.mname = stringArray[n++];
                        break;
                    }
                    case '0': {
                        this.flag0 = true;
                        break;
                    }
                    default: {
                        this.error("Illegal option: " + string.charAt(n2));
                        this.usageError();
                        return false;
                    }
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.usageError();
            return false;
        }
        if (!(this.cflag || this.tflag || this.xflag)) {
            this.error("One of options -{ctx} must be specified.");
            this.usageError();
            return false;
        }
        if (stringArray.length - n > 0) {
            this.files = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, this.files, 0, this.files.length);
        } else if (this.cflag) {
            this.error("'c' flag requires that input files specified!");
            this.usageError();
            return false;
        }
        return true;
    }

    String[] expand(String[] stringArray) {
        Vector vector = new Vector();
        this.expand(null, stringArray, vector, new Hashtable());
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((File)vector.elementAt(n)).getPath();
            ++n;
        }
        return stringArray;
    }

    void expand(File file, String[] stringArray, Vector vector, Hashtable hashtable) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = file == null ? new File(stringArray[n]) : new File(file, stringArray[n]);
            if (file2.isFile()) {
                if (!hashtable.contains(file2)) {
                    hashtable.put(file2, file2);
                    vector.addElement(file2);
                }
            } else if (file2.isDirectory()) {
                File file3 = file2.getPath().endsWith(File.separator) ? file2 : new File(String.valueOf(file2.getPath()) + File.separator);
                hashtable.put(file3, file3);
                vector.addElement(file3);
                this.expand(file2, file2.list(), vector, hashtable);
            } else {
                this.error(String.valueOf(file2) + ": no such file or directory");
            }
            ++n;
        }
    }

    void create(OutputStream outputStream, String[] stringArray, Manifest manifest) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        if (this.flag0) {
            zipOutputStream.setMethod(0);
        }
        if (manifest != null) {
            manifest.addFiles(null, stringArray);
            ZipEntry zipEntry = new ZipEntry(MANIFEST);
            zipEntry.setTime(System.currentTimeMillis());
            if (this.flag0) {
                this.crc32Manifest(zipEntry, manifest);
            }
            zipOutputStream.putNextEntry(zipEntry);
            manifest.stream((OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
        int n = 0;
        while (n < stringArray.length) {
            this.addFile(zipOutputStream, new File(stringArray[n]));
            ++n;
        }
        zipOutputStream.close();
    }

    private String entryName(String string) {
        if ((string = string.replace(File.separatorChar, '/')).startsWith("/")) {
            string = string.substring(1);
        } else if (string.startsWith("./")) {
            string = string.substring(2);
        }
        return string;
    }

    void addFile(ZipOutputStream zipOutputStream, File file) throws IOException {
        long l;
        String string = this.entryName(file.getPath());
        if (string.equals("") || string.equals(".") || string.equals(this.zname)) {
            return;
        }
        boolean bl = file.isDirectory();
        long l2 = l = bl ? 0L : file.length();
        if (this.vflag) {
            this.err.print("adding: " + string + " ");
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(file.lastModified());
        if (l == 0L) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        } else if (this.flag0) {
            zipEntry.setSize(l);
            this.crc32File(zipEntry, file);
        }
        zipOutputStream.putNextEntry(zipEntry);
        if (!bl) {
            int n;
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            ((InputStream)bufferedInputStream).close();
        }
        zipOutputStream.closeEntry();
        if (this.vflag) {
            l = zipEntry.getSize();
            long l3 = zipEntry.getCompressedSize();
            this.err.print("(in=" + l + ") (out=" + l3 + ") ");
            if (zipEntry.getMethod() == 8) {
                long l4 = 0L;
                if (l != 0L) {
                    l4 = (l - l3) * 100L / l;
                }
                this.output("(deflated " + l4 + "%)");
                return;
            }
            this.output("(stored 0%)");
        }
    }

    private void crc32Manifest(ZipEntry zipEntry, Manifest manifest) throws IOException {
        this.crc32.reset();
        CRC32OutputStream cRC32OutputStream = new CRC32OutputStream(this.crc32);
        PrintStream printStream = new PrintStream((OutputStream)cRC32OutputStream);
        manifest.stream((OutputStream)printStream);
        zipEntry.setSize(cRC32OutputStream.n);
        zipEntry.setCrc(this.crc32.getValue());
    }

    private void crc32File(ZipEntry zipEntry, File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[1024];
        this.crc32.reset();
        int n = 0;
        int n2 = 0;
        long l = file.length();
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            n2 += n;
            this.crc32.update(byArray, 0, n);
        }
        ((InputStream)bufferedInputStream).close();
        if (n2 != (int)l) {
            throw new JarException("incorrect length while processing: " + file.getPath());
        }
        zipEntry.setCrc(this.crc32.getValue());
    }

    void extract(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (stringArray == null) {
                this.extractFile(zipInputStream, zipEntry);
                continue;
            }
            String string = zipEntry.getName().replace('/', File.separatorChar);
            int n = 0;
            while (n < stringArray.length) {
                if (string.startsWith(stringArray[n])) {
                    this.extractFile(zipInputStream, zipEntry);
                    continue block0;
                }
                ++n;
            }
        }
    }

    void extractFile(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        File file = new File(zipEntry.getName().replace('/', File.separatorChar));
        if (zipEntry.isDirectory()) {
            if (!file.exists() && !file.mkdirs() || !file.isDirectory()) {
                throw new IOException(String.valueOf(file) + ": could not create directory");
            }
            if (this.vflag) {
                this.output("   created: " + file.getPath());
                return;
            }
        } else {
            int n;
            Object object;
            if (!(file.getParent() == null || (((File)(object = new File(file.getParent()))).exists() || ((File)object).mkdirs()) && ((File)object).isDirectory())) {
                throw new IOException(String.valueOf(object) + ": could not create directory");
            }
            object = new FileOutputStream(file);
            byte[] byArray = new byte[512];
            while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                ((OutputStream)object).write(byArray, 0, n);
            }
            zipInputStream.closeEntry();
            ((OutputStream)object).close();
            if (this.vflag) {
                if (zipEntry.getMethod() == 8) {
                    this.output(" extracted: " + file.getPath());
                    return;
                }
                this.output("  inflated: " + file.getPath());
            }
        }
    }

    void list(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName().replace('/', File.separatorChar);
            zipInputStream.closeEntry();
            if (stringArray == null) {
                this.printEntry(zipEntry);
                continue;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (string.startsWith(stringArray[n])) {
                    this.printEntry(zipEntry);
                    continue block0;
                }
                ++n;
            }
        }
    }

    void printEntry(ZipEntry zipEntry) throws IOException {
        if (this.vflag) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = Long.toString(zipEntry.getSize());
            int n = 6 - string.length();
            while (n > 0) {
                stringBuffer.append(' ');
                --n;
            }
            stringBuffer.append(string).append(' ').append(new Date(zipEntry.getTime()).toString());
            stringBuffer.append(' ').append(zipEntry.getName());
            this.output(stringBuffer.toString());
            return;
        }
        this.output(zipEntry.getName());
    }

    void usageError() {
        this.error("Usage: jar {ctx}[vfm0M] [jar-file] [manifest-file] files ...");
        this.error("Options:");
        this.error("  -c  create new archive");
        this.error("  -t  list table of contents for archive");
        this.error("  -x  extract named (or all) files from archive");
        this.error("  -v  generate verbose output on standard error");
        this.error("  -f  specify archive file name");
        this.error("  -m  include manifest information from specified manifest file");
        this.error("  -0  store only; use no ZIP compression");
        this.error("  -M  Do not create a manifest file for the entries\n");
        this.error("If any file is a directory then it is processed recursively.");
        this.error("The manifest file name and the archive file name needs to be specified");
        this.error("in the same order the 'm' and 'f' flags are specified.\n");
        this.error("Example: to archive two class files into an archive called classes.jar: ");
        this.error("  jar cvf classes.jar Foo.class Bar.class ");
        this.error("Note: use the '0' option to create a jar file that can be put in your CLASSPATH");
    }

    void fatalError(Exception exception) {
        exception.printStackTrace();
    }

    void fatalError(String string) {
        this.error(String.valueOf(this.program) + ": " + string);
    }

    protected void output(String string) {
        this.err.println(string);
    }

    protected void error(String string) {
        this.err.println(string);
    }

    public static void main(String[] stringArray) {
        Main main = new Main(System.out, System.err, "jar");
        System.exit(main.run(stringArray) ? 0 : 1);
    }
}

