/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import sun.tools.java.BinaryAttribute;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.BinaryExceptionHandler;
import sun.tools.java.BinaryField;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;

public class BinaryCode
implements Constants {
    int maxStack;
    int maxLocals;
    BinaryExceptionHandler[] exceptionHandlers;
    BinaryAttribute atts;
    BinaryConstantPool cpool;
    byte[] code;

    public BinaryCode(byte[] byArray, BinaryConstantPool binaryConstantPool, Environment environment) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            this.cpool = binaryConstantPool;
            this.maxStack = dataInputStream.readShort();
            this.maxLocals = dataInputStream.readShort();
            int n = dataInputStream.readInt();
            this.code = new byte[n];
            dataInputStream.read(this.code);
            int n2 = dataInputStream.readShort();
            this.exceptionHandlers = new BinaryExceptionHandler[n2];
            int n3 = 0;
            while (n3 < n2) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                ClassDeclaration classDeclaration = binaryConstantPool.getDeclaration(environment, dataInputStream.readShort());
                this.exceptionHandlers[n3] = new BinaryExceptionHandler(s, s2, s3, classDeclaration);
                ++n3;
            }
            this.atts = BinaryAttribute.load(dataInputStream, binaryConstantPool, -1);
            if (dataInputStream.available() != 0) {
                System.err.println("Should have exhausted input stream!");
                return;
            }
        }
        catch (IOException iOException) {
            throw new CompilerError(iOException);
        }
    }

    public BinaryExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public byte[] getCode() {
        return this.code;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public BinaryAttribute getAttributes() {
        return this.atts;
    }

    public static BinaryCode load(BinaryField binaryField, BinaryConstantPool binaryConstantPool, Environment environment) {
        byte[] byArray = binaryField.getAttribute(Constants.idCode);
        if (byArray != null) {
            return new BinaryCode(byArray, binaryConstantPool, environment);
        }
        return null;
    }
}

