/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.Type;

public final class BinaryConstantPool
implements Constants {
    private byte[] types;
    private Object[] cpool;
    Hashtable indexHashObject;
    Hashtable indexHashAscii;
    Vector MoreStuff;

    BinaryConstantPool(DataInputStream dataInputStream) throws IOException {
        this.types = new byte[dataInputStream.readShort()];
        this.cpool = new Object[this.types.length];
        int n = 1;
        while (n < this.cpool.length) {
            this.types[n] = dataInputStream.readByte();
            switch (this.types[n]) {
                case 1: {
                    this.cpool[n] = dataInputStream.readUTF();
                    break;
                }
                case 3: {
                    this.cpool[n] = new Integer(dataInputStream.readInt());
                    break;
                }
                case 4: {
                    this.cpool[n] = new Float(dataInputStream.readFloat());
                    break;
                }
                case 5: {
                    this.cpool[n++] = new Long(dataInputStream.readLong());
                    break;
                }
                case 6: {
                    this.cpool[n++] = new Double(dataInputStream.readDouble());
                    break;
                }
                case 7: 
                case 8: {
                    this.cpool[n] = new Integer(dataInputStream.readShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.cpool[n] = new Integer(dataInputStream.readShort() << 16 | dataInputStream.readShort());
                    break;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.types[n]);
                }
            }
            ++n;
        }
    }

    public int getInteger(int n) {
        if (n == 0) {
            return 0;
        }
        return ((Number)this.cpool[n]).intValue();
    }

    public Object getValue(int n) {
        if (n == 0) {
            return null;
        }
        return this.cpool[n];
    }

    public String getString(int n) {
        if (n == 0) {
            return null;
        }
        return (String)this.cpool[n];
    }

    public Identifier getIdentifier(int n) {
        if (n == 0) {
            return null;
        }
        return Identifier.lookup(this.getString(n));
    }

    public ClassDeclaration getDeclarationFromName(Environment environment, int n) {
        if (n == 0) {
            return null;
        }
        return environment.getClassDeclaration(Identifier.lookup(this.getString(n).replace('/', '.')));
    }

    public ClassDeclaration getDeclaration(Environment environment, int n) {
        if (n == 0) {
            return null;
        }
        return this.getDeclarationFromName(environment, this.getInteger(n));
    }

    public Type getType(int n) {
        return Type.tType(this.getString(n));
    }

    public int getConstantType(int n) {
        return this.types[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getConstant(int n, Environment environment) {
        int n2 = this.getConstantType(n);
        switch (n2) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.getValue(n);
            }
            case 7: {
                return this.getDeclaration(environment, n);
            }
            case 8: {
                return this.getString(this.getInteger(n));
            }
            case 9: 
            case 10: 
            case 11: {
                try {
                    int n3 = this.getInteger(n);
                    ClassDefinition classDefinition = this.getDeclaration(environment, n3 >> 16).getClassDefinition(environment);
                    int n4 = this.getInteger(n3 & 0xFFFF);
                    Identifier identifier = this.getIdentifier(n4 >> 16);
                    Type type = this.getType(n4 & 0xFFFF);
                    FieldDefinition fieldDefinition = classDefinition.getFirstMatch(identifier);
                    while (fieldDefinition != null) {
                        boolean bl;
                        Type type2 = fieldDefinition.getType();
                        if (n2 == 9) {
                            if (type2 == type) return fieldDefinition;
                            bl = false;
                        } else {
                            bl = type2.equalArguments(type);
                        }
                        if (bl) {
                            return fieldDefinition;
                        }
                        fieldDefinition = fieldDefinition.getNextMatch();
                    }
                    return null;
                }
                catch (ClassNotFound classNotFound) {}
                return null;
            }
        }
        throw new ClassFormatError("invalid constant type: " + n2);
    }

    public Vector getDependencies(Environment environment) {
        Vector<ClassDeclaration> vector = new Vector<ClassDeclaration>();
        int n = 1;
        while (n < this.cpool.length) {
            switch (this.types[n]) {
                case 7: {
                    vector.addElement(this.getDeclarationFromName(environment, this.getInteger(n)));
                    break;
                }
            }
            ++n;
        }
        return vector;
    }

    public int indexObject(Object object, Environment environment) {
        Integer n;
        if (this.indexHashObject == null) {
            this.createIndexHash(environment);
        }
        if ((n = (Integer)this.indexHashObject.get(object)) == null) {
            throw new IndexOutOfBoundsException("Cannot find object " + object + " of type " + object.getClass() + " in constant pool");
        }
        return n;
    }

    public int indexString(String string, Environment environment) {
        Integer n;
        if (this.indexHashObject == null) {
            this.createIndexHash(environment);
        }
        if ((n = (Integer)this.indexHashAscii.get(string)) == null) {
            if (this.MoreStuff == null) {
                this.MoreStuff = new Vector();
            }
            n = new Integer(this.cpool.length + this.MoreStuff.size());
            this.MoreStuff.addElement(string);
            this.indexHashAscii.put(string, n);
        }
        return n;
    }

    public void createIndexHash(Environment environment) {
        this.indexHashObject = new Hashtable();
        this.indexHashAscii = new Hashtable();
        int n = 1;
        while (n < this.cpool.length) {
            if (this.types[n] == 1) {
                this.indexHashAscii.put(this.cpool[n], new Integer(n));
            } else {
                try {
                    this.indexHashObject.put(this.getConstant(n, environment), new Integer(n));
                }
                catch (ClassFormatError classFormatError) {}
            }
            ++n;
        }
    }

    public void write(DataOutputStream dataOutputStream, Environment environment) throws IOException {
        Object object;
        int n;
        int n2 = this.cpool.length;
        if (this.MoreStuff != null) {
            n2 += this.MoreStuff.size();
        }
        dataOutputStream.writeShort(n2);
        int n3 = 1;
        while (n3 < this.cpool.length) {
            n = this.types[n3];
            object = this.cpool[n3];
            dataOutputStream.writeByte(n);
            switch (n) {
                case 1: {
                    dataOutputStream.writeUTF((String)object);
                    break;
                }
                case 3: {
                    dataOutputStream.writeInt(((Number)object).intValue());
                    break;
                }
                case 4: {
                    dataOutputStream.writeFloat(((Number)object).floatValue());
                    break;
                }
                case 5: {
                    dataOutputStream.writeLong(((Number)object).longValue());
                    ++n3;
                    break;
                }
                case 6: {
                    dataOutputStream.writeDouble(((Number)object).doubleValue());
                    ++n3;
                    break;
                }
                case 7: 
                case 8: {
                    dataOutputStream.writeShort(((Number)object).intValue());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    int n4 = ((Number)object).intValue();
                    dataOutputStream.writeShort(n4 >> 16);
                    dataOutputStream.writeShort(n4 & 0xFFFF);
                    break;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.types[n3]);
                }
            }
            ++n3;
        }
        n = this.cpool.length;
        while (n < n2) {
            object = (String)this.MoreStuff.elementAt(n - this.cpool.length);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF((String)object);
            ++n;
        }
    }
}

