/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.Type;

public final class ClassDeclaration
implements Constants {
    int status;
    Type type;
    ClassDefinition definition;

    public ClassDeclaration(Identifier identifier) {
        this.type = Type.tClass(identifier);
    }

    public int getStatus() {
        return this.status;
    }

    public Identifier getName() {
        return this.type.getClassName();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDefined() {
        switch (this.status) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public ClassDefinition getClassDefinition() {
        return this.definition;
    }

    public ClassDefinition getClassDefinition(Environment environment) throws ClassNotFound {
        block5: while (true) {
            switch (this.status) {
                case 0: 
                case 1: 
                case 3: {
                    environment.loadDefinition(this);
                    continue block5;
                }
                case 2: 
                case 4: {
                    this.definition.basicCheck(environment);
                    return this.definition;
                }
                case 5: 
                case 7: {
                    return this.definition;
                }
            }
            break;
        }
        throw new ClassNotFound(this.getName());
    }

    public void setDefinition(ClassDefinition classDefinition, int n) {
        this.definition = classDefinition;
        this.status = n;
        if (classDefinition != null && !this.getName().equals(classDefinition.getName())) {
            throw new CompilerError("invalid class defintion: " + this + ", " + classDefinition);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ClassDeclaration) {
            return this.type.equals(((ClassDeclaration)object).type);
        }
        return false;
    }

    public String toString() {
        String string;
        String string2 = this.getName().toString();
        String string3 = "type ";
        String string4 = string = this.getName().isInner() ? "nested " : "";
        if (this.getClassDefinition() != null) {
            string3 = this.getClassDefinition().isInterface() ? "interface " : "class ";
            if (!this.getClassDefinition().isTopLevel()) {
                string = "inner ";
                if (this.getClassDefinition().isLocal()) {
                    string = "local ";
                    if (!this.getClassDefinition().isAnonymous()) {
                        string2 = String.valueOf(this.getClassDefinition().getLocalName()) + " (" + string2 + ")";
                    }
                }
            }
        }
        return String.valueOf(string) + string3 + string2;
    }
}

