/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.java.AmbiguousField;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Type;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.LocalField;
import sun.tools.tree.UplevelReference;
import sun.tools.tree.Vset;

public class ClassDefinition
implements Constants {
    protected Object source;
    protected int where;
    protected int modifiers;
    protected Identifier localName;
    protected ClassDeclaration declaration;
    protected IdentifierToken superClassId;
    protected IdentifierToken[] interfaceIds;
    protected ClassDeclaration superClass;
    protected ClassDeclaration[] interfaces;
    protected ClassDefinition outerClass;
    protected FieldDefinition outerField;
    protected FieldDefinition innerClassField;
    protected FieldDefinition firstField;
    protected FieldDefinition lastField;
    protected boolean resolved;
    protected String documentation;
    protected boolean error;
    protected UplevelReference references;
    protected boolean referencesFrozen;
    private Hashtable fieldHash = new Hashtable(31);
    private int abstr;

    protected ClassDefinition(Object object, int n, ClassDeclaration classDeclaration, int n2, IdentifierToken identifierToken, IdentifierToken[] identifierTokenArray) {
        this.source = object;
        this.where = n;
        this.declaration = classDeclaration;
        this.modifiers = n2;
        this.superClassId = identifierToken;
        this.interfaceIds = identifierTokenArray;
    }

    public final Object getSource() {
        return this.source;
    }

    public final boolean getError() {
        return this.error;
    }

    public final void setError(boolean bl) {
        this.error = bl;
    }

    public final int getWhere() {
        return this.where;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.declaration;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final ClassDeclaration getSuperClass() {
        return this.superClass;
    }

    public ClassDeclaration getSuperClass(Environment environment) {
        if (this.superClass == null && this.superClassId != null) {
            this.resolveTypeStructure(environment);
            if (this.superClass == null && this.superClassId != null) {
                environment.error(this.where, "cyclic.scoping");
            }
        }
        return this.superClass;
    }

    public final ClassDeclaration[] getInterfaces() {
        if (this.interfaces == null) {
            throw new CompilerError("getInterfaces");
        }
        return this.interfaces;
    }

    public final ClassDefinition getOuterClass() {
        return this.outerClass;
    }

    protected final void setOuterClass(ClassDefinition classDefinition) {
        if (this.outerClass != null) {
            throw new CompilerError("setOuterClass");
        }
        this.outerClass = classDefinition;
    }

    protected final void setOuterField(FieldDefinition fieldDefinition) {
        if (this.isStatic() || !this.isInnerClass()) {
            throw new CompilerError("setOuterField");
        }
        if (this.outerField != null) {
            throw new CompilerError("setOuterField");
        }
        this.outerField = fieldDefinition;
    }

    public final boolean isInnerClass() {
        return this.outerClass != null;
    }

    public final boolean isMember() {
        return this.outerClass != null && !this.isLocal();
    }

    public final boolean isTopLevel() {
        return this.outerClass == null || this.isStatic() || this.isInterface();
    }

    public final boolean isInsideLocal() {
        return this.isLocal() || this.outerClass != null && this.outerClass.isInsideLocal();
    }

    public Identifier getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        return this.getName().getFlatName().getName();
    }

    public void setLocalName(Identifier identifier) {
        if (this.isLocal()) {
            this.localName = identifier;
        }
    }

    public final FieldDefinition getInnerClassField() {
        if (this.outerClass == null) {
            return null;
        }
        if (this.innerClassField == null) {
            Identifier identifier = this.getName().getFlatName().getName();
            FieldDefinition fieldDefinition = this.outerClass.getFirstMatch(identifier);
            while (fieldDefinition != null) {
                if (fieldDefinition.isInnerClass()) {
                    this.innerClassField = fieldDefinition;
                    break;
                }
                fieldDefinition = fieldDefinition.getNextMatch();
            }
            if (this.innerClassField == null) {
                throw new CompilerError("getInnerClassField");
            }
        }
        return this.innerClassField;
    }

    public final FieldDefinition findOuterField() {
        return this.outerField;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final ClassDefinition getTopClass() {
        ClassDefinition classDefinition;
        ClassDefinition classDefinition2 = this;
        while ((classDefinition = classDefinition2.outerClass) != null) {
            classDefinition2 = classDefinition;
        }
        return classDefinition2;
    }

    public final FieldDefinition getFirstField() {
        return this.firstField;
    }

    public final FieldDefinition getFirstMatch(Identifier identifier) {
        return (FieldDefinition)this.fieldHash.get(identifier);
    }

    public final Identifier getName() {
        return this.declaration.getName();
    }

    public final Type getType() {
        return this.declaration.getType();
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public static boolean containsDeprecated(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while ((n = string.indexOf("@deprecated", n)) >= 0) {
            block5: {
                char c;
                char c2;
                int n2 = n - 1;
                while (n2 >= 0) {
                    c2 = string.charAt(n2);
                    if (c2 == '\n' || c2 == '\r') break;
                    if (Character.isSpace(c2)) {
                        --n2;
                        continue;
                    }
                    break block5;
                }
                if ((c2 = n + "@deprecated".length()) >= string.length() || (c = string.charAt(c2)) == '\n' || c == '\r' || Character.isSpace(c)) {
                    return true;
                }
            }
            n += "@deprecated".length();
        }
        return false;
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final boolean isClass() {
        return (this.getModifiers() & 0x200) == 0;
    }

    public final boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public final boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public final boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    public final boolean isAbstract(Environment environment) throws ClassNotFound {
        if (this.isAbstract()) {
            return true;
        }
        if (this.abstr == 0) {
            int n = this.abstr = this.isInterface() || this.hasAbstractFields(environment) ? 1 : -1;
        }
        return this.abstr == 1;
    }

    public final boolean isSynthetic() {
        return (this.getModifiers() & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.getModifiers() & 0x40000) != 0;
    }

    public final boolean isAnonymous() {
        return (this.getModifiers() & 0x10000) != 0;
    }

    public final boolean isLocal() {
        return (this.getModifiers() & 0x20000) != 0;
    }

    public final boolean hasConstructor() {
        return this.getFirstMatch(Constants.idInit) != null;
    }

    public Enumeration getAbstractFields(Environment environment) throws ClassNotFound {
        Vector vector = new Vector();
        this.getAbstractFields(environment, this, vector);
        return vector.elements();
    }

    private void getAbstractFields(Environment environment, ClassDefinition classDefinition, Vector vector) throws ClassNotFound {
        ClassDefinition classDefinition2;
        Constants constants;
        FieldDefinition fieldDefinition = classDefinition.getFirstField();
        while (fieldDefinition != null) {
            if (fieldDefinition.isAbstract()) {
                constants = this.findMethod(environment, fieldDefinition.getName(), fieldDefinition.getType());
                if (constants == null) {
                    constants = fieldDefinition;
                }
                if (((FieldDefinition)constants).isAbstract() && !vector.contains(constants)) {
                    vector.addElement(constants);
                }
            }
            fieldDefinition = fieldDefinition.getNextField();
        }
        constants = classDefinition.getSuperClass();
        if (constants != null && (classDefinition2 = constants.getClassDefinition(environment)).isAbstract(environment)) {
            this.getAbstractFields(environment, classDefinition2, vector);
        }
    }

    public boolean hasAbstractFields(Environment environment) throws ClassNotFound {
        return this.hasAbstractFields(environment, this);
    }

    private boolean hasAbstractFields(Environment environment, ClassDefinition classDefinition) throws ClassNotFound {
        Constants constants;
        FieldDefinition fieldDefinition = classDefinition.getFirstField();
        while (fieldDefinition != null) {
            if (fieldDefinition.isAbstract() && fieldDefinition.isMethod() && ((constants = this.findMethod(environment, fieldDefinition.getName(), fieldDefinition.getType())) == null || ((FieldDefinition)constants).isAbstract())) {
                return true;
            }
            fieldDefinition = fieldDefinition.getNextField();
        }
        constants = classDefinition.getSuperClass();
        if (constants != null) {
            ClassDefinition classDefinition2 = ((ClassDeclaration)constants).getClassDefinition(environment);
            return classDefinition2.isAbstract(environment) && this.hasAbstractFields(environment, classDefinition2);
        }
        return false;
    }

    public boolean superClassOf(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        while (classDeclaration != null) {
            if (this.getClassDeclaration().equals(classDeclaration)) {
                return true;
            }
            classDeclaration = classDeclaration.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public boolean enclosingClassOf(ClassDefinition classDefinition) {
        while ((classDefinition = classDefinition.getOuterClass()) != null) {
            if (this != classDefinition) continue;
            return true;
        }
        return false;
    }

    public boolean subClassOf(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        ClassDeclaration classDeclaration2 = this.getClassDeclaration();
        while (classDeclaration2 != null) {
            if (classDeclaration2.equals(classDeclaration)) {
                return true;
            }
            classDeclaration2 = classDeclaration2.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public boolean implementedBy(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        while (classDeclaration != null) {
            if (this.getClassDeclaration().equals(classDeclaration)) {
                return true;
            }
            ClassDeclaration[] classDeclarationArray = classDeclaration.getClassDefinition(environment).getInterfaces();
            int n = 0;
            while (n < classDeclarationArray.length) {
                if (this.implementedBy(environment, classDeclarationArray[n])) {
                    return true;
                }
                ++n;
            }
            classDeclaration = classDeclaration.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public boolean extendsCanAccess(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        if (this.outerClass != null) {
            return this.outerClass.canAccess(environment, classDeclaration);
        }
        ClassDefinition classDefinition = classDeclaration.getClassDefinition(environment);
        if (classDefinition.isLocal()) {
            throw new CompilerError("top local");
        }
        if (classDefinition.isInnerClass()) {
            FieldDefinition fieldDefinition = classDefinition.getInnerClassField();
            if (fieldDefinition.isPublic()) {
                return true;
            }
            if (fieldDefinition.isPrivate()) {
                return this.getClassDeclaration().equals(fieldDefinition.getTopClass().getClassDeclaration());
            }
            return this.getName().getQualifier().equals(fieldDefinition.getClassDeclaration().getName().getQualifier());
        }
        if (classDefinition.isPublic()) {
            return true;
        }
        return this.getName().getQualifier().equals(classDeclaration.getName().getQualifier());
    }

    public boolean canAccess(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        ClassDefinition classDefinition = classDeclaration.getClassDefinition(environment);
        if (classDefinition.isLocal()) {
            return true;
        }
        if (classDefinition.isInnerClass()) {
            return this.canAccess(environment, classDefinition.getInnerClassField());
        }
        if (classDefinition.isPublic()) {
            return true;
        }
        return this.getName().getQualifier().equals(classDeclaration.getName().getQualifier());
    }

    public boolean canAccess(Environment environment, FieldDefinition fieldDefinition) throws ClassNotFound {
        if (fieldDefinition.isPublic()) {
            return true;
        }
        if (fieldDefinition.isProtected() && this.subClassOf(environment, fieldDefinition.getClassDeclaration())) {
            return true;
        }
        if (fieldDefinition.isPrivate()) {
            return this.getTopClass().getClassDeclaration().equals(fieldDefinition.getTopClass().getClassDeclaration());
        }
        return this.getName().getQualifier().equals(fieldDefinition.getClassDeclaration().getName().getQualifier());
    }

    public boolean protectedAccess(Environment environment, FieldDefinition fieldDefinition, Type type) throws ClassNotFound {
        return fieldDefinition.isStatic() || type.isType(9) && fieldDefinition.getName() == Constants.idClone && fieldDefinition.getType().getArgumentTypes().length == 0 || type.isType(10) && environment.getClassDefinition(type.getClassName()).subClassOf(environment, this.getClassDeclaration()) || this.getName().getQualifier().equals(fieldDefinition.getClassDeclaration().getName().getQualifier());
    }

    public FieldDefinition getAccessField(Environment environment, Context context, FieldDefinition fieldDefinition) {
        return null;
    }

    public FieldDefinition getUpdateField(Environment environment, Context context, FieldDefinition fieldDefinition) {
        return null;
    }

    public FieldDefinition getVariable(Environment environment, Identifier identifier) throws AmbiguousField, ClassNotFound {
        FieldDefinition fieldDefinition = this.getFirstMatch(identifier);
        while (fieldDefinition != null) {
            if (fieldDefinition.isVariable()) {
                return fieldDefinition;
            }
            fieldDefinition = fieldDefinition.getNextMatch();
        }
        ClassDeclaration classDeclaration = this.getSuperClass();
        FieldDefinition fieldDefinition2 = classDeclaration != null ? classDeclaration.getClassDefinition(environment).getVariable(environment, identifier) : null;
        int n = 0;
        while (n < this.interfaces.length) {
            FieldDefinition fieldDefinition3 = this.interfaces[n].getClassDefinition(environment).getVariable(environment, identifier);
            if (fieldDefinition3 != null) {
                if (fieldDefinition2 != null && fieldDefinition3 != fieldDefinition2) {
                    throw new AmbiguousField(fieldDefinition3, fieldDefinition2);
                }
                fieldDefinition2 = fieldDefinition3;
            }
            ++n;
        }
        return fieldDefinition2;
    }

    public boolean reportDeprecated(Environment environment) {
        return this.isDeprecated() || this.outerClass != null && this.outerClass.reportDeprecated(environment);
    }

    public void noteUsedBy(ClassDefinition classDefinition, int n, Environment environment) {
        if (this.reportDeprecated(environment)) {
            environment.error(n, "warn.class.is.deprecated", this);
        }
    }

    public FieldDefinition getInnerClass(Environment environment, Identifier identifier) throws ClassNotFound {
        FieldDefinition fieldDefinition = this.getFirstMatch(identifier);
        while (fieldDefinition != null) {
            if (fieldDefinition.isInnerClass() && !fieldDefinition.getInnerClass().isLocal()) {
                return fieldDefinition;
            }
            fieldDefinition = fieldDefinition.getNextMatch();
        }
        ClassDeclaration classDeclaration = this.getSuperClass(environment);
        if (classDeclaration != null) {
            return classDeclaration.getClassDefinition(environment).getInnerClass(environment, identifier);
        }
        return null;
    }

    private FieldDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier, Type[] typeArray, FieldDefinition fieldDefinition, boolean bl) throws AmbiguousField, ClassNotFound {
        ClassDeclaration classDeclaration;
        FieldDefinition fieldDefinition2 = this.getFirstMatch(identifier);
        while (fieldDefinition2 != null) {
            if (environment.isApplicable(fieldDefinition2, typeArray) && (classDefinition == null || classDefinition.canAccess(environment, fieldDefinition2))) {
                if (bl) {
                    if (fieldDefinition == null || environment.isMoreSpecific(fieldDefinition2, fieldDefinition)) {
                        fieldDefinition = fieldDefinition2;
                    }
                } else if (fieldDefinition2 != fieldDefinition && !environment.isMoreSpecific(fieldDefinition, fieldDefinition2)) {
                    throw new AmbiguousField(fieldDefinition, fieldDefinition2);
                }
            }
            fieldDefinition2 = fieldDefinition2.getNextMatch();
        }
        if (identifier.equals(Constants.idInit)) {
            return fieldDefinition;
        }
        if (!(fieldDefinition != null && bl || (classDeclaration = this.getSuperClass()) == null)) {
            ClassDefinition classDefinition2 = classDeclaration.getClassDefinition(environment);
            fieldDefinition = classDefinition2.matchMethod(environment, classDefinition, identifier, typeArray, fieldDefinition, bl);
            if (this.isInterface()) {
                ClassDeclaration[] classDeclarationArray = this.getInterfaces();
                int n = 0;
                while (n < classDeclarationArray.length) {
                    fieldDefinition = classDeclarationArray[n].getClassDefinition(environment).matchMethod(environment, classDefinition, identifier, typeArray, fieldDefinition, bl);
                    ++n;
                }
            }
        }
        return fieldDefinition;
    }

    public FieldDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier, Type[] typeArray) throws AmbiguousField, ClassNotFound {
        FieldDefinition fieldDefinition = this.matchMethod(environment, classDefinition, identifier, typeArray, null, true);
        if (fieldDefinition != null) {
            this.matchMethod(environment, classDefinition, identifier, typeArray, fieldDefinition, false);
        }
        return fieldDefinition;
    }

    public FieldDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier) throws AmbiguousField, ClassNotFound {
        return this.matchMethod(environment, classDefinition, identifier, Type.noArgs);
    }

    public FieldDefinition findMethod(Environment environment, Identifier identifier, Type type) throws ClassNotFound {
        FieldDefinition fieldDefinition = this.getFirstMatch(identifier);
        while (fieldDefinition != null) {
            if (fieldDefinition.getType().equalArguments(type)) {
                return fieldDefinition;
            }
            fieldDefinition = fieldDefinition.getNextMatch();
        }
        if (identifier.equals(Constants.idInit)) {
            return null;
        }
        ClassDeclaration classDeclaration = this.getSuperClass();
        if (classDeclaration == null) {
            return null;
        }
        return classDeclaration.getClassDefinition(environment).findMethod(environment, identifier, type);
    }

    protected void basicCheck(Environment environment) throws ClassNotFound {
        if (this.outerClass != null) {
            this.outerClass.basicCheck(environment);
        }
    }

    public void check(Environment environment) throws ClassNotFound {
    }

    public Vset checkLocalClass(Environment environment, Context context, Vset vset, ClassDefinition classDefinition, Expression[] expressionArray, Type[] typeArray) throws ClassNotFound {
        throw new CompilerError("checkLocalClass");
    }

    public void inlineLocalClass(Environment environment) {
    }

    public void resolveTypeStructure(Environment environment) {
    }

    public Identifier resolveName(Environment environment, Identifier identifier) {
        if (environment.innerClasses()) {
            if (identifier.isQualified()) {
                Identifier identifier2 = this.resolveName(environment, identifier.getHead());
                if (!environment.classExists(identifier2)) {
                    return environment.resolvePackageQualifiedName(identifier);
                }
                try {
                    return environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
                }
                catch (ClassNotFound classNotFound) {
                    return Identifier.lookupInner(identifier2, identifier.getTail());
                }
            }
            ClassDefinition classDefinition = this;
            while (classDefinition != null) {
                try {
                    FieldDefinition fieldDefinition = classDefinition.getInnerClass(environment, identifier);
                    if (fieldDefinition != null) {
                        return fieldDefinition.getInnerClass().getName();
                    }
                }
                catch (ClassNotFound classNotFound) {}
                classDefinition = classDefinition.outerClass;
            }
        }
        return environment.resolveName(identifier);
    }

    public Identifier resolveInnerClass(Environment environment, Identifier identifier) {
        if (identifier.isInner()) {
            throw new CompilerError("inner");
        }
        if (identifier.isQualified()) {
            Identifier identifier2 = this.resolveInnerClass(environment, identifier.getHead());
            try {
                return environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
            }
            catch (ClassNotFound classNotFound) {
                return Identifier.lookupInner(identifier2, identifier.getTail());
            }
        }
        try {
            FieldDefinition fieldDefinition = this.getInnerClass(environment, identifier);
            if (fieldDefinition != null) {
                return fieldDefinition.getInnerClass().getName();
            }
        }
        catch (ClassNotFound classNotFound) {}
        return Identifier.lookupInner(this.getName(), identifier);
    }

    public boolean innerClassExists(Identifier identifier) {
        FieldDefinition fieldDefinition = this.getFirstMatch(identifier.getHead());
        while (fieldDefinition != null) {
            if (fieldDefinition.isInnerClass() && !fieldDefinition.getInnerClass().isLocal()) {
                return !identifier.isQualified() || fieldDefinition.getInnerClass().innerClassExists(identifier.getTail());
            }
            fieldDefinition = fieldDefinition.getNextMatch();
        }
        return false;
    }

    public FieldDefinition findAnyMethod(Environment environment, Identifier identifier) throws ClassNotFound {
        FieldDefinition fieldDefinition = this.getFirstMatch(identifier);
        while (fieldDefinition != null) {
            if (fieldDefinition.isMethod()) {
                return fieldDefinition;
            }
            fieldDefinition = fieldDefinition.getNextMatch();
        }
        ClassDeclaration classDeclaration = this.getSuperClass();
        if (classDeclaration == null) {
            return null;
        }
        return classDeclaration.getClassDefinition(environment).findAnyMethod(environment, identifier);
    }

    public int diagnoseMismatch(Environment environment, Identifier identifier, Type[] typeArray, int n, Type[] typeArray2) throws ClassNotFound {
        int[] nArray = new int[typeArray.length];
        Type[] typeArray3 = new Type[typeArray.length];
        if (!this.diagnoseMismatch(environment, identifier, typeArray, n, nArray, typeArray3)) {
            return -2;
        }
        int n2 = n;
        while (n2 < typeArray.length) {
            if (nArray[n2] < 4) {
                typeArray2[0] = typeArray3[n2];
                return n2 << 2 | nArray[n2];
            }
            ++n2;
        }
        return -1;
    }

    private boolean diagnoseMismatch(Environment environment, Identifier identifier, Type[] typeArray, int n, int[] nArray, Type[] typeArray2) throws ClassNotFound {
        Type[] typeArray3;
        boolean bl = false;
        FieldDefinition fieldDefinition = this.getFirstMatch(identifier);
        while (fieldDefinition != null) {
            block11: {
                if (!fieldDefinition.isMethod() || (typeArray3 = fieldDefinition.getType().getArgumentTypes()).length != typeArray.length) break block11;
                bl = true;
                int n2 = n;
                while (n2 < typeArray.length) {
                    block13: {
                        Type type;
                        block15: {
                            block14: {
                                Type type2;
                                block12: {
                                    type2 = typeArray[n2];
                                    type = typeArray3[n2];
                                    if (!environment.implicitCast(type2, type)) break block12;
                                    nArray[n2] = 4;
                                    break block13;
                                }
                                if (nArray[n2] > 2 || !environment.explicitCast(type2, type)) break block14;
                                if (nArray[n2] < 2) {
                                    typeArray2[n2] = null;
                                }
                                nArray[n2] = 2;
                                break block15;
                            }
                            if (nArray[n2] > 0) break block13;
                        }
                        if (typeArray2[n2] == null) {
                            typeArray2[n2] = type;
                        } else if (typeArray2[n2] != type) {
                            int n3 = n2;
                            nArray[n3] = nArray[n3] | 1;
                        }
                    }
                    ++n2;
                }
            }
            fieldDefinition = fieldDefinition.getNextMatch();
        }
        if (identifier.equals(Constants.idInit)) {
            return bl;
        }
        typeArray3 = this.getSuperClass();
        if (typeArray3 != null && typeArray3.getClassDefinition(environment).diagnoseMismatch(environment, identifier, typeArray, n, nArray, typeArray2)) {
            bl = true;
        }
        return bl;
    }

    public void addField(FieldDefinition fieldDefinition) {
        if (this.firstField == null) {
            this.firstField = this.lastField = fieldDefinition;
        } else if (fieldDefinition.isSynthetic() && fieldDefinition.isFinal() && fieldDefinition.isVariable()) {
            fieldDefinition.nextField = this.firstField;
            this.firstField = fieldDefinition;
            fieldDefinition.nextMatch = (FieldDefinition)this.fieldHash.get(fieldDefinition.name);
        } else {
            this.lastField.nextField = fieldDefinition;
            this.lastField = fieldDefinition;
            fieldDefinition.nextMatch = (FieldDefinition)this.fieldHash.get(fieldDefinition.name);
        }
        this.fieldHash.put(fieldDefinition.name, fieldDefinition);
    }

    public void addField(Environment environment, FieldDefinition fieldDefinition) {
        this.addField(fieldDefinition);
        if (this.resolved) {
            fieldDefinition.resolveTypeStructure(environment);
        }
    }

    public UplevelReference getReference(LocalField localField) {
        UplevelReference uplevelReference = this.references;
        while (uplevelReference != null) {
            if (uplevelReference.getTarget() == localField) {
                return uplevelReference;
            }
            uplevelReference = uplevelReference.getNext();
        }
        return this.addReference(localField);
    }

    protected UplevelReference addReference(LocalField localField) {
        if (localField.getClassDefinition() == this) {
            throw new CompilerError("addReference " + localField);
        }
        this.referencesMustNotBeFrozen();
        UplevelReference uplevelReference = new UplevelReference(this, localField);
        this.references = uplevelReference.insertInto(this.references);
        return uplevelReference;
    }

    public UplevelReference getReferences() {
        return this.references;
    }

    public UplevelReference getReferencesFrozen() {
        this.referencesFrozen = true;
        return this.references;
    }

    public final void referencesMustNotBeFrozen() {
        if (this.referencesFrozen) {
            throw new CompilerError("referencesMustNotBeFrozen " + this);
        }
    }

    public void addDependency(ClassDeclaration classDeclaration) {
        throw new CompilerError("addDependency");
    }

    public void print(PrintStream printStream) {
        if (this.isPublic()) {
            printStream.print("public ");
        }
        if (this.isInterface()) {
            printStream.print("interface ");
        } else {
            printStream.print("class ");
        }
        printStream.print(String.valueOf(this.getName()) + " ");
        if (this.getSuperClass() != null) {
            printStream.print("extends " + this.getSuperClass().getName() + " ");
        }
        if (this.interfaces.length > 0) {
            printStream.print("implements ");
            int n = 0;
            while (n < this.interfaces.length) {
                if (n > 0) {
                    printStream.print(", ");
                }
                printStream.print(this.interfaces[n].getName());
                printStream.print(" ");
                ++n;
            }
        }
        printStream.println("{");
        FieldDefinition fieldDefinition = this.getFirstField();
        while (fieldDefinition != null) {
            printStream.print("    ");
            fieldDefinition.print(printStream);
            fieldDefinition = fieldDefinition.getNextField();
        }
        printStream.println("}");
    }

    public String toString() {
        return this.getClassDeclaration().toString();
    }

    public void cleanup(Environment environment) {
        if (environment.dump()) {
            environment.output("[cleanup " + this.getName() + "]");
        }
        FieldDefinition fieldDefinition = this.getFirstField();
        while (fieldDefinition != null) {
            fieldDefinition.cleanup(environment);
            fieldDefinition = fieldDefinition.getNextField();
        }
        this.documentation = null;
    }
}

