/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import sun.tools.java.AmbiguousClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Imports;
import sun.tools.java.Package;
import sun.tools.java.Type;

public class Environment
implements Constants {
    Environment env;
    String encoding;
    Object source;
    private static boolean debugging = System.getProperty("debug") != null;

    public Environment(Environment environment, Object object) {
        if (environment != null && environment.env != null && environment.getClass() == this.getClass()) {
            environment = environment.env;
        }
        this.env = environment;
        this.source = object;
    }

    public Environment() {
        this(null, null);
    }

    public ClassDeclaration getClassDeclaration(Identifier identifier) {
        return this.env.getClassDeclaration(identifier);
    }

    public final ClassDefinition getClassDefinition(Identifier identifier) throws ClassNotFound {
        if (identifier.isInner()) {
            ClassDefinition classDefinition = this.getClassDefinition(identifier.getTopName());
            Identifier identifier2 = identifier.getFlatName();
            block0: while (identifier2.isQualified()) {
                identifier2 = identifier2.getTail();
                Identifier identifier3 = identifier2.getHead();
                FieldDefinition fieldDefinition = classDefinition.getFirstMatch(identifier3);
                while (fieldDefinition != null) {
                    if (fieldDefinition.isInnerClass()) {
                        classDefinition = fieldDefinition.getInnerClass();
                        continue block0;
                    }
                    fieldDefinition = fieldDefinition.getNextMatch();
                }
                throw new ClassNotFound(Identifier.lookupInner(classDefinition.getName(), identifier3));
            }
            return classDefinition;
        }
        return this.getClassDeclaration(identifier).getClassDefinition(this);
    }

    public ClassDeclaration getClassDeclaration(Type type) {
        return this.getClassDeclaration(type.getClassName());
    }

    public final ClassDefinition getClassDefinition(Type type) throws ClassNotFound {
        return this.getClassDefinition(type.getClassName());
    }

    public boolean classExists(Identifier identifier) {
        return this.env.classExists(identifier);
    }

    public final boolean classExists(Type type) {
        return !type.isType(10) || this.classExists(type.getClassName());
    }

    public Package getPackage(Identifier identifier) throws IOException {
        return this.env.getPackage(identifier);
    }

    public void loadDefinition(ClassDeclaration classDeclaration) {
        this.env.loadDefinition(classDeclaration);
    }

    public final Object getSource() {
        return this.source;
    }

    public boolean resolve(int n, ClassDefinition classDefinition, Type type) {
        switch (type.getTypeCode()) {
            case 10: {
                try {
                    ClassDefinition classDefinition2;
                    Identifier identifier = type.getClassName();
                    if (!(identifier.isQualified() || identifier.isInner() || this.classExists(identifier))) {
                        this.resolve(identifier);
                    }
                    if (!classDefinition.canAccess(this, (classDefinition2 = this.getClassDefinition(type)).getClassDeclaration())) {
                        this.error(n, "cant.access.class", classDefinition2);
                        return true;
                    }
                    classDefinition2.noteUsedBy(classDefinition, n, this.env);
                }
                catch (AmbiguousClass ambiguousClass) {
                    this.error(n, "ambig.class", ambiguousClass.name1, ambiguousClass.name2);
                    return false;
                }
                catch (ClassNotFound classNotFound) {
                    try {
                        if (classNotFound.name.isInner() && this.getPackage(classNotFound.name.getTopName()).exists()) {
                            this.env.error(n, "class.and.package", classNotFound.name.getTopName());
                        }
                    }
                    catch (IOException iOException) {
                        this.env.error(n, "io.exception", "package check");
                    }
                    this.error(n, "class.not.found", classNotFound.name, "type declaration");
                    return false;
                }
                return true;
            }
            case 9: {
                return this.resolve(n, classDefinition, type.getElementType());
            }
            case 12: {
                boolean bl = this.resolve(n, classDefinition, type.getReturnType());
                Type[] typeArray = type.getArgumentTypes();
                int n2 = typeArray.length;
                while (n2-- > 0) {
                    bl &= this.resolve(n, classDefinition, typeArray[n2]);
                }
                return bl;
            }
        }
        return true;
    }

    public Type resolveNames(ClassDefinition classDefinition, Type type) {
        switch (type.getTypeCode()) {
            case 10: {
                Identifier identifier = type.getClassName();
                Identifier identifier2 = classDefinition.resolveName(this, identifier);
                if (identifier == identifier2) break;
                type = Type.tClass(identifier2);
                break;
            }
            case 9: {
                type = Type.tArray(this.resolveNames(classDefinition, type.getElementType()));
                break;
            }
            case 12: {
                Type type2 = type.getReturnType();
                Type type3 = this.resolveNames(classDefinition, type2);
                Type[] typeArray = type.getArgumentTypes();
                Type[] typeArray2 = new Type[typeArray.length];
                boolean bl = type2 != type3;
                int n = typeArray.length;
                while (n-- > 0) {
                    Type type4;
                    Type type5 = typeArray[n];
                    typeArray2[n] = type4 = this.resolveNames(classDefinition, type5);
                    if (type5 == type4) continue;
                    bl = true;
                }
                if (!bl) break;
                type = Type.tMethod(type3, typeArray2);
                break;
            }
        }
        return type;
    }

    public Identifier resolveName(Identifier identifier) {
        if (this.innerClasses() && identifier.isQualified()) {
            Identifier identifier2 = this.resolveName(identifier.getHead());
            if (!this.classExists(identifier2)) {
                return this.resolvePackageQualifiedName(identifier);
            }
            try {
                return this.getClassDefinition(identifier2).resolveInnerClass(this, identifier.getTail());
            }
            catch (ClassNotFound classNotFound) {
                return Identifier.lookupInner(identifier2, identifier.getTail());
            }
        }
        try {
            return this.resolve(identifier);
        }
        catch (ClassNotFound classNotFound) {
            Imports imports = this.getImports();
            if (imports != null) {
                return imports.forceResolve(this, identifier);
            }
            return identifier;
        }
    }

    public final Identifier resolvePackageQualifiedName(Identifier identifier) {
        if (!this.innerClasses()) {
            return identifier;
        }
        Identifier identifier2 = null;
        while (!this.classExists(identifier)) {
            if (!identifier.isQualified()) {
                identifier = identifier2 == null ? identifier : Identifier.lookup(identifier, identifier2);
                identifier2 = null;
                break;
            }
            Identifier identifier3 = identifier.getName();
            identifier2 = identifier2 == null ? identifier3 : Identifier.lookup(identifier3, identifier2);
            identifier = identifier.getQualifier();
        }
        if (identifier2 != null) {
            identifier = Identifier.lookupInner(identifier, identifier2);
        }
        return identifier;
    }

    public Identifier resolve(Identifier identifier) throws ClassNotFound {
        if (this.env == null) {
            return identifier;
        }
        return this.env.resolve(identifier);
    }

    public Imports getImports() {
        if (this.env == null) {
            return null;
        }
        return this.env.getImports();
    }

    public ClassDefinition makeClassDefinition(Environment environment, int n, IdentifierToken identifierToken, String string, int n2, IdentifierToken identifierToken2, IdentifierToken[] identifierTokenArray, ClassDefinition classDefinition) {
        if (this.env == null) {
            return null;
        }
        return this.env.makeClassDefinition(environment, n, identifierToken, string, n2, identifierToken2, identifierTokenArray, classDefinition);
    }

    public FieldDefinition makeFieldDefinition(Environment environment, int n, ClassDefinition classDefinition, String string, int n2, Type type, Identifier identifier, IdentifierToken[] identifierTokenArray, IdentifierToken[] identifierTokenArray2, Object object) {
        if (this.env == null) {
            return null;
        }
        return this.env.makeFieldDefinition(environment, n, classDefinition, string, n2, type, identifier, identifierTokenArray, identifierTokenArray2, object);
    }

    public boolean isApplicable(FieldDefinition fieldDefinition, Type[] typeArray) throws ClassNotFound {
        Type type = fieldDefinition.getType();
        if (!type.isType(12)) {
            return false;
        }
        Type[] typeArray2 = type.getArgumentTypes();
        if (typeArray.length != typeArray2.length) {
            return false;
        }
        int n = typeArray.length;
        while (--n >= 0) {
            if (this.isMoreSpecific(typeArray[n], typeArray2[n])) continue;
            return false;
        }
        return true;
    }

    public boolean isMoreSpecific(FieldDefinition fieldDefinition, FieldDefinition fieldDefinition2) throws ClassNotFound {
        Type type;
        Type type2 = fieldDefinition.getClassDeclaration().getType();
        boolean bl = this.isMoreSpecific(type2, type = fieldDefinition2.getClassDeclaration().getType()) && this.isApplicable(fieldDefinition2, fieldDefinition.getType().getArgumentTypes());
        return bl;
    }

    public boolean isMoreSpecific(Type type, Type type2) throws ClassNotFound {
        return this.implicitCast(type, type2);
    }

    public boolean implicitCast(Type type, Type type2) throws ClassNotFound {
        if (type == type2) {
            return true;
        }
        int n = type2.getTypeCode();
        switch (type.getTypeCode()) {
            case 1: {
                if (n == 3) {
                    return true;
                }
            }
            case 2: 
            case 3: {
                if (n == 4) {
                    return true;
                }
            }
            case 4: {
                if (n == 5) {
                    return true;
                }
            }
            case 5: {
                if (n == 6) {
                    return true;
                }
            }
            case 6: {
                if (n == 7) {
                    return true;
                }
            }
            default: {
                return false;
            }
            case 8: {
                return type2.inMask(1792);
            }
            case 9: {
                if (!type2.isType(9)) {
                    return type2 == Type.tObject || type2 == Type.tCloneable || type2 == Type.tSerializable;
                }
                do {
                    type = type.getElementType();
                    type2 = type2.getElementType();
                } while (type.isType(9) && type2.isType(9));
                if (type.inMask(1536) && type2.inMask(1536)) {
                    return this.isMoreSpecific(type, type2);
                }
                return type.getTypeCode() == type2.getTypeCode();
            }
            case 10: 
        }
        if (n == 10) {
            ClassDefinition classDefinition = this.getClassDefinition(type);
            ClassDefinition classDefinition2 = this.getClassDefinition(type2);
            return classDefinition2.implementedBy(this, classDefinition.getClassDeclaration());
        }
        return false;
    }

    public boolean explicitCast(Type type, Type type2) throws ClassNotFound {
        if (this.implicitCast(type, type2)) {
            return true;
        }
        if (type.inMask(254)) {
            return type2.inMask(254);
        }
        if (type.isType(10) && type2.isType(10)) {
            ClassDefinition classDefinition = this.getClassDefinition(type);
            ClassDefinition classDefinition2 = this.getClassDefinition(type2);
            if (classDefinition2.isFinal()) {
                return classDefinition.implementedBy(this, classDefinition2.getClassDeclaration());
            }
            if (classDefinition.isFinal()) {
                return classDefinition2.implementedBy(this, classDefinition.getClassDeclaration());
            }
            return classDefinition2.isInterface() || classDefinition.isInterface() || classDefinition.superClassOf(this, classDefinition2.getClassDeclaration());
        }
        if (type2.isType(9)) {
            if (type.isType(9)) {
                Type type3 = type.getElementType();
                Type type4 = type2.getElementType();
                while (type3.getTypeCode() == 9 && type4.getTypeCode() == 9) {
                    type3 = type3.getElementType();
                    type4 = type4.getElementType();
                }
                if (type3.inMask(1536) && type4.inMask(1536)) {
                    return this.explicitCast(type3, type4);
                }
            } else if (type == Type.tObject || type == Type.tCloneable || type == Type.tSerializable) {
                return true;
            }
        }
        return false;
    }

    public int getFlags() {
        return this.env.getFlags();
    }

    public final boolean debug() {
        return (this.getFlags() & 8) != 0;
    }

    public final boolean optimize() {
        return (this.getFlags() & 0x10) != 0;
    }

    public final boolean verbose() {
        return (this.getFlags() & 1) != 0;
    }

    public final boolean dump() {
        return (this.getFlags() & 2) != 0;
    }

    public final boolean warnings() {
        return (this.getFlags() & 4) != 0;
    }

    public final boolean dependencies() {
        return (this.getFlags() & 0x20) != 0;
    }

    public final boolean print_dependencies() {
        return (this.getFlags() & 0x400) != 0;
    }

    public final boolean innerClasses() {
        return (this.getFlags() & 0x100) != 0;
    }

    public final boolean deprecation() {
        return (this.getFlags() & 0x200) != 0;
    }

    public void innerClassesUsed(int n) {
        if (this.innerClasses()) {
            return;
        }
        this.error(n, "no.inner.classes");
    }

    public void shutdown() {
        if (this.env != null) {
            this.env.shutdown();
        }
    }

    public void error(Object object, int n, String string, Object object2, Object object3, Object object4) {
        this.env.error(object, n, string, object2, object3, object4);
    }

    public final void error(int n, String string, Object object, Object object2, Object object3) {
        this.error(this.source, n, string, object, object2, object3);
    }

    public final void error(int n, String string, Object object, Object object2) {
        this.error(this.source, n, string, object, object2, null);
    }

    public final void error(int n, String string, Object object) {
        this.error(this.source, n, string, object, null, null);
    }

    public final void error(int n, String string) {
        this.error(this.source, n, string, null, null, null);
    }

    public void output(String string) {
        this.env.output(string);
    }

    public static void debugOutput(Object object) {
        if (debugging) {
            System.out.println(object.toString());
        }
    }

    public void setCharacterEncoding(String string) {
        this.encoding = string;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public final boolean coverage() {
        return (this.getFlags() & 0x40) != 0;
    }

    public final boolean covdata() {
        return (this.getFlags() & 0x80) != 0;
    }

    public File getcovFile() {
        return this.env.getcovFile();
    }
}

