/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.PrintStream;
import java.util.Vector;
import sun.tools.asm.Assembler;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Type;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.Node;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class FieldDefinition
implements Constants {
    protected int where;
    protected int modifiers;
    protected Type type;
    protected String documentation;
    protected IdentifierToken[] expIds;
    protected ClassDeclaration[] exp;
    protected Node value;
    protected ClassDefinition clazz;
    protected Identifier name;
    protected ClassDefinition innerClass;
    protected FieldDefinition nextField;
    protected FieldDefinition nextMatch;
    protected FieldDefinition accessPeer;

    public FieldDefinition(int n, ClassDefinition classDefinition, int n2, Type type, Identifier identifier, IdentifierToken[] identifierTokenArray, Node node) {
        if (identifierTokenArray == null) {
            identifierTokenArray = new IdentifierToken[]{};
        }
        this.where = n;
        this.clazz = classDefinition;
        this.modifiers = n2;
        this.type = type;
        this.name = identifier;
        this.expIds = identifierTokenArray;
        this.value = node;
    }

    public FieldDefinition(ClassDefinition classDefinition) {
        this(classDefinition.getWhere(), classDefinition.getOuterClass(), classDefinition.getModifiers(), classDefinition.getType(), classDefinition.getName().getFlatName().getName(), null, null);
        this.innerClass = classDefinition;
    }

    public final int getWhere() {
        return this.where;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.clazz.getClassDeclaration();
    }

    public void resolveTypeStructure(Environment environment) {
    }

    public ClassDeclaration getDefiningClassDeclaration() {
        return this.getClassDeclaration();
    }

    public final ClassDefinition getClassDefinition() {
        return this.clazz;
    }

    public final ClassDefinition getTopClass() {
        return this.clazz.getTopClass();
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final void subModifiers(int n) {
        this.modifiers &= ~n;
    }

    public final void addModifiers(int n) {
        this.modifiers |= n;
    }

    public final Type getType() {
        return this.type;
    }

    public final Identifier getName() {
        return this.name;
    }

    public Vector getArguments() {
        if (this.isMethod()) {
            return new Vector();
        }
        return null;
    }

    public ClassDeclaration[] getExceptions(Environment environment) {
        if (this.expIds != null && this.exp == null) {
            if (this.expIds.length == 0) {
                this.exp = new ClassDeclaration[0];
            } else {
                throw new CompilerError("getExceptions " + this);
            }
        }
        return this.exp;
    }

    public final IdentifierToken[] getExceptionIds() {
        return this.expIds;
    }

    public ClassDefinition getInnerClass() {
        return this.innerClass;
    }

    public boolean isUplevelValue() {
        if (!this.isSynthetic() || !this.isVariable() || this.isStatic()) {
            return false;
        }
        String string = this.name.toString();
        return string.startsWith("val$") || string.toString().startsWith("loc$") || string.toString().startsWith("this$");
    }

    public boolean isAccessMethod() {
        return this.isSynthetic() && this.isMethod() && this.name.toString().startsWith("access$");
    }

    public FieldDefinition getAccessMethodTarget() {
        if (this.isAccessMethod()) {
            FieldDefinition fieldDefinition = this.accessPeer;
            while (fieldDefinition != null) {
                if (!fieldDefinition.isAccessMethod()) {
                    return fieldDefinition;
                }
                fieldDefinition = fieldDefinition.accessPeer;
            }
        }
        return null;
    }

    public void setAccessMethodTarget(FieldDefinition fieldDefinition) {
        if (this.getAccessMethodTarget() != fieldDefinition) {
            if (!this.isAccessMethod() || this.accessPeer != null || fieldDefinition.accessPeer != null) {
                throw new CompilerError("accessPeer");
            }
            this.accessPeer = fieldDefinition;
        }
    }

    public FieldDefinition getAccessUpdateField() {
        if (this.isAccessMethod()) {
            FieldDefinition fieldDefinition = this.accessPeer;
            while (fieldDefinition != null) {
                if (fieldDefinition.isAccessMethod()) {
                    return fieldDefinition;
                }
                fieldDefinition = fieldDefinition.accessPeer;
            }
        }
        return null;
    }

    public void setAccessUpdateField(FieldDefinition fieldDefinition) {
        if (this.getAccessUpdateField() != fieldDefinition) {
            if (!this.isAccessMethod() || fieldDefinition.getAccessMethodTarget() != this.getAccessMethodTarget()) {
                throw new CompilerError("accessPeer");
            }
            fieldDefinition.accessPeer = this.accessPeer;
            this.accessPeer = fieldDefinition;
        }
    }

    public final boolean isBlankFinal() {
        return this.isFinal() && !this.isSynthetic() && this.getValue() == null;
    }

    public boolean isNeverNull() {
        if (this.isUplevelValue()) {
            return !this.name.toString().startsWith("val$");
        }
        return false;
    }

    public Node getValue(Environment environment) throws ClassNotFound {
        return this.value;
    }

    public final Node getValue() {
        return this.value;
    }

    public final void setValue(Node node) {
        this.value = node;
    }

    public Object getInitialValue() {
        return null;
    }

    public final FieldDefinition getNextField() {
        return this.nextField;
    }

    public final FieldDefinition getNextMatch() {
        return this.nextMatch;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void check(Environment environment) throws ClassNotFound {
    }

    public Vset check(Environment environment, Context context, Vset vset) throws ClassNotFound {
        return vset;
    }

    public void code(Environment environment, Assembler assembler) throws ClassNotFound {
        throw new CompilerError("code");
    }

    public void codeInit(Environment environment, Context context, Assembler assembler) throws ClassNotFound {
        throw new CompilerError("codeInit");
    }

    public boolean reportDeprecated(Environment environment) {
        return this.isDeprecated() || this.clazz.reportDeprecated(environment);
    }

    public final boolean canReach(Environment environment, FieldDefinition fieldDefinition) {
        if (fieldDefinition.isLocal() || !fieldDefinition.isVariable() || !this.isVariable() && !this.isInitializer()) {
            return true;
        }
        if (this.getClassDeclaration().equals(fieldDefinition.getClassDeclaration()) && this.isStatic() == fieldDefinition.isStatic()) {
            while ((fieldDefinition = fieldDefinition.getNextField()) != null && fieldDefinition != this) {
            }
            return fieldDefinition != null;
        }
        return true;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isMethod() {
        return this.type.isType(12);
    }

    public final boolean isVariable() {
        return !this.type.isType(12) && this.innerClass == null;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x40000) != 0;
    }

    public final boolean isInnerClass() {
        return this.innerClass != null;
    }

    public final boolean isInitializer() {
        return this.getName().equals(Constants.idClassInit);
    }

    public final boolean isConstructor() {
        return this.getName().equals(Constants.idInit);
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isInlineable(Environment environment, boolean bl) throws ClassNotFound {
        return (this.isStatic() || this.isPrivate() || this.isFinal() || this.isConstructor() || bl) && !this.isSynchronized() && !this.isNative();
    }

    public boolean isConstant() {
        if (this.isFinal() && this.isVariable() && this.value != null) {
            try {
                this.modifiers &= 0xFFFFFFEF;
                boolean bl = ((Expression)this.value).isConstant();
                Object var3_2 = null;
                this.modifiers |= 0x10;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.modifiers |= 0x10;
                throw throwable;
            }
        }
        return false;
    }

    public String toString() {
        Identifier identifier = this.getClassDefinition().getName();
        if (this.isInitializer()) {
            if (this.isStatic()) {
                return "static {}";
            }
            return "instance {}";
        }
        if (this.isConstructor()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(identifier);
            stringBuffer.append('(');
            Type[] typeArray = this.getType().getArgumentTypes();
            int n = 0;
            while (n < typeArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeArray[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.isInnerClass()) {
            return this.getInnerClass().toString();
        }
        return this.type.typeString(this.getName().toString());
    }

    public void print(PrintStream printStream) {
        if (this.isPublic()) {
            printStream.print("public ");
        }
        if (this.isPrivate()) {
            printStream.print("private ");
        }
        if (this.isProtected()) {
            printStream.print("protected ");
        }
        if (this.isFinal()) {
            printStream.print("final ");
        }
        if (this.isStatic()) {
            printStream.print("static ");
        }
        if (this.isSynchronized()) {
            printStream.print("synchronized ");
        }
        if (this.isAbstract()) {
            printStream.print("abstract ");
        }
        if (this.isNative()) {
            printStream.print("native ");
        }
        if (this.isVolatile()) {
            printStream.print("volatile ");
        }
        if (this.isTransient()) {
            printStream.print("transient ");
        }
        printStream.println(String.valueOf(this.toString()) + ";");
    }

    public void cleanup(Environment environment) {
        this.documentation = null;
        if (this.isMethod() && this.value != null) {
            int n = 0;
            if (this.isPrivate() || this.isInitializer()) {
                this.value = Statement.empty;
            } else {
                n = ((Statement)this.value).costInline(30, null, null);
                if (n >= 30) {
                    this.value = Statement.empty;
                } else {
                    try {
                        if (!this.isInlineable(null, true)) {
                            this.value = Statement.empty;
                        }
                    }
                    catch (ClassNotFound classNotFound) {}
                }
            }
            if (this.value != Statement.empty && environment.dump()) {
                environment.output("[after cleanup of " + this.getName() + ", " + n + " expression cost units remain]");
                return;
            }
        } else if (this.isVariable() && (this.isPrivate() || !this.isFinal() || this.type.isType(9))) {
            this.value = null;
        }
    }
}

