/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.IOException;
import java.io.InputStream;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.ScannerInputStream;

public class Scanner
implements Constants {
    public static final int OFFSETINC = 1;
    public static final int LINEINC = 262144;
    public static final int EOF = -1;
    public Environment env;
    protected ScannerInputStream in;
    public boolean scanComments = false;
    public int token;
    public int pos;
    public int prevPos;
    protected int ch;
    public char charValue;
    public int intValue;
    public long longValue;
    public float floatValue;
    public double doubleValue;
    public String stringValue;
    public Identifier idValue;
    public int radix;
    public String docComment;
    private int count;
    private char[] buffer = new char[32];

    private void putc(int n) {
        if (this.count == this.buffer.length) {
            char[] cArray = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
            this.buffer = cArray;
        }
        this.buffer[this.count++] = (char)n;
    }

    private String bufferString() {
        char[] cArray = new char[this.count];
        System.arraycopy(this.buffer, 0, cArray, 0, this.count);
        return new String(cArray);
    }

    public Scanner(Environment environment, InputStream inputStream) throws IOException {
        this.env = environment;
        this.useInputStream(inputStream);
    }

    protected void useInputStream(InputStream inputStream) throws IOException {
        try {
            this.in = new ScannerInputStream(this.env, inputStream);
        }
        catch (Exception exception) {
            this.env.setCharacterEncoding(null);
            this.in = new ScannerInputStream(this.env, inputStream);
        }
        this.ch = this.in.read();
        this.prevPos = this.in.pos;
        this.scan();
    }

    protected Scanner(Environment environment) {
        this.env = environment;
    }

    private static void defineKeyword(int n) {
        Identifier.lookup(Constants.opNames[n]).setType(n);
    }

    private void skipComment() throws IOException {
        block4: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.comment");
                    return;
                }
                case 42: {
                    this.ch = this.in.read();
                    if (this.ch != 47) continue block4;
                    this.ch = this.in.read();
                    return;
                }
            }
            this.ch = this.in.read();
        }
    }

    private String scanDocComment() throws IOException {
        this.count = 0;
        if (this.ch == 42) {
            do {
                this.ch = this.in.read();
            } while (this.ch == 42);
            if (this.ch == 47) {
                this.ch = this.in.read();
                return "";
            }
        }
        switch (this.ch) {
            case 10: 
            case 32: {
                this.ch = this.in.read();
                break;
            }
        }
        boolean bl = false;
        int n = this.count;
        block13: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.comment");
                    return this.bufferString();
                }
                case 10: {
                    this.putc(10);
                    this.ch = this.in.read();
                    bl = false;
                    n = this.count;
                    continue block13;
                }
                case 9: 
                case 32: {
                    if (bl) {
                        this.putc(this.ch);
                    }
                    this.ch = this.in.read();
                    continue block13;
                }
                case 42: {
                    if (bl) {
                        this.ch = this.in.read();
                        if (this.ch == 47) {
                            this.ch = this.in.read();
                            this.count = n;
                            return this.bufferString();
                        }
                        this.putc(42);
                        continue block13;
                    }
                    bl = true;
                    this.count = n;
                    while ((this.ch = this.in.read()) == 42) {
                    }
                    switch (this.ch) {
                        default: {
                            continue block13;
                        }
                        case 47: 
                    }
                    this.ch = this.in.read();
                    this.count = n;
                    return this.bufferString();
                }
            }
            if (!bl) {
                bl = true;
            }
            this.putc(this.ch);
            this.ch = this.in.read();
            n = this.count;
        }
    }

    private void scanNumber() throws IOException {
        block20: {
            block19: {
                boolean bl;
                block22: {
                    long l;
                    block21: {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        this.radix = this.ch == 48 ? 8 : 10;
                        l = this.ch - 48;
                        this.count = 0;
                        this.putc(this.ch);
                        block9: while (true) {
                            this.ch = this.in.read();
                            switch (this.ch) {
                                case 46: {
                                    if (this.radix == 16) break block9;
                                    this.scanReal();
                                    return;
                                }
                                case 56: 
                                case 57: {
                                    bl2 = true;
                                }
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    this.putc(this.ch);
                                    if (this.radix == 10) {
                                        bl3 = bl3 || l * 10L / 10L != l;
                                        l = l * 10L + (long)(this.ch - 48);
                                        bl3 = bl3 || l - 1L < -1L;
                                        continue block9;
                                    }
                                    if (this.radix == 8) {
                                        bl3 = bl3 || l >>> 61 != 0L;
                                        l = (l << 3) + (long)(this.ch - 48);
                                        continue block9;
                                    }
                                    bl3 = bl3 || l >>> 60 != 0L;
                                    l = (l << 4) + (long)(this.ch - 48);
                                    continue block9;
                                }
                                case 68: 
                                case 69: 
                                case 70: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    if (this.radix != 16) {
                                        this.scanReal();
                                        return;
                                    }
                                }
                                case 65: 
                                case 66: 
                                case 67: 
                                case 97: 
                                case 98: 
                                case 99: {
                                    this.putc(this.ch);
                                    if (this.radix != 16) break block9;
                                    bl3 = bl3 || l >>> 60 != 0L;
                                    l = (l << 4) + 10L + (long)Character.toLowerCase((char)this.ch) - 97L;
                                    continue block9;
                                }
                                case 76: 
                                case 108: {
                                    this.ch = this.in.read();
                                    this.longValue = l;
                                    this.token = 66;
                                    break block9;
                                }
                                case 88: 
                                case 120: {
                                    if (this.count != 1 || this.radix != 8) break block9;
                                    this.radix = 16;
                                    continue block9;
                                }
                                default: {
                                    this.intValue = (int)l;
                                    this.token = 65;
                                    break block9;
                                }
                            }
                            break;
                        }
                        if (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46) {
                            this.env.error(this.in.pos, "invalid.number");
                            do {
                                this.ch = this.in.read();
                            } while (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46);
                            this.intValue = 0;
                            this.token = 65;
                            return;
                        }
                        if (this.radix == 8 && bl2) {
                            this.intValue = 0;
                            this.token = 65;
                            this.env.error(this.in.pos, "invalid.octal.number");
                            return;
                        }
                        if (bl3) break block19;
                        if (this.token != 65) break block20;
                        if (this.radix != 10) break block21;
                        if (this.intValue - 1 < -1) break block19;
                        bl = false;
                        break block22;
                    }
                    if ((l & 0xFFFFFFFF00000000L) != 0L) break block19;
                    bl = false;
                }
                if (!bl) break block20;
            }
            this.intValue = 0;
            this.longValue = 0L;
            this.env.error(this.pos, "overflow");
        }
    }

    private void scanReal() throws IOException {
        block21: {
            char c;
            boolean bl = false;
            boolean bl2 = false;
            if (this.ch == 46) {
                this.putc(this.ch);
                this.ch = this.in.read();
            }
            block9: while (true) {
                switch (this.ch) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.putc(this.ch);
                        break;
                    }
                    case 69: 
                    case 101: {
                        if (bl) break block9;
                        this.putc(this.ch);
                        bl = true;
                        break;
                    }
                    case 43: 
                    case 45: {
                        c = this.buffer[this.count - 1];
                        if (c != 'e' && c != 'E') break block9;
                        this.putc(this.ch);
                        break;
                    }
                    case 70: 
                    case 102: {
                        this.ch = this.in.read();
                        bl2 = true;
                        break block9;
                    }
                    case 68: 
                    case 100: {
                        this.ch = this.in.read();
                        break block9;
                    }
                }
                this.ch = this.in.read();
            }
            if (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46) {
                this.env.error(this.in.pos, "invalid.number");
                do {
                    this.ch = this.in.read();
                } while (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46);
                this.doubleValue = 0.0;
                this.token = 68;
                return;
            }
            this.token = bl2 ? 67 : 68;
            try {
                c = this.buffer[this.count - 1];
                if (c == 'e' || c == 'E' || c == '+' || c == '-') {
                    this.env.error(this.in.pos - 1, "float.format");
                    return;
                }
                if (bl2) {
                    String string = this.bufferString();
                    this.floatValue = Float.valueOf(string).floatValue();
                    if (Float.isInfinite(this.floatValue)) {
                        this.env.error(this.pos, "overflow");
                        return;
                    }
                    if (this.floatValue == 0.0f && !Scanner.looksLikeZero(string)) {
                        this.env.error(this.pos, "underflow");
                        return;
                    }
                } else {
                    String string = this.bufferString();
                    this.doubleValue = Double.valueOf(string);
                    if (Double.isInfinite(this.doubleValue)) {
                        this.env.error(this.pos, "overflow");
                        return;
                    }
                    if (this.doubleValue != 0.0 || Scanner.looksLikeZero(string)) break block21;
                    this.env.error(this.pos, "underflow");
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.env.error(this.pos, "float.format");
                this.doubleValue = 0.0;
                this.floatValue = 0.0f;
                return;
            }
        }
    }

    private static boolean looksLikeZero(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return false;
                }
                case 'E': 
                case 'F': 
                case 'e': 
                case 'f': {
                    return true;
                }
            }
            ++n2;
        }
        return true;
    }

    private int scanEscapeChar() throws IOException {
        int n = this.in.pos;
        this.ch = this.in.read();
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n2 = this.ch - 48;
                int n3 = 2;
                while (n3 > 0) {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            n2 = (n2 << 3) + this.ch - 48;
                            break;
                        }
                        default: {
                            if (n2 > 255) {
                                this.env.error(n, "invalid.escape.char");
                            }
                            return n2;
                        }
                    }
                    --n3;
                }
                this.ch = this.in.read();
                if (n2 > 255) {
                    this.env.error(n, "invalid.escape.char");
                }
                return n2;
            }
            case 114: {
                this.ch = this.in.read();
                return 13;
            }
            case 110: {
                this.ch = this.in.read();
                return 10;
            }
            case 102: {
                this.ch = this.in.read();
                return 12;
            }
            case 98: {
                this.ch = this.in.read();
                return 8;
            }
            case 116: {
                this.ch = this.in.read();
                return 9;
            }
            case 92: {
                this.ch = this.in.read();
                return 92;
            }
            case 34: {
                this.ch = this.in.read();
                return 34;
            }
            case 39: {
                this.ch = this.in.read();
                return 39;
            }
        }
        this.env.error(n, "invalid.escape.char");
        this.ch = this.in.read();
        return -1;
    }

    private void scanString() throws IOException {
        this.token = 69;
        this.count = 0;
        this.ch = this.in.read();
        block6: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.string");
                    this.stringValue = this.bufferString();
                    return;
                }
                case 10: {
                    this.ch = this.in.read();
                    this.env.error(this.pos, "newline.in.string");
                    this.stringValue = this.bufferString();
                    return;
                }
                case 34: {
                    this.ch = this.in.read();
                    this.stringValue = this.bufferString();
                    return;
                }
                case 92: {
                    int n = this.scanEscapeChar();
                    if (n < 0) continue block6;
                    this.putc((char)n);
                    continue block6;
                }
            }
            this.putc(this.ch);
            this.ch = this.in.read();
        }
    }

    private void scanCharacter() throws IOException {
        this.token = 63;
        this.ch = this.in.read();
        switch (this.ch) {
            case 92: {
                int n = this.scanEscapeChar();
                this.charValue = (char)(n >= 0 ? n : 0);
                break;
            }
            case 10: {
                this.charValue = '\u0000';
                this.env.error(this.pos, "invalid.char.constant");
                return;
            }
            default: {
                this.charValue = (char)this.ch;
                this.ch = this.in.read();
            }
        }
        if (this.ch == 39) {
            this.ch = this.in.read();
            return;
        }
        this.env.error(this.pos, "invalid.char.constant");
        while (true) {
            switch (this.ch) {
                case 39: {
                    this.ch = this.in.read();
                    return;
                }
                case -1: 
                case 10: 
                case 59: {
                    return;
                }
            }
            this.ch = this.in.read();
        }
    }

    private void scanIdentifier() throws IOException {
        this.count = 0;
        block3: while (true) {
            this.putc(this.ch);
            this.ch = this.in.read();
            switch (this.ch) {
                case 36: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block3;
                }
            }
            if (!Character.isJavaLetterOrDigit((char)this.ch)) break;
        }
        this.idValue = Identifier.lookup(this.bufferString());
        this.token = this.idValue.getType();
    }

    public int getEndPos() {
        return this.in.pos;
    }

    public IdentifierToken getIdToken() {
        if (this.token != 60) {
            return null;
        }
        return new IdentifierToken(this.pos, this.idValue);
    }

    public int scan() throws IOException {
        int n = this.xscan();
        return n;
    }

    protected int xscan() throws IOException {
        int n = this.pos;
        this.prevPos = this.in.pos;
        this.docComment = null;
        block70: while (true) {
            this.pos = this.in.pos;
            switch (this.ch) {
                case -1: {
                    this.token = -1;
                    return n;
                }
                case 10: {
                    if (this.scanComments) {
                        this.ch = 32;
                        this.token = 146;
                        return n;
                    }
                }
                case 9: 
                case 12: 
                case 32: {
                    this.ch = this.in.read();
                    continue block70;
                }
                case 47: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 47: {
                            while ((this.ch = this.in.read()) != -1 && this.ch != 10) {
                            }
                            if (!this.scanComments) continue block70;
                            this.token = 146;
                            return n;
                        }
                        case 42: {
                            this.ch = this.in.read();
                            if (this.ch == 42) {
                                this.docComment = this.scanDocComment();
                            } else {
                                this.skipComment();
                            }
                            if (!this.scanComments) continue block70;
                            return n;
                        }
                        case 61: {
                            this.ch = this.in.read();
                            this.token = 3;
                            return n;
                        }
                    }
                    this.token = 31;
                    return n;
                }
                case 34: {
                    this.scanString();
                    return n;
                }
                case 39: {
                    this.scanCharacter();
                    return n;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.scanNumber();
                    return n;
                }
                case 46: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.count = 0;
                            this.putc(46);
                            this.scanReal();
                            break;
                        }
                        default: {
                            this.token = 46;
                        }
                    }
                    return n;
                }
                case 123: {
                    this.ch = this.in.read();
                    this.token = 138;
                    return n;
                }
                case 125: {
                    this.ch = this.in.read();
                    this.token = 139;
                    return n;
                }
                case 40: {
                    this.ch = this.in.read();
                    this.token = 140;
                    return n;
                }
                case 41: {
                    this.ch = this.in.read();
                    this.token = 141;
                    return n;
                }
                case 91: {
                    this.ch = this.in.read();
                    this.token = 142;
                    return n;
                }
                case 93: {
                    this.ch = this.in.read();
                    this.token = 143;
                    return n;
                }
                case 44: {
                    this.ch = this.in.read();
                    this.token = 0;
                    return n;
                }
                case 59: {
                    this.ch = this.in.read();
                    this.token = 135;
                    return n;
                }
                case 63: {
                    this.ch = this.in.read();
                    this.token = 137;
                    return n;
                }
                case 126: {
                    this.ch = this.in.read();
                    this.token = 38;
                    return n;
                }
                case 58: {
                    this.ch = this.in.read();
                    this.token = 136;
                    return n;
                }
                case 45: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 45: {
                            this.ch = this.in.read();
                            this.token = 51;
                            return n;
                        }
                        case 61: {
                            this.ch = this.in.read();
                            this.token = 6;
                            return n;
                        }
                    }
                    this.token = 30;
                    return n;
                }
                case 43: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 43: {
                            this.ch = this.in.read();
                            this.token = 50;
                            return n;
                        }
                        case 61: {
                            this.ch = this.in.read();
                            this.token = 5;
                            return n;
                        }
                    }
                    this.token = 29;
                    return n;
                }
                case 60: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 60: {
                            this.ch = this.in.read();
                            if (this.ch == 61) {
                                this.ch = this.in.read();
                                this.token = 7;
                                return n;
                            }
                            this.token = 26;
                            return n;
                        }
                        case 61: {
                            this.ch = this.in.read();
                            this.token = 23;
                            return n;
                        }
                    }
                    this.token = 24;
                    return n;
                }
                case 62: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 62: {
                            this.ch = this.in.read();
                            switch (this.ch) {
                                case 61: {
                                    this.ch = this.in.read();
                                    this.token = 8;
                                    return n;
                                }
                                case 62: {
                                    this.ch = this.in.read();
                                    if (this.ch == 61) {
                                        this.ch = this.in.read();
                                        this.token = 9;
                                        return n;
                                    }
                                    this.token = 28;
                                    return n;
                                }
                            }
                            this.token = 27;
                            return n;
                        }
                        case 61: {
                            this.ch = this.in.read();
                            this.token = 21;
                            return n;
                        }
                    }
                    this.token = 22;
                    return n;
                }
                case 124: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 124: {
                            this.ch = this.in.read();
                            this.token = 14;
                            return n;
                        }
                        case 61: {
                            this.ch = this.in.read();
                            this.token = 11;
                            return n;
                        }
                    }
                    this.token = 16;
                    return n;
                }
                case 38: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 38: {
                            this.ch = this.in.read();
                            this.token = 15;
                            return n;
                        }
                        case 61: {
                            this.ch = this.in.read();
                            this.token = 10;
                            return n;
                        }
                    }
                    this.token = 18;
                    return n;
                }
                case 61: {
                    this.ch = this.in.read();
                    if (this.ch == 61) {
                        this.ch = this.in.read();
                        this.token = 20;
                        return n;
                    }
                    this.token = 1;
                    return n;
                }
                case 37: {
                    this.ch = this.in.read();
                    if (this.ch == 61) {
                        this.ch = this.in.read();
                        this.token = 4;
                        return n;
                    }
                    this.token = 32;
                    return n;
                }
                case 94: {
                    this.ch = this.in.read();
                    if (this.ch == 61) {
                        this.ch = this.in.read();
                        this.token = 12;
                        return n;
                    }
                    this.token = 17;
                    return n;
                }
                case 33: {
                    this.ch = this.in.read();
                    if (this.ch == 61) {
                        this.ch = this.in.read();
                        this.token = 19;
                        return n;
                    }
                    this.token = 37;
                    return n;
                }
                case 42: {
                    this.ch = this.in.read();
                    if (this.ch == 61) {
                        this.ch = this.in.read();
                        this.token = 2;
                        return n;
                    }
                    this.token = 33;
                    return n;
                }
                case 36: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.scanIdentifier();
                    return n;
                }
                case 26: {
                    this.ch = this.in.read();
                    if (this.ch == -1) {
                        this.token = -1;
                        return n;
                    }
                    this.env.error(this.pos, "funny.char");
                    this.ch = this.in.read();
                    continue block70;
                }
            }
            if (Character.isJavaLetter((char)this.ch)) {
                this.scanIdentifier();
                return n;
            }
            this.env.error(this.pos, "funny.char");
            this.ch = this.in.read();
        }
    }

    public void match(int n, int n2) throws IOException {
        int n3 = 1;
        while (true) {
            this.scan();
            if (this.token == n) {
                ++n3;
                continue;
            }
            if (this.token == n2) {
                if (--n3 != 0) continue;
                return;
            }
            if (this.token == -1) break;
        }
        this.env.error(this.pos, "unbalanced.paren");
    }

    static {
        Scanner.defineKeyword(92);
        Scanner.defineKeyword(90);
        Scanner.defineKeyword(91);
        Scanner.defineKeyword(93);
        Scanner.defineKeyword(94);
        Scanner.defineKeyword(95);
        Scanner.defineKeyword(96);
        Scanner.defineKeyword(97);
        Scanner.defineKeyword(98);
        Scanner.defineKeyword(99);
        Scanner.defineKeyword(100);
        Scanner.defineKeyword(101);
        Scanner.defineKeyword(102);
        Scanner.defineKeyword(103);
        Scanner.defineKeyword(104);
        Scanner.defineKeyword(70);
        Scanner.defineKeyword(71);
        Scanner.defineKeyword(72);
        Scanner.defineKeyword(73);
        Scanner.defineKeyword(74);
        Scanner.defineKeyword(75);
        Scanner.defineKeyword(76);
        Scanner.defineKeyword(77);
        Scanner.defineKeyword(78);
        Scanner.defineKeyword(25);
        Scanner.defineKeyword(80);
        Scanner.defineKeyword(81);
        Scanner.defineKeyword(49);
        Scanner.defineKeyword(82);
        Scanner.defineKeyword(83);
        Scanner.defineKeyword(84);
        Scanner.defineKeyword(110);
        Scanner.defineKeyword(111);
        Scanner.defineKeyword(112);
        Scanner.defineKeyword(113);
        Scanner.defineKeyword(114);
        Scanner.defineKeyword(115);
        Scanner.defineKeyword(144);
        Scanner.defineKeyword(120);
        Scanner.defineKeyword(121);
        Scanner.defineKeyword(122);
        Scanner.defineKeyword(124);
        Scanner.defineKeyword(125);
        Scanner.defineKeyword(126);
        Scanner.defineKeyword(127);
        Scanner.defineKeyword(130);
        Scanner.defineKeyword(129);
        Scanner.defineKeyword(128);
        Scanner.defineKeyword(123);
        Scanner.defineKeyword(58);
    }
}

