/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javac;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.java.BinaryClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Package;
import sun.tools.java.Type;
import sun.tools.javac.BatchParser;
import sun.tools.javac.ErrorConsumer;
import sun.tools.javac.ErrorMessage;
import sun.tools.javac.Main;
import sun.tools.javac.SourceClass;
import sun.tools.javac.SourceField;
import sun.tools.tree.Node;

public class BatchEnvironment
extends Environment
implements ErrorConsumer {
    OutputStream out;
    ClassPath path;
    Hashtable packages = new Hashtable(31);
    Vector classesOrdered = new Vector();
    Hashtable classes = new Hashtable(351);
    public int flags;
    public File covFile;
    public int nerrors;
    public int nwarnings;
    public int ndeprecations;
    Vector deprecationFiles = new Vector();
    ErrorConsumer errorConsumer;
    String errorFileName;
    ErrorMessage errors;
    private int errorsPushed;
    public int errorLimit = 100;
    private boolean hitErrorLimit;

    public BatchEnvironment(ClassPath classPath) {
        this(System.out, classPath);
    }

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath) {
        this(outputStream, classPath, null);
    }

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath, ErrorConsumer errorConsumer) {
        this.out = outputStream;
        this.path = classPath;
        if (errorConsumer == null) {
            this.errorConsumer = this;
            return;
        }
        this.errorConsumer = errorConsumer;
    }

    public int getFlags() {
        return this.flags;
    }

    public File getcovFile() {
        return this.covFile;
    }

    public Enumeration getClasses() {
        return this.classesOrdered.elements();
    }

    public ClassDeclaration getClassDeclaration(Identifier identifier) {
        return this.getClassDeclaration(Type.tClass(identifier));
    }

    public ClassDeclaration getClassDeclaration(Type type) {
        ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
        if (classDeclaration == null) {
            classDeclaration = new ClassDeclaration(type.getClassName());
            this.classes.put(type, classDeclaration);
            this.classesOrdered.addElement(classDeclaration);
        }
        return classDeclaration;
    }

    public boolean classExists(Identifier identifier) {
        if (identifier.isInner()) {
            identifier = identifier.getTopName();
        }
        Type type = Type.tClass(identifier);
        try {
            ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
            if (classDeclaration != null) {
                return classDeclaration.getName().equals(identifier);
            }
            return this.getPackage(identifier.getQualifier()).classExists(identifier.getName());
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public Identifier generateName(Identifier identifier, Identifier identifier2) {
        Identifier identifier3 = identifier.getFlatName();
        Identifier identifier4 = Identifier.lookup(identifier.getQualifier(), identifier3.getHead());
        int n = 1;
        String string;
        Identifier identifier5;
        while (this.classes.get(Type.tClass(identifier5 = Identifier.lookupInner(identifier4, Identifier.lookup(string = String.valueOf(n) + (identifier2.equals(Constants.idNull) ? "" : "$" + identifier2))))) != null) {
            ++n;
        }
        return identifier5;
    }

    public Package getPackage(Identifier identifier) throws IOException {
        Package package_ = (Package)this.packages.get(identifier);
        if (package_ == null) {
            package_ = new Package(this.path, identifier);
            this.packages.put(identifier, package_);
        }
        return package_;
    }

    public void parseFile(ClassFile classFile) throws FileNotFoundException {
        BatchParser batchParser;
        InputStream inputStream;
        long l = System.currentTimeMillis();
        try {
            inputStream = classFile.getInputStream();
            Environment environment = new Environment(this, classFile);
            environment.setCharacterEncoding(this.getCharacterEncoding());
            batchParser = new BatchParser(environment, new BufferedInputStream(inputStream));
        }
        catch (IOException iOException) {
            throw new FileNotFoundException();
        }
        try {
            batchParser.parseFile();
        }
        catch (Exception exception) {
            throw new CompilerError(exception);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        if (this.verbose()) {
            l = System.currentTimeMillis() - l;
            this.output(Main.getText("benv.parsed_in", classFile.getPath(), Long.toString(l)));
        }
    }

    BinaryClass loadFile(ClassFile classFile) throws IOException {
        long l = System.currentTimeMillis();
        InputStream inputStream = classFile.getInputStream();
        BinaryClass binaryClass = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            binaryClass = BinaryClass.load(new Environment(this, classFile), dataInputStream, this.loadFileFlags());
        }
        catch (ClassFormatError classFormatError) {
            this.error(0, "class.format", classFile.getPath(), classFormatError.getMessage());
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        inputStream.close();
        if (this.verbose()) {
            l = System.currentTimeMillis() - l;
            this.output(Main.getText("benv.loaded_in", classFile.getPath(), Long.toString(l)));
        }
        return binaryClass;
    }

    int loadFileFlags() {
        return 0;
    }

    boolean needsCompilation(Hashtable hashtable, ClassDeclaration classDeclaration) {
        switch (classDeclaration.getStatus()) {
            case 0: {
                this.loadDefinition(classDeclaration);
                return this.needsCompilation(hashtable, classDeclaration);
            }
            case 1: {
                if (hashtable.get(classDeclaration) == null) {
                    hashtable.put(classDeclaration, classDeclaration);
                    BinaryClass binaryClass = (BinaryClass)classDeclaration.getClassDefinition();
                    Enumeration enumeration = binaryClass.getDependencies();
                    while (enumeration.hasMoreElements()) {
                        ClassDeclaration classDeclaration2 = (ClassDeclaration)enumeration.nextElement();
                        if (!this.needsCompilation(hashtable, classDeclaration2)) continue;
                        classDeclaration.setDefinition(binaryClass, 3);
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    public void loadDefinition(ClassDeclaration classDeclaration) {
        switch (classDeclaration.getStatus()) {
            case 0: {
                Package package_;
                Identifier identifier = classDeclaration.getName();
                try {
                    package_ = this.getPackage(identifier.getQualifier());
                }
                catch (IOException iOException) {
                    this.error(0, "io.exception", classDeclaration);
                    return;
                }
                ClassFile classFile = package_.getBinaryFile(identifier.getName());
                if (classFile == null) {
                    classDeclaration.setDefinition(null, 3);
                    return;
                }
                ClassFile classFile2 = package_.getSourceFile(identifier.getName());
                if (classFile2 == null) {
                    BinaryClass binaryClass = null;
                    try {
                        binaryClass = this.loadFile(classFile);
                    }
                    catch (IOException iOException) {
                        this.error(0, "io.exception", classFile);
                        return;
                    }
                    if (binaryClass != null && !binaryClass.getName().equals(identifier)) {
                        this.error(0, "wrong.class", classFile.getPath(), classDeclaration, binaryClass);
                        binaryClass = null;
                    }
                    if (binaryClass == null) {
                        classDeclaration.setDefinition(null, 6);
                        return;
                    }
                    if (binaryClass.getSource() != null) {
                        classFile2 = new ClassFile(new File((String)binaryClass.getSource()));
                        if ((classFile2 = package_.getSourceFile(classFile2.getName())) != null && classFile2.exists()) {
                            if (classFile2.lastModified() > classFile.lastModified()) {
                                classDeclaration.setDefinition(binaryClass, 3);
                                binaryClass.hasBeenLoaded(this);
                                return;
                            }
                            classDeclaration.setDefinition(binaryClass, this.dependencies() ? 1 : 2);
                            binaryClass.hasBeenLoaded(this);
                            return;
                        }
                    }
                    classDeclaration.setDefinition(binaryClass, 2);
                    binaryClass.hasBeenLoaded(this);
                    return;
                }
                BinaryClass binaryClass = null;
                try {
                    if (classFile2.lastModified() > classFile.lastModified()) {
                        classDeclaration.setDefinition(null, 3);
                        return;
                    }
                    binaryClass = this.loadFile(classFile);
                }
                catch (IOException iOException) {
                    this.error(0, "io.exception", classFile);
                }
                if (binaryClass != null && !binaryClass.getName().equals(identifier)) {
                    this.error(0, "wrong.class", classFile.getPath(), classDeclaration, binaryClass);
                    binaryClass = null;
                }
                if (binaryClass != null) {
                    if (binaryClass.getName().equals(classDeclaration.getName())) {
                        classDeclaration.setDefinition(binaryClass, this.dependencies() ? 1 : 2);
                    } else {
                        classDeclaration.setDefinition(null, 6);
                        this.getClassDeclaration(binaryClass.getName()).setDefinition(binaryClass, this.dependencies() ? 1 : 2);
                    }
                } else {
                    classDeclaration.setDefinition(null, 6);
                }
                if (binaryClass != null && binaryClass == classDeclaration.getClassDefinition()) {
                    binaryClass.hasBeenLoaded(this);
                }
                return;
            }
            case 1: {
                Hashtable hashtable = new Hashtable();
                if (!this.needsCompilation(hashtable, classDeclaration)) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        ClassDeclaration classDeclaration2 = (ClassDeclaration)enumeration.nextElement();
                        if (classDeclaration2.getStatus() != 1) continue;
                        classDeclaration2.setDefinition(classDeclaration2.getClassDefinition(), 2);
                    }
                }
                return;
            }
            case 3: {
                ClassFile classFile = null;
                Package package_ = null;
                if (classDeclaration.getClassDefinition() != null) {
                    try {
                        package_ = this.getPackage(classDeclaration.getName().getQualifier());
                        classFile = package_.getSourceFile((String)classDeclaration.getClassDefinition().getSource());
                    }
                    catch (IOException iOException) {
                        this.error(0, "io.exception", classDeclaration);
                    }
                    if (classFile == null) {
                        String string = (String)classDeclaration.getClassDefinition().getSource();
                        classFile = new ClassFile(new File(string));
                    }
                } else {
                    Identifier identifier = classDeclaration.getName();
                    try {
                        package_ = this.getPackage(identifier.getQualifier());
                        classFile = package_.getSourceFile(identifier.getName());
                    }
                    catch (IOException iOException) {
                        this.error(0, "io.exception", classDeclaration);
                    }
                    if (classFile == null) {
                        classDeclaration.setDefinition(null, 6);
                        return;
                    }
                }
                try {
                    this.parseFile(classFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.error(0, "io.exception", classFile);
                }
                if (classDeclaration.getClassDefinition() == null || classDeclaration.getStatus() == 3) {
                    this.error(0, "wrong.source", classFile.getPath(), classDeclaration, package_);
                    classDeclaration.setDefinition(null, 6);
                }
                return;
            }
        }
    }

    public ClassDefinition makeClassDefinition(Environment environment, int n, IdentifierToken identifierToken, String string, int n2, IdentifierToken identifierToken2, IdentifierToken[] identifierTokenArray, ClassDefinition classDefinition) {
        Identifier identifier = identifierToken.getName();
        int n3 = identifierToken.getWhere();
        Identifier identifier2 = identifier.isQualified() || identifier.isInner() ? identifier : ((n2 & 0x30000) != 0 ? this.generateName(classDefinition.getName(), identifier) : (classDefinition != null ? Identifier.lookupInner(classDefinition.getName(), identifier) : identifier));
        ClassDeclaration classDeclaration = environment.getClassDeclaration(identifier2);
        if (classDeclaration.isDefined()) {
            environment.error(n3, "class.multidef", classDeclaration.getName(), classDeclaration.getClassDefinition().getSource());
            classDeclaration = new ClassDeclaration(identifier2);
        }
        if (identifierToken2 == null && !identifier2.equals(Constants.idJavaLangObject)) {
            identifierToken2 = new IdentifierToken(Constants.idJavaLangObject);
        }
        SourceClass sourceClass = new SourceClass(environment, n, classDeclaration, string, n2, identifierToken2, identifierTokenArray, (SourceClass)classDefinition);
        if (classDefinition != null) {
            classDefinition.addField(environment, new SourceField(sourceClass));
        }
        if (sourceClass.isAnonymous()) {
            sourceClass.setLocalName(Constants.idNull);
        } else if (sourceClass.isLocal()) {
            sourceClass.setLocalName(identifier);
        }
        return sourceClass;
    }

    public FieldDefinition makeFieldDefinition(Environment environment, int n, ClassDefinition classDefinition, String string, int n2, Type type, Identifier identifier, IdentifierToken[] identifierTokenArray, IdentifierToken[] identifierTokenArray2, Object object) {
        Vector<IdentifierToken> vector = null;
        if (identifierTokenArray != null) {
            vector = new Vector<IdentifierToken>(identifierTokenArray.length);
            int n3 = 0;
            while (n3 < identifierTokenArray.length) {
                vector.addElement(identifierTokenArray[n3]);
                ++n3;
            }
        }
        SourceField sourceField = new SourceField(n, classDefinition, string, n2, type, identifier, vector, identifierTokenArray2, (Node)object);
        classDefinition.addField(environment, sourceField);
        return sourceField;
    }

    public void shutdown() {
        if (this.path != null) {
            try {
                this.path.close();
            }
            catch (IOException iOException) {
                this.output(Main.getText("benv.failed_to_close_class_path", iOException.toString()));
            }
            this.path = null;
        }
        super.shutdown();
    }

    public String errorString(String string, Object object, Object object2, Object object3) {
        String string2 = null;
        string2 = string.startsWith("warn.") ? "javac.err." + string.substring(5) : "javac.err." + string;
        return Main.getText(string2, object != null ? object.toString() : null, object2 != null ? object2.toString() : null, object3 != null ? object3.toString() : null);
    }

    public void insertError(int n, String string) {
        ErrorMessage errorMessage = new ErrorMessage(n, string);
        if (this.errors == null) {
            this.errors = errorMessage;
            return;
        }
        if (this.errors.where > n) {
            errorMessage.next = this.errors;
            this.errors = errorMessage;
            return;
        }
        ErrorMessage errorMessage2 = this.errors;
        while (errorMessage2.next != null && errorMessage2.next.where <= n) {
            errorMessage2 = errorMessage2.next;
        }
        errorMessage.next = errorMessage2.next;
        errorMessage2.next = errorMessage;
    }

    public void pushError(String string, int n, String string2, String string3, String string4) {
        int n2 = this.errorLimit + this.nwarnings;
        if (++this.errorsPushed >= n2 && this.errorLimit >= 0) {
            if (!this.hitErrorLimit) {
                this.hitErrorLimit = true;
                this.output(this.errorString("too.many.errors", new Integer(this.errorLimit), null, null));
            }
            return;
        }
        this.output(String.valueOf(string) + ":" + n + ":" + " " + string2);
        this.output(string3);
        this.output(string4);
    }

    /*
     * Unable to fully structure code
     */
    public void flushErrors() {
        if (this.errors == null) {
            return;
        }
        try {
            var1_1 = new FileInputStream(this.errorFileName);
            var2_2 = new char[var1_1.available()];
            var3_3 = this.getCharacterEncoding() != null ? new InputStreamReader((InputStream)var1_1, this.getCharacterEncoding()) : new InputStreamReader(var1_1);
            var4_4 = var3_3.read(var2_2);
            var3_3.close();
            var5_5 = this.errors;
            ** GOTO lbl41
            {
                var5_5 = var6_6;
                if (this.nwarnings > 1) {
                    --this.nwarnings;
                } else {
                    --this.nerrors;
                }
                do {
                    if ((var6_6 = var5_5.next) != null && var5_5.where == var6_6.where && var5_5.message.equals(var6_6.message)) continue block2;
                    var7_7 = var5_5.where >>> 18;
                    var8_8 = var5_5.where & 262143;
                    if (var8_8 > var4_4) {
                        var8_8 = var4_4;
                    }
                    var9_9 = var8_8;
                    while (var9_9 > 0 && var2_2[var9_9 - 1] != '\n' && var2_2[var9_9 - 1] != '\r') {
                        --var9_9;
                    }
                    var10_10 = var8_8;
                    while (var10_10 < var4_4 && var2_2[var10_10] != '\n' && var2_2[var10_10] != '\r') {
                        ++var10_10;
                    }
                    var11_11 = new String(var2_2, var9_9, var10_10 - var9_9);
                    var12_12 = new char[var8_8 - var9_9 + 1];
                    var10_10 = var9_9;
                    while (var10_10 < var8_8) {
                        var12_12[var10_10 - var9_9] = var2_2[var10_10] == '\t' ? 9 : 32;
                        ++var10_10;
                    }
                    var12_12[var8_8 - var9_9] = 94;
                    var13_13 = new String(var12_12);
                    this.errorConsumer.pushError(this.errorFileName, var7_7, var5_5.message, var11_11, var13_13);
                    var5_5 = var5_5.next;
lbl41:
                    // 2 sources

                } while (var5_5 != null);
            }
        }
        catch (IOException v0) {
            this.output("I/O exception");
        }
        this.errors = null;
    }

    public void reportError(Object object, int n, String string, String string2) {
        if (object == null) {
            if (this.errorFileName != null) {
                this.flushErrors();
                this.errorFileName = null;
            }
            if (string.startsWith("warn.")) {
                if (this.warnings()) {
                    ++this.nwarnings;
                    this.output(string2);
                }
                return;
            }
            this.output("error: " + string2);
            ++this.nerrors;
            this.flags |= 0x10000;
            return;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            if (!string3.equals(this.errorFileName)) {
                this.flushErrors();
                this.errorFileName = string3;
            }
            if (string.startsWith("warn.")) {
                if (string.indexOf("is.deprecated") >= 0) {
                    ++this.ndeprecations;
                    if (!this.deprecationFiles.contains(object)) {
                        this.deprecationFiles.addElement(object);
                    }
                    if (!this.deprecation()) {
                        return;
                    }
                }
                ++this.nwarnings;
                if (!this.warnings()) {
                    return;
                }
            } else {
                ++this.nerrors;
                this.flags |= 0x10000;
            }
            this.insertError(n, string2);
            return;
        }
        if (object instanceof ClassFile) {
            this.reportError(((ClassFile)object).getPath(), n, string, string2);
            return;
        }
        if (object instanceof Identifier) {
            this.reportError(object.toString(), n, string, string2);
            return;
        }
        if (object instanceof ClassDeclaration) {
            try {
                this.reportError(((ClassDeclaration)object).getClassDefinition(this), n, string, string2);
                return;
            }
            catch (ClassNotFound classNotFound) {
                this.reportError(((ClassDeclaration)object).getName(), n, string, string2);
                return;
            }
        }
        if (object instanceof ClassDefinition) {
            ClassDefinition classDefinition = (ClassDefinition)object;
            if (!string.startsWith("warn.")) {
                classDefinition.setError(true);
            }
            this.reportError(classDefinition.getSource(), n, string, string2);
            return;
        }
        if (object instanceof FieldDefinition) {
            this.reportError(((FieldDefinition)object).getClassDeclaration(), n, string, string2);
            return;
        }
        this.output(String.valueOf(object) + ":error=" + string + ":" + string2);
    }

    public void error(Object object, int n, String string, Object object2, Object object3, Object object4) {
        if (this.errorsPushed >= this.errorLimit + this.nwarnings) {
            return;
        }
        if (System.getProperty("javac.dump.stack") != null) {
            this.output("javac.err." + string + ": " + this.errorString(string, object2, object3, object4));
            new Exception("Stack trace").printStackTrace(new PrintStream(this.out));
        }
        this.reportError(object, n, string, this.errorString(string, object2, object3, object4));
    }

    public void output(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        printStream.println(string);
    }
}

