/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javadoc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.Type;
import sun.tools.javac.BatchEnvironment;
import sun.tools.javac.SourceClass;
import sun.tools.javadoc.Main;

abstract class DocumentationGenerator
implements Constants {
    BatchEnvironment env;
    Hashtable classesToDocument;
    static String encoding;
    private static final Identifier idIOException;
    static ClassDeclaration exDecl;
    static ClassDeclaration errorDecl;

    public void init(Vector vector, String string) {
        encoding = string;
        this.env = Main.env;
        this.classesToDocument = new Hashtable(vector.size() * 2 + 1);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ClassDeclaration classDeclaration = (ClassDeclaration)enumeration.nextElement();
            this.classesToDocument.put(classDeclaration, classDeclaration);
        }
    }

    public ClassDeclaration getClassDeclaration(ClassDefinition classDefinition, Identifier identifier) {
        Environment environment;
        Constants constants;
        if (classDefinition instanceof SourceClass) {
            constants = (SourceClass)classDefinition;
            environment = constants.getImports().newEnvironment(this.env);
        } else {
            environment = this.env;
        }
        constants = classDefinition.resolveName(environment, identifier);
        return this.env.getClassDeclaration((Identifier)constants);
    }

    public ClassDefinition getClassDefinition(ClassDeclaration classDeclaration) throws ClassNotFound {
        if (classDeclaration.getName().isInner()) {
            throw new ClassNotFound(classDeclaration.getName());
        }
        ClassDefinition classDefinition = classDeclaration.getClassDefinition(this.env);
        classDefinition.resolveTypeStructure(this.env);
        return classDefinition;
    }

    public String getReferenceName(Identifier identifier) {
        identifier = Identifier.lookup(identifier.getQualifier(), identifier.getFlatName());
        return identifier.toString();
    }

    public static String getReferenceName(FieldDefinition fieldDefinition) {
        if (fieldDefinition.isConstructor()) {
            Identifier identifier = fieldDefinition.getClassDeclaration().getName();
            identifier = identifier.getFlatName();
            return identifier.getName().toString();
        }
        return fieldDefinition.getName().toString();
    }

    boolean shouldDocument(ClassDeclaration classDeclaration) {
        return this.classesToDocument.containsKey(classDeclaration);
    }

    boolean shouldDocument(ClassDefinition classDefinition) {
        return this.shouldDocument(classDefinition.getClassDeclaration());
    }

    static boolean shouldDocument(FieldDefinition fieldDefinition) {
        if (fieldDefinition.isSynthetic()) {
            return false;
        }
        return Main.showAccess.checkField(fieldDefinition);
    }

    static Vector allVariables(ClassDefinition classDefinition) {
        Vector<FieldDefinition> vector = new Vector<FieldDefinition>();
        FieldDefinition fieldDefinition = classDefinition.getFirstField();
        while (fieldDefinition != null) {
            if (fieldDefinition.isVariable() && DocumentationGenerator.shouldDocument(fieldDefinition)) {
                vector.addElement(fieldDefinition);
            }
            fieldDefinition = fieldDefinition.getNextField();
        }
        return vector;
    }

    static Vector allConstructors(ClassDefinition classDefinition) {
        Vector<FieldDefinition> vector = new Vector<FieldDefinition>();
        FieldDefinition fieldDefinition = classDefinition.getFirstField();
        while (fieldDefinition != null) {
            if (fieldDefinition.isConstructor() && DocumentationGenerator.shouldDocument(fieldDefinition)) {
                vector.addElement(fieldDefinition);
            }
            fieldDefinition = fieldDefinition.getNextField();
        }
        return vector;
    }

    static Vector allMethods(ClassDefinition classDefinition) {
        Vector<FieldDefinition> vector = new Vector<FieldDefinition>();
        FieldDefinition fieldDefinition = classDefinition.getFirstField();
        while (fieldDefinition != null) {
            if (fieldDefinition.isMethod() && !fieldDefinition.isConstructor() && DocumentationGenerator.shouldDocument(fieldDefinition)) {
                vector.addElement(fieldDefinition);
            }
            fieldDefinition = fieldDefinition.getNextField();
        }
        return vector;
    }

    static Vector localFieldsOf(ClassDefinition classDefinition, Vector vector) {
        Vector<FieldDefinition> vector2 = new Vector<FieldDefinition>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            FieldDefinition fieldDefinition = (FieldDefinition)enumeration.nextElement();
            if (!fieldDefinition.getClassDefinition().equals(classDefinition) || fieldDefinition.getClassDeclaration() != fieldDefinition.getDefiningClassDeclaration()) continue;
            vector2.addElement(fieldDefinition);
        }
        return vector2;
    }

    Vector superclassesOf(ClassDeclaration classDeclaration) {
        if (classDeclaration == null) {
            return new Vector();
        }
        try {
            ClassDeclaration classDeclaration2 = this.getClassDefinition(classDeclaration).getSuperClass();
            Vector vector = this.superclassesOf(classDeclaration2);
            vector.addElement(classDeclaration);
            return vector;
        }
        catch (ClassNotFound classNotFound) {
            System.out.println(Main.getText("doc.Warning_superclass_info", classDeclaration.getName().toString()));
            return new Vector();
        }
    }

    static Vector mergeDoc(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = string2.trim();
            if (string3.length() == 0) continue;
            if (string3.charAt(0) == '@') {
                vector.addElement(string3);
                continue;
            }
            if (vector.size() == 0) {
                vector.addElement("@comment " + string2);
                continue;
            }
            int n = vector.size() - 1;
            vector.setElementAt(String.valueOf(vector.elementAt(n)) + "\n" + string2, n);
        }
        return vector;
    }

    abstract String commentString(String var1);

    abstract String returnString(String var1);

    abstract String versionString(String var1);

    abstract String authorString(String var1);

    String deprecatedString(String string) {
        return string;
    }

    String getComment(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("@comment")) continue;
            return this.commentString(string.substring(8).trim());
        }
        return null;
    }

    String getReturn(Vector vector) {
        String string = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("@return")) continue;
            if ((string2 = string2.substring(7).trim()).length() == 0) {
                System.out.println(Main.getText("doc.Warning_Empty_statement", "@return"));
                continue;
            }
            if (string == null) {
                string = this.returnString(string2);
                continue;
            }
            System.out.println(Main.getText("doc.Warning_Multiple_statements", "@return"));
        }
        return string;
    }

    String getVersion(Vector vector) {
        if (!Main.showVersion) {
            return null;
        }
        String string = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("@version")) continue;
            if ((string2 = string2.substring(8).trim()).length() == 0) {
                System.out.println(Main.getText("doc.Warning_Empty_statement", "@version"));
                continue;
            }
            if (string == null) {
                string = this.versionString(string2);
                continue;
            }
            System.out.println(Main.getText("doc.Warning_Multiple_statements", "@version"));
        }
        return string;
    }

    String getDeprecated(Vector vector) {
        if (!Main.showDeprecated) {
            return null;
        }
        String string = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("@deprecated")) continue;
            string2 = string2.substring(11).trim();
            if (string == null) {
                string = this.deprecatedString(string2);
                continue;
            }
            System.out.println(Main.getText("doc.Warning_Multiple_statements", "@deprecated"));
        }
        return string;
    }

    Vector getSees(Vector vector, ClassDeclaration classDeclaration) {
        Vector vector2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("@see")) continue;
            if ((string = string.substring(4).trim()).length() == 0) {
                System.out.println(Main.getText("doc.Warning_Empty_statement", "@see"));
                continue;
            }
            if (vector2 == null) {
                vector2 = new Vector();
            }
            this.parseSeeString(string, classDeclaration, vector2);
        }
        return vector2;
    }

    String getAuthors(Vector vector) {
        if (!Main.showAuthors) {
            return null;
        }
        String string = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("@author")) continue;
            if ((string2 = string2.substring(7).trim()).length() == 0) {
                System.out.println(Main.getText("doc.Warning_Empty_statement", "@author"));
                continue;
            }
            string = string == null ? this.authorString(string2) : String.valueOf(string) + ", " + this.authorString(string2);
        }
        return string;
    }

    static Vector getParameters(Vector vector) {
        Vector<String> vector2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("@param")) continue;
            int n = 0;
            string = string.substring(6).trim();
            while (n < string.length()) {
                if (string.charAt(n) == ' ' || string.charAt(n) == '\t') break;
                ++n;
            }
            if (n < string.length()) {
                if (vector2 == null) {
                    vector2 = new Vector<String>();
                }
                vector2.addElement(string.substring(0, n));
                vector2.addElement(string.substring(n).trim());
                continue;
            }
            System.out.println(Main.getText("doc.Warning_Empty_statement", "@param"));
        }
        return vector2;
    }

    Vector getThrows(Vector vector, FieldDefinition fieldDefinition) {
        Constants constants;
        Object object;
        Constants constants2;
        Object object2;
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!((String)object2).startsWith("@exception")) continue;
            int n = 0;
            object2 = ((String)object2).substring(10).trim();
            while (n < ((String)object2).length()) {
                if (((String)object2).charAt(n) == ' ' || ((String)object2).charAt(n) == '\t' || ((String)object2).charAt(n) == '\n') break;
                ++n;
            }
            if (n >= ((String)object2).length()) {
                System.out.println(Main.getText("doc.Warning_Empty_statement", "@exception"));
                continue;
            }
            constants2 = Identifier.lookup(((String)object2).substring(0, n));
            object = this.getClassDeclaration(fieldDefinition.getClassDefinition(), (Identifier)constants2);
            vector2.addElement(object);
            vector2.addElement(((String)object2).substring(n).trim());
        }
        object2 = this.env.getClassDeclaration(Constants.idJavaLangError);
        ClassDeclaration classDeclaration = this.env.getClassDeclaration(Constants.idJavaLangRuntimeException);
        constants2 = this.env.getClassDeclaration(idIOException);
        object = fieldDefinition.getExceptions(this.env);
        int n = 0;
        while (n < ((ClassDeclaration[])object).length) {
            block14: {
                ClassDeclaration classDeclaration2 = object[n];
                try {
                    constants = this.getClassDefinition(classDeclaration2);
                    if (((ClassDefinition)constants).subClassOf(this.env, (ClassDeclaration)object2) || ((ClassDefinition)constants).subClassOf(this.env, classDeclaration) || ((ClassDefinition)constants).subClassOf(this.env, (ClassDeclaration)constants2)) break block14;
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        if (!((ClassDefinition)constants).subClassOf(this.env, (ClassDeclaration)vector2.elementAt(n2))) {
                            n2 += 2;
                            continue;
                        }
                        break block14;
                    }
                    System.out.println(Main.getText("doc.Method_there_is_no_exception", fieldDefinition.toString(), ((ClassDefinition)constants).toString(), "@exception"));
                }
                catch (ClassNotFound classNotFound) {
                    System.out.println(Main.getText("doc.Could_not_find", classNotFound.name.toString()));
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < vector2.size()) {
            block15: {
                constants = (ClassDeclaration)vector2.elementAt(n3);
                try {
                    ClassDefinition classDefinition = this.getClassDefinition((ClassDeclaration)constants);
                    if (classDefinition.subClassOf(this.env, (ClassDeclaration)object2) || classDefinition.subClassOf(this.env, classDeclaration) || classDefinition.subClassOf(this.env, (ClassDeclaration)constants2)) break block15;
                    int n4 = 0;
                    while (n4 < ((ClassDeclaration[])object).length) {
                        if (!classDefinition.subClassOf(this.env, object[n4])) {
                            ++n4;
                            continue;
                        }
                        break block15;
                    }
                    System.out.println(Main.getText("doc.Method_Throw_does_not_declare", fieldDefinition.toString(), ((ClassDeclaration)constants).toString()));
                }
                catch (ClassNotFound classNotFound) {
                    System.out.println(Main.getText("doc.Could_not_find", classNotFound.name.toString()));
                }
            }
            n3 += 2;
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }

    FieldDefinition getOverride(FieldDefinition fieldDefinition) {
        FieldDefinition fieldDefinition2 = null;
        try {
            if (!fieldDefinition.isStatic() && !fieldDefinition.isConstructor() && fieldDefinition.getClassDefinition().getSuperClass() != null) {
                fieldDefinition2 = this.getClassDefinition(fieldDefinition.getClassDefinition().getSuperClass()).findMethod(this.env, fieldDefinition.getName(), fieldDefinition.getType());
            }
        }
        catch (ClassNotFound classNotFound) {
            fieldDefinition2 = null;
        }
        return fieldDefinition2;
    }

    boolean isException(ClassDeclaration classDeclaration) {
        if (exDecl == null) {
            Identifier identifier = Identifier.lookup("java.lang.Exception");
            exDecl = this.env.getClassDeclaration(identifier);
        }
        try {
            return this.getClassDefinition(classDeclaration).subClassOf(this.env, exDecl);
        }
        catch (ClassNotFound classNotFound) {
            System.out.println(Main.getText("doc.Warning_Could_not_find_class_info", exDecl.getName().toString()));
            return false;
        }
    }

    boolean isError(ClassDeclaration classDeclaration) {
        if (errorDecl == null) {
            Identifier identifier = Identifier.lookup("java.lang.Error");
            errorDecl = this.env.getClassDeclaration(identifier);
        }
        try {
            return this.getClassDefinition(classDeclaration).subClassOf(this.env, errorDecl);
        }
        catch (ClassNotFound classNotFound) {
            System.out.println(Main.getText("doc.Warning_Could_not_find_class_info", errorDecl.getName().toString()));
            return false;
        }
    }

    static PrintWriter openFile(String string) {
        OutputStreamWriter outputStreamWriter;
        if (Main.destDir != null) {
            string = String.valueOf(Main.destDir.getPath()) + File.separator + string;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            outputStreamWriter = encoding == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, encoding);
        }
        catch (IOException iOException) {
            try {
                String string2 = new File(string).getParent();
                if (string2 == null) {
                    throw new IOException();
                }
                new File(string2).mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                outputStreamWriter = encoding == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, encoding);
            }
            catch (IOException iOException2) {
                throw new Error(Main.getText("doc.Can_not_open_output_file"));
            }
        }
        return new PrintWriter(new BufferedWriter(outputStreamWriter));
    }

    String firstSentence(ClassDefinition classDefinition) {
        return this.firstSentence(classDefinition.getDocumentation());
    }

    String firstSentence(FieldDefinition fieldDefinition) {
        return this.firstSentence(this.getDocumentation(fieldDefinition));
    }

    private String firstSentence(String string) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case '.': {
                    bl = true;
                    break;
                }
                case '@': {
                    return string.substring(0, n2);
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    if (!bl) break;
                    return string.substring(0, n2);
                }
                default: {
                    bl = false;
                }
            }
            ++n2;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    String getDocumentation(FieldDefinition var1_1) {
        var2_2 = var1_1.getDocumentation();
        if (var2_2 == null && !var1_1.isVariable() && !var1_1.isConstructor()) ** GOTO lbl13
        return var2_2;
        while ((var3_3 = var1_1.getClassDefinition().getSuperClass()) != null) {
            try {
                var1_1 = this.getClassDefinition(var3_3).findMethod(this.env, var1_1.getName(), var1_1.getType());
            }
            catch (ClassNotFound v0) {
                System.out.println(Main.getText("doc.Warning_Could_not_find_class_info", var3_3.getName().toString()));
                var1_1 = null;
            }
            if (var1_1 != null) {
                var2_2 = var1_1.getDocumentation();
            }
lbl13:
            // 4 sources

            if (var1_1 != null && var2_2 == null) continue;
        }
        if (var2_2 != null) {
            return this.firstSentence(var2_2);
        }
        return null;
    }

    String typeString(Type type) {
        switch (type.getTypeCode()) {
            case 11: {
                return "void";
            }
            case 0: {
                return "boolean";
            }
            case 1: {
                return "byte";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 10: {
                return this.classString(this.env.getClassDeclaration(type));
            }
            case 9: {
                return this.typeString(type.getElementType());
            }
        }
        return "error";
    }

    String typeArrayString(Type type) {
        String string = "";
        while (type.getTypeCode() == 9) {
            string = String.valueOf(string) + "[]";
            type = type.getElementType();
        }
        return string;
    }

    static String modString(FieldDefinition fieldDefinition) {
        return DocumentationGenerator.modString(fieldDefinition, true);
    }

    static String modString(FieldDefinition fieldDefinition, boolean bl) {
        String string;
        int n = fieldDefinition.getModifiers();
        if (!bl) {
            n &= 0xFFFFFFDF;
        }
        if ((string = Modifier.toString(n)).length() > 0) {
            return " " + string;
        }
        return "";
    }

    private static int compare(ClassDeclaration classDeclaration, ClassDeclaration classDeclaration2) {
        Identifier identifier = classDeclaration.getName();
        Identifier identifier2 = classDeclaration2.getName();
        int n = identifier.getName().toString().compareTo(identifier2.getName().toString());
        if (n == 0) {
            return identifier.getQualifier().toString().compareTo(identifier2.getQualifier().toString());
        }
        return n;
    }

    static void sort(ClassDeclaration[] classDeclarationArray) {
        boolean bl;
        do {
            bl = true;
            int n = classDeclarationArray.length - 1;
            while (n > 0) {
                if (DocumentationGenerator.compare(classDeclarationArray[n - 1], classDeclarationArray[n]) > 0) {
                    ClassDeclaration classDeclaration = classDeclarationArray[n];
                    classDeclarationArray[n] = classDeclarationArray[n - 1];
                    classDeclarationArray[n - 1] = classDeclaration;
                    bl = false;
                }
                --n;
            }
        } while (!bl);
    }

    void genPackagesDocumentation(Vector vector) {
        Object[] objectArray;
        Vector<Object[]> vector2 = new Vector<Object[]>();
        Vector vector3 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            (objectArray.startsWith("java.") ? vector2 : vector3).addElement(objectArray);
        }
        objectArray = null;
        Object[] objectArray2 = null;
        if (vector2.size() > 0) {
            objectArray = new String[vector2.size()];
            vector2.copyInto(objectArray);
            DocumentationGenerator.sort((String[])objectArray);
        }
        if (vector3.size() > 0) {
            objectArray2 = new String[vector3.size()];
            vector3.copyInto(objectArray2);
            DocumentationGenerator.sort((String[])objectArray2);
        }
        this.genPackagesDocumentation((String[])objectArray, (String[])objectArray2);
    }

    abstract void genPackagesDocumentation(String[] var1, String[] var2);

    private Vector collectClasses() {
        Vector vector = new Vector();
        Enumeration enumeration = this.env.getClasses();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    void genPackageDocumentation(Identifier identifier) {
        Object object;
        Object object2;
        boolean bl;
        do {
            bl = false;
            Enumeration enumeration = this.collectClasses().elements();
            while (enumeration.hasMoreElements()) {
                ClassDeclaration classDeclaration = (ClassDeclaration)enumeration.nextElement();
                if (classDeclaration.isDefined()) continue;
                try {
                    this.getClassDefinition(classDeclaration);
                    bl = true;
                }
                catch (ClassNotFound classNotFound) {}
            }
        } while (bl);
        Vector vector = this.collectClasses();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (ClassDeclaration)enumeration.nextElement();
            try {
                object = this.getClassDefinition((ClassDeclaration)object2);
                if (!this.shouldDocument((ClassDeclaration)object2) || !((ClassDeclaration)object2).getName().getQualifier().equals(identifier)) continue;
                if (((ClassDefinition)object).isInterface()) {
                    ++n;
                    continue;
                }
                if (this.isException((ClassDeclaration)object2)) {
                    ++n3;
                    continue;
                }
                if (this.isError((ClassDeclaration)object2)) {
                    ++n4;
                    continue;
                }
                ++n2;
            }
            catch (ClassNotFound classNotFound) {}
        }
        object2 = new ClassDeclaration[n];
        object = new ClassDeclaration[n2];
        ClassDeclaration[] classDeclarationArray = new ClassDeclaration[n3];
        ClassDeclaration[] classDeclarationArray2 = new ClassDeclaration[n4];
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            ClassDeclaration classDeclaration = (ClassDeclaration)enumeration2.nextElement();
            try {
                ClassDefinition classDefinition = this.getClassDefinition(classDeclaration);
                if (!this.shouldDocument(classDeclaration) || !classDeclaration.getName().getQualifier().equals(identifier)) continue;
                if (classDefinition.isInterface()) {
                    object2[--n] = classDeclaration;
                    continue;
                }
                if (this.isException(classDeclaration)) {
                    classDeclarationArray[--n3] = classDeclaration;
                    continue;
                }
                if (this.isError(classDeclaration)) {
                    classDeclarationArray2[--n4] = classDeclaration;
                    continue;
                }
                object[--n2] = classDeclaration;
            }
            catch (ClassNotFound classNotFound) {}
        }
        vector = null;
        this.genPackageDocumentation(identifier, (ClassDeclaration[])object2, (ClassDeclaration[])object, classDeclarationArray, classDeclarationArray2);
    }

    abstract void genPackageDocumentation(Identifier var1, ClassDeclaration[] var2, ClassDeclaration[] var3, ClassDeclaration[] var4, ClassDeclaration[] var5);

    abstract void genClassDocumentation(ClassDeclaration var1, ClassDeclaration var2, ClassDeclaration var3);

    abstract String classString(ClassDeclaration var1);

    static void sort(FieldDefinition[] fieldDefinitionArray) {
        DocumentationGenerator.xsort(fieldDefinitionArray);
    }

    static void sort(String[] stringArray) {
        boolean bl;
        do {
            bl = true;
            int n = stringArray.length - 1;
            while (n > 0) {
                if (stringArray[n - 1].compareTo(stringArray[n]) > 0) {
                    String string = stringArray[n];
                    stringArray[n] = stringArray[n - 1];
                    stringArray[n - 1] = string;
                    bl = false;
                }
                --n;
            }
        } while (!bl);
    }

    static String sortKey(FieldDefinition fieldDefinition) {
        ClassDefinition classDefinition = fieldDefinition.getClassDefinition();
        String string = (String.valueOf(classDefinition.getName().getName()) + "." + classDefinition.getName().getQualifier()).toLowerCase();
        if (fieldDefinition.isVariable()) {
            return String.valueOf(fieldDefinition.getName().toString().toLowerCase()) + " " + string;
        }
        String string2 = DocumentationGenerator.getReferenceName(fieldDefinition);
        Type type = fieldDefinition.getType();
        return String.valueOf(type.typeString(string2, true, false).toLowerCase()) + string;
    }

    static void xsort(FieldDefinition[] fieldDefinitionArray, String[] stringArray) {
        DocumentationGenerator.xsort(fieldDefinitionArray, stringArray, 0, fieldDefinitionArray.length - 1);
    }

    static void xsort(FieldDefinition[] fieldDefinitionArray) {
        String[] stringArray = new String[fieldDefinitionArray.length];
        int n = fieldDefinitionArray.length;
        while (--n >= 0) {
            stringArray[n] = DocumentationGenerator.sortKey(fieldDefinitionArray[n]);
        }
        DocumentationGenerator.xsort(fieldDefinitionArray, stringArray, 0, fieldDefinitionArray.length - 1);
    }

    /*
     * Unable to fully structure code
     */
    private static void xsort(FieldDefinition[] var0, String[] var1_1, int var2_2, int var3_3) {
        if (var2_2 >= var3_3) {
            return;
        }
        var4_4 = var1_1[var2_2];
        var5_5 = var2_2;
        var6_6 = var3_3;
        ** GOTO lbl20
        {
            ++var5_5;
            do {
                if (var5_5 <= var3_3 && var1_1[var5_5].compareTo(var4_4) <= 0) continue block0;
                while (var6_6 >= var2_2 && var1_1[var6_6].compareTo(var4_4) > 0) {
                    --var6_6;
                }
                if (var5_5 >= var6_6) continue;
                var7_7 = var0[var5_5];
                var8_9 = var1_1[var5_5];
                var0[var5_5] = var0[var6_6];
                var0[var6_6] = var7_7;
                var1_1[var5_5] = var1_1[var6_6];
                var1_1[var6_6] = var8_9;
lbl20:
                // 3 sources

            } while (var5_5 < var6_6);
        }
        var7_8 = var6_6;
        var8_9 = var0[var2_2];
        var9_10 = var1_1[var2_2];
        var0[var2_2] = var0[var7_8];
        var0[var7_8] = var8_9;
        var1_1[var2_2] = var1_1[var7_8];
        var1_1[var7_8] = var9_10;
        DocumentationGenerator.xsort(var0, var1_1, var2_2, var7_8 - 1);
        DocumentationGenerator.xsort(var0, var1_1, var7_8 + 1, var3_3);
    }

    Hashtable createClassTree() {
        Object object;
        Hashtable<ClassDeclaration, Object[]> hashtable = new Hashtable<ClassDeclaration, Object[]>();
        Enumeration enumeration = this.env.getClasses();
        while (enumeration.hasMoreElements()) {
            object = (ClassDeclaration)enumeration.nextElement();
            if (!this.shouldDocument((ClassDeclaration)object)) continue;
            this.genClassTree((ClassDeclaration)object, hashtable);
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            ClassDeclaration classDeclaration = (ClassDeclaration)object.nextElement();
            Vector vector = (Vector)hashtable.get(classDeclaration);
            if (vector.size() > 0) {
                Object[] objectArray = new ClassDeclaration[vector.size()];
                vector.copyInto(objectArray);
                DocumentationGenerator.sort((ClassDeclaration[])objectArray);
                hashtable.put(classDeclaration, objectArray);
                continue;
            }
            hashtable.remove(classDeclaration);
        }
        return hashtable;
    }

    private Vector genClassTree(ClassDeclaration classDeclaration, Hashtable hashtable) {
        Vector vector = (Vector)hashtable.get(classDeclaration);
        if (vector != null) {
            return vector;
        }
        vector = new Vector();
        hashtable.put(classDeclaration, vector);
        try {
            ClassDeclaration classDeclaration2 = this.getClassDefinition(classDeclaration).getSuperClass();
            if (classDeclaration2 != null) {
                Vector vector2 = this.genClassTree(classDeclaration2, hashtable);
                vector2.addElement(classDeclaration);
            }
        }
        catch (ClassNotFound classNotFound) {}
        return vector;
    }

    abstract void genFieldIndex();

    void genClassTree() {
        this.genClassTree(this.createClassTree(), this.env.getClassDeclaration(Type.tObject.getClassName()));
    }

    abstract void genClassTree(Hashtable var1, ClassDeclaration var2);

    void parseSeeString(String string, ClassDeclaration classDeclaration, Vector vector) {
        ClassDeclaration classDeclaration2;
        Constants constants;
        Object object;
        String string2;
        String string3;
        int n;
        string = string.trim();
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            n = string.charAt(n3);
            switch (n) {
                case 40: {
                    ++n2;
                    break;
                }
                case 41: {
                    --n2;
                    break;
                }
                case 9: 
                case 32: 
                case 44: {
                    if (n2 > 0) break;
                    System.out.println(Main.getText("doc.see_warning_extraneous_text", string));
                    string = string.substring(0, n3);
                    break;
                }
            }
            ++n3;
        }
        n = string.indexOf(35);
        if (n >= 0) {
            string3 = string.substring(n + 1);
            string2 = string.substring(0, n);
        } else {
            n = string.indexOf(40);
            if (n >= 0) {
                System.out.println(Main.getText("doc.see_warning_missing_sharp", string));
                string3 = string;
                string2 = "";
            } else {
                string3 = null;
                string2 = string;
            }
        }
        if (string2.length() > 0) {
            object = Identifier.lookup(string2);
            try {
                int n4;
                constants = this.getClassDefinition(classDeclaration);
                classDeclaration2 = this.getClassDeclaration((ClassDefinition)constants, (Identifier)object);
                if (classDeclaration2.getName().isInner() && string3 == null && (n4 = string2.lastIndexOf(46)) >= 0) {
                    String string4 = new String(string2);
                    string3 = string2.substring(n4 + 1);
                    string2 = string2.substring(0, n4);
                    System.out.print(Main.getText("doc.see_warning_Treating_reference", string4, string2, string3));
                    object = Identifier.lookup(string2);
                    classDeclaration2 = this.getClassDeclaration((ClassDefinition)constants, (Identifier)object);
                }
            }
            catch (ClassNotFound classNotFound) {
                classDeclaration2 = this.env.getClassDeclaration(Identifier.lookup(string2));
            }
        } else {
            classDeclaration2 = classDeclaration;
        }
        if (string3 == null) {
            vector.addElement(classDeclaration2);
            vector.addElement(null);
            vector.addElement(null);
            return;
        }
        n = string3.indexOf(40);
        object = n >= 0 ? string3.substring(0, n) : string3;
        constants = Identifier.lookup((String)object);
        try {
            if (!((String)object).equals(string2)) {
                FieldDefinition fieldDefinition = this.findVisibleField(classDeclaration2, this.env, (Identifier)constants, n > 0);
                if (fieldDefinition == null) {
                    System.out.println(Main.getText("doc.see_warning_Can_not_find_field", (String)object, classDeclaration2.toString()));
                } else if (fieldDefinition.getClassDeclaration() != classDeclaration2) {
                    System.out.println(Main.getText("doc.see_warning_Found_in_parent", (String)object, fieldDefinition.getClassDeclaration().toString(), classDeclaration2.toString()));
                    classDeclaration2 = fieldDefinition.getClassDeclaration();
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            System.out.println(Main.getText("doc.see_warning_Can_not_find", classDeclaration2.toString()));
        }
        vector.addElement(classDeclaration2);
        vector.addElement(object);
        vector.addElement(string3);
    }

    FieldDefinition findVisibleField(ClassDeclaration classDeclaration, Environment environment, Identifier identifier, boolean bl) throws ClassNotFound {
        ClassDefinition classDefinition = this.getClassDefinition(classDeclaration);
        FieldDefinition fieldDefinition = classDefinition.getFirstMatch(identifier);
        while (fieldDefinition != null) {
            if (DocumentationGenerator.shouldDocument(fieldDefinition) && (!bl || fieldDefinition.isMethod())) {
                return fieldDefinition;
            }
            fieldDefinition = fieldDefinition.getNextMatch();
        }
        ClassDeclaration classDeclaration2 = classDefinition.getSuperClass();
        if (classDeclaration2 == null) {
            return null;
        }
        return this.findVisibleField(classDeclaration2, environment, identifier, bl);
    }

    DocumentationGenerator() {
    }

    static {
        idIOException = Identifier.lookup("java.io.IOException");
    }
}

