/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javadoc;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Constants;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.Package;
import sun.tools.javac.BatchEnvironment;
import sun.tools.javac.SourceClass;
import sun.tools.javadoc.DocumentationGenerator;
import sun.tools.util.ModifierFilter;

public final class Main
implements Constants {
    public static final String program = "javadoc";
    public static BatchEnvironment env;
    public static File destDir;
    public static DocumentationGenerator generator;
    public static boolean showAuthors;
    public static boolean showVersion;
    public static boolean showPackage;
    public static ModifierFilter showAccess;
    public static boolean showDeprecated;
    public static boolean showIndex;
    public static boolean showTree;
    private static ResourceBundle messageRB;

    static void error(String string) {
        System.out.println("javadoc: " + string);
        if (env != null) {
            ++Main.env.nerrors;
        }
    }

    static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.tools.javadoc.resources.javadoc");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for javadoc is missing");
        }
    }

    public static String getText(String string) {
        return Main.getText(string, null);
    }

    public static String getText(String string, int n) {
        return Main.getText(string, Integer.toString(n), null);
    }

    public static String getText(String string, String string2) {
        return Main.getText(string, string2, null);
    }

    public static String getText(String string, String string2, String string3) {
        return Main.getText(string, string2, string3, null);
    }

    public static String getText(String string, String string2, String string3, String string4) {
        if (messageRB == null) {
            Main.initResource();
        }
        try {
            String string5 = messageRB.getString(string);
            Object[] objectArray = new String[]{string2, string3, string4};
            return MessageFormat.format(string5, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for javadoc is broken. There is no " + string + " key in resource.");
        }
    }

    static void exit() {
        int n = 0;
        if (env == null) {
            n = 1;
        } else {
            env.flushErrors();
            if (Main.env.nerrors > 0) {
                if (Main.env.nerrors > 1) {
                    System.out.print(Main.getText("main.errors", Main.env.nerrors));
                } else {
                    System.out.print(Main.getText("main.error", Main.env.nerrors));
                }
                if (Main.env.nwarnings > 0) {
                    if (Main.env.nwarnings > 1) {
                        System.out.print(Main.getText("main.warnings", Main.env.nwarnings));
                    } else {
                        System.out.print(Main.getText("main.warning", Main.env.nwarnings));
                    }
                }
                System.out.println();
                n = 1;
            } else if (Main.env.nwarnings > 0) {
                if (Main.env.nwarnings > 1) {
                    System.out.print(Main.getText("main.warnings", Main.env.nwarnings));
                } else {
                    System.out.print(Main.getText("main.warning", Main.env.nwarnings));
                }
            }
        }
        System.exit(n);
    }

    static void usage() {
        System.out.println(Main.getText("main.usage"));
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string = System.getProperty("java.class.path");
        int n = 4;
        long l = System.currentTimeMillis();
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        String string2 = "HTML";
        String string3 = null;
        String string4 = null;
        n |= 0x100;
        int n2 = 0;
        while (n2 < stringArray.length) {
            object2 = stringArray[n2];
            if (((String)object2).equals("-verbose")) {
                n |= 1;
            } else if (((String)object2).equals("-version")) {
                showVersion = true;
            } else if (((String)object2).equals("-nodeprecated")) {
                showDeprecated = false;
            } else if (((String)object2).equals("-author") || ((String)object2).equals("-authors")) {
                showAuthors = true;
            } else if (((String)object2).equals("-private")) {
                showAccess = new ModifierFilter(-9223372036854775801L);
            } else if (((String)object2).equals("-package")) {
                showAccess = new ModifierFilter(-9223372036854775803L);
            } else if (((String)object2).equals("-protected")) {
                showAccess = new ModifierFilter(5L);
            } else if (((String)object2).equals("-public")) {
                showAccess = new ModifierFilter(1L);
            } else if (((String)object2).equals("-sourcepath") || ((String)object2).equals("-classpath")) {
                if (n2 + 1 < stringArray.length) {
                    string = stringArray[++n2];
                } else {
                    Main.error(Main.getText("main.requires_argument", (String)object2));
                    Main.usage();
                    Main.exit();
                }
            } else if (((String)object2).equals("-doctype")) {
                if (n2 + 1 < stringArray.length) {
                    string2 = stringArray[++n2];
                } else {
                    Main.error(Main.getText("main.requires_argument", "-docType"));
                    Main.usage();
                    Main.exit();
                }
            } else if (((String)object2).equals("-noindex")) {
                showIndex = false;
            } else if (((String)object2).equals("-notree")) {
                showTree = false;
            } else if (((String)object2).equals("-d")) {
                if (n2 + 1 < stringArray.length) {
                    if (!(destDir = new File(stringArray[++n2])).exists()) {
                        Main.error(Main.getText("main.does_not_exist", destDir.getPath()));
                        Main.exit();
                    }
                } else {
                    Main.error(Main.getText("main.requires_argument", "-d"));
                    Main.usage();
                    Main.exit();
                }
            } else if (((String)object2).equals("-encoding")) {
                if (n2 + 1 < stringArray.length) {
                    string3 = stringArray[++n2];
                } else {
                    Main.error(Main.getText("main.requires_argument", "-encoding"));
                    Main.usage();
                    Main.exit();
                }
            } else if (((String)object2).equals("-docencoding")) {
                if (n2 + 1 < stringArray.length) {
                    string4 = stringArray[++n2];
                } else {
                    Main.error(Main.getText("main.requires_argument", "-docencoding"));
                    Main.usage();
                    Main.exit();
                }
            } else if (((String)object2).startsWith("-")) {
                Main.error(Main.getText("main.invalid_flag", (String)object2));
                Main.usage();
                Main.exit();
            } else if (((String)object2).endsWith(".java") && ((String)object2).indexOf(46) == ((String)object2).length() - 5) {
                vector2.addElement(object2);
            } else {
                vector.addElement(object2);
            }
            ++n2;
        }
        if (vector.size() == 0 && vector2.size() == 0) {
            Main.error(Main.getText("main.No_packages_or_classes_specified"));
            Main.usage();
            Main.exit();
        }
        if (string == null) {
            string = ".";
        }
        object2 = new ClassPath(string);
        env = new BatchEnvironment((ClassPath)object2);
        Main.env.flags |= n;
        env.setCharacterEncoding(string3);
        try {
            object = Class.forName("sun.tools.javadoc." + string2 + "DocumentationGenerator");
            generator = (DocumentationGenerator)((Class)object).newInstance();
        }
        catch (Exception exception) {
            System.out.println(Main.getText("main.Cannot_generate", string2));
            return;
        }
        try {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Serializable serializable;
            object = vector2.elements();
            while (object.hasMoreElements()) {
                serializable = new File((String)object.nextElement());
                try {
                    env.parseFile(new ClassFile((File)serializable));
                }
                catch (IOException iOException) {
                    env.error(0, "cant.read", ((File)serializable).getPath());
                }
            }
            serializable = new Vector();
            Enumeration enumeration = env.getClasses();
            while (enumeration.hasMoreElements()) {
                object6 = (ClassDeclaration)enumeration.nextElement();
                object5 = ((ClassDeclaration)object6).getClassDefinition();
                if (!((ClassDeclaration)object6).isDefined() || !(object5 instanceof SourceClass) || !showAccess.checkClass((ClassDefinition)object5)) continue;
                ((Vector)serializable).addElement(object6);
            }
            object6 = (Vector)((Vector)serializable).clone();
            object5 = new Hashtable();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Object object7;
                object4 = Identifier.lookup((String)enumeration2.nextElement());
                object3 = new Package((ClassPath)object2, (Identifier)object4);
                boolean bl = false;
                Enumeration enumeration3 = ((Package)object3).getSourceFiles();
                while (enumeration3.hasMoreElements()) {
                    if (!bl) {
                        System.out.println(Main.getText("main.Loading_source_files_for", ((Identifier)object4).toString()));
                        bl = true;
                    }
                    object7 = (ClassFile)enumeration3.nextElement();
                    try {
                        env.parseFile((ClassFile)object7);
                    }
                    catch (IOException iOException) {
                        env.error(0, "cant.read", ((ClassFile)object7).getPath());
                    }
                }
                if (!bl) {
                    System.out.println(Main.getText("main.Warning_No_source_files_for_package", ((Identifier)object4).toString()));
                    continue;
                }
                object7 = env.getClasses();
                while (object7.hasMoreElements()) {
                    ClassDeclaration classDeclaration = (ClassDeclaration)object7.nextElement();
                    ClassDefinition classDefinition = classDeclaration.getClassDefinition();
                    if (classDeclaration.isDefined() && !classDefinition.isSynthetic() && classDefinition instanceof SourceClass && showAccess.checkClass(classDefinition)) {
                        ((Vector)object6).addElement(classDeclaration);
                    }
                    if (classDefinition == null || ((Hashtable)object5).get(classDeclaration) != null) continue;
                    FieldDefinition fieldDefinition = classDefinition.getFirstField();
                    while (fieldDefinition != null) {
                        if (fieldDefinition.isMethod() && fieldDefinition.getValue() != null) {
                            fieldDefinition.setValue(null);
                        }
                        fieldDefinition = fieldDefinition.getNextField();
                    }
                    ((Hashtable)object5).put(classDeclaration, classDeclaration);
                }
            }
            if (string4 == null) {
                string4 = string3;
            }
            generator.init((Vector)object6, string4);
            generator.genPackagesDocumentation(vector);
            object4 = vector.elements();
            while (object4.hasMoreElements()) {
                object3 = Identifier.lookup((String)object4.nextElement());
                generator.genPackageDocumentation((Identifier)object3);
                env.flushErrors();
            }
            object3 = ((Vector)serializable).elements();
            while (object3.hasMoreElements()) {
                ClassDeclaration classDeclaration = (ClassDeclaration)object3.nextElement();
                generator.genClassDocumentation(classDeclaration, null, null);
                env.flushErrors();
            }
            if (showIndex) {
                System.out.println(Main.getText("main.Generating_index"));
                generator.genFieldIndex();
            }
            if (showTree) {
                System.out.println(Main.getText("main.Generating_tree"));
                generator.genClassTree();
            }
        }
        catch (Error error) {
            error.printStackTrace();
            env.error(0, "fatal.error");
            env.flushErrors();
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            env.error(0, "fatal.exception");
            env.flushErrors();
            System.exit(1);
        }
        if (env.verbose()) {
            l = System.currentTimeMillis() - l;
            System.out.println(Main.getText("main.done_in", Long.toString(l)));
        }
        Main.exit();
    }

    static {
        showAccess = new ModifierFilter(5L);
        showDeprecated = true;
        showIndex = true;
        showTree = true;
    }
}

