/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import sun.tools.java.BinaryClass;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;
import sun.tools.javap.JavaPClassPrinter;
import sun.tools.javap.JavaPEnvironment;
import sun.tools.util.ModifierFilter;

public class JavaP {
    private JavaPEnvironment env;
    private Vector classList = new Vector();
    private PrintWriter output;
    private static final String progname = "javap";
    private static final String version = "98/07/01";

    public JavaP(PrintWriter printWriter) {
        this.output = printWriter;
        this.env = new JavaPEnvironment(printWriter);
    }

    private void error(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            System.err.write(string.charAt(n2));
            ++n2;
        }
        System.err.write(10);
        System.err.flush();
    }

    private void usage() {
        this.error("Usage: javap <options> <classes>...");
        this.error("");
        this.error("where options include:");
        this.error("   -b         Backward compatibility with javap in JDK 1.1");
        this.error("   -c         Disassemble the code");
        this.error("   -classpath <directories separated by colons>");
        this.error("              List directories in which to look for classes");
        this.error("   -l         Print line number and local variable tables");
        this.error("   -public    Show only public classes and members");
        this.error("   -protected Show protected/public classes and members");
        this.error("   -package   Show package/protected/public classes");
        this.error("              and members (default)");
        this.error("   -private   Show all classes and members");
        this.error("   -s         Print internal type signatures");
        this.error("   -verbose   Print stack size, number of locals and args for methods");
        this.error("              If verifying, print reasons for failure");
        this.error("   -version   Print the javap version string");
        this.error("   -verify    Run the verifier");
        this.error("");
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseArguments(String[] stringArray) {
        String string = System.getProperty("java.class.path");
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            block8: {
                String string2;
                block9: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    string2 = stringArray[n];
                                                                    if (!string2.startsWith("-")) break block9;
                                                                    if (!string2.equals("-l")) break block10;
                                                                    this.env.showLineAndLocal = true;
                                                                    break block8;
                                                                }
                                                                if (!string2.equals("-private") && !string2.equals("-p")) break block11;
                                                                this.env.showAccess = new ModifierFilter(-9223372036854775801L);
                                                                break block8;
                                                            }
                                                            if (!string2.equals("-package")) break block12;
                                                            this.env.showAccess = new ModifierFilter(-9223372036854775803L);
                                                            break block8;
                                                        }
                                                        if (!string2.equals("-protected")) break block13;
                                                        this.env.showAccess = new ModifierFilter(5L);
                                                        break block8;
                                                    }
                                                    if (!string2.equals("-public")) break block14;
                                                    this.env.showAccess = new ModifierFilter(1L);
                                                    break block8;
                                                }
                                                if (!string2.equals("-b")) break block15;
                                                this.env.showBackwardCompatible = true;
                                                break block8;
                                            }
                                            if (!string2.equals("-c")) break block16;
                                            this.env.showDisassembled = true;
                                            break block8;
                                        }
                                        if (!string2.equals("-s")) break block17;
                                        this.env.showInternalSigs = true;
                                        break block8;
                                    }
                                    if (!string2.equals("-verbose")) break block18;
                                    this.env.showVerbose = true;
                                    break block8;
                                }
                                if (!string2.equals("-v")) break block19;
                                this.env.showVerbose = true;
                                break block8;
                            }
                            if (!string2.equals("-h")) break block20;
                            this.env.doMakeInclude = true;
                            break block8;
                        }
                        if (!string2.equals("-verify")) break block21;
                        this.env.doVerify = true;
                        break block8;
                    }
                    if (string2.equals("-verify-verbose")) {
                        this.env.doVerify = true;
                        ++this.env.verifyLevel;
                        break block8;
                    } else if (string2.equals("-version")) {
                        this.error("javap version 98/07/01");
                        bl = false;
                        break block8;
                    } else {
                        if (!string2.equals("-classpath")) {
                            this.error("invalid flag: " + string2);
                            this.usage();
                            return false;
                        }
                        if (n + 1 >= stringArray.length) {
                            this.error("-classpath requires argument");
                            this.usage();
                            return false;
                        }
                        string = stringArray[++n];
                    }
                    break block8;
                }
                this.classList.addElement(string2);
                bl = false;
            }
            ++n;
        }
        if (bl) {
            this.usage();
            return false;
        }
        this.env.path = new ClassPath(string);
        return true;
    }

    private void displayResults() {
        int n = 0;
        while (n < this.classList.size()) {
            String string = (String)this.classList.elementAt(n);
            Identifier identifier = Identifier.lookup(string);
            if (!this.env.classExists(identifier)) {
                this.error("Class '" + string + "' not found");
            } else {
                try {
                    BinaryClass binaryClass = (BinaryClass)this.env.getClassDefinition(identifier);
                    binaryClass.hasBeenLoaded(this.env);
                    JavaPClassPrinter javaPClassPrinter = new JavaPClassPrinter(binaryClass, this.env);
                    javaPClassPrinter.print();
                }
                catch (ClassNotFound classNotFound) {
                    this.error("class not found");
                }
                catch (IOException iOException) {
                    this.error("I/O Exception");
                }
            }
            ++n;
        }
    }

    private void exec(String string) {
        Object object;
        String string2 = System.getProperty("file.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("java.home"));
        stringBuffer.append(string2).append("bin").append(string2);
        stringBuffer.append(string);
        stringBuffer.append(" -classpath ").append(this.env.path);
        if (this.env.showVerbose) {
            stringBuffer.append(" -verbose");
        }
        int n = 0;
        while (n < this.env.verifyLevel) {
            stringBuffer.append(" -verify-verbose");
            ++n;
        }
        int n2 = 0;
        while (n2 < this.classList.size()) {
            object = (String)this.classList.elementAt(n2);
            stringBuffer.append(" ").append((String)object);
            ++n2;
        }
        String string3 = stringBuffer.toString();
        try {
            int n3;
            object = Runtime.getRuntime().exec(string3);
            InputStream inputStream = ((Process)object).getInputStream();
            InputStream inputStream2 = ((Process)object).getErrorStream();
            byte[] byArray = new byte[256];
            ((Process)object).waitFor();
            while ((n3 = inputStream2.read(byArray)) != -1) {
                this.output.write(new String(byArray, 0, n3));
            }
            while ((n3 = inputStream.read(byArray)) != -1) {
                this.output.write(new String(byArray, 0, n3));
            }
            return;
        }
        catch (IOException iOException) {
            this.error("Cannot execute '" + string3 + "' - " + iOException);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.error("Cannot execute '" + string3 + "' - " + interruptedException);
            return;
        }
    }

    private void perform(String[] stringArray) {
        if (this.parseArguments(stringArray)) {
            if (this.env.doMakeInclude) {
                this.error("-h is no longer available - use the 'javah' program");
                return;
            }
            if (this.env.doVerify) {
                if (this.env.verifyLevel > 0) {
                    this.exec("javaverify_g");
                    return;
                }
                this.exec("javaverify");
                return;
            }
            this.displayResults();
        }
    }

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        try {
            JavaP javaP = new JavaP(printWriter);
            javaP.perform(stringArray);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            printWriter.close();
            throw throwable;
        }
        Object var3_3 = null;
        printWriter.close();
    }
}

