/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import sun.tools.java.BinaryAttribute;
import sun.tools.java.BinaryCode;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.BinaryExceptionHandler;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.Constants;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.MethodType;
import sun.tools.java.RuntimeConstants;
import sun.tools.javap.JavaPEnvironment;
import sun.tools.util.ConstantPrinter;

class JavaPBinaryCode
extends BinaryCode
implements Constants {
    private JavaPEnvironment env;
    private PrintWriter output;
    private byte[] codeBytes;
    private BinaryConstantPool cpool;
    private ConstantPrinter constPrint;
    private FieldDefinition fieldDef;
    private String methodName;
    private int offset;

    JavaPBinaryCode(byte[] byArray, BinaryConstantPool binaryConstantPool, JavaPEnvironment javaPEnvironment, FieldDefinition fieldDefinition) {
        super(byArray, binaryConstantPool, javaPEnvironment);
        this.output = javaPEnvironment.output;
        this.codeBytes = this.getCode();
        this.cpool = binaryConstantPool;
        this.constPrint = new ConstantPrinter(binaryConstantPool, javaPEnvironment, !javaPEnvironment.showBackwardCompatible);
        this.fieldDef = fieldDefinition;
        this.methodName = fieldDefinition.toString();
    }

    FieldDefinition fieldDefinition() {
        return this.fieldDef;
    }

    private final int at(int n) {
        return this.codeBytes[this.offset + n] & 0xFF;
    }

    private final int shortAt(int n) {
        int n2 = this.offset + n;
        return (this.codeBytes[n2] & 0xFF) << 8 | this.codeBytes[n2 + 1] & 0xFF;
    }

    private final int intAt(int n, int n2) {
        int n3 = n + (n2 << 2);
        return this.codeBytes[n3] << 24 | (this.codeBytes[n3 + 1] & 0xFF) << 16 | (this.codeBytes[n3 + 2] & 0xFF) << 8 | this.codeBytes[n3 + 3] & 0xFF;
    }

    private void printFixedWidthInt(int n, int n2) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.print(n);
        String string = charArrayWriter.toString();
        int n3 = n2 - string.length();
        while (n3 > 0) {
            this.output.print(' ');
            --n3;
        }
        this.output.print(string);
    }

    void printCodeSequence() throws IOException {
        this.output.println("");
        this.output.println("Method " + this.methodName);
        this.offset = 0;
        while (this.offset < this.codeBytes.length) {
            int n;
            int n2 = this.at(0);
            this.printFixedWidthInt(this.offset, 4);
            this.output.print(" ");
            if (n2 == 196) {
                n2 = this.at(1);
                this.output.print(String.valueOf(RuntimeConstants.opcNames[n2]) + "_w ");
                n = this.shortAt(2);
                switch (n2) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        this.output.print(n);
                        this.offset += 4;
                        break;
                    }
                    case 132: {
                        this.output.print(String.valueOf(n) + " " + (short)this.shortAt(4));
                        this.offset += 6;
                        break;
                    }
                    default: {
                        this.output.print("Invalid opcode");
                        ++this.offset;
                        break;
                    }
                }
                continue;
            }
            this.output.print(RuntimeConstants.opcNames[n2]);
            switch (n2) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: {
                    this.output.print(" " + this.at(1));
                    this.offset += 2;
                    break;
                }
                case 132: {
                    this.output.print(" " + this.at(1) + " " + (byte)this.at(2));
                    this.offset += 3;
                    break;
                }
                case 170: {
                    n = this.offset + 1 + 3 & 0xFFFFFFFC;
                    int n3 = this.intAt(n, 0);
                    int n4 = this.intAt(n, 1);
                    int n5 = this.intAt(n, 2);
                    this.output.print(" " + n4 + " to " + n5 + ": default=");
                    this.output.print(this.offset + n3);
                    n += 12;
                    int n6 = n4;
                    while (n6 <= n5) {
                        this.output.println("");
                        this.output.print('\t');
                        this.printFixedWidthInt(n6, 5);
                        this.output.print(": " + (this.offset + this.intAt(n, n6 - n4)));
                        ++n6;
                    }
                    this.offset = n + (n5 - n4 + 1 << 2);
                    break;
                }
                case 171: {
                    n = this.offset + 1 + 3 & 0xFFFFFFFC;
                    int n3 = this.intAt(n, 0);
                    int n4 = this.intAt(n, 1);
                    int n5 = n4 * 2;
                    this.output.print(" " + n4);
                    this.output.print(": default=" + (this.offset + n3));
                    n += 8;
                    int n6 = 0;
                    while (n6 < n5) {
                        this.output.println("");
                        this.output.print('\t');
                        this.printFixedWidthInt(this.intAt(n, n6), 5);
                        this.output.print(": " + (this.offset + this.intAt(n, n6 + 1)));
                        n6 += 2;
                    }
                    this.offset = n + (n5 << 2);
                    break;
                }
                case 188: {
                    switch (this.at(1)) {
                        case 10: {
                            this.output.print(" int");
                            break;
                        }
                        case 11: {
                            this.output.print(" long");
                            break;
                        }
                        case 6: {
                            this.output.print(" float");
                            break;
                        }
                        case 7: {
                            this.output.print(" double");
                            break;
                        }
                        case 5: {
                            this.output.print(" char");
                            break;
                        }
                        case 9: {
                            this.output.print(" short");
                            break;
                        }
                        case 8: {
                            this.output.print(" byte");
                            break;
                        }
                        case 4: {
                            this.output.print(" boolean");
                            break;
                        }
                        default: {
                            this.output.print(" BOGUS TYPE");
                        }
                    }
                    this.offset += 2;
                    break;
                }
                case 189: {
                    n = this.shortAt(1);
                    this.output.print(" class #" + n + " ");
                    this.constPrint.printConstant(n);
                    this.offset += 3;
                    break;
                }
                case 17: {
                    this.output.print(" " + (short)this.shortAt(1));
                    this.offset += 3;
                    break;
                }
                case 16: {
                    this.output.print(" " + (byte)this.at(1));
                    this.offset += 2;
                    break;
                }
                case 18: {
                    n = this.at(1);
                    this.output.print(" #" + n + " ");
                    this.constPrint.printConstant(n);
                    this.offset += 2;
                    break;
                }
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 192: 
                case 193: {
                    n = this.shortAt(1);
                    this.output.print(" #" + n + " ");
                    this.constPrint.printConstant(n);
                    this.offset += 3;
                    break;
                }
                case 185: {
                    n = this.shortAt(1);
                    this.output.print(" (args " + this.at(3) + ") #" + n + " ");
                    this.constPrint.printConstant(n);
                    this.offset += 5;
                    break;
                }
                case 197: {
                    n = this.shortAt(1);
                    this.output.print(" #" + n + " dim #" + this.at(3) + " ");
                    this.constPrint.printConstant(n);
                    this.offset += 4;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    n = this.offset + (short)this.shortAt(1);
                    this.output.print(" " + n);
                    this.offset += 3;
                    break;
                }
                case 200: 
                case 201: {
                    n = this.offset + this.intAt(this.offset + 1, 0);
                    this.output.print(" " + n);
                    this.offset += 5;
                    break;
                }
                default: {
                    ++this.offset;
                }
            }
            this.output.println("");
        }
    }

    void printExceptionTable() throws IOException {
        BinaryExceptionHandler[] binaryExceptionHandlerArray = this.getExceptionHandlers();
        if (binaryExceptionHandlerArray.length > 0) {
            this.output.print("Exception table:\n   from   to  target type\n");
            int n = 0;
            while (n < binaryExceptionHandlerArray.length) {
                BinaryExceptionHandler binaryExceptionHandler = binaryExceptionHandlerArray[n];
                this.printFixedWidthInt(binaryExceptionHandler.startPC, 6);
                this.printFixedWidthInt(binaryExceptionHandler.endPC, 6);
                this.printFixedWidthInt(binaryExceptionHandler.handlerPC, 6);
                this.output.print("   ");
                ClassDeclaration classDeclaration = binaryExceptionHandler.exceptionClass;
                if (classDeclaration == null) {
                    this.output.println("any");
                } else {
                    this.constPrint.printClassDeclaration(classDeclaration);
                    this.output.println("");
                }
                ++n;
            }
        }
    }

    private DataInputStream findAttribute(Identifier identifier) {
        BinaryAttribute binaryAttribute = this.getAttributes();
        while (binaryAttribute != null) {
            if (binaryAttribute.getName().equals(identifier)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binaryAttribute.getData());
                return new DataInputStream(byteArrayInputStream);
            }
            binaryAttribute = binaryAttribute.getNextAttribute();
        }
        return null;
    }

    void printLineNumberTable() throws IOException {
        int n;
        DataInputStream dataInputStream = this.findAttribute(Constants.idLineNumberTable);
        if (dataInputStream != null && (n = dataInputStream.readShort()) > 0) {
            this.output.println("");
            this.output.println("Line numbers for method " + this.methodName);
            int n2 = n;
            while (n2 > 0) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                this.output.println("   line " + s2 + ": " + s);
                --n2;
            }
        }
    }

    void printLocalVariableTable() throws IOException {
        int n;
        DataInputStream dataInputStream = this.findAttribute(Constants.idLocalVariableTable);
        if (dataInputStream != null && (n = dataInputStream.readShort()) > 0) {
            this.output.println("");
            this.output.println("Local variables for method " + this.methodName);
            int n2 = n;
            while (n2 > 0) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                short s4 = dataInputStream.readShort();
                short s5 = dataInputStream.readShort();
                this.output.print("   ");
                this.output.print(this.cpool.getType(s4));
                this.output.print(" ");
                this.output.print(this.cpool.getString(s3));
                this.output.println("  pc=" + s + ", length=" + s2 + ", slot=" + s5);
                --n2;
            }
        }
    }

    void printVerboseHeader() {
        MethodType methodType = (MethodType)this.fieldDef.getType();
        int n = methodType.getArgumentTypes().length;
        if (!this.fieldDef.isStatic()) {
            ++n;
        }
        this.output.println("\t/* Stack=" + this.getMaxStack() + ", Locals=" + this.getMaxLocals() + ", Args_size=" + n + " */");
    }
}

