/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Vector;
import sun.tools.java.BinaryClass;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.BinaryField;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.Constants;
import sun.tools.java.FieldDefinition;
import sun.tools.javap.JavaPBinaryCode;
import sun.tools.javap.JavaPEnvironment;

class JavaPClassPrinter
implements Constants {
    private BinaryClass cdef;
    private JavaPEnvironment env;
    private PrintWriter output;
    private Vector codesVec;

    JavaPClassPrinter(BinaryClass binaryClass, JavaPEnvironment javaPEnvironment) {
        this.cdef = binaryClass;
        this.env = javaPEnvironment;
        this.output = javaPEnvironment.output;
    }

    JavaPBinaryCode codeFor(FieldDefinition fieldDefinition) {
        byte[] byArray = ((BinaryField)fieldDefinition).getAttribute(Constants.idCode);
        if (byArray != null) {
            BinaryConstantPool binaryConstantPool = this.cdef.getConstants();
            return new JavaPBinaryCode(byArray, binaryConstantPool, this.env, fieldDefinition);
        }
        return null;
    }

    public void printClassHeader() {
        ClassDeclaration[] classDeclarationArray;
        String string = Modifier.toString(this.cdef.getModifiers());
        if (string.length() > 0) {
            this.output.print(String.valueOf(string) + " ");
        }
        if (this.cdef.isInterface()) {
            this.output.print("interface ");
        } else {
            this.output.print("class ");
        }
        this.output.print(String.valueOf(this.cdef.getName()) + " ");
        if (this.cdef.getSuperClass() != null) {
            this.output.print("extends " + this.cdef.getSuperClass().getName() + " ");
        }
        if ((classDeclarationArray = this.cdef.getInterfaces()).length > 0) {
            this.output.print("implements ");
            int n = 0;
            while (n < classDeclarationArray.length) {
                if (n > 0) {
                    this.output.print(", ");
                }
                this.output.print(classDeclarationArray[n].getName());
                this.output.print(" ");
                ++n;
            }
        }
        if ((this.cdef.getModifiers() & 0x20) != 0) {
            this.output.println();
            this.output.println("    /* ACC_SUPER bit set */");
        }
    }

    public void printFieldDefinition(FieldDefinition fieldDefinition) {
        String string = Modifier.toString(fieldDefinition.getModifiers());
        if (string.length() > 0) {
            this.output.print(String.valueOf(string) + " ");
        }
        this.output.println(String.valueOf(fieldDefinition.toString()) + ";");
    }

    public void printFields() throws IOException {
        FieldDefinition fieldDefinition = this.cdef.getFirstField();
        while (fieldDefinition != null) {
            if (this.env.showAccess.checkField(fieldDefinition)) {
                Constants constants;
                this.output.print("    ");
                if (fieldDefinition.isInnerClass()) {
                    constants = (BinaryClass)fieldDefinition.getInnerClass();
                    JavaPClassPrinter javaPClassPrinter = new JavaPClassPrinter((BinaryClass)constants, this.env);
                    javaPClassPrinter.print();
                } else {
                    this.printFieldDefinition(fieldDefinition);
                    if (this.env.showInternalSigs) {
                        this.output.println("\t/*   " + fieldDefinition.getType().getTypeSignature() + "   */");
                    }
                    if (this.env.showVerbose && (constants = this.codeFor(fieldDefinition)) != null) {
                        ((JavaPBinaryCode)constants).printVerboseHeader();
                    }
                }
            }
            fieldDefinition = fieldDefinition.getNextField();
        }
    }

    public void print() throws IOException {
        Object object = this.cdef.getSource();
        if (object == null) {
            this.output.print("No source");
        } else {
            this.output.print("Compiled from ");
            this.output.println((String)object);
        }
        this.printClassHeader();
        this.output.println("{");
        this.printFields();
        if (this.env.showBackwardCompatible) {
            JavaPBinaryCode javaPBinaryCode;
            Codes codes;
            if (this.env.showDisassembled) {
                codes = new Codes();
                while ((javaPBinaryCode = codes.next()) != null) {
                    javaPBinaryCode.printCodeSequence();
                    javaPBinaryCode.printExceptionTable();
                }
            }
            if (this.env.showLineAndLocal) {
                this.output.println();
                codes = new Codes();
                while ((javaPBinaryCode = codes.next()) != null) {
                    javaPBinaryCode.printLineNumberTable();
                }
                this.output.println();
                Codes codes2 = new Codes();
                while ((javaPBinaryCode = codes2.next()) != null) {
                    javaPBinaryCode.printLocalVariableTable();
                }
            }
            this.output.println();
            this.output.println("}");
            return;
        }
        this.output.println("}");
        if (this.env.showDisassembled || this.env.showLineAndLocal) {
            JavaPBinaryCode javaPBinaryCode;
            Codes codes = new Codes();
            while ((javaPBinaryCode = codes.next()) != null) {
                if (this.env.showDisassembled) {
                    javaPBinaryCode.printCodeSequence();
                    javaPBinaryCode.printExceptionTable();
                }
                if (!this.env.showLineAndLocal) continue;
                javaPBinaryCode.printLineNumberTable();
                javaPBinaryCode.printLocalVariableTable();
            }
        }
    }

    private class Codes {
        private int index;

        Codes() {
            JavaPClassPrinter.this = JavaPClassPrinter.this;
            if (JavaPClassPrinter.this.codesVec == null) {
                JavaPClassPrinter.this.codesVec = new Vector();
                FieldDefinition fieldDefinition = JavaPClassPrinter.this.cdef.getFirstField();
                while (fieldDefinition != null) {
                    JavaPBinaryCode javaPBinaryCode = JavaPClassPrinter.this.codeFor(fieldDefinition);
                    if (javaPBinaryCode != null) {
                        JavaPClassPrinter.this.codesVec.addElement(javaPBinaryCode);
                    }
                    fieldDefinition = fieldDefinition.getNextField();
                }
            }
            this.index = 0;
        }

        JavaPBinaryCode next() {
            if (this.index < JavaPClassPrinter.this.codesVec.size()) {
                return (JavaPBinaryCode)JavaPClassPrinter.this.codesVec.elementAt(this.index++);
            }
            return null;
        }
    }
}

