/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.serialver;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.text.MessageFormat;
import java.util.Properties;
import sun.tools.serialver.SerialVerFrame;

public class SerialVer
extends Applet {
    GridBagLayout gb;
    TextField classname_t;
    Button show_b;
    TextField serialversion_t;
    Label footer_l;

    public synchronized void init() {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("rmi.home");
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        SerialVer.pushPropFile(string2, "serialver.properties");
        this.gb = new GridBagLayout();
        this.setLayout(this.gb);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        Label label = new Label(SerialVer.I18N("FullClassName"));
        label.setAlignment(2);
        this.gb.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.classname_t = new TextField(20);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        this.gb.setConstraints(this.classname_t, gridBagConstraints);
        this.add(this.classname_t);
        this.show_b = new Button(SerialVer.I18N("Show"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this.gb.setConstraints(this.show_b, gridBagConstraints);
        this.add(this.show_b);
        Label label2 = new Label(SerialVer.I18N("SerialVersion"));
        label2.setAlignment(2);
        gridBagConstraints.gridwidth = 1;
        this.gb.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        this.serialversion_t = new TextField(50);
        this.serialversion_t.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        this.gb.setConstraints(this.serialversion_t, gridBagConstraints);
        this.add(this.serialversion_t);
        this.footer_l = new Label();
        gridBagConstraints.gridwidth = 0;
        this.gb.setConstraints(this.footer_l, gridBagConstraints);
        this.add(this.footer_l);
        this.classname_t.requestFocus();
    }

    public void start() {
        this.classname_t.requestFocus();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.classname_t) {
            this.show((String)event.arg);
            return true;
        }
        if (event.target == this.show_b) {
            this.show(this.classname_t.getText());
            return true;
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        boolean bl = super.handleEvent(event);
        return bl;
    }

    void show(String string) {
        try {
            this.footer_l.setText("");
            ((TextComponent)this.serialversion_t).setText("");
            if (string.equals("")) {
                return;
            }
            String string2 = SerialVer.serialSyntax(string);
            if (string2 != null) {
                ((TextComponent)this.serialversion_t).setText(string2);
                return;
            }
            this.footer_l.setText(SerialVer.I18N("NotSerializable", string));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.footer_l.setText(SerialVer.I18N("ClassNotFound", string));
            return;
        }
    }

    static String serialSyntax(String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return "    static final long serialVersionUID = " + objectStreamClass.getSerialVersionUID() + "L;";
        }
        return null;
    }

    public static String I18N(String string) {
        return System.getProperty(string, "<" + string + ">");
    }

    public static String I18N(String string, String string2) {
        return SerialVer.I18N(string, string2, null);
    }

    public static String I18N(String string, String string2, String string3) {
        String string4 = System.getProperty(string);
        if (string4 == null) {
            return "Message '" + string + "' not found";
        }
        Object[] objectArray = new Object[]{string2, string3};
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null & !(objectArray[n] instanceof String)) {
                objectArray[n] = objectArray[n].toString();
            }
            ++n;
        }
        return MessageFormat.format(string4, objectArray);
    }

    static void pushPropFile(String string, String string2) {
        String string3 = String.valueOf(string) + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + string2;
        try {
            Properties properties = new Properties(System.getProperties());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
            System.setProperties(properties);
            return;
        }
        catch (IOException iOException) {
            System.err.println("failed to read properties file: " + string3);
            return;
        }
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("rmi.home");
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        SerialVer.pushPropFile(string2, "serialver.properties");
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-show")) {
                bl = true;
            } else {
                if (!stringArray[n].startsWith("-")) break;
                System.err.println(SerialVer.I18N("invalid.flag", stringArray[n]));
                SerialVer.usage();
                System.exit(1);
            }
            ++n;
        }
        if (!bl) {
            if (n == stringArray.length) {
                SerialVer.usage();
                System.exit(0);
            }
            while (n < stringArray.length) {
                try {
                    String string3 = SerialVer.serialSyntax(stringArray[n]);
                    if (string3 != null) {
                        System.out.println(String.valueOf(stringArray[n]) + ":" + string3);
                    } else {
                        System.err.println(SerialVer.I18N("NotSerializable", stringArray[n]));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(SerialVer.I18N("ClassNotFound", stringArray[n]));
                }
                ++n;
            }
            return;
        }
        if (n < stringArray.length) {
            System.err.println(SerialVer.I18N("ignoring.classes"));
            System.exit(1);
        }
        SerialVerFrame serialVerFrame = new SerialVerFrame();
        SerialVer serialVer = new SerialVer();
        serialVer.init();
        serialVerFrame.add("Center", serialVer);
        serialVerFrame.pack();
        serialVerFrame.show();
    }

    public static void usage() {
        System.err.println(SerialVer.I18N("usage"));
    }
}

