/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import sun.tools.java.AmbiguousField;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.tree.CheckContext;
import sun.tools.tree.ContextEnvironment;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.InlineMethodExpression;
import sun.tools.tree.InlineNewInstanceExpression;
import sun.tools.tree.LocalField;
import sun.tools.tree.Node;
import sun.tools.tree.Statement;
import sun.tools.tree.ThisExpression;
import sun.tools.tree.UplevelReference;
import sun.tools.tree.Vset;

public class Context
implements Constants {
    Context prev;
    Node node;
    int varNumber;
    LocalField locals;
    LocalField classes;
    FieldDefinition field;
    int scopeNumber;
    int frameNumber;

    public Context(Context context, FieldDefinition fieldDefinition) {
        this.field = fieldDefinition;
        if (context == null) {
            this.frameNumber = 1;
            this.scopeNumber = 2;
            this.varNumber = 0;
            return;
        }
        this.prev = context;
        this.locals = context.locals;
        this.classes = context.classes;
        if (fieldDefinition != null && (fieldDefinition.isVariable() || fieldDefinition.isInitializer())) {
            this.frameNumber = context.frameNumber;
            this.scopeNumber = context.scopeNumber + 1;
        } else {
            this.frameNumber = context.scopeNumber + 1;
            this.scopeNumber = this.frameNumber + 1;
        }
        this.varNumber = context.varNumber;
    }

    public Context(Context context, ClassDefinition classDefinition) {
        this(context, (FieldDefinition)null);
    }

    Context(Context context, Node node) {
        if (context == null) {
            this.frameNumber = 1;
            this.scopeNumber = 2;
            this.varNumber = 0;
            return;
        }
        this.prev = context;
        this.locals = context.locals;
        this.varNumber = context.varNumber;
        this.field = context.field;
        this.frameNumber = context.frameNumber;
        this.scopeNumber = context.scopeNumber + 1;
        this.node = node;
    }

    public Context(Context context) {
        this(context, (Node)null);
    }

    public int declare(Environment environment, LocalField localField) {
        localField.scopeNumber = this.scopeNumber;
        if (this.field == null && Constants.idThis.equals(localField.getName())) {
            ++localField.scopeNumber;
        }
        if (localField.isInnerClass()) {
            localField.prev = this.classes;
            this.classes = localField;
            return 0;
        }
        localField.subModifiers(0x100000);
        localField.prev = this.locals;
        this.locals = localField;
        localField.number = this.varNumber;
        this.varNumber += localField.getType().stackSize();
        return localField.number;
    }

    public LocalField getLocalField(Identifier identifier) {
        LocalField localField = this.locals;
        while (localField != null) {
            if (identifier.equals(localField.getName())) {
                return localField;
            }
            localField = localField.prev;
        }
        return null;
    }

    public int getScopeNumber(ClassDefinition classDefinition) {
        Context context = this;
        while (context != null) {
            if (context.field != null && context.field.getClassDefinition() == classDefinition) {
                return context.frameNumber;
            }
            context = context.prev;
        }
        return -1;
    }

    private FieldDefinition getFieldCommon(Environment environment, Identifier identifier, boolean bl) throws AmbiguousField, ClassNotFound {
        LocalField localField = this.getLocalField(identifier);
        int n = localField == null ? -2 : localField.scopeNumber;
        ClassDefinition classDefinition = this.field.getClassDefinition();
        while (classDefinition != null) {
            FieldDefinition fieldDefinition = classDefinition.getVariable(environment, identifier);
            if (!(fieldDefinition == null || this.getScopeNumber(classDefinition) <= n || bl && fieldDefinition.getClassDefinition() != classDefinition)) {
                return fieldDefinition;
            }
            classDefinition = classDefinition.getOuterClass();
        }
        return localField;
    }

    public int declareMemberNumber(FieldDefinition fieldDefinition) {
        return this.declare(null, new LocalField(fieldDefinition));
    }

    public int getMemberNumber(FieldDefinition fieldDefinition) {
        LocalField localField = this.locals;
        while (localField != null) {
            if (localField.getMember() == fieldDefinition) {
                return localField.number;
            }
            localField = localField.prev;
        }
        return -1;
    }

    public FieldDefinition getElement(int n) {
        LocalField localField = this.locals;
        while (localField != null) {
            if (localField.number == n) {
                FieldDefinition fieldDefinition = localField.getMember();
                if (fieldDefinition != null) {
                    return fieldDefinition;
                }
                return localField;
            }
            localField = localField.prev;
        }
        return null;
    }

    public LocalField getLocalClass(Identifier identifier) {
        LocalField localField = this.classes;
        while (localField != null) {
            if (identifier.equals(localField.getName())) {
                return localField;
            }
            localField = localField.prev;
        }
        return null;
    }

    private FieldDefinition getClassCommon(Environment environment, Identifier identifier, boolean bl) throws ClassNotFound {
        LocalField localField = this.getLocalClass(identifier);
        int n = localField == null ? -2 : localField.scopeNumber;
        ClassDefinition classDefinition = this.field.getClassDefinition();
        while (classDefinition != null) {
            FieldDefinition fieldDefinition = classDefinition.getInnerClass(environment, identifier);
            if (!(fieldDefinition == null || this.getScopeNumber(classDefinition) <= n || bl && fieldDefinition.getClassDefinition() != classDefinition)) {
                return fieldDefinition;
            }
            classDefinition = classDefinition.getOuterClass();
        }
        return localField;
    }

    public final FieldDefinition getField(Environment environment, Identifier identifier) throws AmbiguousField, ClassNotFound {
        return this.getFieldCommon(environment, identifier, false);
    }

    public final FieldDefinition getApparentField(Environment environment, Identifier identifier) throws AmbiguousField, ClassNotFound {
        return this.getFieldCommon(environment, identifier, true);
    }

    public boolean isInScope(LocalField localField) {
        LocalField localField2 = this.locals;
        while (localField2 != null) {
            if (localField == localField2) {
                return true;
            }
            localField2 = localField2.prev;
        }
        return false;
    }

    public UplevelReference noteReference(Environment environment, LocalField localField) {
        int n = !this.isInScope(localField) ? -1 : localField.scopeNumber;
        UplevelReference uplevelReference = null;
        int n2 = -1;
        Context context = this;
        while (context != null) {
            if (n2 != context.frameNumber) {
                n2 = context.frameNumber;
                if (n >= n2) break;
                ClassDefinition classDefinition = context.field.getClassDefinition();
                UplevelReference uplevelReference2 = classDefinition.getReference(localField);
                uplevelReference2.noteReference(environment, context);
                if (uplevelReference == null) {
                    uplevelReference = uplevelReference2;
                }
            }
            context = context.prev;
        }
        return uplevelReference;
    }

    public Expression makeReference(Environment environment, LocalField localField) {
        UplevelReference uplevelReference = this.noteReference(environment, localField);
        if (uplevelReference != null) {
            return uplevelReference.makeLocalReference(environment, this);
        }
        if (Constants.idThis.equals(localField.getName())) {
            return new ThisExpression(0, localField);
        }
        return new IdentifierExpression(0, localField);
    }

    public Expression findOuterLink(Environment environment, int n, FieldDefinition fieldDefinition) {
        ClassDefinition classDefinition;
        ClassDefinition classDefinition2 = fieldDefinition.getClassDefinition();
        ClassDefinition classDefinition3 = fieldDefinition.isStatic() ? null : (!fieldDefinition.isConstructor() ? classDefinition2 : (classDefinition = classDefinition2.isTopLevel() ? null : classDefinition2.getOuterClass()));
        if (classDefinition == null) {
            return null;
        }
        return this.findOuterLink(environment, n, classDefinition, fieldDefinition);
    }

    private static boolean match(Environment environment, ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        try {
            return classDefinition == classDefinition2 || classDefinition2.implementedBy(environment, classDefinition.getClassDeclaration());
        }
        catch (ClassNotFound classNotFound) {
            return false;
        }
    }

    public Expression findOuterLink(Environment environment, int n, ClassDefinition classDefinition, FieldDefinition fieldDefinition) {
        Constants constants;
        if (this.field.isStatic()) {
            Constants constants2;
            if (fieldDefinition == null) {
                constants2 = classDefinition.getName().getFlatName().getName();
                environment.error(n, "undef.var", Identifier.lookup(constants2, Constants.idThis));
            } else if (fieldDefinition.isConstructor()) {
                environment.error(n, "no.outer.arg", classDefinition, fieldDefinition.getClassDeclaration());
            } else if (fieldDefinition.isMethod()) {
                environment.error(n, "no.static.meth.access", fieldDefinition, fieldDefinition.getClassDeclaration());
            } else {
                environment.error(n, "no.static.field.access", fieldDefinition.getName(), fieldDefinition.getClassDeclaration());
            }
            constants2 = new ThisExpression(n, this);
            ((Expression)constants2).type = classDefinition.getType();
            return constants2;
        }
        if (!environment.innerClasses()) {
            return new ThisExpression(n, this);
        }
        LocalField localField = this.locals;
        Expression expression = null;
        LocalField localField2 = null;
        ClassDefinition classDefinition2 = null;
        ClassDefinition classDefinition3 = null;
        if (this.field.isConstructor()) {
            classDefinition3 = this.field.getClassDefinition();
        }
        if (!this.field.isMethod()) {
            classDefinition2 = this.field.getClassDefinition();
            expression = new ThisExpression(n, this);
        }
        while (true) {
            if (expression == null) {
                while (localField != null && !Constants.idThis.equals(localField.getName())) {
                    localField = localField.prev;
                }
                if (localField == null) break;
                expression = new ThisExpression(n, localField);
                classDefinition2 = localField.getClassDefinition();
                localField2 = localField;
                localField = localField.prev;
            }
            if (Context.match(environment, classDefinition2, classDefinition)) break;
            constants = classDefinition2.findOuterField();
            if (constants == null) {
                expression = null;
                continue;
            }
            ClassDefinition classDefinition4 = classDefinition2;
            classDefinition2 = classDefinition4.getOuterClass();
            if (classDefinition4 == classDefinition3) {
                Identifier identifier = ((FieldDefinition)constants).getName();
                IdentifierExpression identifierExpression = new IdentifierExpression(n, identifier);
                identifierExpression.bind(environment, this);
                expression = identifierExpression;
                continue;
            }
            expression = new FieldExpression(n, expression, (FieldDefinition)constants);
        }
        if (expression != null) {
            return expression;
        }
        if (fieldDefinition == null) {
            constants = classDefinition.getName().getFlatName().getName();
            environment.error(n, "undef.var", Identifier.lookup((Identifier)constants, Constants.idThis));
        } else if (fieldDefinition.isConstructor()) {
            environment.error(n, "no.outer.arg", classDefinition, fieldDefinition.getClassDefinition());
        } else {
            environment.error(n, "no.static.field.access", fieldDefinition, this.field);
        }
        constants = new ThisExpression(n, this);
        ((Expression)constants).type = classDefinition.getType();
        return constants;
    }

    public static boolean outerLinkExists(Environment environment, ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        while (!Context.match(environment, classDefinition2, classDefinition)) {
            if (classDefinition2.isTopLevel()) {
                return false;
            }
            classDefinition2 = classDefinition2.getOuterClass();
        }
        return true;
    }

    public ClassDefinition findScope(Environment environment, ClassDefinition classDefinition) {
        ClassDefinition classDefinition2 = this.field.getClassDefinition();
        while (classDefinition2 != null && !Context.match(environment, classDefinition2, classDefinition)) {
            classDefinition2 = classDefinition2.getOuterClass();
        }
        return classDefinition2;
    }

    Identifier resolveName(Environment environment, Identifier identifier) {
        block7: {
            if (!environment.innerClasses()) break block7;
            if (identifier.isQualified()) {
                Identifier identifier2 = this.resolveName(environment, identifier.getHead());
                if (!environment.classExists(identifier2)) {
                    return environment.resolvePackageQualifiedName(identifier);
                }
                try {
                    return environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
                }
                catch (ClassNotFound classNotFound) {
                    return Identifier.lookupInner(identifier2, identifier.getTail());
                }
            }
            try {
                FieldDefinition fieldDefinition = this.getClassCommon(environment, identifier, false);
                if (fieldDefinition != null) {
                    return fieldDefinition.getInnerClass().getName();
                }
            }
            catch (ClassNotFound classNotFound) {}
        }
        return environment.resolveName(identifier);
    }

    public Identifier getApparentClassName(Environment environment, Identifier identifier) {
        Constants constants;
        if (environment.innerClasses()) {
            if (identifier.isQualified()) {
                Identifier identifier2 = this.getApparentClassName(environment, identifier.getHead());
                if (identifier2 == null) {
                    return Constants.idNull;
                }
                return Identifier.lookup(identifier2, identifier.getTail());
            }
            try {
                constants = this.getClassCommon(environment, identifier, true);
                if (constants != null) {
                    return ((FieldDefinition)constants).getInnerClass().getName();
                }
            }
            catch (ClassNotFound classNotFound) {}
        }
        if (((Identifier)(constants = this.field.getClassDefinition().getTopClass().getName())).getName().equals(identifier)) {
            return constants;
        }
        return Constants.idNull;
    }

    public void checkBackBranch(Environment environment, Statement statement, Vset vset, Vset vset2) {
        LocalField localField = this.locals;
        while (localField != null) {
            if (localField.isBlankFinal() && vset.testVarUnassigned(localField.number) && !vset2.testVarUnassigned(localField.number)) {
                environment.error(statement.where, "assign.to.blank.final.in.loop", localField.getName());
            }
            localField = localField.prev;
        }
    }

    public boolean canReach(Environment environment, FieldDefinition fieldDefinition) {
        return this.field.canReach(environment, fieldDefinition);
    }

    public Context getLabelContext(Identifier identifier) {
        Context context = this;
        while (context != null) {
            if (context.node != null && context.node instanceof Statement && ((Statement)context.node).hasLabel(identifier)) {
                return context;
            }
            context = context.prev;
        }
        return null;
    }

    public Context getBreakContext(Identifier identifier) {
        if (identifier != null) {
            return this.getLabelContext(identifier);
        }
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public Context getContinueContext(Identifier identifier) {
        if (identifier != null) {
            return this.getLabelContext(identifier);
        }
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 92: 
                    case 93: 
                    case 94: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public CheckContext getReturnContext() {
        Context context = this;
        while (context != null) {
            if (context.node != null && context.node.op == 47) {
                return (CheckContext)context;
            }
            context = context.prev;
        }
        return null;
    }

    Context getInlineContext() {
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 150: 
                    case 151: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    Context getInlineFieldContext(FieldDefinition fieldDefinition) {
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 150: {
                        if (!((InlineMethodExpression)context.node).field.equals(fieldDefinition)) break;
                        return context;
                    }
                    case 151: {
                        if (!((InlineNewInstanceExpression)context.node).field.equals(fieldDefinition)) break;
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public final Vset removeAdditionalVars(Vset vset) {
        return vset.removeAdditionalVars(this.varNumber);
    }

    public final int getVarNumber() {
        return this.varNumber;
    }

    public int getThisNumber() {
        LocalField localField = this.getLocalField(Constants.idThis);
        if (localField != null && localField.getClassDefinition() == this.field.getClassDefinition()) {
            return localField.number;
        }
        return this.varNumber;
    }

    public final FieldDefinition getField() {
        return this.field;
    }

    public static Environment newEnvironment(Environment environment, Context context) {
        return new ContextEnvironment(environment, context);
    }
}

