/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.AmbiguousField;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Type;
import sun.tools.tree.AssignExpression;
import sun.tools.tree.CatchStatement;
import sun.tools.tree.CommaExpression;
import sun.tools.tree.ConditionalExpression;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldUpdater;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.LengthExpression;
import sun.tools.tree.MethodExpression;
import sun.tools.tree.NewInstanceExpression;
import sun.tools.tree.NotEqualExpression;
import sun.tools.tree.NullExpression;
import sun.tools.tree.ReturnStatement;
import sun.tools.tree.Statement;
import sun.tools.tree.StringExpression;
import sun.tools.tree.SuperExpression;
import sun.tools.tree.ThisExpression;
import sun.tools.tree.ThrowStatement;
import sun.tools.tree.TryStatement;
import sun.tools.tree.TypeExpression;
import sun.tools.tree.UnaryExpression;
import sun.tools.tree.Vset;

public class FieldExpression
extends UnaryExpression {
    Identifier id;
    FieldDefinition field;
    Expression implementation;

    public FieldExpression(int n, Expression expression, Identifier identifier) {
        super(46, n, Type.tError, expression);
        this.id = identifier;
    }

    public FieldExpression(int n, Expression expression, FieldDefinition fieldDefinition) {
        super(46, n, fieldDefinition.getType(), expression);
        this.id = fieldDefinition.getName();
        this.field = fieldDefinition;
    }

    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    public static Identifier toIdentifier(Expression expression) {
        StringBuffer stringBuffer = new StringBuffer();
        while (expression.op == 46) {
            FieldExpression fieldExpression = (FieldExpression)expression;
            if (fieldExpression.id == Constants.idThis || fieldExpression.id == Constants.idClass) {
                return null;
            }
            stringBuffer.insert(0, fieldExpression.id);
            stringBuffer.insert(0, '.');
            expression = fieldExpression.right;
        }
        if (expression.op != 60) {
            return null;
        }
        stringBuffer.insert(0, ((IdentifierExpression)expression).id);
        return Identifier.lookup(stringBuffer.toString());
    }

    Type toType(Environment environment, Context context) {
        Identifier identifier = FieldExpression.toIdentifier(this);
        if (identifier == null) {
            environment.error(this.where, "invalid.type.expr");
            return Type.tError;
        }
        Type type = Type.tClass(context.resolveName(environment, identifier));
        if (environment.resolve(this.where, context.field.getClassDefinition(), type)) {
            return type;
        }
        return Type.tError;
    }

    public Vset checkAmbigName(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression) {
        if (this.id == Constants.idThis || this.id == Constants.idClass) {
            unaryExpression = null;
        }
        return this.checkCommon(environment, context, vset, hashtable, unaryExpression, false);
    }

    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        return this.checkCommon(environment, context, vset, hashtable, null, false);
    }

    static void reportFailedPackagePrefix(Environment environment, Expression expression) {
        Expression expression2 = expression;
        while (expression2 instanceof UnaryExpression) {
            expression2 = ((UnaryExpression)expression2).right;
        }
        IdentifierExpression identifierExpression = (IdentifierExpression)expression2;
        if (expression2 == expression) {
            environment.error(identifierExpression.where, "undef.var.or.class", identifierExpression.id);
            return;
        }
        if (environment.innerClasses()) {
            environment.error(identifierExpression.where, "undef.var.class.or.package", identifierExpression.id);
            return;
        }
        environment.error(identifierExpression.where, "undef.var.or.package", identifierExpression.id);
    }

    private Expression implementFieldAccess(Environment environment, Context context, Expression expression, boolean bl) {
        ClassDefinition classDefinition;
        ClassDefinition classDefinition2;
        if (this.field.isPrivate() && (classDefinition2 = this.field.getClassDefinition()) != (classDefinition = context.field.getClassDefinition())) {
            FieldDefinition fieldDefinition = classDefinition2.getAccessField(environment, context, this.field);
            if (fieldDefinition != null) {
                if (!bl) {
                    if (this.field.isStatic()) {
                        Expression[] expressionArray = new Expression[]{};
                        MethodExpression methodExpression = new MethodExpression(this.where, null, fieldDefinition, expressionArray);
                        return new CommaExpression(this.where, expression, methodExpression);
                    }
                    Expression[] expressionArray = new Expression[]{expression};
                    return new MethodExpression(this.where, null, fieldDefinition, expressionArray);
                }
            } else {
                environment.error(this.where, "uplevel.private", this.id, classDefinition2);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vset checkCommon(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression, boolean bl) {
        if (this.field != null) {
            this.implementation = this.implementFieldAccess(environment, context, this.right, bl);
            if (this.right != null) return this.right.checkAmbigName(environment, context, vset, hashtable, this);
            return vset;
        }
        vset = this.right.checkAmbigName(environment, context, vset, hashtable, this);
        if (this.right.type == Type.tPackage) {
            if (unaryExpression == null) {
                FieldExpression.reportFailedPackagePrefix(environment, this.right);
                return vset;
            }
            Identifier identifier = FieldExpression.toIdentifier(this);
            if (identifier != null && environment.classExists(identifier)) {
                unaryExpression.right = new TypeExpression(this.where, Type.tClass(identifier));
                environment.resolve(this.where, context.field.getClassDefinition(), unaryExpression.right.type);
                return vset;
            }
            this.type = Type.tPackage;
            return vset;
        }
        try {
            ClassDefinition classDefinition;
            block38: {
                boolean bl2 = this.right instanceof TypeExpression;
                if (this.id == Constants.idClass) {
                    Type type;
                    if (!bl2) {
                        environment.error(this.right.where, "invalid.type.expr");
                    }
                    if (!(type = this.right.type).isType(10) && !type.isType(9)) {
                        if (type.isType(13)) {
                            this.type = Type.tClassDesc;
                            return vset;
                        }
                        String string = null;
                        switch (type.getTypeCode()) {
                            case 11: {
                                string = "Void";
                                break;
                            }
                            case 0: {
                                string = "Boolean";
                                break;
                            }
                            case 1: {
                                string = "Byte";
                                break;
                            }
                            case 2: {
                                string = "Character";
                                break;
                            }
                            case 3: {
                                string = "Short";
                                break;
                            }
                            case 4: {
                                string = "Integer";
                                break;
                            }
                            case 6: {
                                string = "Float";
                                break;
                            }
                            case 5: {
                                string = "Long";
                                break;
                            }
                            case 7: {
                                string = "Double";
                                break;
                            }
                            default: {
                                environment.error(this.right.where, "invalid.type.expr");
                                return vset;
                            }
                        }
                        Identifier identifier = Identifier.lookup(String.valueOf(Constants.idJavaLang) + "." + string);
                        TypeExpression typeExpression = new TypeExpression(this.where, Type.tClass(identifier));
                        this.implementation = new FieldExpression(this.where, (Expression)typeExpression, Constants.idTYPE);
                        vset = this.implementation.checkValue(environment, context, vset, hashtable);
                        this.type = this.implementation.type;
                        return vset;
                    }
                    FieldDefinition fieldDefinition = FieldExpression.getClassLiteralLookup(environment, context);
                    if (fieldDefinition == null) {
                        this.type = Type.tClassDesc;
                        environment.error(this.where, "invalid.field.reference", this.id, type);
                        return vset;
                    }
                    String string = type.getTypeSignature();
                    String string2 = type.isType(10) ? string.substring(1, string.length() - 1).replace('/', '.') : string.replace('/', '.');
                    FieldDefinition fieldDefinition2 = FieldExpression.getClassLiteralCache(environment, context, string2);
                    this.implementation = this.makeClassLiteralCacheRef(environment, context, fieldDefinition, fieldDefinition2, string2);
                    vset = this.implementation.checkValue(environment, context, vset, hashtable);
                    this.type = this.implementation.type;
                    return vset;
                }
                if (!this.right.type.isType(10)) {
                    if (this.right.type.isType(9) && this.id.equals(Constants.idLength)) {
                        this.type = Type.tInt;
                        this.implementation = new LengthExpression(this.where, this.right);
                        return vset;
                    }
                    if (this.right.type.isType(13)) return vset;
                    environment.error(this.where, "invalid.field.reference", this.id, this.right.type);
                    return vset;
                }
                ClassDefinition classDefinition2 = environment.getClassDefinition(this.right.type);
                if (this.id == Constants.idThis) {
                    if (!bl2) {
                        environment.error(this.right.where, "invalid.type.expr");
                    }
                    this.implementation = context.findOuterLink(environment, this.where, classDefinition2, null);
                    vset = this.implementation.checkValue(environment, context, vset, hashtable);
                    this.type = classDefinition2.getType();
                    return vset;
                }
                this.field = classDefinition2.getVariable(environment, this.id);
                if (this.field == null && environment.innerClasses() && bl2 && unaryExpression != null) {
                    this.field = classDefinition2.getInnerClass(environment, this.id);
                    if (this.field != null) {
                        return this.checkInnerClass(environment, context, vset, hashtable, unaryExpression);
                    }
                }
                if (this.field == null) {
                    this.field = classDefinition2.findAnyMethod(environment, this.id);
                    if (this.field != null) {
                        environment.error(this.where, "invalid.field", this.id, this.field.getClassDeclaration());
                        return vset;
                    }
                    environment.error(this.where, "no.such.field", this.id, classDefinition2);
                    return vset;
                }
                classDefinition = context.field.getClassDefinition();
                this.type = this.field.getType();
                if (!classDefinition.canAccess(environment, this.field)) {
                    environment.error(this.where, "no.field.access", this.id, classDefinition2, context.field.getClassDeclaration());
                    return vset;
                }
                if (bl2 && !this.field.isStatic()) {
                    ClassDefinition classDefinition3 = this.field.getClassDefinition();
                    if (classDefinition3.implementedBy(environment, context.field.getClassDeclaration()) && !context.field.isStatic()) {
                        ThisExpression thisExpression = new ThisExpression(this.right.where);
                        vset = ((Expression)thisExpression).checkValue(environment, context, vset, hashtable);
                        FieldExpression fieldExpression = new FieldExpression(this.where, (Expression)thisExpression, this.field);
                        Expression expression = this.implementFieldAccess(environment, context, fieldExpression, bl);
                        this.implementation = expression == null ? fieldExpression : expression;
                        this.implementation.type = this.type;
                        bl2 = false;
                        break block38;
                    } else {
                        environment.error(this.where, "no.static.field.access", this.id, classDefinition2);
                        return vset;
                    }
                }
                this.implementation = this.implementFieldAccess(environment, context, this.right, bl);
            }
            if (this.field.isProtected() && !(this.right instanceof SuperExpression) && !classDefinition.protectedAccess(environment, this.field, this.right.type)) {
                environment.error(this.where, "invalid.protected.field.use", this.field.getName(), this.field.getClassDeclaration(), this.right.type);
                return vset;
            }
            if (!this.field.isStatic() && this.right.op == 82 && !vset.testVar(context.getThisNumber())) {
                environment.error(this.where, "access.inst.before.super", this.id);
            }
            if (this.field.reportDeprecated(environment)) {
                environment.error(this.where, "warn.field.is.deprecated", this.id, this.field.getClassDefinition());
            }
            context.field.getClassDefinition().addDependency(this.field.getClassDeclaration());
            return vset;
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, context.field);
            return vset;
        }
        catch (AmbiguousField ambiguousField) {
            environment.error(this.where, "ambig.field", this.id, ambiguousField.field1.getClassDeclaration(), ambiguousField.field2.getClassDeclaration());
        }
        return vset;
    }

    public Expression implementAssignment(Environment environment, Context context, Expression expression) {
        if (this.field == null) {
            throw new CompilerError("implementAssignment");
        }
        if (this.field.isPrivate()) {
            FieldDefinition fieldDefinition;
            ClassDefinition classDefinition = context.field.getClassDefinition();
            ClassDefinition classDefinition2 = this.field.getClassDefinition();
            if (classDefinition2 != classDefinition && (fieldDefinition = classDefinition2.getUpdateField(environment, context, this.field)) != null) {
                if (this.field.isStatic()) {
                    Expression[] expressionArray = new Expression[]{expression};
                    MethodExpression methodExpression = new MethodExpression(this.where, null, fieldDefinition, expressionArray);
                    return new CommaExpression(this.where, this.right, methodExpression);
                }
                Expression[] expressionArray = new Expression[]{this.right, expression};
                return new MethodExpression(this.where, null, fieldDefinition, expressionArray);
            }
        }
        return null;
    }

    public FieldUpdater getUpdater(Environment environment, Context context) {
        if (this.field == null) {
            throw new CompilerError("getUpdater");
        }
        if (this.field.isPrivate()) {
            ClassDefinition classDefinition = context.field.getClassDefinition();
            ClassDefinition classDefinition2 = this.field.getClassDefinition();
            if (classDefinition2 != classDefinition) {
                FieldDefinition fieldDefinition = classDefinition2.getAccessField(environment, context, this.field);
                FieldDefinition fieldDefinition2 = classDefinition2.getUpdateField(environment, context, this.field);
                if (fieldDefinition != null && fieldDefinition2 != null) {
                    Expression expression = this.right == null ? null : this.right.copyInline(context);
                    return new FieldUpdater(this.where, this.field, expression, fieldDefinition, fieldDefinition2);
                }
            }
        }
        return null;
    }

    private Vset checkInnerClass(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression) {
        ClassDefinition classDefinition = this.field.getInnerClass();
        this.type = classDefinition.getType();
        if (!classDefinition.isTopLevel()) {
            environment.error(this.where, "inner.static.ref", classDefinition.getName());
        }
        TypeExpression typeExpression = new TypeExpression(this.where, this.type);
        ClassDefinition classDefinition2 = context.field.getClassDefinition();
        try {
            if (!classDefinition2.canAccess(environment, this.field)) {
                ClassDefinition classDefinition3 = environment.getClassDefinition(this.right.type);
                environment.error(this.where, "no.type.access", this.id, classDefinition3, context.field.getClassDeclaration());
                return vset;
            }
            if (this.field.isProtected() && !(this.right instanceof SuperExpression) && !classDefinition2.protectedAccess(environment, this.field, this.right.type)) {
                environment.error(this.where, "invalid.protected.field.use", this.field.getName(), this.field.getClassDeclaration(), this.right.type);
                return vset;
            }
            classDefinition.noteUsedBy(classDefinition2, this.where, environment);
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, context.field);
        }
        context.field.getClassDefinition().addDependency(this.field.getClassDeclaration());
        if (unaryExpression == null) {
            return ((Expression)typeExpression).checkValue(environment, context, vset, hashtable);
        }
        unaryExpression.right = typeExpression;
        return vset;
    }

    public Vset checkLHS(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        boolean bl = this.field != null;
        this.checkCommon(environment, context, vset, hashtable, null, true);
        if (this.implementation != null) {
            return super.checkLHS(environment, context, vset, hashtable);
        }
        if (this.field != null && this.field.isFinal() && !bl) {
            if (this.right != null && this.right.op == 82 && !this.field.isStatic()) {
                vset = FieldExpression.checkFinalAssign(environment, context, vset, this.where, this.field);
            } else {
                environment.error(this.where, "assign.to.final", this.id);
            }
        }
        return vset;
    }

    public Vset checkAssignOp(Environment environment, Context context, Vset vset, Hashtable hashtable, Expression expression) {
        this.checkCommon(environment, context, vset, hashtable, null, true);
        if (this.implementation != null) {
            return super.checkLHS(environment, context, vset, hashtable);
        }
        if (this.field != null && this.field.isFinal()) {
            environment.error(this.where, "assign.to.final", this.id);
        }
        return vset;
    }

    public static Vset checkFinalAssign(Environment environment, Context context, Vset vset, int n, FieldDefinition fieldDefinition) {
        if (fieldDefinition.isBlankFinal() && fieldDefinition.getClassDefinition() == context.field.getClassDefinition()) {
            int n2 = context.getMemberNumber(fieldDefinition);
            if (n2 >= 0 && vset.testVarUnassigned(n2)) {
                vset = vset.addVar(n2);
            } else {
                Identifier identifier = fieldDefinition.getName();
                environment.error(n, "assign.to.blank.final", identifier);
            }
        } else {
            Identifier identifier = fieldDefinition.getName();
            environment.error(n, "assign.to.final", identifier);
        }
        return vset;
    }

    private static FieldDefinition getClassLiteralLookup(Environment environment, Context context) {
        FieldDefinition fieldDefinition;
        ClassDefinition classDefinition = context.field.getClassDefinition();
        while (classDefinition.isInnerClass()) {
            classDefinition = classDefinition.getOuterClass();
        }
        Identifier identifier = Identifier.lookup("class$");
        Type[] typeArray = new Type[]{Type.tString};
        try {
            fieldDefinition = classDefinition.matchMethod(environment, classDefinition, identifier, typeArray);
        }
        catch (ClassNotFound classNotFound) {
            return null;
        }
        catch (AmbiguousField ambiguousField) {
            return null;
        }
        if (fieldDefinition != null) {
            return fieldDefinition;
        }
        int n = classDefinition.getWhere();
        IdentifierToken identifierToken = new IdentifierToken(n, identifier);
        Expression expression = new IdentifierExpression(identifierToken);
        Expression[] expressionArray = new Expression[]{expression};
        Identifier identifier2 = Identifier.lookup("forName");
        expression = new MethodExpression(n, (Expression)new TypeExpression(n, Type.tClassDesc), identifier2, expressionArray);
        Statement statement = new ReturnStatement(n, expression);
        Identifier identifier3 = Identifier.lookup("java.lang.ClassNotFoundException");
        Identifier identifier4 = Identifier.lookup("java.lang.NoClassDefFoundError");
        Type type = Type.tClass(identifier3);
        Type type2 = Type.tClass(identifier4);
        Identifier identifier5 = Identifier.lookup("getMessage");
        expression = new IdentifierExpression(n, identifier2);
        expression = new MethodExpression(n, expression, identifier5, new Expression[0]);
        Expression[] expressionArray2 = new Expression[]{expression};
        expression = new NewInstanceExpression(n, new TypeExpression(n, type2), expressionArray2);
        CatchStatement catchStatement = new CatchStatement(n, (Expression)new TypeExpression(n, type), new IdentifierToken(identifier2), (Statement)new ThrowStatement(n, expression));
        Statement[] statementArray = new Statement[]{catchStatement};
        statement = new TryStatement(n, statement, statementArray);
        Type type3 = Type.tMethod(Type.tClassDesc, typeArray);
        IdentifierToken[] identifierTokenArray = new IdentifierToken[]{identifierToken};
        return environment.makeFieldDefinition(environment, n, classDefinition, null, 524296, type3, identifier, identifierTokenArray, null, statement);
    }

    private static FieldDefinition getClassLiteralCache(Environment environment, Context context, String string) {
        FieldDefinition fieldDefinition;
        String string2;
        if (!string.startsWith("[")) {
            string2 = "class$" + string.replace('.', '$');
        } else {
            string2 = "array$" + string.substring(1);
            string2 = string2.replace('[', '$');
            if (string.endsWith(";")) {
                string2 = string2.substring(0, string2.length() - 1);
                string2 = string2.replace('.', '$');
            }
        }
        Identifier identifier = Identifier.lookup(string2);
        ClassDefinition classDefinition = context.field.getClassDefinition();
        while (classDefinition.isInnerClass()) {
            classDefinition = classDefinition.getOuterClass();
        }
        try {
            fieldDefinition = classDefinition.getVariable(environment, identifier);
        }
        catch (ClassNotFound classNotFound) {
            return null;
        }
        catch (AmbiguousField ambiguousField) {
            return null;
        }
        if (fieldDefinition != null) {
            return fieldDefinition;
        }
        return environment.makeFieldDefinition(environment, classDefinition.getWhere(), classDefinition, null, 524296, Type.tClassDesc, identifier, null, null, null);
    }

    private Expression makeClassLiteralCacheRef(Environment environment, Context context, FieldDefinition fieldDefinition, FieldDefinition fieldDefinition2, String string) {
        TypeExpression typeExpression = new TypeExpression(this.where, fieldDefinition2.getClassDefinition().getType());
        FieldExpression fieldExpression = new FieldExpression(this.where, (Expression)typeExpression, fieldDefinition2);
        NotEqualExpression notEqualExpression = new NotEqualExpression(this.where, ((Expression)fieldExpression).copyInline(context), new NullExpression(this.where));
        TypeExpression typeExpression2 = new TypeExpression(this.where, fieldDefinition.getClassDefinition().getType());
        StringExpression stringExpression = new StringExpression(this.where, string);
        Expression[] expressionArray = new Expression[]{stringExpression};
        UnaryExpression unaryExpression = new MethodExpression(this.where, (Expression)typeExpression2, fieldDefinition, expressionArray);
        unaryExpression = new AssignExpression(this.where, ((Expression)fieldExpression).copyInline(context), unaryExpression);
        return new ConditionalExpression(this.where, notEqualExpression, fieldExpression, (Expression)unaryExpression);
    }

    public boolean isConstant() {
        if (this.implementation != null) {
            return this.implementation.isConstant();
        }
        if (this.field != null && (this.right == null || this.right instanceof TypeExpression || this.right.op == 82 && this.right.where == this.where)) {
            return this.field.isConstant();
        }
        return false;
    }

    public Expression inline(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inline(environment, context);
        }
        if (this.right != null) {
            return this.right.inline(environment, context);
        }
        return null;
    }

    public Expression inlineValue(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inlineValue(environment, context);
        }
        try {
            Expression expression;
            if (this.field == null) {
                return this;
            }
            if (this.field.isFinal() && (expression = (Expression)this.field.getValue(environment)) != null && expression.isConstant()) {
                expression = expression.copyInline(context);
                expression.where = this.where;
                return new CommaExpression(this.where, this.right, expression).inlineValue(environment, context);
            }
            if (this.right != null) {
                if (this.field.isStatic()) {
                    expression = this.right.inline(environment, context);
                    this.right = null;
                    if (expression != null) {
                        return new CommaExpression(this.where, expression, this);
                    }
                } else {
                    this.right = this.right.inlineValue(environment, context);
                }
            }
            return this;
        }
        catch (ClassNotFound classNotFound) {
            throw new CompilerError(classNotFound);
        }
    }

    public Expression inlineLHS(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inlineLHS(environment, context);
        }
        if (this.right != null) {
            if (this.field.isStatic()) {
                Expression expression = this.right.inline(environment, context);
                this.right = null;
                if (expression != null) {
                    return new CommaExpression(this.where, expression, this);
                }
            } else {
                this.right = this.right.inlineValue(environment, context);
            }
        }
        return this;
    }

    public Expression copyInline(Context context) {
        if (this.implementation != null) {
            return this.implementation.copyInline(context);
        }
        return super.copyInline(context);
    }

    public int costInline(int n, Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.costInline(n, environment, context);
        }
        if (context == null) {
            return 3 + (this.right == null ? 0 : this.right.costInline(n, environment, context));
        }
        ClassDefinition classDefinition = context.field.getClassDefinition();
        try {
            if (classDefinition.canAccess(environment, this.field.getClassDeclaration()) && classDefinition.canAccess(environment, this.field)) {
                if (this.right == null) {
                    return 3;
                }
                ClassDeclaration classDeclaration = environment.getClassDeclaration(this.right.type);
                if (classDefinition.canAccess(environment, classDeclaration)) {
                    return 3 + this.right.costInline(n, environment, context);
                }
            }
        }
        catch (ClassNotFound classNotFound) {}
        return n;
    }

    int codeLValue(Environment environment, Context context, Assembler assembler) {
        if (this.implementation != null) {
            throw new CompilerError("codeLValue");
        }
        if (this.field.isStatic()) {
            if (this.right != null) {
                this.right.code(environment, context, assembler);
                return 1;
            }
            return 0;
        }
        this.right.codeValue(environment, context, assembler);
        return 1;
    }

    void codeLoad(Environment environment, Context context, Assembler assembler) {
        if (this.field == null) {
            throw new CompilerError("should not be null");
        }
        if (this.field.isStatic()) {
            assembler.add(this.where, 178, this.field);
            return;
        }
        assembler.add(this.where, 180, this.field);
    }

    void codeStore(Environment environment, Context context, Assembler assembler) {
        if (this.field.isStatic()) {
            assembler.add(this.where, 179, this.field);
            return;
        }
        assembler.add(this.where, 181, this.field);
    }

    public void codeValue(Environment environment, Context context, Assembler assembler) {
        this.codeLValue(environment, context, assembler);
        this.codeLoad(environment, context, assembler);
    }

    public void print(PrintStream printStream) {
        printStream.print("(");
        if (this.right != null) {
            this.right.print(printStream);
        } else {
            printStream.print("<empty>");
        }
        printStream.print("." + this.id + ")");
        if (this.implementation != null) {
            printStream.print("/IMPL=");
            this.implementation.print(printStream);
        }
    }
}

