/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.LocalVariable;
import sun.tools.java.AmbiguousField;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Type;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.FieldUpdater;
import sun.tools.tree.LocalField;
import sun.tools.tree.TypeExpression;
import sun.tools.tree.UnaryExpression;
import sun.tools.tree.Vset;

public class IdentifierExpression
extends Expression {
    Identifier id;
    FieldDefinition field;
    Expression implementation;

    public IdentifierExpression(int n, Identifier identifier) {
        super(60, n, Type.tError);
        this.id = identifier;
    }

    public IdentifierExpression(IdentifierToken identifierToken) {
        this(identifierToken.getWhere(), identifierToken.getName());
    }

    public IdentifierExpression(int n, FieldDefinition fieldDefinition) {
        super(60, n, fieldDefinition.getType());
        this.id = fieldDefinition.getName();
        this.field = fieldDefinition;
    }

    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    public boolean equals(Identifier identifier) {
        return this.id.equals(identifier);
    }

    private Vset assign(Environment environment, Context context, Vset vset) {
        if (this.field.isLocal()) {
            LocalField localField = (LocalField)this.field;
            if (localField.scopeNumber < context.frameNumber) {
                environment.error(this.where, "assign.to.uplevel", this.id);
            }
            if (localField.isFinal()) {
                if (!localField.isBlankFinal()) {
                    environment.error(this.where, "assign.to.final", this.id);
                } else if (!vset.testVarUnassigned(localField.number)) {
                    environment.error(this.where, "assign.to.blank.final", this.id);
                }
            }
            vset.addVar(localField.number);
            ++localField.writecount;
        } else if (this.field.isFinal()) {
            vset = FieldExpression.checkFinalAssign(environment, context, vset, this.where, this.field);
        }
        return vset;
    }

    private Vset get(Environment environment, Context context, Vset vset) {
        if (this.field.isLocal()) {
            LocalField localField = (LocalField)this.field;
            if (localField.scopeNumber < context.frameNumber && !localField.isFinal()) {
                environment.error(this.where, "invalid.uplevel", this.id);
            }
            if (!vset.testVar(localField.number)) {
                environment.error(this.where, "var.not.initialized", this.id);
                vset.addVar(localField.number);
            }
            ++localField.readcount;
        } else {
            int n;
            if (!this.field.isStatic() && !vset.testVar(context.getThisNumber())) {
                environment.error(this.where, "access.inst.before.super", this.id);
                this.implementation = null;
            }
            if (this.field.isBlankFinal() && (n = context.getMemberNumber(this.field)) >= 0 && !vset.testVar(n)) {
                environment.error(this.where, "var.not.initialized", this.id);
            }
        }
        return vset;
    }

    boolean bind(Environment environment, Context context) {
        try {
            this.field = context.getField(environment, this.id);
            if (this.field == null) {
                ClassDefinition classDefinition = context.field.getClassDefinition();
                while (classDefinition != null) {
                    if (classDefinition.findAnyMethod(environment, this.id) != null) {
                        environment.error(this.where, "invalid.var", this.id, context.field.getClassDeclaration());
                        return false;
                    }
                    classDefinition = classDefinition.getOuterClass();
                }
                environment.error(this.where, "undef.var", this.id);
                return false;
            }
            this.type = this.field.getType();
            if (!context.field.getClassDefinition().canAccess(environment, this.field)) {
                environment.error(this.where, "no.field.access", this.id, this.field.getClassDeclaration(), context.field.getClassDeclaration());
                return false;
            }
            if (this.field.isLocal()) {
                LocalField localField = (LocalField)this.field;
                if (localField.scopeNumber < context.frameNumber) {
                    this.implementation = context.makeReference(environment, localField);
                }
            } else {
                Constants constants;
                ClassDefinition classDefinition;
                FieldDefinition fieldDefinition = this.field;
                if (fieldDefinition.reportDeprecated(environment)) {
                    environment.error(this.where, "warn.field.is.deprecated", this.id, fieldDefinition.getClassDefinition());
                }
                if ((classDefinition = fieldDefinition.getClassDefinition()) != context.field.getClassDefinition() && (constants = context.getApparentField(environment, this.id)) != null && constants != fieldDefinition) {
                    ClassDefinition classDefinition2 = context.findScope(environment, classDefinition);
                    if (classDefinition2 == null) {
                        classDefinition2 = fieldDefinition.getClassDefinition();
                    }
                    if (((FieldDefinition)constants).isLocal()) {
                        environment.error(this.where, "inherited.hides.local", this.id, classDefinition2.getClassDeclaration());
                    } else {
                        environment.error(this.where, "inherited.hides.field", this.id, classDefinition2.getClassDeclaration(), ((FieldDefinition)constants).getClassDeclaration());
                    }
                }
                if (fieldDefinition.isStatic()) {
                    new TypeExpression(this.where, fieldDefinition.getClassDeclaration().getType());
                    this.implementation = new FieldExpression(this.where, null, fieldDefinition);
                } else {
                    constants = context.findOuterLink(environment, this.where, fieldDefinition);
                    if (constants != null) {
                        this.implementation = new FieldExpression(this.where, (Expression)constants, fieldDefinition);
                    }
                }
            }
            if (!context.canReach(environment, this.field)) {
                environment.error(this.where, "forward.ref", this.id, this.field.getClassDeclaration());
                return false;
            }
            return true;
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, context.field);
        }
        catch (AmbiguousField ambiguousField) {
            environment.error(this.where, "ambig.field", this.id, ambiguousField.field1.getClassDeclaration(), ambiguousField.field2.getClassDeclaration());
        }
        return false;
    }

    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        if (this.field != null) {
            return vset;
        }
        if (this.bind(environment, context)) {
            vset = this.get(environment, context, vset);
            context.field.getClassDefinition().addDependency(this.field.getClassDeclaration());
            if (this.implementation != null) {
                vset = this.implementation.checkValue(environment, context, vset, hashtable);
            }
        }
        return vset;
    }

    public Vset checkLHS(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        if (!this.bind(environment, context)) {
            return vset;
        }
        vset = this.assign(environment, context, vset);
        if (this.implementation != null) {
            vset = this.implementation.checkValue(environment, context, vset, hashtable);
        }
        return vset;
    }

    public Vset checkAssignOp(Environment environment, Context context, Vset vset, Hashtable hashtable, Expression expression) {
        if (!this.bind(environment, context)) {
            return vset;
        }
        vset = this.assign(environment, context, this.get(environment, context, vset));
        if (this.implementation != null) {
            vset = this.implementation.checkValue(environment, context, vset, hashtable);
        }
        return vset;
    }

    public Expression implementAssignment(Environment environment, Context context, Expression expression) {
        if (this.implementation != null) {
            return this.implementation.implementAssignment(environment, context, expression);
        }
        return null;
    }

    public FieldUpdater getUpdater(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.getUpdater(environment, context);
        }
        return null;
    }

    public Vset checkAmbigName(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression) {
        try {
            if (context.getField(environment, this.id) != null) {
                return this.checkValue(environment, context, vset, hashtable);
            }
        }
        catch (ClassNotFound classNotFound) {
        }
        catch (AmbiguousField ambiguousField) {}
        ClassDefinition classDefinition = this.toResolvedType(environment, context, true);
        if (classDefinition != null) {
            unaryExpression.right = new TypeExpression(this.where, classDefinition.getType());
            return vset;
        }
        this.type = Type.tPackage;
        return vset;
    }

    private ClassDefinition toResolvedType(Environment environment, Context context, boolean bl) {
        Identifier identifier = context.resolveName(environment, this.id);
        Type type = Type.tClass(identifier);
        if (bl && !environment.classExists(type)) {
            return null;
        }
        if (environment.resolve(this.where, context.field.getClassDefinition(), type)) {
            try {
                Identifier identifier2;
                ClassDefinition classDefinition;
                ClassDefinition classDefinition2 = environment.getClassDefinition(type);
                if (classDefinition2.isMember() && (classDefinition = context.findScope(environment, classDefinition2.getOuterClass())) != classDefinition2.getOuterClass() && !(identifier2 = context.getApparentClassName(environment, this.id)).equals(Constants.idNull) && !identifier2.equals(identifier)) {
                    environment.error(this.where, "inherited.hides.type", this.id, classDefinition.getClassDeclaration());
                }
                if (!classDefinition2.getLocalName().equals(this.id.getFlatName().getName())) {
                    environment.error(this.where, "illegal.mangled.name", this.id, classDefinition2);
                }
                return classDefinition2;
            }
            catch (ClassNotFound classNotFound) {
            }
        }
        return null;
    }

    Type toType(Environment environment, Context context) {
        ClassDefinition classDefinition = this.toResolvedType(environment, context, false);
        if (classDefinition != null) {
            return classDefinition.getType();
        }
        return Type.tError;
    }

    public boolean isConstant() {
        if (this.implementation != null) {
            return this.implementation.isConstant();
        }
        if (this.field != null) {
            return this.field.isConstant();
        }
        return false;
    }

    public Expression inline(Environment environment, Context context) {
        return null;
    }

    public Expression inlineValue(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inlineValue(environment, context);
        }
        if (this.field == null) {
            return this;
        }
        try {
            if (this.field.isLocal()) {
                if (this.field.isInlineable(environment, false)) {
                    Expression expression = (Expression)this.field.getValue(environment);
                    if (expression == null) {
                        return this;
                    }
                    return expression.inlineValue(environment, context);
                }
                return this;
            }
            return this;
        }
        catch (ClassNotFound classNotFound) {
            throw new CompilerError(classNotFound);
        }
    }

    public Expression inlineLHS(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inlineLHS(environment, context);
        }
        return this;
    }

    public Expression copyInline(Context context) {
        if (this.implementation != null) {
            return this.implementation.copyInline(context);
        }
        IdentifierExpression identifierExpression = (IdentifierExpression)super.copyInline(context);
        if (this.field != null && this.field.isLocal()) {
            identifierExpression.field = ((LocalField)this.field).getCurrentInlineCopy(context);
        }
        return identifierExpression;
    }

    public int costInline(int n, Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.costInline(n, environment, context);
        }
        return super.costInline(n, environment, context);
    }

    int codeLValue(Environment environment, Context context, Assembler assembler) {
        return 0;
    }

    void codeLoad(Environment environment, Context context, Assembler assembler) {
        assembler.add(this.where, 21 + this.type.getTypeCodeOffset(), new Integer(((LocalField)this.field).number));
    }

    void codeStore(Environment environment, Context context, Assembler assembler) {
        LocalField localField = (LocalField)this.field;
        assembler.add(this.where, 54 + this.type.getTypeCodeOffset(), new LocalVariable(localField, localField.number));
    }

    public void codeValue(Environment environment, Context context, Assembler assembler) {
        this.codeLValue(environment, context, assembler);
        this.codeLoad(environment, context, assembler);
    }

    public void print(PrintStream printStream) {
        printStream.print(String.valueOf(this.id) + "#" + (this.field != null ? this.field.hashCode() : 0));
        if (this.implementation != null) {
            printStream.print("/IMPL=");
            this.implementation.print(printStream);
        }
    }
}

