/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.Label;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.ConditionVars;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.ExpressionStatement;
import sun.tools.tree.NotExpression;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class IfStatement
extends Statement {
    Expression cond;
    Statement ifTrue;
    Statement ifFalse;

    public IfStatement(int n, Expression expression, Statement statement, Statement statement2) {
        super(90, n);
        this.cond = expression;
        this.ifTrue = statement;
        this.ifFalse = statement2;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        CheckContext checkContext = new CheckContext(context, this);
        Vset vset2 = vset.copy();
        ConditionVars conditionVars = this.cond.checkCondition(environment, checkContext, this.reach(environment, vset), hashtable);
        this.cond = this.convert(environment, checkContext, Type.tBoolean, this.cond);
        Vset vset3 = conditionVars.vsTrue.isDeadEnd() ? vset2 : conditionVars.vsTrue;
        Vset vset4 = conditionVars.vsFalse.isDeadEnd() ? vset2 : conditionVars.vsFalse;
        vset3 = this.ifTrue.check(environment, checkContext, vset3, hashtable);
        if (this.ifFalse != null) {
            vset4 = this.ifFalse.check(environment, checkContext, vset4, hashtable);
        }
        vset = vset3.join(vset4.join(checkContext.vsBreak));
        return context.removeAdditionalVars(vset);
    }

    public Statement inline(Environment environment, Context context) {
        context = new Context(context, this);
        this.cond = this.cond.inlineValue(environment, context);
        if (this.cond.equals(true)) {
            this.ifTrue = this.ifTrue.inline(environment, context);
            return this.eliminate(environment, this.ifTrue);
        }
        if (this.cond.equals(false)) {
            return this.eliminate(environment, this.ifFalse != null ? this.ifFalse.inline(environment, context) : null);
        }
        if (this.ifTrue != null) {
            this.ifTrue = this.ifTrue.inline(environment, context);
        }
        if (this.ifFalse != null) {
            this.ifFalse = this.ifFalse.inline(environment, context);
        }
        if (this.ifTrue == null && this.ifFalse == null) {
            return this.eliminate(environment, new ExpressionStatement(this.where, this.cond).inline(environment, context));
        }
        if (this.ifTrue == null) {
            this.cond = new NotExpression(this.cond.where, this.cond).inlineValue(environment, context);
            return this.eliminate(environment, new IfStatement(this.where, this.cond, this.ifFalse, null));
        }
        return this;
    }

    public Statement copyInline(Context context, boolean bl) {
        IfStatement ifStatement = (IfStatement)this.clone();
        ifStatement.cond = this.cond.copyInline(context);
        if (this.ifTrue != null) {
            ifStatement.ifTrue = this.ifTrue.copyInline(context, bl);
        }
        if (this.ifFalse != null) {
            ifStatement.ifFalse = this.ifFalse.copyInline(context, bl);
        }
        return ifStatement;
    }

    public int costInline(int n, Environment environment, Context context) {
        int n2 = 1 + this.cond.costInline(n, environment, context);
        if (this.ifTrue != null) {
            n2 += this.ifTrue.costInline(n, environment, context);
        }
        if (this.ifFalse != null) {
            n2 += this.ifFalse.costInline(n, environment, context);
        }
        return n2;
    }

    public void code(Environment environment, Context context, Assembler assembler) {
        CodeContext codeContext = new CodeContext(context, this);
        Label label = new Label();
        this.cond.codeBranch(environment, codeContext, assembler, label, false);
        this.ifTrue.code(environment, codeContext, assembler);
        if (this.ifFalse != null) {
            Label label2 = new Label();
            assembler.add(true, this.where, 167, label2);
            assembler.add(label);
            this.ifFalse.code(environment, codeContext, assembler);
            assembler.add(label2);
        } else {
            assembler.add(label);
        }
        assembler.add(codeContext.breakLabel);
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("if ");
        this.cond.print(printStream);
        printStream.print(" ");
        this.ifTrue.print(printStream, n);
        if (this.ifFalse != null) {
            printStream.print(" else ");
            this.ifFalse.print(printStream, n);
        }
    }
}

