/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import sun.tools.asm.Assembler;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.FieldDefinition;
import sun.tools.java.Identifier;
import sun.tools.tree.AssignExpression;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.LocalField;

public class UplevelReference
implements Constants {
    ClassDefinition client;
    LocalField target;
    LocalField localArgument;
    FieldDefinition localField;
    UplevelReference next;

    public UplevelReference(ClassDefinition classDefinition, LocalField localField) {
        Identifier identifier;
        int n;
        Constants constants;
        this.client = classDefinition;
        this.target = localField;
        if (localField.getName().equals(Constants.idThis)) {
            constants = localField.getClassDefinition();
            n = 0;
            ClassDefinition classDefinition2 = constants;
            while (!classDefinition2.isTopLevel()) {
                ++n;
                classDefinition2 = classDefinition2.getOuterClass();
            }
            identifier = Identifier.lookup("this$" + n);
        } else {
            identifier = Identifier.lookup("val$" + localField.getName());
        }
        constants = identifier;
        n = 0;
        while (true) {
            boolean bl = classDefinition.getFirstMatch(identifier) != null;
            UplevelReference uplevelReference = classDefinition.getReferences();
            while (uplevelReference != null) {
                if (uplevelReference.target.getName().equals(identifier)) {
                    bl = true;
                }
                uplevelReference = uplevelReference.next;
            }
            if (!bl) break;
            identifier = Identifier.lookup(String.valueOf(constants) + "$" + ++n);
        }
        this.localArgument = new LocalField(localField.getWhere(), classDefinition, 524304, localField.getType(), identifier);
    }

    public UplevelReference insertInto(UplevelReference uplevelReference) {
        if (uplevelReference == null || this.isEarlierThan(uplevelReference)) {
            this.next = uplevelReference;
            return this;
        }
        UplevelReference uplevelReference2 = uplevelReference;
        while (uplevelReference2.next != null && !this.isEarlierThan(uplevelReference2.next)) {
            uplevelReference2 = uplevelReference2.next;
        }
        this.next = uplevelReference2.next;
        uplevelReference2.next = this;
        return uplevelReference;
    }

    public final boolean isEarlierThan(UplevelReference uplevelReference) {
        if (this.isClientOuterField()) {
            return true;
        }
        if (uplevelReference.isClientOuterField()) {
            return false;
        }
        LocalField localField = uplevelReference.target;
        Identifier identifier = this.target.getName();
        Identifier identifier2 = localField.getName();
        int n = identifier.toString().compareTo(identifier2.toString());
        if (n != 0) {
            return n < 0;
        }
        Identifier identifier3 = this.target.getClassDefinition().getName();
        Identifier identifier4 = localField.getClassDefinition().getName();
        int n2 = identifier3.toString().compareTo(identifier4.toString());
        return n2 < 0;
    }

    public final LocalField getTarget() {
        return this.target;
    }

    public final LocalField getLocalArgument() {
        return this.localArgument;
    }

    public final FieldDefinition getLocalField() {
        return this.localField;
    }

    public final FieldDefinition getLocalField(Environment environment) {
        if (this.localField == null) {
            this.makeLocalField(environment);
        }
        return this.localField;
    }

    public final ClassDefinition getClient() {
        return this.client;
    }

    public final UplevelReference getNext() {
        return this.next;
    }

    public boolean isClientOuterField() {
        FieldDefinition fieldDefinition = this.client.findOuterField();
        return fieldDefinition != null && this.localField == fieldDefinition;
    }

    public boolean localArgumentAvailable(Environment environment, Context context) {
        FieldDefinition fieldDefinition = context.field;
        if (fieldDefinition.getClassDefinition() != this.client) {
            throw new CompilerError("localArgumentAvailable");
        }
        return fieldDefinition.isConstructor() || fieldDefinition.isVariable() || fieldDefinition.isInitializer();
    }

    public void noteReference(Environment environment, Context context) {
        if (this.localField == null && !this.localArgumentAvailable(environment, context)) {
            this.makeLocalField(environment);
        }
    }

    private void makeLocalField(Environment environment) {
        this.client.referencesMustNotBeFrozen();
        int n = 524306;
        this.localField = environment.makeFieldDefinition(environment, this.localArgument.getWhere(), this.client, null, n, this.localArgument.getType(), this.localArgument.getName(), null, null, null);
    }

    public Expression makeLocalReference(Environment environment, Context context) {
        if (context.field.getClassDefinition() != this.client) {
            throw new CompilerError("makeLocalReference");
        }
        if (this.localArgumentAvailable(environment, context)) {
            return new IdentifierExpression(0, this.localArgument);
        }
        return this.makeFieldReference(environment, context);
    }

    public Expression makeFieldReference(Environment environment, Context context) {
        Expression expression = context.findOuterLink(environment, 0, this.localField);
        return new FieldExpression(0, expression, this.localField);
    }

    public void willCodeArguments(Environment environment, Context context) {
        if (!this.isClientOuterField()) {
            context.noteReference(environment, this.target);
        }
        if (this.next != null) {
            this.next.willCodeArguments(environment, context);
        }
    }

    public void codeArguments(Environment environment, Context context, Assembler assembler, int n, FieldDefinition fieldDefinition) {
        if (!this.isClientOuterField()) {
            Expression expression = context.makeReference(environment, this.target);
            expression.codeValue(environment, context, assembler);
        }
        if (this.next != null) {
            this.next.codeArguments(environment, context, assembler, n, fieldDefinition);
        }
    }

    public void codeInitialization(Environment environment, Context context, Assembler assembler, int n, FieldDefinition fieldDefinition) {
        if (this.localField != null) {
            Expression expression = context.makeReference(environment, this.target);
            Expression expression2 = this.makeFieldReference(environment, context);
            expression = new AssignExpression(expression.getWhere(), expression2, expression);
            expression.type = this.localField.getType();
            expression.code(environment, context, assembler);
        }
        if (this.next != null) {
            this.next.codeInitialization(environment, context, assembler, n, fieldDefinition);
        }
    }

    public String toString() {
        return "[" + this.localArgument + " in " + this.client + "]";
    }
}

