/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.ttydebug;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import sun.tools.debug.DebuggerCallback;
import sun.tools.debug.NoSuchLineNumberException;
import sun.tools.debug.RemoteArray;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteDebugger;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteInt;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteStackVariable;
import sun.tools.debug.RemoteThread;
import sun.tools.debug.RemoteThreadGroup;
import sun.tools.debug.RemoteValue;

public class TTY
implements DebuggerCallback {
    RemoteDebugger debugger;
    RemoteThread currentThread;
    RemoteThreadGroup currentThreadGroup;
    PrintStream out;
    PrintStream console;
    private static final String progname = "jdb";
    private static final String version = "98/12/02";
    private String lastArgs;
    private boolean hasRun = false;
    static final String printDelimiters = ".[(";

    private RemoteThread indexToThread(int n) throws Exception {
        this.setDefaultThreadGroup();
        RemoteThread[] remoteThreadArray = this.currentThreadGroup.listThreads(true);
        if (n == 0 || n > remoteThreadArray.length) {
            return null;
        }
        return remoteThreadArray[n - 1];
    }

    private int parseThreadId(String string) throws Exception {
        int n;
        if (string.startsWith("t@")) {
            string = string.substring(2);
        }
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (this.indexToThread(n) == null) {
            this.out.println("\"" + string + "\" is not a valid thread id.");
            return 0;
        }
        return n;
    }

    private void printPrompt() throws Exception {
        if (this.currentThread == null) {
            this.out.print("> ");
        } else {
            this.out.print(String.valueOf(this.currentThread.getName()) + "[" + (this.currentThread.getCurrentFrameIndex() + 1) + "] ");
        }
        this.out.flush();
    }

    public synchronized void printToConsole(String string) throws Exception {
        this.console.print(string);
        this.console.flush();
    }

    public void breakpointEvent(RemoteThread remoteThread) throws Exception {
        this.out.print("\nBreakpoint hit: ");
        RemoteStackFrame[] remoteStackFrameArray = remoteThread.dumpStack();
        if (remoteStackFrameArray.length > 0) {
            this.out.println(remoteStackFrameArray[0].toString());
            this.currentThread = remoteThread;
        } else {
            this.out.println("Invalid thread specified in breakpoint.");
        }
        this.printPrompt();
    }

    public void exceptionEvent(RemoteThread remoteThread, String string) throws Exception {
        this.out.println("\n" + string);
        remoteThread.setCurrentFrameIndex(0);
        this.currentThread = remoteThread;
        this.printPrompt();
    }

    public void threadDeathEvent(RemoteThread remoteThread) throws Exception {
        this.out.println("\n" + remoteThread.getName() + " died.");
        if (remoteThread == this.currentThread) {
            this.currentThread = null;
        }
        this.printPrompt();
    }

    public void quitEvent() throws Exception {
        StringTokenizer stringTokenizer;
        String string = null;
        if (this.lastArgs != null && (stringTokenizer = new StringTokenizer(this.lastArgs)).hasMoreTokens()) {
            string = new String("\n" + stringTokenizer.nextToken() + " exited");
        }
        if (string == null) {
            string = new String("\nThe application exited");
        }
        this.out.println(string);
        this.currentThread = null;
        System.exit(0);
    }

    void classes() throws Exception {
        RemoteClass[] remoteClassArray = this.debugger.listClasses();
        this.out.println("** classes list **");
        int n = 0;
        while (n < remoteClassArray.length) {
            this.out.println(remoteClassArray[n].description());
            ++n;
        }
    }

    void methods(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        try {
            RemoteClass remoteClass = this.getClassFromToken(string);
            RemoteField[] remoteFieldArray = remoteClass.getMethods();
            int n = 0;
            while (n < remoteFieldArray.length) {
                this.out.println(remoteFieldArray[n].getTypedName());
                ++n;
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
            return;
        }
    }

    int printThreadGroup(RemoteThreadGroup remoteThreadGroup, int n) throws Exception {
        int n2;
        Object[] objectArray;
        int n3;
        this.out.println("Group " + remoteThreadGroup.getName() + ":");
        RemoteThread[] remoteThreadArray = remoteThreadGroup.listThreads(false);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < remoteThreadArray.length) {
            String string;
            int n7 = remoteThreadArray[n6].description().length();
            if (n7 > n4) {
                n4 = n7;
            }
            if ((n3 = (string = remoteThreadArray[n6].getName()).lastIndexOf(46)) >= 0 && string.length() > n3) {
                string = string.substring(n3 + 1);
            }
            if (string.length() > n5) {
                n5 = string.length();
            }
            ++n6;
        }
        String string = String.valueOf(n + remoteThreadArray.length);
        int n8 = string.length();
        n3 = 0;
        while (n3 < remoteThreadArray.length) {
            objectArray = new char[80];
            n2 = 0;
            while (n2 < 79) {
                objectArray[n2] = 32;
                ++n2;
            }
            objectArray[79] = '\u0000';
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((char[])objectArray);
            String string2 = String.valueOf(n + n3 + 1);
            stringBuffer.insert(n8 - string2.length(), string2);
            stringBuffer.insert(n8, ".");
            int n9 = n8 + 2;
            stringBuffer.insert(n9, remoteThreadArray[n3].description());
            n9 += n4 + 1;
            String string3 = remoteThreadArray[n3].getName();
            int n10 = string3.lastIndexOf(46);
            if (n10 >= 0 && string3.length() > n10) {
                string3 = string3.substring(n10 + 1);
            }
            stringBuffer.insert(n9, string3);
            stringBuffer.insert(n9 += n5 + 1, remoteThreadArray[n3].getStatus());
            stringBuffer.setLength(79);
            this.out.println(stringBuffer.toString());
            ++n3;
        }
        objectArray = this.debugger.listThreadGroups(remoteThreadGroup);
        n2 = 0;
        while (n2 < objectArray.length) {
            if (remoteThreadGroup != objectArray[n2]) {
                n += this.printThreadGroup((RemoteThreadGroup)objectArray[n2], n + remoteThreadArray.length);
            }
            ++n2;
        }
        return remoteThreadArray.length;
    }

    private void setDefaultThreadGroup() throws Exception {
        if (this.currentThreadGroup == null) {
            RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
            this.currentThreadGroup = remoteThreadGroupArray[0];
        }
    }

    void threads(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.setDefaultThreadGroup();
            this.printThreadGroup(this.currentThreadGroup, 0);
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            if (string.equals(remoteThreadGroupArray[n].getName())) {
                this.printThreadGroup(remoteThreadGroupArray[n], 0);
                return;
            }
            ++n;
        }
        this.out.println(String.valueOf(string) + " is not a valid threadgroup name.");
    }

    void threadGroups() throws Exception {
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            this.out.println(String.valueOf(new Integer(n + 1).toString()) + ". " + remoteThreadGroupArray[n].description() + " " + remoteThreadGroupArray[n].getName());
            ++n;
        }
    }

    void setThread(int n) throws Exception {
        this.setDefaultThreadGroup();
        RemoteThread remoteThread = this.indexToThread(n);
        if (remoteThread == null) {
            this.out.println("\"" + n + "\" is not a valid thread id.");
            return;
        }
        this.currentThread = remoteThread;
    }

    void thread(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Thread number not specified.");
            return;
        }
        int n = this.parseThreadId(stringTokenizer.nextToken());
        if (n == 0) {
            return;
        }
        this.setThread(n);
    }

    void threadGroup(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Threadgroup name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            if (string.equals(remoteThreadGroupArray[n].getName())) {
                this.currentThreadGroup = remoteThreadGroupArray[n];
                return;
            }
            ++n;
        }
        this.out.println(String.valueOf(string) + " is not a valid threadgroup name.");
    }

    void run(StringTokenizer stringTokenizer) throws Exception {
        RemoteObject remoteObject;
        String[] stringArray = new String[100];
        int n = 0;
        if (this.hasRun) {
            this.out.println("Cannot restart program in this session");
            return;
        }
        if (!stringTokenizer.hasMoreTokens() && this.lastArgs != null) {
            stringTokenizer = new StringTokenizer(this.lastArgs);
            this.out.println("run " + this.lastArgs);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
            if (n != 1) continue;
            remoteObject = this.debugger.findClass(stringArray[0]);
            if (remoteObject == null) {
                this.out.println("Could not load the " + stringArray[0] + " class.");
                return;
            }
            stringArray[0] = ((RemoteClass)remoteObject).getName();
        }
        if (n > 0) {
            remoteObject = this.debugger.run(n, stringArray);
            if (remoteObject != null) {
                this.currentThreadGroup = remoteObject;
                this.setThread(1);
                this.out.println("running ...");
            } else {
                this.out.println(String.valueOf(stringArray[0]) + " failed.");
            }
        } else {
            this.out.println("No class name specified.");
        }
        this.hasRun = true;
    }

    void load(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Class name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteClass remoteClass = this.debugger.findClass(string);
        if (remoteClass == null) {
            this.out.print(String.valueOf(string) + " not found");
            this.out.println(string.indexOf(46) > 0 ? " (try the full name)" : "");
            return;
        }
        this.out.println(remoteClass.toString());
    }

    /*
     * Unable to fully structure code
     */
    void suspend(StringTokenizer var1_1) throws Exception {
        if (var1_1.hasMoreTokens()) ** GOTO lbl22
        this.setDefaultThreadGroup();
        var2_2 = this.currentThreadGroup.listThreads(true);
        var3_4 = 0;
        while (var3_4 < var2_2.length) {
            var2_2[var3_4].suspend();
            ++var3_4;
        }
        this.out.println("All (non-system) threads suspended.");
        return;
lbl-1000:
        // 1 sources

        {
            var2_3 = var1_1.nextToken();
            try {
                var3_5 = Integer.valueOf(var2_3);
            }
            catch (NumberFormatException v0) {
                var3_5 = 0;
            }
            var4_6 = this.indexToThread(var3_5);
            if (var4_6 == null) {
                this.out.println("\"" + var2_3 + "\" is not a valid thread id.");
                continue;
            }
            var4_6.suspend();
lbl22:
            // 3 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl23:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    void resume(StringTokenizer var1_1) throws Exception {
        if (var1_1.hasMoreTokens()) ** GOTO lbl26
        this.setDefaultThreadGroup();
        var2_2 = this.currentThreadGroup.listThreads(true);
        var3_4 = 0;
        while (var3_4 < var2_2.length) {
            var2_2[var3_4].resume();
            ++var3_4;
        }
        if (this.currentThread != null) {
            this.currentThread.resetCurrentFrameIndex();
        }
        this.out.println("All threads resumed.");
        return;
lbl-1000:
        // 1 sources

        {
            var2_3 = var1_1.nextToken();
            try {
                var3_5 = Integer.valueOf(var2_3);
            }
            catch (NumberFormatException v0) {
                var3_5 = 0;
            }
            var4_6 = this.indexToThread(var3_5);
            if (var4_6 == null) {
                this.out.println("\"" + var2_3 + "\" is not a valid thread id.");
                continue;
            }
            var4_6.resume();
            if (var4_6 != this.currentThread) continue;
            this.currentThread.resetCurrentFrameIndex();
lbl26:
            // 4 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl27:
        // 1 sources

    }

    void cont() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        this.debugger.cont();
    }

    void step(StringTokenizer stringTokenizer) throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            if (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().toLowerCase();
                if (string.equals("up")) {
                    this.currentThread.stepOut();
                    return;
                }
                this.currentThread.step(true);
                return;
            }
            this.currentThread.step(true);
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not suspended.");
            return;
        }
    }

    void stepi() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            this.currentThread.step(false);
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not suspended.");
            return;
        }
    }

    void next() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            this.currentThread.next();
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not suspended.");
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    void kill(StringTokenizer var1_1) throws Exception {
        if (var1_1.hasMoreTokens()) ** GOTO lbl26
        this.out.println("Usage: kill <threadgroup name> or <thread id>");
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.nextToken();
            try {
                var3_3 = Integer.valueOf(var2_2);
            }
            catch (NumberFormatException v0) {
                var3_3 = 0;
            }
            var4_4 = this.indexToThread(var3_3);
            if (var4_4 != null) {
                this.out.println("killing thread: " + var4_4.getName());
                var4_4.stop();
                return;
            }
            var5_5 = this.debugger.listThreadGroups(null);
            var5_5 = this.debugger.listThreadGroups(var5_5[0]);
            var6_6 = 0;
            while (var6_6 < var5_5.length) {
                if (var5_5[var6_6].getName().equals(var2_2)) {
                    this.out.println("killing threadgroup: " + var2_2);
                    var5_5[var6_6].stop();
                    return;
                }
                ++var6_6;
            }
            this.out.println("\"" + var2_2 + "\" is not a valid threadgroup or id.");
lbl26:
            // 2 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl27:
        // 1 sources

    }

    void catchException(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            String[] stringArray = this.debugger.getExceptionCatchList();
            int n = 0;
            while (n < stringArray.length) {
                this.out.print("  " + stringArray[n]);
                if ((n & 4) == 3 || n == stringArray.length - 1) {
                    this.out.println();
                }
                ++n;
            }
            return;
        }
        String string = stringTokenizer.nextToken();
        try {
            RemoteClass remoteClass = this.getClassFromToken(string);
            remoteClass.catchExceptions();
            return;
        }
        catch (Exception exception) {
            this.out.println("Invalid exception class name: " + string);
            return;
        }
    }

    void ignoreException(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            String[] stringArray = this.debugger.getExceptionCatchList();
            int n = 0;
            while (n < stringArray.length) {
                this.out.print("  " + stringArray[n]);
                if ((n & 4) == 3 || n == stringArray.length - 1) {
                    this.out.println();
                }
                ++n;
            }
            return;
        }
        String string = stringTokenizer.nextToken();
        try {
            RemoteClass remoteClass = this.getClassFromToken(string);
            remoteClass.ignoreExceptions();
            return;
        }
        catch (Exception exception) {
            this.out.println("Invalid exception class name: " + string);
            return;
        }
    }

    void up(StringTokenizer stringTokenizer) throws Exception {
        if (this.currentThread == null) {
            this.out.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 == 0) {
                this.out.println("Usage: up [n frames]");
                return;
            }
            n = n2;
        }
        try {
            this.currentThread.up(n);
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Thread isn't suspended.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("End of stack.");
            return;
        }
    }

    void down(StringTokenizer stringTokenizer) throws Exception {
        if (this.currentThread == null) {
            this.out.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 == 0) {
                this.out.println("usage: down [n frames]");
                return;
            }
            n = n2;
        }
        try {
            this.currentThread.down(n);
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Thread isn't suspended.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("End of stack.");
            return;
        }
    }

    void dumpStack(RemoteThread remoteThread, boolean bl) throws Exception {
        RemoteStackFrame[] remoteStackFrameArray = remoteThread.dumpStack();
        if (remoteStackFrameArray.length == 0) {
            this.out.println("Thread is not running (no stack).");
            return;
        }
        int n = remoteStackFrameArray.length;
        int n2 = remoteThread.getCurrentFrameIndex();
        while (n2 < n) {
            this.out.print("  [" + (n2 + 1) + "] ");
            this.out.print(remoteStackFrameArray[n2].toString());
            if (bl) {
                this.out.print(", pc = " + remoteStackFrameArray[n2].getPC());
            }
            this.out.println();
            ++n2;
        }
    }

    void where(StringTokenizer stringTokenizer, boolean bl) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            if (this.currentThread == null) {
                this.out.println("No thread specified.");
                return;
            }
            this.dumpStack(this.currentThread, bl);
            return;
        }
        String string = stringTokenizer.nextToken();
        if (string.toLowerCase().equals("all")) {
            this.setDefaultThreadGroup();
            RemoteThread[] remoteThreadArray = this.currentThreadGroup.listThreads(true);
            int n = 0;
            while (n < remoteThreadArray.length) {
                this.out.println(String.valueOf(remoteThreadArray[n].getName()) + ": ");
                this.dumpStack(remoteThreadArray[n], bl);
                ++n;
            }
            return;
        }
        int n = this.parseThreadId(string);
        if (n == 0) {
            return;
        }
        this.dumpStack(this.indexToThread(n), bl);
    }

    void trace(String string, StringTokenizer stringTokenizer) throws Exception {
        boolean bl;
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("(i)trace < \"on\" | \"off\" >");
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("on")) {
            bl = true;
        } else if (string2.equals("off")) {
            bl = false;
        } else {
            this.out.println("(i)trace < \"on\" | \"off\" >");
            return;
        }
        if (string.equals("trace")) {
            this.debugger.trace(bl);
            return;
        }
        this.debugger.itrace(bl);
    }

    void memory() throws Exception {
        this.out.println("Free: " + this.debugger.freeMemory() + ", total: " + this.debugger.totalMemory());
    }

    void gc() throws Exception {
        RemoteObject[] remoteObjectArray = new RemoteObject[]{this.currentThread, this.currentThreadGroup};
        this.debugger.gc(remoteObjectArray);
    }

    private RemoteClass getClassFromToken(String string) throws Exception {
        RemoteObject remoteObject;
        if (string.startsWith("0x") || Character.isDigit(string.charAt(0))) {
            int n;
            try {
                n = RemoteValue.fromHex(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n == 0 || (remoteObject = this.debugger.get(new Integer(n))) == null) {
                throw new IllegalArgumentException();
            }
            if (!(remoteObject instanceof RemoteClass)) {
                throw new IllegalArgumentException();
            }
        } else {
            remoteObject = this.debugger.findClass(string);
            if (remoteObject == null) {
                throw new IllegalArgumentException();
            }
        }
        return remoteObject;
    }

    void listBreakpoints() throws Exception {
        String[] stringArray = this.debugger.listBreakpoints();
        if (stringArray.length > 0) {
            this.out.println("Current breakpoints set:");
            int n = 0;
            while (n < stringArray.length) {
                this.out.println("\t" + stringArray[n]);
                ++n;
            }
            return;
        }
        this.out.println("No breakpoints set.");
    }

    void stop(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        String string = null;
        try {
            Object object;
            RemoteField remoteField;
            boolean bl;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("at")) {
                bl = true;
            } else if (string2.equals("in")) {
                bl = false;
            } else {
                this.out.println("Usage: stop at <class>:<line_number> or");
                this.out.println("       stop in <class>.<method_name>");
                return;
            }
            if (string2.equals("at")) {
                String string3;
                int n;
                string = stringTokenizer.nextToken(": \t\n\r");
                RemoteClass remoteClass = this.getClassFromToken(string);
                String string4 = remoteClass.setBreakpointLine(n = Integer.valueOf(string3 = stringTokenizer.nextToken()).intValue());
                if (string4.length() > 0) {
                    this.out.println(string4);
                    return;
                }
                this.out.println("Breakpoint set at " + remoteClass.getName() + ":" + n);
                return;
            }
            string = stringTokenizer.nextToken(": \t\n\r");
            RemoteClass remoteClass = null;
            String string5 = null;
            try {
                remoteClass = this.getClassFromToken(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int n = string.lastIndexOf(".");
                if (n == -1) {
                    this.out.println("\"" + string + "\" is not a valid id or class name.");
                    return;
                }
                string5 = string.substring(n + 1);
                string = string.substring(0, n);
                remoteClass = this.getClassFromToken(string);
            }
            if (string5 == null) {
                string5 = stringTokenizer.nextToken();
            }
            try {
                remoteField = remoteClass.getMethod(string5);
                object = remoteClass.getMethods();
                int n = 0;
                while (n < ((RemoteField[])object).length) {
                    if (object[n].getName().equals(string5) && object[n] != remoteField) {
                        this.out.println(String.valueOf(remoteClass.getName()) + "." + string5 + " is overloaded. Use the 'stop at' command to " + "set a breakpoint in one of the overloads");
                        return;
                    }
                    ++n;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.out.println("Class " + remoteClass.getName() + " doesn't have a method " + string5);
                return;
            }
            object = remoteClass.setBreakpointMethod(remoteField);
            if (((String)object).length() > 0) {
                this.out.println((String)object);
                return;
            }
            this.out.println("Breakpoint set in " + remoteClass.getName() + "." + string5);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("Usage: stop at <class>:<line_number> or");
            this.out.println("       stop in <class>.<method_name>");
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.out.println("Invalid line number.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
            return;
        }
    }

    void clear(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        String string = null;
        String string2 = null;
        RemoteClass remoteClass = null;
        try {
            string = stringTokenizer.nextToken(": \t\n\r");
            try {
                remoteClass = this.getClassFromToken(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RemoteField remoteField;
                int n = string.lastIndexOf(".");
                if (n == -1) {
                    this.out.println("\"" + string + "\" is not a valid id or class name.");
                    return;
                }
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
                remoteClass = this.getClassFromToken(string);
                try {
                    remoteField = remoteClass.getMethod(string2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.out.println("\"" + string2 + "\" is not a valid method name of class " + remoteClass.getName());
                    return;
                }
                String string3 = remoteClass.clearBreakpointMethod(remoteField);
                if (string3.length() > 0) {
                    this.out.println(string3);
                    return;
                }
                this.out.println("Breakpoint cleared at " + remoteClass.getName() + "." + string2);
                return;
            }
            String string4 = stringTokenizer.nextToken();
            int n = Integer.valueOf(string4);
            String string5 = remoteClass.clearBreakpointLine(n);
            if (string5.length() > 0) {
                this.out.println(string5);
                return;
            }
            this.out.println("Breakpoint cleared at " + remoteClass.getName() + ": " + n);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("Usage: clear <class>:<line_number>");
            this.out.println("   or: clear <class>.<method>");
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.out.println("Usage: clear <class>:<line_number>");
            this.out.println("   or: clear <class>.<method>");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
            return;
        }
    }

    void list(StringTokenizer stringTokenizer) throws Exception {
        int n;
        RemoteStackFrame remoteStackFrame = null;
        if (this.currentThread == null) {
            this.out.println("No thread specified.");
            return;
        }
        try {
            remoteStackFrame = this.currentThread.getCurrentFrame();
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread isn't suspended.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("Thread is not running (no stack).");
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    n = remoteStackFrame.getRemoteClass().getMethodLineNumber(string);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.out.println(String.valueOf(string) + " is not a valid line number or " + "method name for class " + remoteStackFrame.getRemoteClass().getName());
                    return;
                }
                catch (NoSuchLineNumberException noSuchLineNumberException) {
                    this.out.println("Line number information not found in " + remoteStackFrame.getRemoteClass().getName());
                    return;
                }
            }
        } else {
            n = remoteStackFrame.getLineNumber();
        }
        int n2 = n > 4 ? n - 4 : 1;
        int n3 = n2 + 9;
        InputStream inputStream = remoteStackFrame.getRemoteClass().getSourceFile();
        if (inputStream == null) {
            this.out.println("Unable to find " + remoteStackFrame.getRemoteClass().getSourceFileName());
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = null;
        int n4 = 1;
        while (n4 <= n2) {
            string = dataInputStream.readLine();
            ++n4;
        }
        if (string == null) {
            this.out.println(String.valueOf(new Integer(n).toString()) + " is an invalid line number for the file " + remoteStackFrame.getRemoteClass().getSourceFileName());
        }
        int n5 = n2;
        while (n5 < n3 && string != null) {
            this.out.print(String.valueOf(new Integer(n5).toString()) + "\t" + (n5 == n ? "=> " : "   "));
            this.out.println(string);
            string = dataInputStream.readLine();
            ++n5;
        }
    }

    void use(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println(this.debugger.getSourcePath());
            return;
        }
        this.debugger.setSourcePath(stringTokenizer.nextToken());
    }

    private void printVar(RemoteStackVariable remoteStackVariable) {
        this.out.print("  " + remoteStackVariable.getName());
        if (remoteStackVariable.inScope()) {
            RemoteValue remoteValue = remoteStackVariable.getValue();
            this.out.println(" = " + (remoteValue == null ? "null" : remoteValue.toString()));
            return;
        }
        this.out.println(" is not in scope");
    }

    void locals() throws Exception {
        if (this.currentThread == null) {
            this.out.println("No default thread specified: use the \"thread\" command first.");
            return;
        }
        if (!this.currentThread.isSuspended()) {
            this.out.println("Thread isn't suspended.");
            return;
        }
        RemoteStackVariable[] remoteStackVariableArray = this.currentThread.getStackVariables();
        if (remoteStackVariableArray == null || remoteStackVariableArray.length == 0) {
            this.out.println("No local variables: try compiling with -g");
            return;
        }
        this.out.println("Method arguments:");
        int n = 0;
        while (n < remoteStackVariableArray.length) {
            if (remoteStackVariableArray[n].methodArgument()) {
                this.printVar(remoteStackVariableArray[n]);
            }
            ++n;
        }
        this.out.println("Local variables:");
        int n2 = 0;
        while (n2 < remoteStackVariableArray.length) {
            if (!remoteStackVariableArray[n2].methodArgument()) {
                this.printVar(remoteStackVariableArray[n2]);
            }
            ++n2;
        }
    }

    void print(StringTokenizer stringTokenizer, boolean bl) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No objects specified.");
            return;
        }
        RemoteValue remoteValue = null;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            int n;
            String string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, printDelimiters, true);
            String string2 = stringTokenizer2.nextToken();
            if (string2.startsWith("t@")) {
                this.setDefaultThreadGroup();
                RemoteThread[] remoteThreadArray = this.currentThreadGroup.listThreads(true);
                try {
                    n = Integer.valueOf(string2.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n <= 0 || n > remoteThreadArray.length) {
                    this.out.println("\"" + string2 + "\" is not a valid thread id.");
                    continue;
                }
                remoteValue = remoteThreadArray[n - 1];
            } else if (string2.startsWith("$s")) {
                int n2;
                try {
                    n2 = Integer.valueOf(string2.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    this.out.println("\"" + string2 + "\" is not a valid slot.");
                    continue;
                }
                if (this.currentThread != null) {
                    object = this.currentThread.getStackVariables();
                    if (object == null || n2 >= ((RemoteStackVariable[])object).length) {
                        this.out.println("\"" + string2 + "\" is not a valid slot.");
                        continue;
                    }
                    remoteValue = object[n2].getValue();
                }
            } else if (string2.startsWith("0x") || Character.isDigit(string2.charAt(0))) {
                try {
                    n = RemoteValue.fromHex(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n == 0 || (remoteValue = this.debugger.get(new Integer(n))) == null) {
                    this.out.println("\"" + string2 + "\" is not a valid id.");
                    continue;
                }
            } else {
                RemoteStackVariable remoteStackVariable = null;
                if (this.currentThread != null) {
                    remoteStackVariable = this.currentThread.getStackVariable(string2);
                    if (remoteStackVariable != null && !remoteStackVariable.inScope()) {
                        this.out.println(String.valueOf(string2) + " is not in scope.");
                        continue;
                    }
                    RemoteValue remoteValue2 = remoteValue = remoteStackVariable == null ? null : remoteStackVariable.getValue();
                }
                if (remoteStackVariable == null) {
                    String string3;
                    object = null;
                    String string4 = string2;
                    try {
                        string4 = String.valueOf(string4) + stringTokenizer2.nextToken("");
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    if (this.currentThread != null) {
                        remoteStackVariable = this.currentThread.getStackVariable("this");
                    }
                    if (remoteStackVariable != null && remoteStackVariable.inScope()) {
                        remoteValue = remoteStackVariable.getValue();
                        object = this.printModifiers(string, new StringTokenizer("." + string4, printDelimiters, true), bl, remoteValue, true);
                        if (object == null) continue;
                    }
                    stringTokenizer2 = new StringTokenizer(string4, printDelimiters, true);
                    string2 = stringTokenizer2.nextToken();
                    while ((remoteValue = this.debugger.findClass(string2)) == null && stringTokenizer2.hasMoreTokens() && (string3 = stringTokenizer2.nextToken()).equals(".") && stringTokenizer2.hasMoreTokens()) {
                        string2 = String.valueOf(string2) + string3 + stringTokenizer2.nextToken();
                    }
                    if (remoteValue == null) {
                        if (object == null) {
                            object = "\"" + string + "\" is not a " + "valid local or class name.";
                        }
                    } else {
                        string3 = this.printModifiers(string, stringTokenizer2, bl, remoteValue, false);
                        if (string3 == null) continue;
                        if (object == null) {
                            object = string3;
                        }
                    }
                    this.out.println((String)object);
                    continue;
                }
            }
            String string5 = this.printModifiers(string, stringTokenizer2, bl, remoteValue, false);
            if (string5 == null) continue;
            this.out.println(string5);
        }
    }

    String printModifiers(String string, StringTokenizer stringTokenizer, boolean bl, RemoteValue remoteValue, boolean bl2) throws Exception {
        Object object;
        RemoteInt remoteInt = new RemoteInt(-1);
        RemoteValue remoteValue2 = remoteInt;
        if (remoteValue == null) {
            remoteValue2 = null;
        } else if (!remoteValue.isObject()) {
            remoteValue2 = remoteValue;
        }
        String string2 = "";
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        while (string3 != null) {
            if (string3.equals(".")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return "\"" + string + "\" is not a valid expression.";
                }
                string3 = stringTokenizer.nextToken();
                if (remoteValue2 != remoteInt) {
                    return "\"" + string2 + "\" is not an object.";
                }
                string2 = string3;
                object = ((RemoteObject)remoteValue).getFields();
                boolean bl3 = false;
                int n = ((RemoteField[])object).length - 1;
                while (n >= 0) {
                    if (string3.equals(object[n].getName())) {
                        remoteValue2 = ((RemoteObject)remoteValue).getFieldValue(n);
                        bl3 = true;
                        break;
                    }
                    --n;
                }
                if (!bl3) {
                    if (bl2) {
                        return "\"" + string + "\" is not a valid local, class name, or field of " + remoteValue.description();
                    }
                    return "\"" + string3 + "\" is not a valid field of " + remoteValue.description();
                }
                bl2 = false;
                if (remoteValue2 != null && remoteValue2.isObject()) {
                    remoteValue = remoteValue2;
                    remoteValue2 = remoteInt;
                }
                string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                continue;
            }
            if (string3.equals("[")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return "\"" + string + "\" is not a valid expression.";
                }
                string3 = stringTokenizer.nextToken("]");
                try {
                    int n = Integer.valueOf(string3);
                    remoteValue2 = ((RemoteArray)remoteValue).getElement(n);
                }
                catch (NumberFormatException numberFormatException) {
                    return "\"" + string3 + "\" is not a valid decimal number.";
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return String.valueOf(string3) + " is out of bounds for " + remoteValue.description();
                }
                if (remoteValue2 != null && remoteValue2.isObject()) {
                    remoteValue = remoteValue2;
                    remoteValue2 = remoteInt;
                }
                if (!stringTokenizer.hasMoreTokens() || !(string3 = stringTokenizer.nextToken()).equals("]")) {
                    return "\"" + string + "\" is not a valid expression.";
                }
                string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken(printDelimiters) : null;
                continue;
            }
            if (string3.equals("(")) {
                return "print <method> not supported yet.";
            }
            return "invalid expression";
        }
        this.out.print(String.valueOf(string) + " = ");
        if (remoteValue2 != remoteInt) {
            this.out.println(remoteValue2 == null ? "null" : remoteValue2.description());
        } else if (bl && remoteValue instanceof RemoteObject) {
            RemoteClass[] remoteClassArray;
            this.out.println(String.valueOf(remoteValue.description()) + " {");
            if (remoteValue instanceof RemoteClass) {
                object = (RemoteClass)remoteValue;
                this.out.print("    superclass = ");
                RemoteClass remoteClass = ((RemoteClass)object).getSuperclass();
                this.out.println(remoteClass == null ? "null" : remoteClass.description());
                this.out.print("    loader = ");
                RemoteObject remoteObject = ((RemoteClass)object).getClassLoader();
                this.out.println(remoteObject == null ? "null" : remoteObject.description());
                remoteClassArray = ((RemoteClass)object).getInterfaces();
                if (remoteClassArray != null && remoteClassArray.length > 0) {
                    this.out.println("    interfaces:");
                    int n = 0;
                    while (n < remoteClassArray.length) {
                        this.out.println("        " + remoteClassArray[n]);
                        ++n;
                    }
                }
            }
            object = ((RemoteObject)remoteValue).getFields();
            if (remoteValue instanceof RemoteClass && ((Object)object).length > 0) {
                this.out.println();
            }
            int n = 0;
            while (n < ((Object)object).length) {
                String string4 = ((RemoteField)object[n]).getTypedName();
                remoteClassArray = ((RemoteField)object[n]).getModifiers();
                this.out.print("    " + (String)remoteClassArray + string4 + " = ");
                RemoteValue remoteValue3 = ((RemoteObject)remoteValue).getFieldValue(n);
                this.out.println(remoteValue3 == null ? "null" : remoteValue3.description());
                ++n;
            }
            this.out.println("}");
        } else {
            this.out.println(remoteValue.toString());
        }
        return null;
    }

    void help() {
        this.out.println("** command list **");
        this.out.println("threads [threadgroup]     -- list threads");
        this.out.println("thread <thread id>        -- set default thread");
        this.out.println("suspend [thread id(s)]    -- suspend threads (default: all)");
        this.out.println("resume [thread id(s)]     -- resume threads (default: all)");
        this.out.println("where [thread id] | all   -- dump a thread's stack");
        this.out.println("wherei [thread id] | all  -- dump a thread's stack, with pc info");
        this.out.println("threadgroups              -- list threadgroups");
        this.out.println("threadgroup <name>        -- set current threadgroup\n");
        this.out.println("print <id> [id(s)]        -- print object or field");
        this.out.println("dump <id> [id(s)]         -- print all object information\n");
        this.out.println("locals                    -- print all local variables in current stack frame\n");
        this.out.println("classes                   -- list currently known classes");
        this.out.println("methods <class id>        -- list a class's methods\n");
        this.out.println("stop in <class id>.<method> -- set a breakpoint in a method");
        this.out.println("stop at <class id>:<line> -- set a breakpoint at a line");
        this.out.println("up [n frames]             -- move up a thread's stack");
        this.out.println("down [n frames]           -- move down a thread's stack");
        this.out.println("clear <class id>:<line>   -- clear a breakpoint");
        this.out.println("step                      -- execute current line");
        this.out.println("step up                   -- execute until the current method returns to its caller");
        this.out.println("stepi                     -- execute current instruction");
        this.out.println("next                      -- step one line (step OVER calls)");
        this.out.println("cont                      -- continue execution from breakpoint\n");
        this.out.println("catch <class id>          -- break for the specified exception");
        this.out.println("ignore <class id>         -- ignore when the specified exception\n");
        this.out.println("list [line number|method] -- print source code");
        this.out.println("use [source file path]    -- display or change the source path\n");
        this.out.println("memory                    -- report memory usage");
        this.out.println("gc                        -- free unused objects\n");
        this.out.println("load classname            -- load Java class to be debugged");
        this.out.println("run <class> [args]        -- start execution of a loaded Java class");
        this.out.println("!!                        -- repeat last command");
        this.out.println("help (or ?)               -- list commands");
        this.out.println("exit (or quit)            -- exit debugger");
    }

    void executeCommand(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().toLowerCase();
        try {
            if (string.equals("print")) {
                this.print(stringTokenizer, false);
                return;
            }
            if (string.equals("dump")) {
                this.print(stringTokenizer, true);
                return;
            }
            if (string.equals("locals")) {
                this.locals();
                return;
            }
            if (string.equals("classes")) {
                this.classes();
                return;
            }
            if (string.equals("methods")) {
                this.methods(stringTokenizer);
                return;
            }
            if (string.equals("threads")) {
                this.threads(stringTokenizer);
                return;
            }
            if (string.equals("thread")) {
                this.thread(stringTokenizer);
                return;
            }
            if (string.equals("suspend")) {
                this.suspend(stringTokenizer);
                return;
            }
            if (string.equals("resume")) {
                this.resume(stringTokenizer);
                return;
            }
            if (string.equals("threadgroups")) {
                this.threadGroups();
                return;
            }
            if (string.equals("threadgroup")) {
                this.threadGroup(stringTokenizer);
                return;
            }
            if (string.equals("catch")) {
                this.catchException(stringTokenizer);
                return;
            }
            if (string.equals("ignore")) {
                this.ignoreException(stringTokenizer);
                return;
            }
            if (string.equals("cont")) {
                this.cont();
                return;
            }
            if (string.equals("step")) {
                this.step(stringTokenizer);
                return;
            }
            if (string.equals("stepi")) {
                this.stepi();
                return;
            }
            if (string.equals("next")) {
                this.next();
                return;
            }
            if (string.equals("kill")) {
                this.kill(stringTokenizer);
                return;
            }
            if (string.equals("where")) {
                this.where(stringTokenizer, false);
                return;
            }
            if (string.equals("wherei")) {
                this.where(stringTokenizer, true);
                return;
            }
            if (string.equals("up")) {
                this.up(stringTokenizer);
                return;
            }
            if (string.equals("down")) {
                this.down(stringTokenizer);
                return;
            }
            if (string.equals("load")) {
                this.load(stringTokenizer);
                return;
            }
            if (string.equals("run")) {
                this.run(stringTokenizer);
                return;
            }
            if (string.equals("memory")) {
                this.memory();
                return;
            }
            if (string.equals("gc")) {
                this.gc();
                return;
            }
            if (string.equals("stop")) {
                this.stop(stringTokenizer);
                return;
            }
            if (string.equals("clear")) {
                this.clear(stringTokenizer);
                return;
            }
            if (string.equals("list")) {
                this.list(stringTokenizer);
                return;
            }
            if (string.equals("use")) {
                this.use(stringTokenizer);
                return;
            }
            if (string.equals("help") || string.equals("?")) {
                this.help();
                return;
            }
            if (string.equals("quit") || string.equals("exit")) {
                this.debugger.close();
                System.exit(0);
                return;
            }
            this.out.println("huh? Try help...");
            return;
        }
        catch (Exception exception) {
            this.out.println("Internal exception:");
            this.out.flush();
            exception.printStackTrace();
            return;
        }
    }

    void readCommandFile(File file) {
        try {
            if (file.canRead()) {
                String string;
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                while ((string = dataInputStream.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    this.executeCommand(stringTokenizer);
                }
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public TTY(String string, String string2, String string3, String string4, PrintStream printStream, PrintStream printStream2, boolean bl) throws Exception {
        Object object;
        System.out.println("Initializing jdb...");
        this.out = printStream;
        this.console = printStream2;
        this.debugger = string2 == null ? new RemoteDebugger(string3, this, bl) : new RemoteDebugger(string, string2, this, bl);
        DataInputStream dataInputStream = new DataInputStream(System.in);
        String string5 = null;
        if (string4 != null && string4.length() > 0) {
            object = new StringTokenizer(string4);
            this.load((StringTokenizer)object);
            this.lastArgs = string4;
        }
        Thread.currentThread().setPriority(5);
        object = new File(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "jdb.ini");
        if (!((File)object).canRead()) {
            object = new File(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".jdbrc");
        }
        this.readCommandFile((File)object);
        object = new File(String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "startup.jdb");
        this.readCommandFile((File)object);
        while (true) {
            StringTokenizer stringTokenizer;
            this.printPrompt();
            String string6 = dataInputStream.readLine();
            if (string6 == null) {
                this.out.println("Input stream closed.");
                return;
            }
            if (string6.startsWith("!!") && string5 != null) {
                string6 = String.valueOf(string5) + string6.substring(2);
                this.out.println(string6);
            }
            if (!(stringTokenizer = new StringTokenizer(string6)).hasMoreTokens()) continue;
            string5 = string6;
            this.executeCommand(stringTokenizer);
        }
    }

    private static void usage() {
        System.out.println("Usage: jdb <options> <classes>");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("    -help             print out this message and exit");
        System.out.println("    -version          print out the build version and exit");
        System.out.println("    -host <hostname>  host machine of interpreter to attach to");
        System.out.println("    -password <psswd> password of interpreter to attach to (from -debug)");
        System.out.println("options forwarded to debuggee process:");
        System.out.println("    -v -verbose       turn on verbose mode");
        System.out.println("    -debug            enable remote JAVA debugging");
        System.out.println("    -noasyncgc        don't allow asynchronous garbage collection");
        System.out.println("    -verbosegc        print a message when garbage collection occurs");
        System.out.println("    -noclassgc        disable class garbage collection");
        System.out.println("    -cs -checksource  check if source is newer when loading classes");
        System.out.println("    -ss<number>       set the maximum native stack size for any thread");
        System.out.println("    -oss<number>      set the maximum Java stack size for any thread");
        System.out.println("    -ms<number>       set the initial Java heap size");
        System.out.println("    -mx<number>       set the maximum Java heap size");
        System.out.println("    -D<name>=<value>  set a system property");
        System.out.println("    -classpath <directories separated by colons>");
        System.out.println("                      list directories in which to look for classes");
        System.out.println("    -prof[:<file>]    output profiling data to ./java.prof or ./<file>");
        System.out.println("    -verify           verify all classes when read in");
        System.out.println("    -verifyremote     verify classes read in over the network [default]");
        System.out.println("    -noverify         do not verify any class");
        System.out.println("    -dbgtrace         print info for debugging jdb");
        System.out.println();
        System.out.println("For command help type 'help' at jdb prompt");
    }

    public static void main(String[] stringArray) {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            string = "localhost";
        }
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string6 = stringArray[n];
            if (string6.equals("-dbgtrace")) {
                bl = true;
            } else if (string6.equals("-cs") || string6.equals("-checksource") || string6.equals("-noasyncgc") || string6.equals("-prof") || string6.equals("-v") || string6.equals("-verbose") || string6.equals("-verify") || string6.equals("-noverify") || string6.equals("-verifyremote") || string6.equals("-verbosegc") || string6.startsWith("-ms") || string6.startsWith("-mx") || string6.startsWith("-ss") || string6.startsWith("-oss") || string6.startsWith("-D")) {
                string5 = String.valueOf(string5) + string6 + " ";
            } else if (string6.equals("-classpath")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No classpath specified.");
                    TTY.usage();
                    System.exit(1);
                }
                string5 = String.valueOf(string5) + string6 + " " + stringArray[++n] + " ";
            } else if (string6.equals("-host")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No host specified.");
                    TTY.usage();
                    System.exit(1);
                }
                string2 = stringArray[++n];
            } else if (string6.equals("-password")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No password specified.");
                    TTY.usage();
                    System.exit(1);
                }
                string3 = stringArray[++n];
            } else if (string6.equals("-help")) {
                TTY.usage();
                System.exit(0);
            } else if (string6.equals("-version")) {
                System.out.println("jdb version 98/12/02");
                System.exit(0);
            } else {
                if (!string6.startsWith("-")) {
                    string4 = String.valueOf(string6) + " ";
                    ++n;
                    while (n < stringArray.length) {
                        string4 = String.valueOf(string4) + stringArray[n] + " ";
                        ++n;
                    }
                    break;
                }
                System.out.println("invalid option: " + string6);
                TTY.usage();
                System.exit(1);
            }
            ++n;
        }
        if (string2 != null && string3 == null) {
            System.out.println("A debug password must be specified for remote debugging.");
            System.exit(1);
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            if (!string2.equals(string) && string3.length() == 0) {
                System.out.println("No password supplied for accessing remote Java interpreter.");
                System.out.println("The password is reported by the remote interpreterwhen it is started.");
                System.exit(1);
            }
            new TTY(string2, string3, string5, string4, System.out, System.out, bl);
            return;
        }
        catch (SocketException socketException) {
            System.out.println("Failed accessing debugging session on " + string2 + ": invalid password.");
            return;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Failed accessing debugging session on " + string2 + ": invalid password.");
            return;
        }
        catch (Exception exception) {
            System.out.print("Internal exception:  ");
            System.out.flush();
            exception.printStackTrace();
            return;
        }
    }
}

