/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import sun.tools.java.BinaryClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.Package;
import sun.tools.java.Type;

public class LoadEnvironment
extends Environment
implements Constants {
    public PrintWriter output;
    public int flags;
    public ClassPath path;
    Hashtable packages = new Hashtable(31);
    Hashtable classes = new Hashtable(351);

    public LoadEnvironment(PrintWriter printWriter) {
        this.output = printWriter;
    }

    protected int loadFileFlags() {
        return 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean classExists(Identifier identifier) {
        if (identifier.isInner()) {
            identifier = identifier.getTopName();
        }
        Type type = Type.tClass(identifier);
        try {
            ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
            if (classDeclaration != null) {
                return classDeclaration.getName().equals(identifier);
            }
            return this.getPackage(identifier.getQualifier()).getBinaryFile(identifier.getName()) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public ClassDeclaration getClassDeclaration(Identifier identifier) {
        return this.getClassDeclaration(Type.tClass(identifier));
    }

    public ClassDeclaration getClassDeclaration(Type type) {
        ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
        if (classDeclaration == null) {
            classDeclaration = new ClassDeclaration(type.getClassName());
            this.classes.put(type, classDeclaration);
        }
        return classDeclaration;
    }

    public Package getPackage(Identifier identifier) throws IOException {
        Package package_ = (Package)this.packages.get(identifier);
        if (package_ == null) {
            package_ = new Package(this.path, identifier);
            this.packages.put(identifier, package_);
        }
        return package_;
    }

    BinaryClass loadFile(ClassFile classFile) throws IOException {
        System.currentTimeMillis();
        InputStream inputStream = classFile.getInputStream();
        BinaryClass binaryClass = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            binaryClass = BinaryClass.load(new Environment(this, classFile), dataInputStream, this.loadFileFlags());
        }
        catch (ClassFormatError classFormatError) {
            System.err.println("Error: bad class format" + classFile.getPath() + classFormatError.getMessage());
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        inputStream.close();
        return binaryClass;
    }

    public void loadDefinition(ClassDeclaration classDeclaration) {
        switch (classDeclaration.getStatus()) {
            case 0: {
                Package package_;
                Identifier identifier = classDeclaration.getName();
                try {
                    package_ = this.getPackage(identifier.getQualifier());
                }
                catch (IOException iOException) {
                    System.err.println("Error: I/O Exception - " + iOException.getMessage());
                    return;
                }
                ClassFile classFile = package_.getBinaryFile(identifier.getName());
                if (classFile == null) {
                    System.err.println("Error: No binary file '" + identifier.getName() + "'");
                    return;
                }
                BinaryClass binaryClass = null;
                try {
                    binaryClass = this.loadFile(classFile);
                }
                catch (IOException iOException) {
                    System.err.println("Error: I/O Exception - " + iOException.getMessage() + " in " + classFile);
                    return;
                }
                if (binaryClass == null) {
                    System.err.println("Error: Class not found in '" + classFile + "'");
                    return;
                }
                if (!binaryClass.getName().equals(identifier)) {
                    System.err.println("Error: Binary file '" + identifier.getName() + "'  contains " + binaryClass.getName());
                    binaryClass = null;
                }
                classDeclaration.setDefinition(binaryClass, 2);
                binaryClass.hasBeenLoaded(this);
                return;
            }
        }
        System.err.println("Error: No binary file");
    }
}

