/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Domino {
    private static final String SESSION_ID = "SessionID";
    private static final int MAX_COOKIES_PER_REQ = 50;
    private static final String SERVLET_URI = "/servlet";
    private static final int SERVLET_URI_LEN = 8;
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String RESBUNDLE_FILE = "lotus.domino.servlet.ServletResources";
    private static final int PARAM_HTABSIZE = 5;
    public static final boolean DEBUG_TRACING_ON = true;
    public static final String[] SPECIAL_PACKAGES = new String[]{"java.", "javax.", "lotus.notes.", "lotus.domino."};
    public static final int ALL = Integer.MAX_VALUE;
    public static final int NONE = 0;
    public static final int ALWAYS = 0;
    public static final int INIT = 1;
    public static final int SERVICE_REQUEST = 2;
    public static final int REQUEST_DATA = 4;
    public static final int RESPONSE_HEADERS = 8;
    public static final int SIGNAL = 16;
    public static final int EXCEPTION_TRACING = 64;
    public static final int SERVLET_MANAGER = 128;
    public static final int CLASSLOADER = 256;
    public static final int CLASSLOADER_VERBOSE = 512;
    public static final int SESSION_CONTEXT = 1024;
    public static final int POST_DATA = 2048;
    public static String sessionCookieName = "SessionID";
    public static int maxCookiesPerRequest = 50;
    public static boolean sendSetCookie2Header = true;
    public static boolean waitForSessionThread;
    public static boolean gcOnShutdown;
    public static boolean useClassLoader;
    public static boolean allowSessionIdFromURL;
    public static boolean allowSessionIdFromCookie;
    public static String defaultCharset;
    public static String servletURI;
    public static int servletUriLen;
    public static String[] specialPackages;
    public static boolean allowPackageNames;
    private static int c_debugFlags;
    protected static Properties c_servletManagerProps;
    protected static Properties c_servletsProps;
    protected static PropertyResourceBundle c_resBundle;
    protected static Hashtable c_extensionMap;
    protected static Hashtable c_classToAliasMap;
    protected static PrintStream c_out;
    protected static PrintStream c_err;
    public static final String CHARSET_EQ = "charset=";
    public static boolean debugCookies;
    public static boolean commasNotDelimitersInCookieHeader;

    private Domino() {
    }

    public static void init() {
        c_servletManagerProps = new Properties();
        c_servletsProps = new Properties();
        c_extensionMap = null;
        c_classToAliasMap = null;
        c_out = System.out;
        c_err = System.err;
        Locale locale = null;
        try {
            locale = System.getProperty("user.region") == null ? new Locale(System.getProperty("user.language"), "") : new Locale(System.getProperty("user.language"), System.getProperty("user.region"));
        }
        catch (Exception exception) {
            System.err.println("Unable to obtain system locale. Defaulting to English.");
            locale = new Locale("en", "US");
        }
        c_resBundle = (PropertyResourceBundle)ResourceBundle.getBundle(RESBUNDLE_FILE, locale);
    }

    public static void term() {
        c_servletManagerProps = null;
        c_servletsProps = null;
        c_extensionMap = null;
        c_classToAliasMap = null;
        c_resBundle = null;
        c_out = System.out;
        c_err = System.err;
    }

    public static void loadServerProperties(String string) {
        String string2 = String.valueOf(string) + File.separator + "domino.properties";
        Domino.loadProperties(c_servletManagerProps, string2);
        string2 = String.valueOf(string) + File.separator + "servletmanager.properties";
        Domino.loadProperties(c_servletManagerProps, string2);
        string2 = String.valueOf(string) + File.separator + "servlets.properties";
        Domino.loadProperties(c_servletsProps, string2);
        Domino.loadDebugFlags();
        Domino.loadDefaultGlobalSettings();
    }

    private static void loadProperties(Properties properties, String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static void loadDebugFlags() {
        if (Domino.getBoolProp("server.debug.init", false)) {
            Domino.setTracing(1, true);
        }
        if (Domino.getBoolProp("server.debug.service.request", false)) {
            Domino.setTracing(2, true);
        }
        if (Domino.getBoolProp("server.debug.request.data", false)) {
            Domino.setTracing(4, true);
        }
        if (Domino.getBoolProp("server.debug.response.headers", false)) {
            Domino.setTracing(8, true);
        }
        if (Domino.getBoolProp("server.debug.signal", false)) {
            Domino.setTracing(16, true);
        }
        if (Domino.getBoolProp("server.debug.exception.tracing", false)) {
            Domino.setTracing(64, true);
        }
        if (Domino.getBoolProp("server.debug.servlet.manager", false)) {
            Domino.setTracing(128, true);
        }
        if (Domino.getBoolProp("server.debug.classloader", false)) {
            Domino.setTracing(256, true);
        }
        if (Domino.getBoolProp("server.debug.classloader.verbose", false)) {
            Domino.setTracing(512, true);
        }
        if (Domino.getBoolProp("server.debug.session.context", false)) {
            Domino.setTracing(1024, true);
        }
        if (Domino.getBoolProp("server.debug.all", false)) {
            Domino.setTracing(Integer.MAX_VALUE);
        }
        Domino.trace("msg.tracing_flags", Integer.toHexString(c_debugFlags), 128);
        int n = Domino.getIntProp("server.debugFlags", 0);
        if (n != 0) {
            Domino.setTracing(n);
            Domino.trace("msg.tracing_flags", Integer.toHexString(c_debugFlags), 128);
        }
    }

    private static void loadDefaultGlobalSettings() {
        sessionCookieName = Domino.getStringProp("server.session.cookie.name", SESSION_ID);
        maxCookiesPerRequest = Domino.getIntProp("server.maxcookiespersession", 50);
        sendSetCookie2Header = Domino.getBoolProp("server.sendSetCookie2Header", true);
        waitForSessionThread = Domino.getBoolProp("server.waitforsessionthread", false);
        gcOnShutdown = Domino.getBoolProp("server.gconshutdown", false);
        useClassLoader = Domino.getBoolProp("server.useclassloader", true);
        allowSessionIdFromURL = Domino.getBoolProp("server.allowsessionidfromurl", false);
        allowSessionIdFromCookie = Domino.getBoolProp("server.allowsessionidfromcookie", true);
        defaultCharset = Domino.getStringProp("server.defaultcharset", DEFAULT_CHARSET);
        servletURI = Domino.getStringProp("server.servleturi", SERVLET_URI);
        String string = c_servletsProps.getProperty("servlets.commasNotDelimitersInCookieHeader");
        commasNotDelimitersInCookieHeader = string != null ? string.equals("true") : false;
        string = c_servletsProps.getProperty("servlets.debugCookies");
        boolean bl = debugCookies = string != null ? string.equals("true") : false;
        if (!servletURI.endsWith("/")) {
            servletURI = String.valueOf(servletURI) + "/";
        }
        servletUriLen = servletURI.length();
        servletURI = servletURI.toLowerCase();
        allowPackageNames = Domino.getBoolProp("server.allowpackagenames", false);
    }

    private static final String nullValue(String string) {
        if (string == null) {
            return "null";
        }
        return string;
    }

    public static boolean getBoolProp(String string, boolean bl) {
        String string2 = c_servletManagerProps.getProperty(string);
        Domino.trace("msg.property_key", string, Domino.nullValue(string2), new Boolean(bl), 128);
        if (string2 != null) {
            return string2.equals("true");
        }
        return bl;
    }

    public static long getLongProp(String string, long l) {
        long l2;
        block2: {
            String string2 = c_servletManagerProps.getProperty(string);
            Domino.trace("msg.property_key", string, Domino.nullValue(string2), new Long(l), 128);
            l2 = l;
            if (string2 == null || string2.trim().length() <= 0) break block2;
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l2;
    }

    public static int getIntProp(String string, int n) {
        int n2;
        block2: {
            String string2 = c_servletManagerProps.getProperty(string);
            Domino.trace("msg.property_key", string, Domino.nullValue(string2), new Integer(n), 128);
            n2 = n;
            if (string2 == null || string2.trim().length() <= 0) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public static String getStringProp(String string, String string2) {
        String string3 = c_servletManagerProps.getProperty(string, string2);
        Domino.trace("msg.property_key", string, Domino.nullValue(string3), string2, 128);
        return string3;
    }

    public static Hashtable getInitParameters(String string) {
        String string2 = c_servletsProps.getProperty("servlet." + string + ".initArgs");
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        if (string2 == null) {
            return hashtable;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf("=");
            if (n == -1) {
                hashtable.put(string3, "");
                continue;
            }
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            hashtable.put(string4, string5);
        }
        if (hashtable.size() > 0) {
            return hashtable;
        }
        return null;
    }

    public static String[] getStartupList() {
        String string = c_servletsProps.getProperty("servlets.startup");
        if (string != null) {
            String[] stringArray;
            Vector<String[]> vector = new Vector<String[]>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                stringArray = stringTokenizer.nextToken().trim();
                if (stringArray.length() <= 0) continue;
                vector.addElement(stringArray);
            }
            if (vector.size() > 0) {
                stringArray = new String[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    stringArray[n] = (String)vector.elementAt(n);
                    ++n;
                }
                return stringArray;
            }
        }
        return null;
    }

    public static String getNameFromAlias(String string) {
        if (string == null) {
            return null;
        }
        String string2 = c_servletsProps.getProperty("servlet." + string + ".code");
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private static Hashtable getExtensionMap() {
        if (c_extensionMap != null) {
            return c_extensionMap;
        }
        Domino.trace("msg.building_ext_map", 128);
        c_extensionMap = new Hashtable();
        Enumeration<?> enumeration = c_servletsProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("servlet.") || !string.endsWith(".extension")) continue;
            String string2 = string.substring(8, string.length() - 10);
            String string3 = c_servletsProps.getProperty(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (string4.length() <= 0) continue;
                Domino.trace("msg.adding_servlet_ext", string2, string4, 128);
                c_extensionMap.put(string4, string2);
            }
        }
        return c_extensionMap;
    }

    private static Hashtable getClassToAliasMap() {
        if (c_classToAliasMap != null) {
            return c_classToAliasMap;
        }
        Domino.trace("msg.building_class_to_alias_map", 128);
        c_classToAliasMap = new Hashtable();
        Enumeration<?> enumeration = c_servletsProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("servlet.") || !string.endsWith(".code")) continue;
            String string2 = string.substring(8, string.length() - 5);
            String string3 = c_servletsProps.getProperty(string);
            Domino.trace("msg.adding_class_to_alias", string3, string2, 128);
            c_classToAliasMap.put(string3, string2);
        }
        return c_classToAliasMap;
    }

    private static String mapFileExtensionToServlet(String string) {
        Hashtable hashtable = Domino.getExtensionMap();
        return (String)hashtable.get(string);
    }

    private static String mapFilePathToServlet(String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith(servletURI)) {
            int n;
            String string3 = string.substring(servletUriLen);
            int n2 = string3.indexOf(47);
            if (n2 >= 0) {
                string3 = string3.substring(0, n2);
            }
            if ((n = string3.indexOf(63)) >= 0) {
                string3 = string3.substring(0, n);
            }
            return string3;
        }
        return null;
    }

    public static boolean badServletName(String string) {
        if (allowPackageNames) {
            int n = 0;
            while (n < specialPackages.length) {
                if (string.startsWith(specialPackages[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return string.indexOf(46) != -1;
    }

    public static String mapServletURI(String string) {
        String string2 = Domino.mapFilePathToServlet(string);
        if (string2 != null) {
            Hashtable hashtable = Domino.getClassToAliasMap();
            if (hashtable.get(string2) != null) {
                return null;
            }
            if (Domino.badServletName(string2)) {
                return null;
            }
            return string2;
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            int n2 = string.indexOf(47, n);
            String string3 = n2 > 0 ? string.substring(n + 1, n2 - 1) : string.substring(n + 1);
            string2 = Domino.mapFileExtensionToServlet(string3);
        }
        return string2;
    }

    public static String getCharEncodingFromContentType(String string, String string2) {
        if (string == null) {
            return string2;
        }
        int n = string.indexOf(CHARSET_EQ);
        if (n == -1) {
            return string2;
        }
        String string3 = string.substring(n + CHARSET_EQ.length());
        if ((n = string3.indexOf(";")) > -1) {
            return string3.substring(0, n);
        }
        return string3;
    }

    public static String getMimeTypeFromContentType(String string, String string2) {
        if (string == null) {
            return string2;
        }
        int n = string.indexOf(";");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n - 1);
    }

    public static String getMessageText(String string) {
        if (c_resBundle == null) {
            return "";
        }
        try {
            return c_resBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
    }

    public static String getMessageText(String string, Object object) {
        if (c_resBundle == null) {
            return "";
        }
        try {
            Object[] objectArray = new Object[]{object};
            return MessageFormat.format(c_resBundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
    }

    public static String getMessageText(String string, Object object, Object object2) {
        if (c_resBundle == null) {
            return "";
        }
        try {
            Object[] objectArray = new Object[]{object, object2};
            return MessageFormat.format(c_resBundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
    }

    public static void trace(String string, int n) {
        if (c_resBundle == null) {
            return;
        }
        if ((c_debugFlags & n) == n) {
            try {
                String string2 = c_resBundle.getString(string);
                c_out.println(string2);
                return;
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
    }

    public static void trace(String string, Object object, int n) {
        if (c_resBundle == null) {
            return;
        }
        if ((c_debugFlags & n) == n) {
            try {
                Object[] objectArray = new Object[]{object};
                String string2 = MessageFormat.format(c_resBundle.getString(string), objectArray);
                c_out.println(string2);
                return;
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
    }

    public static void trace(String string, Object object, Object object2, int n) {
        if (c_resBundle == null) {
            return;
        }
        if ((c_debugFlags & n) == n) {
            try {
                Object[] objectArray = new Object[]{object, object2};
                String string2 = MessageFormat.format(c_resBundle.getString(string), objectArray);
                c_out.println(string2);
                return;
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
    }

    public static void trace(String string, Object object, Object object2, Object object3, int n) {
        if (c_resBundle == null) {
            return;
        }
        if ((c_debugFlags & n) == n) {
            try {
                Object[] objectArray = new Object[]{object, object2, object3};
                String string2 = MessageFormat.format(c_resBundle.getString(string), objectArray);
                c_out.println(string2);
                return;
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
    }

    public static void logError(String string) {
        if (c_resBundle == null) {
            return;
        }
        String string2 = c_resBundle.getString(string);
        c_err.println(string2);
    }

    public static void logError(String string, Object object) {
        if (c_resBundle == null) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        String string2 = MessageFormat.format(c_resBundle.getString(string), objectArray);
        c_err.println(string2);
    }

    public static void logError(String string, Object object, Object object2) {
        if (c_resBundle == null) {
            return;
        }
        Object[] objectArray = new Object[]{object, object2};
        String string2 = MessageFormat.format(c_resBundle.getString(string), objectArray);
        c_err.println(string2);
    }

    public static void log(String string) {
        c_out.println(string);
    }

    public static void log(Throwable throwable, String string) {
        c_out.println(string);
        c_out.println(String.valueOf(throwable.toString()) + ": " + throwable.getMessage());
        String string2 = Domino.getStackTraceAsString(throwable);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            c_out.println(stringTokenizer.nextToken());
        }
    }

    public static void trace(Throwable throwable) {
        c_out.println(String.valueOf(throwable.toString()) + ": " + throwable.getMessage());
        if ((c_debugFlags & 0x40) == 64) {
            String string = Domino.getStackTraceAsString(throwable);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                c_out.println(stringTokenizer.nextToken());
            }
        }
    }

    public static String getStackTraceAsString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        throwable.printStackTrace(printWriter);
        return byteArrayOutputStream.toString();
    }

    public static void setTracing(int n) {
        c_debugFlags = n;
    }

    public static void setTracing(int n, boolean bl) {
        if (bl) {
            c_debugFlags |= n;
            return;
        }
        c_debugFlags ^= n;
    }

    public static boolean isTracing(int n) {
        return (c_debugFlags & n) != 0;
    }

    static {
        useClassLoader = true;
        allowSessionIdFromCookie = true;
        defaultCharset = DEFAULT_CHARSET;
        servletURI = SERVLET_URI;
        servletUriLen = 8;
        specialPackages = SPECIAL_PACKAGES;
        allowPackageNames = true;
    }
}

