/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import lotus.domino.servlet.Domino;
import lotus.domino.servlet.DominoHttpServletResponse;
import lotus.domino.servlet.DominoServletInputStream;
import lotus.domino.servlet.NativeStub;
import lotus.domino.servlet.NativeStubContext;
import lotus.domino.servlet.NativeStubException;
import lotus.domino.servlet.ServletManager;

public class DominoHttpServletRequest
implements HttpServletRequest {
    public static final String REMOTE_ADDR = "REMOTE_ADDR";
    public static final String REMOTE_HOST = "REMOTE_HOST";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String SERVER_PORT = "SERVER_PORT";
    public static final String QUERY_STRING = "QUERY_STRING";
    public static final String REQUEST_CONTENT_LENGTH = "REQUEST_CONTENT_LENGTH";
    public static final String SERVER_PROTOCOL = "SERVER_PROTOCOL";
    public static final String HTTPS = "HTTPS";
    public static final String AUTH_TYPE = "AUTH_TYPE";
    public static final String PATH_INFO = "PATH_INFO";
    public static final String PATH_TRANSLATED = "PATH_TRANSLATED";
    public static final String REQUEST_METHOD = "REQUEST_METHOD";
    public static final String REMOTE_USER = "REMOTE_USER";
    public static final String REQHDR = "REQHDR";
    public static final String SCRIPT_NAME = "SCRIPT_NAME";
    public static final String URI = "URI";
    public static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    public static final int REQHDR_HTABSIZE = 17;
    public static final int QPARAM_HTABSIZE = 5;
    private NativeStubContext i_api;
    private Hashtable i_parms;
    private Hashtable i_headers;
    private ServletInputStream i_inStr;
    private BufferedReader i_inReader;
    private String i_sessionId;
    private DominoHttpServletResponse i_response;
    private boolean i_sessionIdFromURL;
    private boolean i_sessionIdFromCookie;
    private static Random c_randGenerator = new Random();

    public DominoHttpServletRequest(NativeStubContext nativeStubContext) {
        this.i_api = nativeStubContext;
        this.i_response = null;
        this.i_sessionId = null;
        this.i_sessionIdFromURL = false;
        this.i_sessionIdFromCookie = false;
        this.parseHeaders();
    }

    public void close() throws IOException {
        if (this.i_inStr != null) {
            this.i_inStr.close();
        }
        if (this.i_inReader != null) {
            this.i_inReader.close();
        }
        this.i_inStr = null;
        this.i_inReader = null;
        this.i_headers = null;
        this.i_sessionId = null;
        this.i_response = null;
        this.i_response = null;
        this.i_response = null;
    }

    public Cookie[] getCookies() {
        String string = this.getHeader("Cookie");
        if (string == null) {
            return null;
        }
        Cookie[] cookieArray = null;
        Vector vector = new Vector();
        DominoHttpServletRequest.parseCookieString(string, vector);
        if (vector.size() > 0) {
            cookieArray = new Cookie[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                cookieArray[n] = (Cookie)vector.elementAt(n);
                ++n;
            }
        }
        return cookieArray;
    }

    private static void parseCookieString(String string, Vector vector) {
        Cookie cookie = null;
        String string2 = Domino.commasNotDelimitersInCookieHeader ? ";" : ",;";
        if (Domino.debugCookies) {
            System.out.println("Parsing cookie string: '" + string + "'");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = null;
            String string4 = null;
            int n = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            string3 = stringTokenizer2.nextToken().trim();
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken("").trim();
            }
            if (!string3.startsWith("$")) {
                if (vector.size() >= Domino.maxCookiesPerRequest) break;
                if (Domino.debugCookies) {
                    System.out.println("Cookie name: '" + string3 + "' cookie value: '" + string4 + "'");
                }
                cookie = new Cookie(string3, string4);
                cookie.setVersion(n);
                vector.addElement(cookie);
                continue;
            }
            if (string3.equalsIgnoreCase("$version")) {
                n = Integer.parseInt(string4);
                if (cookie == null) continue;
                cookie.setVersion(n);
                continue;
            }
            if (string3.equalsIgnoreCase("$path") && cookie != null) {
                cookie.setPath(string4);
                continue;
            }
            if (!string3.equalsIgnoreCase("$domain") || cookie == null) continue;
            cookie.setDomain(string4);
        }
    }

    private void parseHeaders() {
        try {
            String string = NativeStub.extract(REQHDR);
            if (string == null) {
                this.i_headers = new Hashtable(17);
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            stringTokenizer.countTokens();
            this.i_headers = new Hashtable(17);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(":");
                if (n < 0) continue;
                String string3 = string2.substring(0, n).toUpperCase().trim();
                String string4 = string2.substring(n + 1).trim();
                this.i_headers.put(string3, string4);
            }
            return;
        }
        catch (Exception exception) {
            Domino.trace(exception);
            return;
        }
    }

    public String getMethod() {
        try {
            return this.i_api.extract(REQUEST_METHOD);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getRequestURI() {
        try {
            String string = this.i_api.extract(URI);
            int n = string.indexOf("?");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            return string;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getServletPath() {
        try {
            String string = this.i_api.extract(SCRIPT_NAME);
            return string;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getPathInfo() {
        try {
            String string = this.i_api.extract(PATH_INFO);
            return string;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getPathTranslated() {
        try {
            String string = this.i_api.extract(PATH_TRANSLATED);
            return string;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getQueryString() {
        try {
            return this.i_api.extract(QUERY_STRING);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getRemoteUser() {
        try {
            return this.i_api.extract(REMOTE_USER);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getRemoteAddr() {
        try {
            return this.i_api.extract(REMOTE_ADDR);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getRemoteHost() {
        try {
            return this.i_api.extract(REMOTE_HOST);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getRealPath(String string) {
        try {
            String string2 = this.i_api.translate(string);
            return string2;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public String getScheme() {
        try {
            String string = this.i_api.extract(HTTPS).toUpperCase();
            if (string.length() > 0 && string.equals("ON")) {
                return "https";
            }
            return "http";
        }
        catch (NativeStubException nativeStubException) {
            return "http";
        }
    }

    public int getServerPort() {
        try {
            String string = this.i_api.extract(SERVER_PORT);
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return -1;
        }
    }

    public String getProtocol() {
        try {
            return this.i_api.extract(SERVER_PROTOCOL);
        }
        catch (NativeStubException nativeStubException) {
            return "HTTP/1.1";
        }
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String getServerName() {
        try {
            return this.i_api.extract(SERVER_NAME);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public int getContentLength() {
        try {
            String string = this.i_api.extract(REQUEST_CONTENT_LENGTH);
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return -1;
        }
    }

    public String[] getParameterValues(String string) {
        if (this.i_parms == null) {
            this.loadParameters();
        }
        return (String[])this.i_parms.get(string);
    }

    public String getAuthType() {
        try {
            return this.i_api.extract(AUTH_TYPE);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }

    public void loadParameters() {
        String string = this.getQueryString();
        String string2 = this.getMethod().toUpperCase();
        if (string == null) {
            string = "";
        }
        if (string2.equals("GET")) {
            try {
                this.i_parms = this.parseQueryString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Domino.trace(illegalArgumentException);
                this.i_parms = new Hashtable(5);
            }
        } else if (string2.equals("POST")) {
            ServletInputStream servletInputStream;
            Object object;
            if (!this.readerInUse() && (object = Domino.getMimeTypeFromContentType(this.getContentType(), FORM_URL_ENCODED)) != null && ((String)object).equalsIgnoreCase(FORM_URL_ENCODED)) {
                servletInputStream = this.getInputStream();
                this.i_parms = HttpUtils.parsePostData((int)this.getContentLength(), (ServletInputStream)servletInputStream);
            }
            if (this.i_parms == null || this.i_parms.size() == 0) {
                try {
                    object = this.parseQueryString(string);
                    servletInputStream = ((Hashtable)object).keys();
                    while (servletInputStream.hasMoreElements()) {
                        if (this.i_parms == null) {
                            this.i_parms = new Hashtable();
                        }
                        String string3 = (String)servletInputStream.nextElement();
                        String[] stringArray = (String[])((Hashtable)object).get(string3);
                        int n = 0;
                        while (n < stringArray.length) {
                            this.addParameter(this.i_parms, string3, stringArray[n]);
                            ++n;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (this.i_parms == null) {
            this.i_parms = new Hashtable(5);
        }
    }

    private Hashtable parseQueryString(String string) {
        String[] stringArray = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf(61);
            if (n == -1) {
                string3 = this.parseName(string4, stringBuffer);
                string2 = null;
            } else {
                string3 = this.parseName(string4.substring(0, n), stringBuffer);
                string2 = this.parseName(string4.substring(n + 1, string4.length()), stringBuffer);
            }
            if (hashtable.containsKey(string3)) {
                String[] stringArray2 = (String[])hashtable.get(string3);
                stringArray = new String[stringArray2.length + 1];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray[n2] = stringArray2[n2];
                    ++n2;
                }
                stringArray[stringArray2.length] = string2;
            } else {
                stringArray = new String[]{string2};
            }
            hashtable.put(string3, stringArray);
        }
        return hashtable;
    }

    private String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                        n += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(n);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) break;
                        ++n;
                        break;
                    }
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void addParameter(Hashtable hashtable, String string, String string2) {
        String[] stringArray = (String[])hashtable.get(string);
        if (stringArray == null) {
            stringArray = new String[1];
        } else {
            String[] stringArray2 = new String[stringArray.length + 1];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n];
                ++n;
            }
            stringArray = stringArray2;
        }
        stringArray[stringArray.length - 1] = string2;
        hashtable.put(string, stringArray);
    }

    public String getParameter(String string) {
        String string2 = null;
        if (this.i_parms == null) {
            this.loadParameters();
        }
        if (this.i_parms != null) {
            String[] stringArray = (String[])this.i_parms.get(string);
            if (stringArray == null) {
                return null;
            }
            string2 = "";
            int n = 0;
            while (n < stringArray.length) {
                if (!string2.equals("")) {
                    string2 = String.valueOf(string2) + ",";
                }
                string2 = String.valueOf(string2) + stringArray[n];
                ++n;
            }
            return string2;
        }
        return null;
    }

    public Enumeration getParameterNames() {
        if (this.i_parms == null) {
            this.loadParameters();
        }
        return this.i_parms.keys();
    }

    public String getHeader(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.i_headers.get(string.toUpperCase());
    }

    public int getIntHeader(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = (String)this.i_headers.get(string.toUpperCase());
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public long getDateHeader(String string) {
        String string2 = (String)this.i_headers.get(string.toUpperCase());
        if (string2 == null) {
            return -1L;
        }
        try {
            return Date.parse(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1L;
        }
    }

    public Enumeration getHeaderNames() {
        if (this.i_headers != null) {
            return this.i_headers.keys();
        }
        return null;
    }

    public HttpSession getSession(boolean bl) {
        if (!ServletManager.getSessionContext().sessionsEnabled()) {
            return null;
        }
        this.getRequestedSessionId();
        if (bl) {
            if (this.i_sessionId == null && this.i_response != null) {
                Date date = new Date();
                String string = Long.toHexString(date.getTime());
                String string2 = Long.toHexString(c_randGenerator.nextLong());
                this.i_sessionId = String.valueOf(string.toUpperCase()) + string2.toUpperCase();
                Cookie cookie = new Cookie(Domino.sessionCookieName, this.i_sessionId);
                cookie.setPath("/");
                try {
                    this.i_response.addCookie(cookie);
                }
                catch (Exception exception) {
                    Domino.trace(exception);
                    return null;
                }
            }
            if (this.i_sessionId != null && !this.i_sessionId.equals("")) {
                ServletManager.getSessionContext().registerSession(this.i_sessionId);
            }
        }
        if (this.i_sessionId == null) {
            return null;
        }
        return ServletManager.getSessionContext().getSession(this.i_sessionId);
    }

    public String getRequestedSessionId() {
        if (this.i_sessionId == null) {
            this.i_sessionId = this.getSessionId();
        }
        return this.i_sessionId;
    }

    private String getSessionId() {
        String string = null;
        String string2 = null;
        if (Domino.allowSessionIdFromCookie) {
            Cookie[] cookieArray = null;
            cookieArray = this.getCookies();
            if (cookieArray != null) {
                int n = 0;
                while (n < cookieArray.length) {
                    if (cookieArray[n].getName().equals(Domino.sessionCookieName)) {
                        string2 = cookieArray[n].getValue();
                        break;
                    }
                    ++n;
                }
            }
        }
        if (Domino.allowSessionIdFromURL) {
            string = this.getParameter(Domino.sessionCookieName);
        }
        this.i_sessionIdFromURL = string != null;
        boolean bl = this.i_sessionIdFromCookie = string2 != null;
        if (string == null) {
            return string2;
        }
        return string;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.getRequestedSessionId() == null) {
            return false;
        }
        return ServletManager.getSessionContext().getSession(this.i_sessionId) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.i_sessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.i_sessionIdFromURL;
    }

    public void setResponse(DominoHttpServletResponse dominoHttpServletResponse) {
        this.i_response = dominoHttpServletResponse;
    }

    public boolean readerInUse() {
        return this.i_inReader != null;
    }

    public boolean inputStreamInUse() {
        return this.i_inStr != null;
    }

    public ServletInputStream getInputStream() {
        if (this.readerInUse()) {
            throw new IllegalStateException("Can't use ServletInputStream while BufferedReader is in use");
        }
        if (this.i_inStr == null) {
            this.i_inStr = new DominoServletInputStream(this.i_api);
        }
        return this.i_inStr;
    }

    public BufferedReader getReader() throws IOException {
        if (this.inputStreamInUse()) {
            throw new IllegalStateException("Can't use BufferedReader while ServletInputStream is in use");
        }
        if (this.i_inReader == null) {
            DominoServletInputStream dominoServletInputStream = new DominoServletInputStream(this.i_api);
            String string = this.getCharacterEncoding();
            this.i_inReader = string != null ? new BufferedReader(new InputStreamReader((InputStream)((Object)dominoServletInputStream), string)) : new BufferedReader(new InputStreamReader((InputStream)((Object)dominoServletInputStream)));
        }
        return this.i_inReader;
    }

    public String getCharacterEncoding() {
        return Domino.getCharEncodingFromContentType(this.getContentType(), null);
    }

    public Object getAttribute(String string) {
        try {
            return this.i_api.extract(string);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return null;
        }
    }
}

