/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import lotus.domino.servlet.Domino;
import lotus.domino.servlet.DominoHttpServletRequest;
import lotus.domino.servlet.DominoServletOutputStream;
import lotus.domino.servlet.NativeStubContext;
import lotus.domino.servlet.NativeStubException;

public class DominoHttpServletResponse
implements HttpServletResponse {
    public static final String CONTENT_LENGTH = "CONTENT_LENGTH";
    public static final String CONTENT_TYPE = "CONTENT_TYPE";
    public static final String HTTP_RESPONSE = "HTTP_RESPONSE";
    public static final String HTTP_REASON = "HTTP_REASON";
    public static final int RESHDR_HTABSIZE = 11;
    private NativeStubContext i_api;
    private DominoServletOutputStream i_outStr;
    private PrintWriter i_writer;
    private int i_contentLength;
    private String i_contentType;
    private Hashtable i_headers;
    private DominoHttpServletRequest i_request;

    DominoHttpServletResponse(NativeStubContext nativeStubContext) {
        this.i_api = nativeStubContext;
        this.i_outStr = null;
        this.i_writer = null;
        this.i_contentLength = -1;
        this.i_contentType = "text/html";
        this.i_headers = new Hashtable(11);
        this.i_request = null;
    }

    public void close() throws IOException {
        if (this.i_outStr != null) {
            this.i_outStr.close();
        }
        if (this.i_writer != null) {
            this.i_writer.close();
        }
        this.i_api = null;
        this.i_outStr = null;
        this.i_writer = null;
        this.i_contentType = null;
        this.i_contentLength = -1;
        this.i_headers = null;
        this.i_request = null;
    }

    public ServletOutputStream getOutputStream() {
        if (this.writerInUse()) {
            throw new IllegalStateException("Can't use ServletOutputStream while PrintWriter is in use");
        }
        if (this.i_outStr == null) {
            this.i_outStr = new DominoServletOutputStream(this.i_api);
        }
        return this.i_outStr;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStreamInUse()) {
            throw new IllegalStateException("Can't use PrintWriter while ServletOutputStream is in use");
        }
        if (this.i_writer == null) {
            OutputStreamWriter outputStreamWriter;
            DominoServletOutputStream dominoServletOutputStream = new DominoServletOutputStream(this.i_api);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)((Object)dominoServletOutputStream), this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter((OutputStream)((Object)dominoServletOutputStream));
            }
            this.i_writer = new PrintWriter(outputStreamWriter);
        }
        return this.i_writer;
    }

    public String getCharacterEncoding() {
        if (this.i_contentType == null) {
            this.setContentType("text/html");
        }
        return Domino.getCharEncodingFromContentType(this.i_contentType, Domino.defaultCharset);
    }

    private String attrAndValue(String string, String string2) {
        if (string2 == null) {
            return "";
        }
        return "; " + string + "=" + string2;
    }

    public void addCookie(Cookie cookie) {
        if (cookie.getVersion() == 1 && Domino.sendSetCookie2Header) {
            this.addCookie2Header(cookie);
        }
        this.addCookieHeader(cookie);
    }

    private void addCookieHeader(Cookie cookie) {
        String string = String.valueOf(cookie.getName()) + "=" + cookie.getValue();
        string = String.valueOf(string) + this.attrAndValue("path", cookie.getPath());
        string = String.valueOf(string) + this.attrAndValue("domain", cookie.getDomain());
        long l = cookie.getMaxAge();
        if (l >= 0L) {
            Date date = new Date();
            Date date2 = new Date(date.getTime() + 1000L * l);
            String string2 = "EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String string3 = simpleDateFormat.format(date2);
            string = String.valueOf(string) + this.attrAndValue("expires", string3);
        }
        if (cookie.getSecure()) {
            string = String.valueOf(string) + "; secure";
        }
        this.setHeader("Set-Cookie", string);
    }

    private void addCookie2Header(Cookie cookie) {
        String string = String.valueOf(cookie.getName()) + "=" + cookie.getValue();
        string = String.valueOf(string) + this.attrAndValue("Version", "1");
        string = String.valueOf(string) + this.attrAndValue("Comment", cookie.getComment());
        string = String.valueOf(string) + this.attrAndValue("Path", cookie.getPath());
        string = String.valueOf(string) + this.attrAndValue("Domain", cookie.getDomain());
        if (cookie.getSecure()) {
            string = String.valueOf(string) + "; Secure";
        }
        int n = cookie.getMaxAge();
        string = String.valueOf(string) + this.attrAndValue("Max-Age", String.valueOf(n));
        if (n < 0) {
            string = String.valueOf(string) + "; Discard";
        }
        this.setHeader("Set-Cookie2", string);
    }

    public void setStatus(int n, String string) {
        try {
            this.i_api.set(HTTP_RESPONSE, Integer.toString(n));
            this.i_api.set(HTTP_REASON, string);
            this.i_api.setReturnCode(n);
            return;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return;
        }
    }

    public void setStatus(int n) {
        try {
            this.i_api.set(HTTP_RESPONSE, Integer.toString(n));
            this.i_api.set(HTTP_REASON, DominoHttpServletResponse.getReasonText(n));
            this.i_api.setReturnCode(n);
            return;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return;
        }
    }

    private static String getReasonText(int n) {
        switch (n) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoratative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authorization Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Large";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Time-out";
            }
            case 505: {
                return "HTTP Version not supported";
            }
        }
        return "Unknown";
    }

    public void setHeader(String string, String string2) {
        try {
            this.i_headers.put(string.toLowerCase(), string2);
            this.i_api.set("HTTP_" + string, string2);
            return;
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            return;
        }
    }

    public boolean containsHeader(String string) {
        return this.i_headers.get(string.toLowerCase()) != null;
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public void setDateHeader(String string, long l) {
        Date date = new Date(l);
        String string2 = "EEE',' dd MMM yyyy HH:mm:ss 'GMT'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string3 = simpleDateFormat.format(date);
        this.setHeader(string, string3);
    }

    public void setContentLength(int n) {
        this.setHeader("Content-Length", new Integer(n).toString());
        this.i_contentLength = n;
    }

    public void setContentType(String string) {
        this.setHeader("Content-Type", string);
        this.i_contentType = string;
    }

    public void sendError(int n, String string) throws IOException {
        this.setStatus(n, string);
    }

    public void sendError(int n) throws IOException {
        this.setStatus(n);
    }

    public void sendRedirect(String string) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", string);
    }

    public String encodeUrl(String string) {
        if (this.i_request == null || this.i_request.isRequestedSessionIdFromCookie()) {
            return new String(string);
        }
        String string2 = this.i_request.getRequestedSessionId();
        if (string2 == null) {
            return new String(string);
        }
        if (string.indexOf(63) == -1) {
            return String.valueOf(string) + '?' + Domino.sessionCookieName + '=' + string2;
        }
        return String.valueOf(string) + '&' + Domino.sessionCookieName + '=' + string2;
    }

    public String encodeRedirectUrl(String string) {
        if (this.i_request == null || string.indexOf(this.i_request.getServerName()) == -1) {
            return new String(string);
        }
        return this.encodeUrl(string);
    }

    public void setRequest(DominoHttpServletRequest dominoHttpServletRequest) {
        this.i_request = dominoHttpServletRequest;
    }

    public boolean writerInUse() {
        return this.i_writer != null;
    }

    public boolean outputStreamInUse() {
        return this.i_outStr != null;
    }
}

