/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import lotus.domino.servlet.Domino;
import lotus.domino.servlet.NativeStubContext;
import lotus.domino.servlet.NativeStubException;

public class DominoServletInputStream
extends ServletInputStream {
    protected byte[] i_buffer;
    protected int i_byteCount;
    protected int i_curByteOffset;

    public DominoServletInputStream(NativeStubContext nativeStubContext) {
        try {
            this.i_byteCount = 0;
            this.i_buffer = nativeStubContext.read();
            if (this.i_buffer != null) {
                this.i_byteCount = this.i_buffer.length;
            }
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
        }
        this.i_curByteOffset = 0;
    }

    public synchronized int read() {
        if (this.i_curByteOffset < this.i_byteCount) {
            return this.i_buffer[this.i_curByteOffset++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.i_curByteOffset >= this.i_byteCount) {
            return -1;
        }
        if (this.i_curByteOffset + n2 > this.i_byteCount) {
            n2 = this.i_byteCount - this.i_curByteOffset;
        }
        if (n2 <= 0) {
            return 0;
        }
        int n3 = n2;
        while (--n3 >= 0) {
            byArray[n++] = this.i_buffer[this.i_curByteOffset++];
        }
        return n2;
    }

    public synchronized int available() {
        return this.i_byteCount - this.i_curByteOffset;
    }

    public synchronized void reset() {
        this.i_curByteOffset = 0;
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2 && this.i_curByteOffset < this.i_byteCount) {
            byArray[n3] = this.i_buffer[this.i_curByteOffset++];
            if (byArray[n3] == 10) {
                return n3 + 1;
            }
            ++n3;
        }
        if (n3 == 0) {
            return -1;
        }
        return n3;
    }
}

