/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import lotus.domino.servlet.Domino;
import lotus.domino.servlet.DominoHttpServletRequest;
import lotus.domino.servlet.DominoHttpServletResponse;
import lotus.domino.servlet.DominoServletConfig;
import lotus.domino.servlet.DominoSession;
import lotus.domino.servlet.NativeStub;
import lotus.domino.servlet.NativeStubContext;
import lotus.domino.servlet.NativeStubException;
import lotus.domino.servlet.ServletManager;

public class DominoServletInvoker {
    public static final int UNINITIALIZED = 0;
    public static final int LOADING = 1;
    public static final int READY = 2;
    public static final int WAITING_TO_DIE = 3;
    public static final int DEAD = 4;
    public static final int ERROR = 5;
    private DominoServletConfig i_config;
    protected String i_aliasName;
    private String i_classname;
    private Servlet i_servlet;
    private int i_state = 0;
    private String i_errorReason = null;

    public DominoServletInvoker(String string, DominoServletConfig dominoServletConfig, String string2, boolean bl) {
        this.i_classname = string;
        this.i_config = dominoServletConfig;
        this.i_aliasName = string2;
        if (this.i_config != null) {
            String string3 = this.i_config.getInitParameter("GO_LOAD_AT_STARTUP");
            if (string3 != null) {
                if (string3.toUpperCase().equals("YES")) {
                    this.load();
                    return;
                }
            } else if (bl) {
                this.load();
            }
        }
    }

    public void load() {
        block19: {
            try {
                Object object;
                this.i_state = 1;
                Domino.trace("msg.loading.class", this.i_classname, 128);
                Object object2 = null;
                int n = this.i_classname.lastIndexOf(".");
                if (n != -1) {
                    object = this.i_classname.substring(n);
                    if (((String)object).toUpperCase().equals(".SER")) {
                        FileInputStream fileInputStream = new FileInputStream(this.i_classname);
                        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                        object2 = objectInputStream.readObject();
                    } else if (((String)object).toUpperCase().equals(".CLASS")) {
                        this.i_classname = this.i_classname.substring(0, n);
                        Class clazz = ServletManager.loadClass(this.i_classname);
                        object2 = clazz.newInstance();
                    } else {
                        Class clazz = ServletManager.loadClass(this.i_classname);
                        object2 = clazz.newInstance();
                    }
                } else {
                    object = ServletManager.loadClass(this.i_classname);
                    object2 = ((Class)object).newInstance();
                }
                if (object2 instanceof Servlet) {
                    this.i_servlet = (Servlet)object2;
                    object = ServletManager.getServletTable();
                    ((Hashtable)object).put(this.i_aliasName, this.i_servlet);
                    this.i_servlet.init((ServletConfig)this.i_config);
                    this.i_state = 2;
                    Domino.trace("msg.loaded_servlet", this.i_aliasName, 128);
                    if (Domino.isTracing(128)) {
                        Domino.trace("msg.string_literal", this, 128);
                        return;
                    }
                    break block19;
                }
                throw new ClassCastException("Cannot convert Class " + this.i_classname + " to java.lang.Servlet");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.file_not_found", this.i_classname);
                Domino.logError("err.loading_servlet_classname", this.i_aliasName, this.i_classname);
                Domino.logError("err.file_not_found", this.i_classname);
                Domino.logError("err.string_literal", this);
                Domino.trace(fileNotFoundException);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.loading_servlet_classname", this.i_aliasName, this.i_classname);
                Domino.logError("err.loading_servlet_classname", this.i_aliasName, this.i_classname);
                Domino.logError("err.string_literal", this);
                Domino.trace(illegalArgumentException);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.class_not_found", this.i_classname);
                Domino.logError("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.class_not_found", this.i_classname);
                Domino.logError("err.string_literal", this);
                Domino.trace(classNotFoundException);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.cant_create_instance", this.i_classname);
                Domino.logError("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.cant_create_instance", this.i_classname);
                Domino.logError("err.string_literal", this);
                Domino.trace(illegalAccessException);
                return;
            }
            catch (InstantiationException instantiationException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.cant_create_instance", this.i_classname);
                Domino.logError("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.cant_create_instance", this.i_classname);
                Domino.logError("err.string_literal", this);
                Domino.trace(instantiationException);
                return;
            }
            catch (OptionalDataException optionalDataException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.cant_create_instance", this.i_classname);
                Domino.logError("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.cant_create_instance", this.i_classname);
                Domino.logError("err.string_literal", this);
                Domino.trace(optionalDataException);
                return;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.bad_serialization_file");
                Domino.logError("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.bad_serialization_file");
                Domino.logError("err.string_literal", this);
                Domino.trace(streamCorruptedException);
                return;
            }
            catch (IOException iOException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.io_error_loading_class", this.i_classname);
                Domino.logError("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.io_error_loading_class", this.i_classname);
                Domino.logError("err.string_literal", this);
                Domino.trace(iOException);
                return;
            }
            catch (ServletException servletException) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.string_literal", this);
                Domino.trace(servletException);
                return;
            }
            catch (Throwable throwable) {
                this.i_state = 5;
                this.i_errorReason = Domino.getMessageText("err.loading_servlet", this.i_aliasName);
                Domino.logError("err.servlet_init_error", this.i_aliasName);
                Domino.logError("err.string_literal", this);
                Domino.trace(throwable);
            }
        }
    }

    public void destroy() {
        if (this.i_state == 2) {
            this.i_state = 3;
            this.i_servlet.destroy();
            this.i_config.destroy();
        }
        this.i_state = 4;
        this.i_errorReason = null;
        this.i_aliasName = null;
        this.i_classname = null;
        this.i_servlet = null;
        this.i_config = null;
    }

    public int invokeSSI() throws ServletException, IOException {
        try {
            if (this.i_state == 5) {
                if (this.i_errorReason == null) {
                    this.i_errorReason = Domino.getMessageText("err.internal_error");
                }
                NativeStub.set("HTTP_REASON", this.i_errorReason);
                return 500;
            }
            return this.executeServlet(true);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
            throw new ServletException("Set HTTP_REASON for SSI failed");
        }
    }

    public int service() throws ServletException, IOException {
        return this.executeServlet(false);
    }

    private int executeServlet(boolean bl) throws ServletException, IOException {
        if (this.i_state == 5) {
            try {
                if (this.i_errorReason == null) {
                    this.i_errorReason = Domino.getMessageText("err.internal_error");
                }
                NativeStub.set("HTTP_REASON", this.i_errorReason);
            }
            catch (NativeStubException nativeStubException) {
                Domino.trace(nativeStubException);
            }
            return 500;
        }
        Object object = this;
        synchronized (object) {
            if (this.i_state == 0 && this.i_config != null) {
                this.load();
            }
        }
        if (this.i_state == 2) {
            object = new NativeStubContext();
            DominoHttpServletRequest dominoHttpServletRequest = null;
            DominoHttpServletResponse dominoHttpServletResponse = null;
            if (!(this.i_servlet instanceof Servlet)) {
                Domino.logError("err.invalid_servlet", this.i_aliasName);
                this.i_state = 5;
                return 500;
            }
            dominoHttpServletRequest = new DominoHttpServletRequest((NativeStubContext)object);
            dominoHttpServletResponse = new DominoHttpServletResponse((NativeStubContext)object);
            dominoHttpServletRequest.setResponse(dominoHttpServletResponse);
            dominoHttpServletResponse.setRequest(dominoHttpServletRequest);
            try {
                Object object2;
                if (this.i_servlet instanceof SingleThreadModel) {
                    object2 = this.i_servlet;
                    synchronized (object2) {
                        this.i_servlet.service((ServletRequest)dominoHttpServletRequest, (ServletResponse)dominoHttpServletResponse);
                    }
                } else {
                    this.i_servlet.service((ServletRequest)dominoHttpServletRequest, (ServletResponse)dominoHttpServletResponse);
                }
                object2 = (DominoSession)dominoHttpServletRequest.getSession(false);
                if (object2 != null) {
                    ((DominoSession)object2).updateLastAccessTime();
                }
            }
            catch (Throwable throwable) {
                Domino.trace("msg.except_executing_servlet", this.i_aliasName, 128);
                Domino.trace(throwable);
                try {
                    if (!dominoHttpServletResponse.containsHeader("HTTP_REASON")) {
                        if (this.i_errorReason == null) {
                            this.i_errorReason = Domino.getMessageText("err.internal_error");
                        }
                        ((NativeStubContext)object).set("HTTP_REASON", this.i_errorReason);
                    }
                }
                catch (NativeStubException nativeStubException) {
                    Domino.trace(nativeStubException);
                }
            }
            dominoHttpServletRequest.close();
            dominoHttpServletResponse.close();
            return ((NativeStubContext)object).getReturnCode();
        }
        try {
            if (this.i_errorReason == null) {
                this.i_errorReason = Domino.getMessageText("err.internal_error");
            }
            NativeStub.set("HTTP_REASON", this.i_errorReason);
        }
        catch (NativeStubException nativeStubException) {
            Domino.trace(nativeStubException);
        }
        return 500;
    }

    public String getName() {
        return this.i_aliasName;
    }

    public Servlet getServlet() {
        return this.i_servlet;
    }

    private String stateToString(int n) {
        switch (n) {
            case 0: {
                return "<Unitialized>";
            }
            case 1: {
                return "<Loading>";
            }
            case 2: {
                return "<Ready>";
            }
            case 3: {
                return "<Waiting-To-Die>";
            }
            case 4: {
                return "<Dead>";
            }
            case 5: {
                return "<Error>";
            }
        }
        return "<Unknown>";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(Domino.getMessageText("msg.servlet_dump_start"));
        stringBuffer.append(Domino.getMessageText("msg.servlet_name", this.i_aliasName));
        stringBuffer.append(Domino.getMessageText("msg.servlet_class", this.i_classname));
        stringBuffer.append(Domino.getMessageText("msg.servlet_state", this.stateToString(this.i_state)));
        if (this.i_config != null) {
            Enumeration enumeration = this.i_config.getInitParameterNames();
            if (!enumeration.hasMoreElements()) {
                stringBuffer.append(Domino.getMessageText("msg.no_config_params"));
            } else {
                stringBuffer.append(Domino.getMessageText("msg.config_params"));
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement().toString();
                    stringBuffer.append(Domino.getMessageText("msg.one_config_param", string, this.i_config.getInitParameter(string)));
                }
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append(Domino.getMessageText("msg.no_config_obj"));
        }
        if (this.i_servlet != null) {
            stringBuffer.append(Domino.getMessageText("msg.config_info_for", this.i_servlet));
        }
        return stringBuffer.toString();
    }
}

