/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import lotus.domino.servlet.NativeStubContext;
import lotus.domino.servlet.NativeStubException;

public class DominoServletOutputStream
extends ServletOutputStream {
    protected NativeStubContext i_api;
    protected boolean i_isOpen;

    public DominoServletOutputStream(NativeStubContext nativeStubContext) {
        this.i_api = nativeStubContext;
        this.i_isOpen = true;
    }

    public void close() throws IOException {
        this.i_isOpen = false;
    }

    public void flush() throws IOException {
        if (!this.i_isOpen) {
            throw new IOException("ServletOutputStream is closed");
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.i_isOpen) {
            throw new IOException("ServletOutputStream is closed");
        }
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.i_api.write(byArray2);
            return;
        }
        catch (NativeStubException nativeStubException) {
            throw new IOException();
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{new Integer(n).byteValue()};
        this.write(byArray, 0, 1);
    }

    public void print(String string) throws IOException {
        this.write(string.getBytes());
    }

    public void print(boolean bl) throws IOException {
        this.write(new Boolean(bl).toString().getBytes());
    }

    public void print(char c) throws IOException {
        this.write(new Character(c).toString().getBytes());
    }

    public void print(int n) throws IOException {
        this.write(new Integer(n).toString().getBytes());
    }

    public void print(long l) throws IOException {
        this.write(new Long(l).toString().getBytes());
    }

    public void print(float f) throws IOException {
        this.write(new Float(f).toString().getBytes());
    }

    public void print(double d) throws IOException {
        this.write(new Double(d).toString().getBytes());
    }

    public void println() throws IOException {
        this.write(new String("\n").getBytes());
    }

    public void println(String string) throws IOException {
        this.write(new String(String.valueOf(string) + "\n").getBytes());
    }

    public void println(boolean bl) throws IOException {
        this.write((String.valueOf(new Boolean(bl).toString()) + "\n").getBytes());
    }

    public void println(char c) throws IOException {
        this.write((String.valueOf(new Character(c).toString()) + "\n").getBytes());
    }

    public void println(int n) throws IOException {
        this.write((String.valueOf(new Integer(n).toString()) + "\n").getBytes());
    }

    public void println(long l) throws IOException {
        this.write((String.valueOf(new Long(l).toString()) + "\n").getBytes());
    }

    public void println(float f) throws IOException {
        this.write((String.valueOf(new Float(f).toString()) + "\n").getBytes());
    }

    public void println(double d) throws IOException {
        this.write((String.valueOf(new Double(d).toString()) + "\n").getBytes());
    }
}

