/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import lotus.domino.servlet.DominoSessionContext;

public class DominoSession
implements HttpSession,
Serializable {
    private static final int STATE_HTABSIZE = 17;
    private String i_id;
    private long i_creationTime;
    private long i_lastAccessTime;
    private boolean i_isNew;
    private boolean i_isInvalid;
    private Hashtable i_sessionState;
    private transient HttpSessionContext i_context;

    public DominoSession(HttpSessionContext httpSessionContext, String string) {
        this.i_id = string;
        this.i_context = httpSessionContext;
        this.i_sessionState = new Hashtable(17);
        Date date = new Date();
        this.i_lastAccessTime = this.i_creationTime = date.getTime();
        this.i_isNew = true;
        this.i_isInvalid = false;
    }

    protected void setContext(HttpSessionContext httpSessionContext) {
        this.i_context = httpSessionContext;
    }

    public synchronized long getCreationTime() {
        return this.i_creationTime;
    }

    public synchronized String getId() {
        return this.i_id;
    }

    public synchronized long getLastAccessedTime() {
        return this.i_lastAccessTime;
    }

    public synchronized int getMaxInactiveInterval() {
        this.checkValid();
        return ((DominoSessionContext)this.i_context).getMaxInactiveInterval();
    }

    public synchronized void setMaxInactiveInterval(int n) {
    }

    public synchronized HttpSessionContext getSessionContext() {
        return this.i_context;
    }

    public synchronized Object getValue(String string) {
        this.checkValid();
        return this.i_sessionState.get(string);
    }

    public synchronized String[] getValueNames() {
        this.checkValid();
        int n = 0;
        String[] stringArray = new String[this.i_sessionState.size()];
        Enumeration enumeration = this.i_sessionState.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = new String((String)enumeration.nextElement());
        }
        return stringArray;
    }

    public synchronized void invalidate() {
        ((DominoSessionContext)this.i_context).unregisterSession(this.i_id);
        this.i_isInvalid = true;
    }

    public synchronized boolean isNew() {
        return this.i_isNew;
    }

    private void checkValid() {
        if (this.i_isInvalid) {
            throw new IllegalStateException("Session is invalid");
        }
    }

    public synchronized void putValue(String string, Object object) {
        this.checkValid();
        Object object2 = this.i_sessionState.put(string, object);
        if (object2 != null && object2 instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object2).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
        if (object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public synchronized void removeValue(String string) {
        this.checkValid();
        Object v = this.i_sessionState.remove(string);
        if (v instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    protected synchronized void removeTransients() {
        Enumeration enumeration = this.i_sessionState.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.i_sessionState.get(string);
            if (v instanceof Serializable) continue;
            this.removeValue(string);
        }
    }

    protected synchronized void bindAll() {
        Enumeration enumeration = this.i_sessionState.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.getValue(string);
            if (!(object instanceof HttpSessionBindingListener)) continue;
            ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    protected synchronized void unbindAll() {
        Enumeration enumeration = this.i_sessionState.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.getValue(string);
            if (!(object instanceof HttpSessionBindingListener)) continue;
            ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    protected synchronized void removeAll() {
        Enumeration enumeration = this.i_sessionState.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.removeValue(string);
        }
    }

    protected synchronized void updateLastAccessTime() {
        Date date = new Date();
        this.i_lastAccessTime = date.getTime();
        this.i_isNew = false;
    }
}

