/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import lotus.domino.servlet.Domino;
import lotus.domino.servlet.DominoSession;
import lotus.domino.servlet.ServletManager;

public class DominoSessionContext
extends Thread
implements HttpSessionContext {
    private Hashtable i_sessions;
    private boolean i_sessionsEnabled = Domino.getBoolProp("server.session.enabled", true);
    private int i_maxSessions;
    private int i_idleTimeout;
    private long i_sessGCinterval = 60000L;
    private boolean i_shutdown = false;
    private boolean i_persistentSessions = Domino.getBoolProp("server.session.persistence", false);
    private String i_persistFilename;
    private static final String SESSION_FILE = "sessdata.ser";
    private static final int DEF_IDLE_TIMEOUT = 1800000;
    private static final int DEF_MAX_SESSIONS = 1000;
    private static final long DEF_GC_INTERVAL = 60000L;

    protected DominoSessionContext() {
        this.i_sessGCinterval = Domino.getLongProp("server.session.gcinterval", 60000L);
        this.i_maxSessions = Domino.getIntProp("server.session.maxsessions", 1000);
        this.i_idleTimeout = Domino.getIntProp("server.session.idletimeout", 1800000);
        this.i_persistFilename = String.valueOf(ServletManager.getConfigPath()) + File.separator + SESSION_FILE;
        if (this.i_maxSessions <= 0) {
            this.i_sessionsEnabled = false;
        }
        if (this.i_sessionsEnabled) {
            if (this.i_persistentSessions) {
                this.loadSessions();
            } else {
                this.removeSessionStateFile();
                this.i_sessions = new Hashtable();
            }
            try {
                this.start();
                return;
            }
            catch (Exception exception) {
                Domino.trace(exception);
                return;
            }
        }
        this.removeSessionStateFile();
        this.i_sessions = null;
    }

    public boolean sessionsEnabled() {
        return this.i_sessionsEnabled;
    }

    public HttpSession getSession(String string) {
        if (this.i_sessionsEnabled) {
            return (HttpSession)this.i_sessions.get(string);
        }
        return null;
    }

    public Enumeration getIds() {
        if (this.i_sessionsEnabled) {
            return this.i_sessions.keys();
        }
        return null;
    }

    protected synchronized void registerSession(String string) {
        if (this.i_sessionsEnabled) {
            DominoSession dominoSession;
            if (this.i_sessions.size() >= this.i_maxSessions) {
                this.removeOldestSession();
            }
            if ((dominoSession = (DominoSession)this.i_sessions.get(string)) == null) {
                Domino.trace("msg.adding_new_session", string, 1024);
                dominoSession = new DominoSession(this, string);
                this.i_sessions.put(string, dominoSession);
                return;
            }
        }
    }

    protected int getMaxInactiveInterval() {
        return this.i_idleTimeout;
    }

    protected synchronized void unregisterSession(Object object) {
        DominoSession dominoSession;
        if (this.i_sessionsEnabled && (dominoSession = (DominoSession)this.i_sessions.remove(object)) != null) {
            Domino.trace("msg.removing_old_session", dominoSession.getId(), 1024);
            dominoSession.removeAll();
        }
    }

    private synchronized void removeOldestSession() {
        long l = new Date().getTime();
        DominoSession dominoSession = null;
        Enumeration enumeration = this.i_sessions.elements();
        while (enumeration.hasMoreElements()) {
            DominoSession dominoSession2 = (DominoSession)enumeration.nextElement();
            if (dominoSession2.getLastAccessedTime() >= l) continue;
            dominoSession = dominoSession2;
            l = dominoSession2.getLastAccessedTime();
        }
        if (dominoSession != null) {
            Domino.trace("msg.removing_oldest_session", dominoSession.getId(), 1024);
            dominoSession.invalidate();
        }
    }

    private synchronized void invalidateSessions() {
        if (this.i_sessions == null || this.i_sessions.isEmpty()) {
            return;
        }
        Domino.trace("msg.expired_sess_check", 1024);
        Vector<DominoSession> vector = new Vector<DominoSession>();
        Enumeration enumeration = this.i_sessions.elements();
        while (enumeration.hasMoreElements()) {
            DominoSession dominoSession = (DominoSession)enumeration.nextElement();
            long l = dominoSession.getLastAccessedTime();
            long l2 = new Date().getTime();
            if (l2 - (long)this.i_idleTimeout <= l) continue;
            Domino.trace("msg.invalidating_session", dominoSession.getId(), 1024);
            vector.addElement(dominoSession);
        }
        int n = 0;
        while (n < vector.size()) {
            DominoSession dominoSession = (DominoSession)vector.elementAt(n);
            dominoSession.invalidate();
            ++n;
        }
    }

    public void run() {
        while (!this.i_shutdown) {
            try {
                Thread.sleep(this.i_sessGCinterval);
                if (this.i_shutdown) continue;
                this.invalidateSessions();
            }
            catch (Exception exception) {
                Domino.trace(exception);
                return;
            }
        }
        Domino.trace("msg.sess_thread_exiting", 1024);
    }

    private void loadSessions() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.i_persistFilename);
            DominoObjectInputStream dominoObjectInputStream = new DominoObjectInputStream(fileInputStream);
            this.i_sessions = (Hashtable)dominoObjectInputStream.readObject();
            fileInputStream.close();
            this.invalidateSessions();
            if (this.i_sessions.size() > this.i_maxSessions) {
                Domino.trace("msg.max_sess_count_changed", 1024);
                this.i_sessions = new Hashtable();
                return;
            }
            Enumeration enumeration = this.i_sessions.elements();
            while (enumeration.hasMoreElements()) {
                DominoSession dominoSession = (DominoSession)enumeration.nextElement();
                dominoSession.setContext(this);
                dominoSession.bindAll();
            }
            Domino.trace("msg.loaded_sessions", new Integer(this.i_sessions.size()), 1024);
            return;
        }
        catch (Exception exception) {
            Domino.trace(exception);
            this.i_sessions = new Hashtable();
            Domino.trace("msg.no_sessions_loaded", exception, 1024);
            return;
        }
    }

    private void removeSessionStateFile() {
        try {
            File file = new File(this.i_persistFilename);
            file.delete();
            Domino.trace("msg.removed_sess_state_file", 1024);
            return;
        }
        catch (Exception exception) {
            Domino.trace(exception);
            return;
        }
    }

    private void saveSessions() {
        String string;
        Enumeration enumeration = this.i_sessions.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            DominoSession dominoSession = (DominoSession)this.getSession(string);
            dominoSession.removeTransients();
            dominoSession.unbindAll();
        }
        try {
            string = String.valueOf(ServletManager.getConfigPath()) + "/" + SESSION_FILE;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.i_sessions);
            objectOutputStream.flush();
            fileOutputStream.close();
            Domino.trace("msg.saved_sessions", new Integer(this.i_sessions.size()), 1024);
            return;
        }
        catch (Exception exception) {
            Domino.trace(exception);
            Domino.trace("msg.no_sessions_saved", exception, 1024);
            return;
        }
    }

    public void terminate() {
        this.i_shutdown = true;
        if (this.i_sessionsEnabled && this.i_persistentSessions) {
            this.saveSessions();
        }
    }

    class DominoObjectInputStream
    extends ObjectInputStream {
        public DominoObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
            super(inputStream);
            DominoSessionContext.this = DominoSessionContext.this;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            Domino.trace("msg.asked_to_resolve", objectStreamClass.getName(), 1024);
            return ServletManager.loadClass(objectStreamClass.getName());
        }
    }
}

