/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lotus.domino.servlet.Domino;

public class ServletClassLoader
extends ClassLoader {
    private Hashtable i_cache;
    private Vector i_classpath;
    private int i_generation;
    private static int c_generationCounter;

    public ServletClassLoader(String string) {
        Object object;
        Vector<File> vector = new Vector<File>();
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            if (string2.indexOf(":") >= 0) {
                string2 = String.valueOf(string2) + ":";
            }
            if (string2.indexOf(";") >= 0) {
                string2 = String.valueOf(string2) + ";";
            }
            object = new StringTokenizer(string, string2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                File file = new File(string3);
                vector.addElement(file);
            }
        }
        int n = vector.size();
        object = new File[vector.size()];
        while (n-- > 0) {
            object[n] = (File)vector.elementAt(n);
        }
        this.init((File[])object);
    }

    public ServletClassLoader(File[] fileArray) {
        this.init(fileArray);
    }

    private void init(File[] fileArray) {
        this.i_cache = new Hashtable();
        this.i_classpath = new Vector(fileArray.length);
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            if (!file.exists()) {
                String string = Domino.getMessageText("err.file_or_dir_does_not_exist", file.getPath());
                throw new IllegalArgumentException(string);
            }
            if (!file.canRead()) {
                String string = Domino.getMessageText("err.no_read_access_for_file", file.getPath());
                throw new IllegalArgumentException(string);
            }
            if (!(file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                String string = Domino.getMessageText("err.not_dir_zip_or_jar", file.getPath());
                throw new IllegalArgumentException(string);
            }
            this.i_classpath.addElement(file);
            ++n;
        }
        this.i_generation = c_generationCounter++;
    }

    public synchronized boolean shouldReload(String string) {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.i_cache.get(string);
        this.debugTrace("Should we reload " + string + "?");
        if (classCacheEntry == null) {
            this.debugTrace(String.valueOf(string) + " wasn't even loaded.");
            return false;
        }
        if (classCacheEntry.isSystemClass()) {
            this.debugTrace(String.valueOf(string) + " is from system : can't reload.");
            return false;
        }
        boolean bl = classCacheEntry.origin.lastModified() > classCacheEntry.lastModified;
        this.debugTrace(String.valueOf(classCacheEntry.origin.lastModified()) + " > " + classCacheEntry.lastModified + " : " + (bl ? " yes." : " no."));
        return bl;
    }

    public synchronized boolean shouldReload() {
        boolean bl = false;
        Enumeration enumeration = this.i_cache.elements();
        while (enumeration.hasMoreElements()) {
            ClassCacheEntry classCacheEntry = (ClassCacheEntry)enumeration.nextElement();
            if (classCacheEntry.isSystemClass()) continue;
            long l = classCacheEntry.origin.lastModified();
            if (l == 0L) {
                this.trace(String.valueOf(classCacheEntry.origin.toString()) + " no longer exists, should reload");
                bl = true;
                break;
            }
            if (l <= classCacheEntry.lastModified) continue;
            this.trace(String.valueOf(classCacheEntry.origin.toString()) + " is new, should reload");
            bl = true;
            break;
        }
        return bl;
    }

    public ServletClassLoader reinstantiate() {
        Object[] objectArray = new File[this.i_classpath.size()];
        this.i_classpath.copyInto(objectArray);
        return new ServletClassLoader((File[])objectArray);
    }

    private void trace(String string) {
        Domino.trace("msg.class_loader", Integer.toString(this.i_generation), string, 256);
    }

    private void debugTrace(String string) {
        Domino.trace("msg.class_loader", Integer.toString(this.i_generation), string, 512);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        this.debugTrace("Asked to load " + string);
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.i_cache.get(string);
        if (classCacheEntry != null) {
            clazz = classCacheEntry.loadedClass;
            this.debugTrace("Loaded class " + string + " from cache.");
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (!this.securityAllowsClass(string)) {
            this.debugTrace(String.valueOf(string) + " must be loaded by system");
            return this.loadSystemClass(string, bl);
        }
        try {
            clazz = this.loadSystemClass(string, bl);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (Exception exception) {
            clazz = null;
        }
        Enumeration enumeration = this.i_classpath.elements();
        ClassCacheEntry classCacheEntry2 = new ClassCacheEntry();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            File file = (File)enumeration.nextElement();
            try {
                byArray = file.isDirectory() ? this.loadClassFromDirectory(file, string, classCacheEntry2) : this.loadClassFromZipfile(file, string, classCacheEntry2);
            }
            catch (IOException iOException) {
                Domino.trace(iOException);
                byArray = null;
            }
            if (byArray == null) continue;
            if (file.isFile()) {
                this.debugTrace("Loaded class " + string + " from zip file " + file.getName());
            } else {
                this.debugTrace("Loaded class " + string + " from directory " + file.getName());
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            this.debugTrace("Defined class " + string);
            classCacheEntry2.loadedClass = clazz;
            classCacheEntry2.lastModified = classCacheEntry2.origin.lastModified();
            this.i_cache.put(string, classCacheEntry2);
            if (bl) {
                this.resolveClass(clazz);
                this.debugTrace("Resolved class " + string);
            }
            return clazz;
        }
        this.debugTrace(String.valueOf(string) + " not found in classpath");
        return this.loadSystemClass(string, bl);
    }

    private Class loadSystemClass(String string, boolean bl) throws NoClassDefFoundError, ClassNotFoundException {
        Class<?> clazz = this.findSystemClass(string);
        ClassCacheEntry classCacheEntry = new ClassCacheEntry();
        classCacheEntry.origin = null;
        classCacheEntry.loadedClass = clazz;
        classCacheEntry.lastModified = Long.MAX_VALUE;
        this.i_cache.put(string, classCacheEntry);
        this.debugTrace("Loaded class " + string + " from system.");
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean securityAllowsClass(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return true;
            }
            int n = string.lastIndexOf(46);
            String string2 = n > -1 ? string.substring(0, n) : "";
            this.debugTrace("Checking package name " + string2);
            if (string2.startsWith("java.") || string2.startsWith("sun.")) {
                throw new SecurityException();
            }
            securityManager.checkPackageDefinition(string2);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = String.valueOf(string.replace('.', File.separatorChar)) + ".class";
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n))) {
                ++n;
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            byte[] byArray;
            classCacheEntry.origin = file2;
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            return byArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        byte[] byArray;
        ZipFile zipFile;
        block4: {
            byte[] byArray2;
            block3: {
                String string2 = String.valueOf(string.replace('.', '/')) + ".class";
                zipFile = new ZipFile(file);
                try {
                    ZipEntry zipEntry = zipFile.getEntry(string2);
                    if (zipEntry != null) {
                        classCacheEntry.origin = file;
                        byArray2 = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                        Object var8_9 = null;
                        break block3;
                    }
                    byArray = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    zipFile.close();
                    throw throwable;
                }
            }
            zipFile.close();
            return byArray2;
        }
        Object var8_10 = null;
        zipFile.close();
        return byArray;
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            Enumeration enumeration = this.i_classpath.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                inputStream = file.isDirectory() ? this.loadResourceFromDirectory(file, string) : this.loadResourceFromZipfile(file, string);
                if (inputStream == null) {
                    continue;
                }
                break;
            }
        } else {
            this.debugTrace("Loaded resource " + string + " from system.");
        }
        return inputStream;
    }

    private InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                this.debugTrace("Loaded resource " + string + " from directory" + file.getName());
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Domino.trace(fileNotFoundException);
                return null;
            }
        }
        return null;
    }

    private InputStream loadResourceFromZipfile(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                this.debugTrace("Loaded resource " + string + " from zip file" + file.getName());
                return zipFile.getInputStream(zipEntry);
            }
            return null;
        }
        catch (IOException iOException) {
            Domino.trace(iOException);
            return null;
        }
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            this.debugTrace("Loaded resource " + string + " from system.");
            return uRL;
        }
        Enumeration enumeration = this.i_classpath.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            File file;
            File file2 = (File)enumeration.nextElement();
            if (!file2.isDirectory() || !(file = new File(file2, string2 = string.replace('/', File.separatorChar))).exists()) continue;
            this.debugTrace("Loaded resource " + string + " from directory " + file2.getName());
            try {
                return new URL("file://" + file.getAbsolutePath());
            }
            catch (MalformedURLException malformedURLException) {
                Domino.trace(malformedURLException);
                return null;
            }
        }
        return null;
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        public boolean isSystemClass() {
            return this.origin == null;
        }

        ClassCacheEntry() {
        }
    }
}

