/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.servlet;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import lotus.domino.servlet.Domino;
import lotus.domino.servlet.DominoServletInvoker;
import lotus.domino.servlet.DominoSessionContext;
import lotus.domino.servlet.NativeStub;
import lotus.domino.servlet.NativeStubException;
import lotus.domino.servlet.ServletClassLoader;
import lotus.domino.servlet.ServletManagerConfig;

public class ServletManager {
    private static ServletManager c_theManager;
    private static final String SERVLET_CNF = "servlet.cnf";
    private ServletManagerConfig i_config;
    private Hashtable i_invokerTable;
    private Hashtable i_servletTable;
    private DominoSessionContext i_sessionContext;
    private ClassLoader i_classLoader;
    private String i_configPath;

    public ServletManager() {
        c_theManager = this;
        this.i_config = null;
        this.i_invokerTable = null;
        this.i_servletTable = null;
        this.i_sessionContext = null;
        this.i_classLoader = null;
        this.i_configPath = null;
    }

    private int initializeConfiguration() {
        this.i_servletTable = new Hashtable();
        this.i_config = new ServletManagerConfig();
        this.i_config.initialize();
        this.i_sessionContext = new DominoSessionContext();
        this.i_invokerTable = this.i_config.getInvokerTable();
        return 200;
    }

    public static Hashtable getServletTable() {
        return ServletManager.c_theManager.i_servletTable;
    }

    public static DominoSessionContext getSessionContext() {
        return ServletManager.c_theManager.i_sessionContext;
    }

    public static String getConfigPath() {
        return ServletManager.c_theManager.i_configPath;
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        if (Domino.useClassLoader) {
            return ServletManager.c_theManager.i_classLoader.loadClass(string);
        }
        return Class.forName(string);
    }

    private void destroyServlets() {
        if (this.i_invokerTable != null) {
            Enumeration enumeration = this.i_invokerTable.elements();
            while (enumeration.hasMoreElements()) {
                DominoServletInvoker dominoServletInvoker = (DominoServletInvoker)enumeration.nextElement();
                dominoServletInvoker.destroy();
            }
        }
        this.i_invokerTable = null;
    }

    public int invokeSSI() {
        try {
            String string = NativeStub.extract("SERVLET_NAME");
            if (string == null || string.length() == 0) {
                return 500;
            }
            String string2 = Domino.getNameFromAlias(string);
            Domino.trace("msg.ssi_invoke", string, string2, 128);
            NativeStub.set("CONTENT_TYPE", "text/html");
            DominoServletInvoker dominoServletInvoker = this.i_config.getServletInvoker(string2, string, false);
            if (dominoServletInvoker != null) {
                return dominoServletInvoker.invokeSSI();
            }
            return 500;
        }
        catch (Throwable throwable) {
            Domino.trace(throwable);
            return 500;
        }
    }

    public int serverInit() {
        try {
            String string = System.getProperty("file.separator");
            Domino.init();
            this.i_configPath = NativeStub.extract("INIT_STRING");
            if (File.separatorChar == '\\') {
                this.i_configPath = this.i_configPath.replace('/', '\\');
            }
            Domino.loadServerProperties(this.i_configPath);
            String string2 = String.valueOf(ServletManager.getConfigPath()) + string + "domino" + string + "servlet";
            String string3 = Domino.getStringProp("server.classpath", string2);
            this.i_classLoader = new ServletClassLoader(string3);
            int n = this.initializeConfiguration();
            if (n != 200) {
                return n;
            }
            String[] stringArray = Domino.getStartupList();
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string4 = stringArray[n2];
                    String string5 = Domino.getNameFromAlias(string4);
                    this.i_config.getServletInvoker(string5, string4, true);
                    ++n2;
                }
            }
            Domino.trace("msg.sm_init", 128);
            return n;
        }
        catch (Throwable throwable) {
            Domino.logError("err.sm_init_exception");
            Domino.trace(throwable);
            return 500;
        }
    }

    public int service() {
        int n = 500;
        if (this.i_config == null) {
            Domino.logError("err.sm_not_initialized");
            return n;
        }
        String string = "";
        try {
            String string2 = NativeStub.extract("SCRIPT_NAME");
            string = NativeStub.extract("URI");
            int n2 = string.indexOf(63);
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            Domino.trace("msg.servlet_request", string, string2, 128);
            String string3 = Domino.mapServletURI(string);
            if (string3 == null || string3.length() == 0) {
                NativeStub.set("HTTP_REASON", Domino.getMessageText("err.no_servlet_for_url"));
                return 500;
            }
            String string4 = Domino.getNameFromAlias(string3);
            Domino.trace("msg.servlet_uri_info", string, string3, string4, 128);
            NativeStub.set("CONTENT_TYPE", "text/html");
            DominoServletInvoker dominoServletInvoker = this.i_config.getServletInvoker(string4, string3, false);
            if (dominoServletInvoker != null) {
                n = dominoServletInvoker.service();
            } else {
                NativeStub.set("HTTP_REASON", Domino.getMessageText("err.no_servlet_for_url"));
                n = 500;
            }
        }
        catch (Throwable throwable) {
            NativeStub.log_error(throwable.toString());
            try {
                NativeStub.set("HTTP_REASON", throwable.toString());
            }
            catch (NativeStubException nativeStubException) {}
            Domino.trace("msg.servlet_exec_error", string, 128);
            Domino.trace(throwable);
            return 500;
        }
        if (n == 0) {
            n = 200;
        }
        return n;
    }

    public int serverTerm() {
        Domino.trace("msg.sm_terminating", 128);
        this.destroyServlets();
        this.i_sessionContext.terminate();
        if (Domino.waitForSessionThread) {
            while (this.i_sessionContext.isAlive()) {
                Domino.trace("msg.sm_term_waiting", 128);
                try {
                    this.i_sessionContext.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        this.i_config.term();
        this.i_config = null;
        Domino.trace("msg.sm_terminated", 128);
        this.i_servletTable = null;
        this.i_classLoader = null;
        this.i_sessionContext = null;
        if (Domino.gcOnShutdown) {
            System.gc();
        }
        Domino.term();
        c_theManager = null;
        return 200;
    }
}

