/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.SSLSession;
import com.ibm.sslight.Util;
import com.ibm.sslight.Vault;
import java.util.StringTokenizer;
import java.util.Vector;

public class SSLContext
implements Cloneable {
    static final String JSKREL = new String("src/com/ibm/sslight/src/SSLContext.java, Java_SSL.SSLight, jsk5a, jsk5a000906");
    static final String FILEVER = new String("1.29");
    static final String BUILDDATE = new String("00/09/14 07:29:56");
    private boolean confirmKey;
    public static final int CA = 0;
    public static final int SITE = 1;
    private static final int PRIVATE = 2;
    private static final int CERT_REQUEST = 5;
    public static final int CONNECTION = 0;
    public static final int SESSION = 1;
    public static final int CONNECT = 2;
    private static final byte CERTIFICATE_TRUSTED = 0;
    private static final byte CERTIFICATE_TRUSTED_BUT_NO_ROOT = 1;
    private static final byte CERTIFICATE_NOT_TRUSTED = -1;
    public boolean clientAuthentication;
    public boolean asyncConnections;
    public boolean debug;
    static final byte[][] bug_null = null;
    static final byte[] cmEnabled = new byte[]{0, -15, -7};
    static String[] cmName = (String[])SSLContext.getTokens("NULL IBM_ZIP_SPEED IBM_ZIP_SIZE", null);
    static final short[] csStepup = new short[]{4, 5};
    static final String[] csStepupName = new String[]{"SSL_RSA_WITH_RC4_128_MD5 ", "SSL_RSA_WITH_RC4_128_SHA "};
    boolean allow_step_up_cryptography = false;
    static final short[] csEnabled = new short[]{4, 5, 10, 3, 9, 8, 6, 1, 2};
    static String[] csName = (String[])SSLContext.getTokens("SSL_RSA_WITH_RC4_128_MD5 SSL_RSA_WITH_RC4_128_SHA SSL_RSA_WITH_3DES_EDE_CBC_SHA SSL_RSA_EXPORT_WITH_RC4_40_MD5 SSL_RSA_WITH_DES_CBC_SHA SSL_RSA_EXPORT_WITH_DES40_CBC_SHA SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 SSL_RSA_WITH_NULL_MD5 SSL_RSA_WITH_NULL_SHA ", null);
    private static int contextCounter;
    private static final int[][] timeoutLimit;
    int context_id;
    int[] timeout = new int[3];
    short[] cs_list = csEnabled;
    byte[] cm_list = cmEnabled;
    Vector[] ring = new Vector[3];
    Vector requests = new Vector();
    Vector requestAliases = new Vector();
    Vector caAliases = new Vector();
    Vector siteAliases = new Vector();
    Vector privateAliases = new Vector();
    Vector secretAliases = new Vector();
    Vector peerSecretAliases = new Vector();
    byte[] authorities;

    private static synchronized int newContextId() {
        return contextCounter++;
    }

    static final boolean isExportBuild() {
        return false;
    }

    static final Object getTokens(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n != 0) {
            String[] stringArray2 = new String[n];
            short[] sArray = stringArray != null ? new short[n] : null;
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray2[n] = stringTokenizer.nextToken();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length && stringArray2[n].compareTo(stringArray[n2]) != 0) {
                        ++n2;
                    }
                    if (n2 == stringArray.length) {
                        return null;
                    }
                    sArray[n] = (short)n2;
                    n2 = 0;
                    while (sArray[n2] != sArray[n]) {
                        ++n2;
                    }
                    if (n2 != n) {
                        return null;
                    }
                }
                ++n;
            }
            if (stringArray == null) {
                return stringArray2;
            }
            return sArray;
        }
        return null;
    }

    static final String getCipherSuite(short s) {
        if (s == 4) {
            return "SSL_RSA_WITH_RC4_128_MD5";
        }
        if (s == 5) {
            return "SSL_RSA_WITH_RC4_128_SHA";
        }
        int n = 0;
        while (n < csEnabled.length) {
            if (s == csEnabled[n]) {
                return csName[n];
            }
            ++n;
        }
        return "<UNKNOWN CIPHER SUITE>";
    }

    static final String getCompressionMethod(byte by) {
        int n = 0;
        while (n < cmEnabled.length) {
            if (by == cmEnabled[n]) {
                return cmName[n];
            }
            ++n;
        }
        return "<UNKNOWN COMPRESSION METHOD>";
    }

    final synchronized Object getCert(int n, byte[] byArray, int n2, int n3, Object object) throws SSLException {
        Boolean bl = null;
        String string = null;
        int n4 = this.getCert(n, byArray, n2, n3);
        if (this.confirmKey) {
            KeyConstraints keyConstraints;
            if (n4 > -1) {
                string = (String)this.privateAliases.elementAt(n4);
            }
            n4 = (string = this.confirmKeySelection(object, string, keyConstraints = new KeyConstraints(2, n, byArray, n2, n3))) != null ? this.privateAliases.indexOf(string) : -1;
        }
        if (n4 > -1) {
            bl = (Boolean)this.ring[2].elementAt(n4);
        }
        if (bl == null) {
            bl = new Boolean(this.handleNoSiteCertificate(object));
        }
        return bl;
    }

    private final boolean signerInChain(SSLCert[] sSLCertArray, byte[] byArray, int n, int n2) throws SSLException {
        SSLCert sSLCert = null;
        int n3 = 0;
        while (n3 < sSLCertArray.length) {
            int n4;
            sSLCert = sSLCertArray[n3];
            int n5 = 0;
            do {
                boolean bl;
                block4: {
                    if ((n4 = Util.msbf(byArray, n + n5, 2)) < 3 || n2 - (n5 += 2) < n4) {
                        throw new SSLException();
                    }
                    if (n4 != sSLCert.issL) continue;
                    byte[] byArray2 = sSLCert.x509;
                    int n6 = sSLCert.iss;
                    int n7 = n + n5;
                    int n8 = n4;
                    while (--n8 >= 0) {
                        if (byArray2[n6++] == byArray[n7++]) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
                if (!bl) continue;
                return true;
            } while ((n5 += n4) + 5 < n2);
            ++n3;
        }
        return false;
    }

    private final int getCert(int n, byte[] byArray, int n2, int n3) throws SSLException {
        Vector vector = this.ring[2];
        int n4 = vector != null ? vector.size() : 0;
        if (n4 != 0) {
            int n5;
            boolean bl = false;
            if (byArray == null) {
                bl = (n & 0x1000) != 0 && (n & 0xF00) == 256;
                n >>>= 16;
            }
            int n6 = -1;
            while ((n5 = n & 0x7F) != 0) {
                int n7 = 0;
                do {
                    Object e = vector.elementAt(n7);
                    SSLCert[] sSLCertArray = (SSLCert[])((Object[])e)[0];
                    if (byArray != null && !this.signerInChain(sSLCertArray, byArray, n2, n3)) continue;
                    SSLCert sSLCert = sSLCertArray[0];
                    int n8 = sSLCert.sigAlg;
                    int n9 = sSLCert.alg;
                    if (n9 != 1 || n5 != 1 || n8 > 5) continue;
                    if (bl ^ sSLCert.keyL > 64) {
                        return n7;
                    }
                    if (n7 == 0) {
                        return n7;
                    }
                    if (n6 != -1) continue;
                    n6 = n7;
                } while (++n7 < n4);
                if (n6 != -1) {
                    return n6;
                }
                n >>>= 8;
            }
        }
        return -1;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    final synchronized byte[] getAuth(int n) {
        if (this.authorities == null) {
            int n2;
            int n3;
            int n4;
            Vector vector;
            int n5 = 5;
            byte[] byArray = new byte[256];
            int n6 = 0;
            while (n6 < 2 && (vector = this.ring[n6]) != null && (n4 = vector.size()) != 0) {
                int n7 = 0;
                while (n7 < n4) {
                    SSLCert sSLCert = (SSLCert)vector.elementAt(n7);
                    int n8 = n6 == 0 ? sSLCert.sub : sSLCert.iss;
                    int n9 = n6 == 0 ? sSLCert.subL : sSLCert.issL;
                    int n10 = 5;
                    boolean bl = true;
                    while (true) {
                        boolean bl2;
                        block11: {
                            int n11;
                            if (!bl || (bl = false) || !true) {
                                n10 += 2 + n11;
                            }
                            if (n10 >= n5) break;
                            n11 = Util.msbf(byArray, n10, 2);
                            if (n11 != n9) continue;
                            n3 = n10 + 2;
                            byte[] byArray2 = sSLCert.x509;
                            n2 = n8;
                            int n12 = n9;
                            while (--n12 >= 0) {
                                if (byArray[n3++] == byArray2[n2++]) continue;
                                bl2 = false;
                                break block11;
                            }
                            bl2 = true;
                        }
                        if (bl2) break;
                    }
                    if (n10 == n5) {
                        if (byArray.length - n5 < n9 + 2) {
                            byte[] byArray3 = new byte[n5 + 256 + 2 + n9];
                            System.arraycopy(byArray, 0, byArray3, 0, n5);
                            byArray = byArray3;
                        }
                        n3 = n5;
                        int n13 = 2;
                        do {
                            byArray[n3++] = (byte)(n9 >>> --n13 * 8);
                        } while (n13 > 0);
                        System.arraycopy(sSLCert.x509, n8, byArray, n5 += 2, n9);
                        n5 += n9;
                    }
                    ++n7;
                }
                ++n6;
            }
            if (n5 != 2) {
                byArray[0] = 2;
                byArray[1] = 1;
                byArray[2] = 2;
                n3 = n5 - 5;
                int n14 = 3;
                n2 = 2;
                do {
                    byArray[n14++] = (byte)(n3 >>> --n2 * 8);
                } while (n2 > 0);
                this.authorities = byArray;
            }
        }
        return this.authorities;
    }

    final synchronized void checkChainValidity(SSLCert[] sSLCertArray) throws SSLException {
        int n = 0;
        while (n < sSLCertArray.length) {
            int n2 = sSLCertArray[n].verify(null);
            if (n2 != 0) {
                throw new SSLException(3, n2, sSLCertArray[n].x509, sSLCertArray[n].ser, sSLCertArray[n].serL);
            }
            if (n > 0 && (n2 = sSLCertArray[n - 1].verify(sSLCertArray[n])) != 0) {
                switch (n2) {
                    case 1021: 
                    case 1022: 
                    case 1027: {
                        throw new SSLException(3, n2, sSLCertArray[n].x509, sSLCertArray[n].ser, sSLCertArray[n].serL);
                    }
                    case 1013: 
                    case 1024: {
                        throw new SSLException(4, n2, sSLCertArray[n - 1].x509, sSLCertArray[n - 1].ser, sSLCertArray[n - 1].serL, sSLCertArray[n].x509, sSLCertArray[n].ser, sSLCertArray[n].serL);
                    }
                }
                throw new SSLException(3, n2, sSLCertArray[n - 1].x509, sSLCertArray[n - 1].ser, sSLCertArray[n - 1].serL);
            }
            ++n;
        }
    }

    final SSLCert getRootFromChain(SSLCert[] sSLCertArray) throws SSLException {
        SSLCert sSLCert = null;
        SSLCert sSLCert2 = sSLCertArray[sSLCertArray.length - 1];
        if (sSLCert2.verify(sSLCert2) == 0) {
            sSLCert = sSLCert2;
        }
        return sSLCert;
    }

    final SSLCert getRootFromDatabase(SSLCert[] sSLCertArray) throws SSLException {
        SSLCert sSLCert = null;
        SSLCert sSLCert2 = sSLCertArray[sSLCertArray.length - 1];
        Vector vector = this.ring[0];
        int n = vector != null ? vector.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            SSLCert sSLCert3 = (SSLCert)vector.elementAt(n2);
            if (sSLCert3.verify(null) == 0 && sSLCert2.verify(sSLCert3) == 0 && sSLCert3.verify(sSLCert3) == 0) {
                sSLCert = sSLCert3;
                break;
            }
            ++n2;
        }
        return sSLCert;
    }

    final synchronized boolean isTrusted(SSLCert sSLCert, int n) throws SSLException {
        SSLCert sSLCert2 = null;
        Vector vector = this.ring[n];
        boolean bl = false;
        int n2 = vector != null ? vector.size() : 0;
        int n3 = 0;
        while (n3 < n2) {
            sSLCert2 = (SSLCert)vector.elementAt(n3);
            if (sSLCert2.equals(sSLCert)) {
                bl = true;
                break;
            }
            ++n3;
        }
        return bl;
    }

    final synchronized boolean isTrusted(SSLCert[] sSLCertArray) throws SSLException {
        int n;
        boolean bl = false;
        SSLCert sSLCert = null;
        SSLCert sSLCert2 = null;
        Vector vector = this.ring[0];
        if (this.isTrusted(sSLCertArray[0], 1)) {
            bl = true;
        } else {
            n = 0;
            while (n < sSLCertArray.length) {
                if (this.isTrusted(sSLCertArray[n], 0)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (!bl && vector != null) {
            sSLCert = sSLCertArray[sSLCertArray.length - 1];
            n = vector.size() - 1;
            while (n >= 0) {
                sSLCert2 = (SSLCert)vector.elementAt(n);
                if (sSLCert2.verify(null) == 0 && sSLCert.verify(sSLCert2) == 0) {
                    bl = true;
                    break;
                }
                --n;
            }
        }
        return bl;
    }

    final synchronized byte verify(SSLCert[] sSLCertArray, SSLSession sSLSession, boolean bl, Object object) throws SSLException {
        SSLCert sSLCert = null;
        boolean bl2 = false;
        byte by = -1;
        this.checkChainValidity(sSLCertArray);
        if (bl) {
            sSLCert = this.getRootFromChain(sSLCertArray);
            if (sSLCert == null) {
                sSLCert = this.getRootFromDatabase(sSLCertArray);
                bl2 = sSLCert != null;
            }
            sSLSession.peer_root_cert = sSLCert;
        }
        if (!bl2) {
            bl2 = this.isTrusted(sSLCertArray);
        }
        by = (bl2 = bl2 ? this.confirmCertificateChain(object, sSLCertArray) : this.handleCertificateChain(object, sSLCertArray)) ? (sSLCert == null ? (byte)1 : 0) : (byte)-1;
        return by;
    }

    protected synchronized String confirmKeySelection(Object object, String string, KeyConstraints keyConstraints) {
        return string;
    }

    protected synchronized void handleConnection(Object object, byte[] byArray) {
    }

    protected synchronized boolean handleCertificateChain(Object object, SSLCert[] sSLCertArray) {
        return false;
    }

    protected synchronized boolean confirmCertificateChain(Object object, SSLCert[] sSLCertArray) {
        return true;
    }

    protected synchronized boolean handleNoSiteCertificate(Object object) {
        return true;
    }

    protected synchronized boolean handleNoPeerCertificate(Object object) {
        return false;
    }

    public synchronized String[] queryAcceptableKeys(KeyConstraints keyConstraints) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = keyConstraints.cipherSuite;
        Vector vector = this.ring[2];
        Vector vector2 = new Vector();
        SSLCert[] sSLCertArray = null;
        SSLCert sSLCert = null;
        Object[] objectArray = null;
        if (vector != null) {
            if (keyConstraints.certAuthorities == null) {
                n >>= 16;
            }
            bl5 = false;
            if ((n & 0x7F00) >> 8 == 1) {
                bl = true;
                bl2 = bl5;
            } else {
                bl3 = true;
                bl4 = bl5;
            }
            bl5 = false;
            if ((n & 0x7F) == 1) {
                bl = true;
                bl2 = bl5;
            } else {
                bl3 = true;
                bl4 = bl5;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                sSLCertArray = (SSLCert[])((Object[])vector.elementAt(n2))[0];
                sSLCert = sSLCertArray[0];
                try {
                    if ((sSLCert.alg == 1 && sSLCert.sigAlg <= 5 && bl || sSLCert.alg == 1 && sSLCert.sigAlg == 27 && bl2 || sSLCert.alg == 12 && sSLCert.sigAlg <= 5 && bl4 || sSLCert.alg == 12 && sSLCert.sigAlg == 27 && bl3) && (keyConstraints.certAuthorities == null || this.signerInChain(sSLCertArray, keyConstraints.certAuthorities, keyConstraints.offset, keyConstraints.length))) {
                        vector2.addElement(this.privateAliases.elementAt(n2));
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public SSLContext() {
        this.timeout[0] = 0;
        this.timeout[1] = 3600000;
        this.timeout[2] = 120000;
        this.context_id = SSLContext.newContextId();
        this.allow_step_up_cryptography = false;
        int n = 0;
        while (n < this.ring.length) {
            this.ring[n] = new Vector();
            ++n;
        }
        this.requests = new Vector();
        Object object = new Object();
        String string = new String("");
        KeyConstraints keyConstraints = new KeyConstraints(0, 0, new byte[0], 0, 0);
        Class[] classArray = new Class[]{object.getClass(), string.getClass(), keyConstraints.getClass()};
        Vector<Class> vector = new Vector<Class>();
        Class clazz = this.getClass();
        while (clazz != null) {
            vector.addElement(clazz);
            clazz = clazz.getSuperclass();
        }
        int n2 = vector.size() - 3;
        while (n2 >= 0) {
            clazz = (Class)vector.elementAt(n2);
            try {
                clazz.getDeclaredMethod("confirmKeySelection", classArray);
                this.confirmKey = true;
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                this.confirmKey = true;
                return;
            }
            --n2;
        }
    }

    public synchronized String[] getEnabledCipherSuites() {
        String[] stringArray = new String[this.cs_list.length];
        int n = 0;
        while (n < this.cs_list.length) {
            stringArray[n] = SSLContext.getCipherSuite(this.cs_list[n]);
            ++n;
        }
        return stringArray;
    }

    public synchronized String[] getEnabledCompressionMethods() {
        String[] stringArray = new String[this.cm_list.length];
        int n = 0;
        while (n < this.cm_list.length) {
            stringArray[n] = SSLContext.getCompressionMethod(this.cm_list[n]);
            ++n;
        }
        return stringArray;
    }

    public synchronized void setEnabledCipherSuites(String string) throws SSLException {
        short[] sArray = (short[])SSLContext.getTokens(string, csName);
        if (sArray != null) {
            int n = 0;
            do {
                sArray[n] = csEnabled[sArray[n]];
            } while (++n < sArray.length);
            this.cs_list = sArray;
            return;
        }
        throw new SSLException(7, 1012, 1);
    }

    public synchronized void setEnabledCompressionMethods(String string) throws SSLException {
        short[] sArray = (short[])SSLContext.getTokens(string, cmName);
        if (sArray != null) {
            byte[] byArray = new byte[sArray.length];
            int n = 0;
            do {
                byArray[n] = cmEnabled[sArray[n]];
            } while (++n < sArray.length);
            this.cm_list = byArray;
            return;
        }
        throw new SSLException(7, 1012, 1);
    }

    public synchronized void setTimeout(int n, int n2) throws SSLException {
        if (n2 < timeoutLimit[n][0] || n2 > timeoutLimit[n][1]) {
            throw new SSLException(7, 1012, 2);
        }
        this.timeout[n] = n2 * 1000;
    }

    public int getTimeout(int n) {
        return this.timeout[n] / 1000;
    }

    public synchronized void setKeyRing(int n, Vector vector) {
        Vault vault = new Vault();
        try {
            vault.setKeyRing(n, vector, null);
            if (n == 5) {
                this.requests = vault.getKeyRing(n);
            } else {
                this.ring[n] = vault.getKeyRing(n);
            }
            switch (n) {
                case 0: {
                    this.caAliases = vault.getAliases(n);
                    break;
                }
                case 1: {
                    this.siteAliases = vault.getAliases(n);
                    break;
                }
                case 2: {
                    this.privateAliases = vault.getAliases(n);
                    break;
                }
                case 5: {
                    this.requestAliases = vault.getAliases(n);
                }
            }
            this.authorities = null;
            return;
        }
        catch (SSLException sSLException) {
            return;
        }
    }

    public synchronized Vector getKeyRing(int n) {
        if (n == 5) {
            return (Vector)this.requests.clone();
        }
        if (this.ring[n] != null) {
            return (Vector)this.ring[n].clone();
        }
        return null;
    }

    public synchronized SSLCert getSSLCertByLabel(String string) {
        if (string == null) {
            return null;
        }
        int n = this.privateAliases.indexOf(string);
        SSLCert sSLCert = null;
        if (n > -1) {
            sSLCert = ((SSLCert[])((Object[])this.ring[2].elementAt(n))[0])[0];
        }
        return sSLCert;
    }

    public synchronized void importCACertificates(String string) throws SSLException {
        Vault vault = new Vault();
        this.setExisting(vault);
        vault.importCACertificates(string);
        this.storeLoaded(vault);
    }

    public synchronized void importSiteCertificates(String string) throws SSLException {
        Vault vault = new Vault();
        this.setExisting(vault);
        vault.importSiteCertificates(string);
        this.storeLoaded(vault);
    }

    public synchronized boolean importKeyRings(byte[] byArray, int n, int n2, String string) throws SSLException {
        Vault vault = new Vault();
        boolean bl = false;
        this.setExisting(vault);
        bl = vault.importKeyRings(byArray, n, n2, string);
        if (bl) {
            this.storeLoaded(vault);
        }
        return bl;
    }

    private void setExisting(Vault vault) throws SSLException {
        vault.setKeyRing(0, this.ring[0], this.caAliases);
        vault.setKeyRing(1, this.ring[1], this.siteAliases);
        vault.setKeyRing(2, this.ring[2], this.privateAliases);
        vault.setKeyRing(5, this.requests, this.requestAliases);
    }

    private void storeLoaded(Vault vault) throws SSLException {
        this.ring[0] = vault.getKeyRing(0);
        this.caAliases = vault.getAliases(0);
        this.ring[1] = vault.getKeyRing(1);
        this.siteAliases = vault.getAliases(1);
        this.ring[2] = vault.getKeyRing(2);
        this.privateAliases = vault.getAliases(2);
        this.requests = vault.getKeyRing(5);
        this.requestAliases = vault.getAliases(5);
    }

    public synchronized boolean importKeyRings(String string, String string2) throws SSLException {
        Vault vault = new Vault();
        boolean bl = false;
        this.setExisting(vault);
        bl = vault.importKeyRings(string, string2);
        if (bl) {
            this.storeLoaded(vault);
        }
        return bl;
    }

    public synchronized byte[] exportKeyRings(String string) throws SSLException {
        Vault vault = new Vault();
        this.setExisting(vault);
        byte[] byArray = null;
        try {
            byArray = vault.exportKeyRings(string);
        }
        catch (Exception exception) {
            throw new SSLException();
        }
        return byArray;
    }

    public void restrictStepUpCryptography() {
        this.allow_step_up_cryptography = false;
    }

    public void allowStepUpCryptography() {
        this.allow_step_up_cryptography = false;
    }

    public Object clone() {
        try {
            SSLContext sSLContext = (SSLContext)super.clone();
            sSLContext.cs_list = (short[])this.cs_list.clone();
            sSLContext.cm_list = (byte[])this.cm_list.clone();
            sSLContext.ring = (Vector[])this.ring.clone();
            int n = 0;
            while (n < this.ring.length) {
                if (this.ring[n] != null) {
                    sSLContext.ring[n] = (Vector)this.ring[n].clone();
                }
                ++n;
            }
            if (this.authorities != null) {
                sSLContext.authorities = (byte[])this.authorities.clone();
            }
            sSLContext.clientAuthentication = this.clientAuthentication;
            sSLContext.asyncConnections = this.asyncConnections;
            sSLContext.debug = this.debug;
            sSLContext.timeout = this.timeout;
            return sSLContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static {
        timeoutLimit = new int[][]{{0, 3600}, {0, 86400}, {0, 600}};
    }

    public static class KeyConstraints {
        int type;
        int cipherSuite;
        byte[] certAuthorities;
        int offset;
        int length;

        KeyConstraints(int n, int n2, byte[] byArray, int n3, int n4) {
            this.type = n;
            this.cipherSuite = n2;
            this.certAuthorities = byArray;
            this.offset = n3;
            this.length = n4;
        }
    }
}

