/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.Util;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Stack;
import java.util.Vector;

class Vault {
    static final String JSKREL = new String("src/com/ibm/sslight/src/Vault.java, Java_SSL.SSLight, jsk5a, jsk5a000906");
    static final String FILEVER = new String("1.11");
    static final String BUILDDATE = new String("00/09/14 07:42:29");
    boolean debug = true;
    private static final byte[] Pad1 = new byte[48];
    private static final byte[] Pad2 = new byte[48];
    static final int CA = 0;
    static final int SITE = 1;
    static final int PRIVATE = 2;
    static final int SECRET = 3;
    static final int PEER_SECRET = 4;
    static final int CERT_REQUEST = 5;
    static final int NEW_CA = 7;
    static final int NEW_SITE = 8;
    static final int NEW_PRIVATE = 9;
    static final int NEW_SECRET = 10;
    static final int NEW_PEER_SECRET = 11;
    static final int LABEL = 12;
    static final int CERT_REQUEST_DATA = 13;
    private Vector[] ring;
    private Vector requests = new Vector();
    private Vector certAliases = new Vector();
    private Vector siteAliases = new Vector();
    private Vector privateAliases = new Vector();
    private Vector secretAliases = new Vector();
    private Vector peerAliases = new Vector();
    private Vector requestAliases = new Vector();
    private int uniqueLabelNumber;
    private boolean labelRead;

    Vault() {
        this.ring = new Vector[5];
        int n = 0;
        while (n < this.ring.length) {
            this.ring[n] = new Vector();
            ++n;
        }
    }

    synchronized Vector getKeyRing(int n) throws SSLException {
        switch (n) {
            case 0: {
                return (Vector)this.ring[0].clone();
            }
            case 1: {
                return (Vector)this.ring[1].clone();
            }
            case 2: {
                return (Vector)this.ring[2].clone();
            }
            case 3: {
                return (Vector)this.ring[3].clone();
            }
            case 4: {
                return (Vector)this.ring[4].clone();
            }
            case 5: {
                return (Vector)this.requests.clone();
            }
        }
        throw new SSLException();
    }

    synchronized Vector getAliases(int n) throws SSLException {
        switch (n) {
            case 0: {
                return (Vector)this.certAliases.clone();
            }
            case 1: {
                return (Vector)this.siteAliases.clone();
            }
            case 2: {
                return (Vector)this.privateAliases.clone();
            }
            case 3: {
                return (Vector)this.secretAliases.clone();
            }
            case 4: {
                return (Vector)this.peerAliases.clone();
            }
            case 5: {
                return (Vector)this.requestAliases.clone();
            }
        }
        throw new SSLException();
    }

    synchronized void setKeyRing(int n, Vector vector, Vector vector2) throws SSLException {
        if (vector == null || vector2 != null && vector.size() != vector2.size()) {
            throw new SSLException();
        }
        if (vector2 == null) {
            vector2 = new Vector();
            this.makeAliases(vector, vector2, n);
        }
        vector = (Vector)vector.clone();
        vector2 = this.ensureUnique(vector2, n);
        switch (n) {
            case 0: {
                this.ring[0] = vector;
                this.certAliases = vector2;
                return;
            }
            case 1: {
                this.ring[1] = vector;
                this.siteAliases = vector2;
                return;
            }
            case 2: {
                this.ring[2] = vector;
                this.privateAliases = vector2;
                return;
            }
            case 3: {
                this.ring[3] = vector;
                this.secretAliases = vector2;
                return;
            }
            case 4: {
                this.ring[4] = vector;
                this.peerAliases = vector2;
                return;
            }
            case 5: {
                this.requests = vector;
                this.requestAliases = vector2;
                return;
            }
        }
        throw new SSLException();
    }

    private Vector ensureUnique(Vector vector, int n) {
        Vector vector2 = (Vector)vector.clone();
        Stack<String> stack = new Stack<String>();
        String string = null;
        while (!vector2.isEmpty()) {
            string = (String)vector2.elementAt(vector2.size() - 1);
            vector2.removeElementAt(vector2.size() - 1);
            if (string == null) {
                string = String.valueOf(++this.uniqueLabelNumber);
            }
            while (stack.contains(string) || vector2.contains(string)) {
                string = String.valueOf(string) + "(" + ++this.uniqueLabelNumber + ")";
            }
            stack.push(string);
        }
        while (!stack.empty()) {
            vector2.addElement(stack.pop());
        }
        return vector2;
    }

    private void makeAliases(Vector vector, Vector vector2, int n) throws SSLException {
        SSLCert[] sSLCertArray = null;
        SSLCert sSLCert = null;
        String string = "";
        int n2 = vector2.size();
        while (n2 < vector.size()) {
            sSLCertArray = null;
            sSLCert = null;
            string = "";
            switch (n) {
                case 0: 
                case 1: {
                    sSLCert = (SSLCert)vector.elementAt(n2);
                    break;
                }
                case 2: {
                    sSLCertArray = (SSLCert[])((Object[])vector.elementAt(n2))[0];
                    sSLCert = sSLCertArray == null ? null : sSLCertArray[0];
                    break;
                }
                case 5: {
                    sSLCert = (SSLCert)((Object[])vector.elementAt(n2))[0];
                    break;
                }
                case 3: 
                case 4: {
                    byte[] byArray = (byte[])((Object[])vector.elementAt(n2))[0];
                    try {
                        string = new String(byArray, "8859_1");
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray);
                    }
                }
            }
            if (sSLCert != null) {
                string = sSLCert.getNameComponent(1, 3);
            }
            vector2.addElement(string);
            ++n2;
        }
    }

    static void mac(byte[] byArray, int n, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        byte[] byArray4 = new byte[64 + (n3 < 16 ? 16 : n3)];
        System.arraycopy(byArray, n, byArray4, 0, 16);
        System.arraycopy(Pad1, 0, byArray4, 16, 48);
        System.arraycopy(byArray2, n2, byArray4, 64, n3);
        Util.util11(null, byArray4, 0, byArray4.length, byArray4, 64);
        System.arraycopy(Pad2, 0, byArray4, 16, 48);
        Util.util11(null, byArray4, 0, 80, byArray3, n4);
    }

    private static byte[] secret(String string, byte[] byArray, int n, boolean bl) {
        int n2;
        if (string != null && (n2 = string.length()) > 0) {
            byte[] byArray2;
            if (bl) {
                Util.random(byArray, n, 16);
            }
            byte[] byArray3 = new byte[16];
            try {
                byArray2 = string.getBytes("8859_1");
            }
            catch (Exception exception) {
                byArray2 = string.getBytes();
            }
            Vault.mac(byArray, n, byArray2, 0, n2, byArray3, 0);
            return byArray3;
        }
        return null;
    }

    private int readAlias(byte[] byArray, int n, Vector vector) throws SSLException {
        if (byArray[n] != 12) {
            throw new SSLException();
        }
        byte[] byArray2 = new byte[Util.msbf(byArray, n + 1, 2)];
        System.arraycopy(byArray, n + 3, byArray2, 0, byArray2.length);
        String string = null;
        try {
            string = new String(byArray2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SSLException();
        }
        vector.addElement(string);
        return 3 + byArray2.length;
    }

    synchronized boolean importKeyRings(byte[] byArray, int n, int n2, String string) throws SSLException {
        return this.load(byArray, n, n2, string, true, true, true);
    }

    synchronized boolean importSiteCertificates(String string) throws SSLException {
        if (string.length() == 0) {
            return true;
        }
        byte[] byArray = Vault.xform7bitTo8bit(string);
        return this.load(byArray, 0, byArray.length, null, false, true, false);
    }

    synchronized boolean importCACertificates(String string) throws SSLException {
        if (string.length() == 0) {
            return true;
        }
        byte[] byArray = Vault.xform7bitTo8bit(string);
        return this.load(byArray, 0, byArray.length, null, true, false, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean load(byte[] byArray, int n, int n2, String string, boolean bl, boolean bl2, boolean bl3) throws SSLException {
        if (n2 == 0) {
            return true;
        }
        boolean bl4 = false;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            int n3;
            Object object;
            if (byArray[n] == -2) {
                bl4 = true;
                ++n;
                --n2;
            }
            if (byArray[n] == -1) {
                if (bl3) {
                    boolean bl5;
                    block63: {
                        byArray2 = Vault.secret(string, byArray, n + 1, false);
                        if (byArray2 == null) {
                            return false;
                        }
                        byArray3 = Util.util13(byArray2, 0, 16);
                        object = new byte[16];
                        Vault.mac(byArray2, 0, byArray, n, n2 -= 16, (byte[])object, 0);
                        int n4 = 0;
                        int n5 = n + n2;
                        n3 = 16;
                        while (--n3 >= 0) {
                            if (object[n4++] == byArray[n5++]) continue;
                            bl5 = false;
                            break block63;
                        }
                        bl5 = true;
                    }
                    if (!bl5) {
                        throw new SSLException(7, 1012, 4);
                    }
                }
                n += 17;
                n2 -= 17;
            }
            n2 += n;
            do {
                void var15_28;
                BigInteger bigInteger;
                BigInteger bigInteger2;
                BigInteger bigInteger3;
                Object object2;
                int n6;
                int n7;
                byte[][] byArray4;
                int n8;
                Object object3;
                int n9;
                if ((n9 = byArray[n++] & 0xFF) == 2) {
                    if (bl4) {
                        n += this.readAlias(byArray, n, this.privateAliases);
                    }
                    object = new Object[2];
                    object3 = null;
                    Object object4 = null;
                    n3 = 0;
                    while (n3 < 2) {
                        n8 = byArray[n++];
                        byArray4 = new byte[n8][];
                        n7 = 0;
                        while (n7 < n8) {
                            n6 = Util.msbf(byArray, n, 2);
                            if (n6 != 0) {
                                byArray4[n7] = new byte[n6];
                                System.arraycopy(byArray, n + 2, byArray4[n7], 0, n6);
                                if (n3 == 1 && byArray3 != null) {
                                    Util.util14(byArray3, byArray4[n7], 0, n6, byArray4[n7], 0);
                                    byte[] byArray5 = byArray4[n7];
                                    byArray5[0] = (byte)(byArray5[0] ^ byArray4[n7][n6 - 1]);
                                }
                            }
                            n += n6 + 2;
                            ++n7;
                        }
                        if (n3 == 0) {
                            object3 = new SSLCert[n8];
                            n7 = 0;
                            while (n7 < n8) {
                                object3[n7] = new SSLCert(byArray4[n7]);
                                ++n7;
                            }
                            object4 = object3[0];
                            object[0] = object3;
                        } else {
                            if (byArray3 != null && byArray4[0] == null) {
                                object2 = ((SSLCert)object4).key();
                                if (((SSLCert)object4).alg == 1) {
                                    byArray4[0] = object2[0];
                                    byArray4[2] = object2[1];
                                    if (byArray4[2] == null || byArray4[3] == null || byArray4[4] == null) throw new SSLException();
                                    bigInteger3 = new BigInteger(byArray4[3]);
                                    bigInteger2 = new BigInteger(byArray4[4]);
                                    bigInteger = new BigInteger("1");
                                    BigInteger bigInteger4 = new BigInteger(byArray4[2]);
                                    byArray4[1] = bigInteger4.modInverse(bigInteger3.subtract(bigInteger).multiply(bigInteger2.subtract(bigInteger))).toByteArray();
                                } else {
                                    n7 = 0;
                                    while (n7 < 3) {
                                        byArray4[n7] = object2[n7];
                                        ++n7;
                                    }
                                }
                            }
                            object[1] = Vault.toBigIntegerArray(byArray4);
                        }
                        ++n3;
                    }
                    Object object5 = object;
                } else if (n9 == 0 || n9 == 1) {
                    if (bl4) {
                        n += this.readAlias(byArray, n, n9 == 0 ? this.certAliases : this.siteAliases);
                    }
                    n6 = Util.msbf(byArray, n, 2);
                    object = new byte[n6];
                    System.arraycopy(byArray, n += 2, object, 0, n6);
                    object3 = new SSLCert((byte[])object);
                    n += n6;
                    Object object6 = object3;
                } else if (n9 == 3 || n9 == 4) {
                    Object object7 = object = n9 == 3 ? this.secretAliases : this.peerAliases;
                    if (bl4 && this.ring.length > 4) {
                        n += this.readAlias(byArray, n, (Vector)object);
                    }
                    object3 = new Object[3];
                    n7 = 0;
                    while (n7 < 3) {
                        Long l;
                        n6 = Util.msbf(byArray, n, 2);
                        n += 2;
                        if (n7 < 2) {
                            byte[] byArray6 = new byte[n6];
                            System.arraycopy(byArray, n, byArray6, 0, n6);
                            if (n7 == 1 && byArray3 != null) {
                                Util.util14(byArray3, byArray6, 0, n6, byArray6, 0);
                            }
                            object3[n7] = byArray6;
                        } else if (n6 == 8 && (l = new Long(Util.msbf(byArray, n, 8))) > System.currentTimeMillis()) {
                            object3[2] = l;
                        }
                        n += n6;
                        ++n7;
                    }
                    if (this.ring.length < 4 || object3[2] == null) continue;
                    Object object8 = object3;
                } else if (n9 == 5) {
                    if (bl4) {
                        n += this.readAlias(byArray, n, this.requestAliases);
                    }
                    object = new Object[2];
                    object3 = new byte[Util.msbf(byArray, n, 2)];
                    System.arraycopy(byArray, n + 2, object3, 0, ((Object[])object3).length);
                    n += 2 + ((Object[])object3).length;
                    SSLCert sSLCert = new SSLCert((byte[])object3);
                    object[0] = sSLCert;
                    n8 = byArray[n++];
                    byte[][] byArray7 = new byte[n8][];
                    n7 = 0;
                    while (n7 < n8) {
                        n6 = Util.msbf(byArray, n, 2);
                        if (n6 != 0) {
                            byArray7[n7] = new byte[n6];
                            System.arraycopy(byArray, n + 2, byArray7[n7], 0, n6);
                            if (byArray3 != null) {
                                Util.util14(byArray3, byArray7[n7], 0, n6, byArray7[n7], 0);
                                byte[] byArray8 = byArray7[n7];
                                byArray8[0] = (byte)(byArray8[0] ^ byArray7[n7][n6 - 1]);
                            }
                        }
                        n += n6 + 2;
                        ++n7;
                    }
                    if (byArray3 != null && byArray7[0] == null) {
                        byArray4 = sSLCert.key();
                        if (sSLCert.alg == 1) {
                            byArray7[0] = byArray4[0];
                            byArray7[2] = byArray4[1];
                            if (byArray7[2] == null || byArray7[3] == null || byArray7[4] == null) throw new SSLException();
                            object2 = new BigInteger(byArray7[3]);
                            bigInteger3 = new BigInteger(byArray7[4]);
                            bigInteger2 = new BigInteger("1");
                            bigInteger = new BigInteger(byArray7[2]);
                            byArray7[1] = bigInteger.modInverse(((BigInteger)object2).subtract(bigInteger2).multiply(bigInteger3.subtract(bigInteger2))).toByteArray();
                        } else {
                            n7 = 0;
                            while (n7 < 3) {
                                byArray7[n7] = byArray4[n7];
                                ++n7;
                            }
                        }
                    }
                    object[1] = Vault.toBigIntegerArray(byArray7);
                    Object object9 = object;
                } else {
                    if (n9 != 255) throw new SSLException(7, 1012, 1);
                    if (!bl4) {
                        this.makeAliases(this.ring[0], this.certAliases, 0);
                        this.makeAliases(this.ring[1], this.siteAliases, 1);
                        this.makeAliases(this.ring[2], this.privateAliases, 2);
                        this.makeAliases(this.ring[3], this.secretAliases, 3);
                        this.makeAliases(this.ring[4], this.peerAliases, 4);
                        this.makeAliases(this.requests, this.requestAliases, 5);
                    }
                    this.certAliases = this.ensureUnique(this.certAliases, 0);
                    this.siteAliases = this.ensureUnique(this.siteAliases, 1);
                    this.privateAliases = this.ensureUnique(this.privateAliases, 2);
                    this.secretAliases = this.ensureUnique(this.secretAliases, 3);
                    this.peerAliases = this.ensureUnique(this.peerAliases, 4);
                    this.requestAliases = this.ensureUnique(this.requestAliases, 5);
                    return true;
                }
                object = null;
                object3 = null;
                if (n9 == 5) {
                    if (this.requests == null) {
                        this.requests = new Vector();
                    }
                    object3 = this.requests;
                } else {
                    if (this.ring[n9] == null) {
                        this.ring[n9] = new Vector();
                    }
                    object3 = this.ring[n9];
                }
                if (n9 == 0) {
                    object = this.certAliases;
                } else if (n9 == 1) {
                    object = this.siteAliases;
                } else if (n9 == 2) {
                    object = this.privateAliases;
                } else {
                    if (n9 != 5) throw new SSLException();
                    object = this.requestAliases;
                }
                String string2 = null;
                if (bl4) {
                    string2 = (String)((Vector)object).elementAt(((Vector)object).size() - 1);
                }
                n7 = 0;
                while (n7 < (n6 = ((Vector)object3).size())) {
                    Object e = ((Vector)object3).elementAt(n7);
                    if (n9 == 2) {
                        if (((SSLCert[])((Object[])e)[0])[0].equals(((SSLCert[])((Object[])var15_28)[0])[0]) && (!bl4 || ((Vector)object).elementAt(n7).equals(string2))) {
                            break;
                        }
                    } else if (n9 != 5 ? n9 < 2 && ((SSLCert)e).equals((SSLCert)var15_28) && (!bl4 || ((Vector)object).elementAt(n7).equals(string2)) : ((SSLCert)((Object[])e)[0]).equals((SSLCert)((Object[])var15_28)[0]) && (!bl4 || ((Vector)object).elementAt(n7).equals(string2))) break;
                    ++n7;
                }
                if (n7 == n6 && (n9 == 0 && bl || n9 == 1 && bl2 || bl3)) {
                    ((Vector)object3).addElement(var15_28);
                    continue;
                }
                if (!bl4) continue;
                ((Vector)object).removeElementAt(((Vector)object).size() - 1);
            } while (n < n2);
            throw new SSLException(7, 1012, 1);
        }
        catch (SSLException sSLException) {
            if (!this.debug) throw sSLException;
            sSLException.printStackTrace();
            throw sSLException;
        }
        catch (Exception exception) {}
        throw new SSLException(7, 1012, 1);
    }

    synchronized boolean importKeyRings(String string, String string2) throws SSLException {
        boolean bl;
        if (string.length() == 0) {
            return true;
        }
        byte[] byArray = Vault.xform7bitTo8bit(string);
        try {
            bl = this.importKeyRings(byArray, 0, byArray.length, string2);
        }
        catch (SSLException sSLException) {
            if (sSLException.getCategory() == 7 && sSLException.getError() == 1012) {
                if (sSLException.getInt1() == 4) {
                    sSLException.setInt1(2);
                } else {
                    sSLException.setInt1(1);
                }
            }
            throw sSLException;
        }
        return bl;
    }

    private static byte[] xform7bitTo8bit(String string) {
        byte[] byArray = new byte[string.length() * 7 / 8];
        int n = 0;
        do {
            byArray[n] = Util.getBits(string, n * 8, 8);
        } while (++n < byArray.length);
        return byArray;
    }

    synchronized byte[] exportKeyRings(String string) throws SSLException {
        int n = 81920;
        byte[] byArray = new byte[16];
        byte[] byArray2 = Vault.secret(string, byArray, 0, true);
        byte[] byArray3 = null;
        try {
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            Object object2;
            int n6;
            Vector vector;
            byte[] byArray4 = new byte[n];
            int n7 = 0;
            int n8 = 0;
            byArray4[n7++] = -2;
            if (byArray2 != null) {
                byArray3 = Util.util13(byArray2, 0, 16);
                byArray4[n7] = -1;
                System.arraycopy(byArray, 0, byArray4, n7 + 1, 16);
                n7 += 17;
            }
            n *= 2;
            do {
                if ((vector = this.ring[n8]) == null || vector.size() <= 0) continue;
                n6 = 0;
                do {
                    if (n8 == 2) {
                        byArray4[n7++] = (byte)n8;
                        if (this.privateAliases != null && n6 < this.privateAliases.size()) {
                            n7 += this.writeLabel((String)this.privateAliases.elementAt(n6), byArray4, n7);
                        } else {
                            throw new SSLException();
                        }
                        object2 = (SSLCert[])((Object[])vector.elementAt(n6))[0];
                        byArray4[n7++] = (byte)((Object)object2).length;
                        n5 = 0;
                        do {
                            int n9 = n4 = ((SSLCert)object2[n5]).x509.length;
                            n3 = n7;
                            n2 = 2;
                            do {
                                byArray4[n3++] = (byte)(n9 >>> --n2 * 8);
                            } while (n2 > 0);
                            System.arraycopy(object2[n5].x509, 0, byArray4, n7 + 2, n4);
                            n7 += 2 + n4;
                        } while (++n5 < ((byte[])object2).length);
                        object = Vault.toByteArrays((BigInteger[])((Object[])vector.elementAt(n6))[1]);
                        byArray4[n7++] = (byte)((Object)object).length;
                        n5 = 0;
                        do {
                            n4 = object2[0].alg == 1 && (n5 == 0 || n5 == 2 || n5 == 1 && ((Object)object).length == 8) || object2[0].alg != 1 && n5 != 3 ? 0 : ((Object)object[n5]).length;
                            n3 = n7;
                            n2 = 2;
                            do {
                                byArray4[n3++] = (byte)(n4 >>> --n2 * 8);
                            } while (n2 > 0);
                            n7 += 2;
                            if (n4 == 0) continue;
                            System.arraycopy(object[n5], 0, byArray4, n7, n4);
                            if (byArray3 != null) {
                                int n10 = n7;
                                byArray4[n10] = (byte)(byArray4[n10] ^ byArray4[n7 + n4 - 1]);
                                Util.util14(byArray3, byArray4, n7, n4, byArray4, n7);
                            }
                            n7 += n4;
                        } while (++n5 < ((Object)object).length);
                        continue;
                    }
                    if (n8 >= 2) continue;
                    byArray4[n7++] = (byte)n8;
                    object2 = n8 == 0 ? this.certAliases : this.siteAliases;
                    if (object2 != null && n6 < object2.size()) {
                        n7 += this.writeLabel((String)object2.elementAt(n6), byArray4, n7);
                    } else {
                        throw new SSLException();
                    }
                    object = (SSLCert)vector.elementAt(n6);
                    n3 = n4 = ((SSLCert)object).x509.length;
                    n2 = n7;
                    int n11 = 2;
                    do {
                        byArray4[n2++] = (byte)(n3 >>> --n11 * 8);
                    } while (n11 > 0);
                    System.arraycopy(((SSLCert)object).x509, 0, byArray4, n7 + 2, n4);
                    n7 += 2 + n4;
                } while (++n6 < vector.size());
            } while (++n8 < this.ring.length);
            if (this.requests != null && this.requests.size() > 0) {
                vector = this.requests;
                n6 = 0;
                do {
                    byArray4[n7++] = 5;
                    if (this.requestAliases != null && n6 < this.requestAliases.size()) {
                        n7 += this.writeLabel((String)this.requestAliases.elementAt(n6), byArray4, n7);
                    } else {
                        throw new SSLException();
                    }
                    object2 = ((SSLCert)((Object[])vector.elementAt((int)n6))[0]).x509;
                    int n12 = ((byte[])object2).length;
                    n3 = n7;
                    n2 = 2;
                    do {
                        byArray4[n3++] = (byte)(n12 >>> --n2 * 8);
                    } while (n2 > 0);
                    System.arraycopy(object2, 0, byArray4, n7 += 2, ((byte[])object2).length);
                    n7 += ((byte[])object2).length;
                    object = Vault.toByteArrays((BigInteger[])((Object[])vector.elementAt(n6))[1]);
                    byArray4[n7++] = (byte)((Object)object).length;
                    n5 = 0;
                    do {
                        n4 = object[n5] == null ? 0 : ((Object)object[n5]).length;
                        n3 = n7;
                        n2 = 2;
                        do {
                            byArray4[n3++] = (byte)(n4 >>> --n2 * 8);
                        } while (n2 > 0);
                        n7 += 2;
                        if (n4 == 0) continue;
                        System.arraycopy(object[n5], 0, byArray4, n7, n4);
                        if (byArray3 != null) {
                            int n13 = n7;
                            byArray4[n13] = (byte)(byArray4[n13] ^ byArray4[n7 + n4 - 1]);
                            Util.util14(byArray3, byArray4, n7, n4, byArray4, n7);
                        }
                        n7 += n4;
                    } while (++n5 < ((Object)object).length);
                } while (++n6 < this.requests.size());
            }
            byArray4[n7++] = -1;
            if (byArray2 != null) {
                Vault.mac(byArray2, 0, byArray4, 1, n7 - 1, byArray4, n7);
                n7 += 16;
            }
            object2 = new byte[n7];
            System.arraycopy(byArray4, 0, object2, 0, n7);
            return object2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SSLException();
        }
    }

    private int writeLabel(String string, byte[] byArray, int n) {
        byte[] byArray2 = null;
        try {
            byArray2 = string == null ? "".getBytes("UTF8") : string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        byArray[n++] = 12;
        int n2 = byArray2.length;
        int n3 = n;
        int n4 = 2;
        do {
            byArray[n3++] = (byte)(n2 >>> --n4 * 8);
        } while (n4 > 0);
        System.arraycopy(byArray2, 0, byArray, n + 2, byArray2.length);
        return byArray2.length + 3;
    }

    private static final byte[][] toByteArrays(BigInteger[] bigIntegerArray) {
        byte[][] byArray = new byte[bigIntegerArray.length][];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte[])(bigIntegerArray[n] == null ? null : bigIntegerArray[n].toByteArray());
            ++n;
        }
        return byArray;
    }

    private static final BigInteger[] toBigIntegerArray(byte[][] byArray) {
        BigInteger[] bigIntegerArray = new BigInteger[byArray.length];
        int n = 0;
        while (n < bigIntegerArray.length) {
            bigIntegerArray[n] = byArray[n] == null ? null : new BigInteger(byArray[n]);
            ++n;
        }
        return bigIntegerArray;
    }

    static {
        int n = 0;
        do {
            Vault.Pad1[n] = 54;
            Vault.Pad2[n] = 92;
        } while (++n < 48);
    }
}

