/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino;

import java.io.PrintStream;
import java.io.PrintWriter;
import lotus.domino.AgentInfo;
import lotus.domino.DebugAgentBase;
import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.NotesThread;
import lotus.domino.Session;
import lotus.notes.AgentThreadGroup;
import lotus.notes.internal.AgentOutputStream;

public class AgentBase
extends NotesThread {
    private boolean m_debug = false;
    private AgentInfo m_ai;
    private PrintWriter m_agentOutput;
    Session m_session;

    private static ThreadGroup getUserThreadGroup() {
        AgentThreadGroup agentThreadGroup = NotesThread.getAgentThreadGroup();
        if (agentThreadGroup != null) {
            return agentThreadGroup.getUserThreadGroup();
        }
        return null;
    }

    private static String getAgentName() {
        AgentThreadGroup agentThreadGroup = NotesThread.getAgentThreadGroup();
        if (agentThreadGroup != null) {
            return agentThreadGroup.getAgentName();
        }
        return "???";
    }

    public AgentBase() {
        super(AgentBase.getUserThreadGroup(), "AgentThread: " + AgentBase.getAgentName());
    }

    public final void startup(AgentInfo agentInfo) {
        try {
            this.m_ai = agentInfo;
            this.dbgMsg("m_restricted = " + this.m_ai.isRestricted());
            this.dbgMsg("m_timeout    = " + this.m_ai.getTimeout());
            this.start();
            return;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(JavaString.getString("agent_base_error")) + " " + exception);
            exception.printStackTrace(System.err);
            return;
        }
        catch (Error error) {
            System.err.println(String.valueOf(JavaString.getString("agent_base_error")) + " " + error);
            error.printStackTrace(System.err);
            throw error;
        }
    }

    public final void runNotes() throws NotesException {
        this.dbgMsg("Inside AgentBase.runNotes()...");
        this.m_session = this.m_ai.getSession();
        this.dbgMsg("m_session = " + this.m_ai.getSession());
        if (this instanceof DebugAgentBase) {
            this.getSession();
            return;
        }
        this.NotesMain();
    }

    public void NotesMain() {
    }

    public Session getSession() {
        return this.m_session;
    }

    public static Session getAgentSession() {
        AgentThreadGroup agentThreadGroup = NotesThread.getAgentThreadGroup();
        if (agentThreadGroup != null) {
            AgentInfo agentInfo = (AgentInfo)agentThreadGroup.getAgentInfo();
            return agentInfo.getSession();
        }
        return null;
    }

    public boolean isRestricted() {
        return this.m_ai.isRestricted();
    }

    public PrintWriter getAgentOutput() {
        if (this.m_agentOutput == null) {
            this.m_agentOutput = AgentOutputStream.getAgentOutput(this.m_ai.redirectAgentOutput(), this.m_ai.getDocID());
        }
        return this.m_agentOutput;
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public void setTrace(boolean bl) {
        Runtime.getRuntime().traceMethodCalls(bl);
    }

    public void dbgMsg(String string, PrintStream printStream) {
        if (this.m_debug) {
            printStream.println("dbg: " + string);
        }
    }

    public void dbgMsg(String string, PrintWriter printWriter) {
        if (this.m_debug) {
            printWriter.println("dbg: " + string);
        }
    }

    public void dbgMsg(String string) {
        if (this.m_debug) {
            this.dbgMsg(string, System.out);
        }
    }
}

