/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino;

import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import lotus.domino.AgentInfo;
import lotus.domino.AgentLauncher;
import lotus.domino.JavaString;
import lotus.domino.NotesThread;
import lotus.notes.AgentSecurityManager;
import lotus.notes.AgentThreadGroup;

public class AgentLoader
extends ClassLoader {
    private Hashtable files = new Hashtable();
    private AgentThreadGroup m_atg;
    private Thread m_thread;
    private static Frame m_frame = null;
    private static boolean m_staticVariablesInitialized;

    public AgentLoader() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!m_staticVariablesInitialized) {
                try {
                    m_frame = new Frame();
                }
                catch (Throwable throwable) {}
                m_staticVariablesInitialized = true;
            }
            return;
        }
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            try {
                return this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2;
                byte[] byArray;
                if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                    securityManager.checkPackageDefinition(string.substring(0, n));
                }
                if ((byArray = (byte[])this.files.get(string2 = String.valueOf(string.replace('.', '/')) + ".class")) == null) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.defineClass(null, byArray, 0, byArray.length);
                this.files.remove(string2);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public void addAttachment(String string, byte[] byArray) {
        if (string.endsWith(".zip") || string.endsWith(".jar") || string.endsWith(".Zip") || string.endsWith(".Jar") || string.endsWith(".ZIP") || string.endsWith(".JAR")) {
            this.explodeArchive(string, byArray);
            return;
        }
        if (!this.files.containsKey(string)) {
            this.files.put(string, byArray);
        }
    }

    private native boolean checkECLMQ(long var1);

    private native boolean getBreakStatus();

    public void runAgent(String string, long l, int n, boolean bl, long l2, boolean bl2) {
        try {
            Object object;
            Class<?> clazz;
            try {
                Class<?> clazz2 = this.findSystemClass("lotus.notes.AgentBase");
                clazz2 = this.findSystemClass("lotus.domino.AgentBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(JavaString.getString("error_loading_base_class"));
                return;
            }
            String string2 = ".class";
            if (string.endsWith(string2)) {
                int n2 = string.length() - string2.length();
                string = string.substring(0, n2);
            }
            string = string.replace('/', '.');
            try {
                clazz = this.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(JavaString.getFormattedString("error_loading_base_class2", string));
                classNotFoundException.printStackTrace(System.err);
                return;
            }
            Class<?> clazz3 = clazz;
            int n3 = 0;
            while (n3 < 500) {
                Class<?> clazz4 = clazz3.getSuperclass();
                if (clazz4 == null) {
                    System.err.println(JavaString.getString("error_loading_base_class"));
                    return;
                }
                if (clazz4.getName().equals("lotus.domino.AgentBase")) {
                    this.m_thread = this.setupAgent(string, clazz, l, n, bl, l2, bl2);
                    break;
                }
                if (clazz4.getName().equals("lotus.notes.AgentBase")) {
                    lotus.notes.AgentLoader agentLoader = new lotus.notes.AgentLoader();
                    this.m_thread = agentLoader.setupAgent(string, clazz, l, n, bl, l2, bl2);
                    break;
                }
                if (clazz4.getName().equals("java.lang.Object")) {
                    System.err.println(JavaString.getString("error_loading_base_class"));
                    return;
                }
                clazz3 = clazz4;
                ++n3;
            }
            if (this.m_thread == null) {
                return;
            }
            this.m_atg = (AgentThreadGroup)this.m_thread.getThreadGroup();
            long l3 = System.currentTimeMillis() + l * 1000L;
            this.m_thread.start();
            while (this.m_thread.isAlive() && !this.getBreakStatus() && (l == 0L || System.currentTimeMillis() < l3)) {
                try {
                    if (this.checkECLMQ(1000L)) continue;
                    this.m_thread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            if (this.m_thread.isAlive() && (object = this.m_atg.getUserThreadGroup()) != null) {
                ((ThreadGroup)object).stop();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_atg.stop();
            while (this.m_atg.getActiveNotesThreadCount() > 0) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
                this.m_atg.stop();
            }
            if (this.m_atg.activeCount() > 0) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                object = (AgentSecurityManager)System.getSecurityManager();
                if (object != null) {
                    ((AgentSecurityManager)object).removeSecurityContext(this.m_atg);
                }
            }
            catch (ClassCastException classCastException) {}
            try {
                this.m_atg.destroy();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            System.err.println(JavaString.getFormattedString("error_executing_agent", string));
            System.err.println("-->" + throwable);
            throwable.printStackTrace(System.err);
            return;
        }
    }

    private void explodeArchive(String string, byte[] byArray) {
        try {
            this.files.put(string, byArray);
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string2 = zipEntry.getName();
                if (!(zipEntry.isDirectory() || string2.equals("META-INF/MANIFEST.MF") || string2.equals("META-INF/INDEX.LIST"))) {
                    int n;
                    byte[] byArray2 = new byte[1024];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n = zipInputStream.read(byArray2, 0, byArray2.length)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    if (!this.files.containsKey(string2)) {
                        this.files.put(string2, byArray3);
                    }
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            return;
        }
        catch (ZipException zipException) {
            System.err.println(JavaString.getFormattedString("ZipException_reading_attachment", string));
            System.err.println("--> " + zipException);
            zipException.printStackTrace(System.err);
            return;
        }
        catch (IOException iOException) {
            System.err.println(JavaString.getFormattedString("IOException_reading_attachment", string));
            System.err.println("--> " + iOException);
            iOException.printStackTrace(System.err);
            return;
        }
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        if (this.files.containsKey(string)) {
            byte[] byArray = (byte[])this.files.get(string);
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public Thread setupAgent(String string, Class clazz, long l, int n, boolean bl, long l2, boolean bl2) {
        try {
            AgentInfo agentInfo = new AgentInfo(string, clazz, l, n, bl, l2, bl2);
            AgentLauncher agentLauncher = new AgentLauncher(agentInfo);
            AgentThreadGroup agentThreadGroup = new AgentThreadGroup(string, agentInfo);
            agentInfo.newSecurityContext(agentThreadGroup);
            return new NotesThread(agentThreadGroup, agentLauncher, "Launcher: " + string);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            System.err.println(JavaString.getFormattedString("error_executing_agent", string));
            System.err.println("-->" + throwable);
            throwable.printStackTrace(System.err);
            return null;
        }
    }
}

