/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino;

import lotus.domino.Base;
import lotus.domino.Database;
import lotus.domino.DebugAgentBase;
import lotus.domino.Document;
import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;

public class AgentRunner
extends NotesThread {
    private static final String ARVersion = "Agent Runner Release 2.0";
    private static String dumpAgentContextFile = "AgentRunner.nsf";
    private static String argServer;
    private static String argDatabase;
    private static String argAgent;
    private String keyServer;
    private String keyDatabase;
    private String keyAgent;
    private String agentClassName;

    public static void main(String[] stringArray) throws Exception {
        AgentRunner agentRunner = new AgentRunner();
        if (stringArray.length > 3) {
            System.out.println(JavaString.getString("too_many_arguments"));
            System.out.println(JavaString.getFormattedString("usage", " java AgentRunner <agent> [<database> [<server>]]"));
            return;
        }
        if (stringArray.length == 0) {
            System.out.println(JavaString.getString("no_arguments"));
            System.out.println(JavaString.getFormattedString("usage", " java AgentRunner <agent> [<database> [<server>]]"));
            return;
        }
        if (stringArray.length > 0) {
            argAgent = stringArray[0];
        }
        if (stringArray.length > 1) {
            argDatabase = stringArray[1];
        }
        if (stringArray.length > 2) {
            argServer = stringArray[2];
        }
        agentRunner.start();
    }

    public void runNotes() {
        try {
            if (this.getAgent()) {
                this.runAgent();
                return;
            }
            System.out.println(JavaString.getString("no_agentcontext_doc_found"));
            System.out.println("   <agent=" + argAgent + ">");
            if (argDatabase != null) {
                System.out.println("   <database=" + argDatabase + ">");
            }
            if (argServer != null) {
                System.out.println("   <server=" + argServer + ">");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getAgent() throws NotesException {
        boolean bl = false;
        Session session = null;
        Database database = null;
        Base base = null;
        Base base2 = null;
        try {
            session = NotesFactory.createSession();
            database = session.getDatabase("", dumpAgentContextFile);
            if (!database.isOpen()) {
                throw new NotesException(0, JavaString.getString("agentcontext_db_not_found"));
            }
            base = database.getView("($AgentContexts)");
            if (base == null) {
                throw new NotesException(0, JavaString.getString("agentcontexts_view_not_found"));
            }
            base2 = base.getFirstDocument();
            while (base2 != null) {
                this.keyAgent = base2.getItemValueString("CurrentAgent");
                this.keyDatabase = base2.getItemValueString("CurrentDatabase_FilePath");
                String string = base2.getItemValueString("CurrentDatabase_Server");
                this.keyServer = string == null || string.equals("") ? "local" : string;
                if (argAgent.equalsIgnoreCase(this.keyAgent) && (argDatabase == null || argDatabase.equalsIgnoreCase(this.keyDatabase)) && (argServer == null || argServer.equalsIgnoreCase(this.keyServer))) {
                    this.agentClassName = base2.getItemValueString("ClassName");
                    bl = true;
                    break;
                }
                base2 = base.getNextDocument((Document)base2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (base2 != null) {
            base2.recycle();
        }
        if (base != null) {
            base.recycle();
        }
        if (database != null) {
            database.recycle();
        }
        if (session != null) {
            session.recycle();
        }
        return bl;
    }

    public void runAgent() {
        try {
            Class<?> clazz = Class.forName(this.agentClassName);
            DebugAgentBase debugAgentBase = (DebugAgentBase)clazz.newInstance();
            debugAgentBase.initAgentRunner(this.keyServer, this.keyDatabase, this.keyAgent);
            debugAgentBase.NotesMain();
            debugAgentBase.termAgentRunner();
            return;
        }
        catch (Exception exception) {
            System.out.println(JavaString.getFormattedString("agent_class_not_found", this.agentClassName));
            return;
        }
    }
}

