/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino;

import java.applet.Applet;
import java.util.Hashtable;
import java.util.Properties;
import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;
import org.omg.CORBA.ORB;

class AppletHelper {
    protected transient boolean m_debug = false;
    private transient boolean isLocal = false;
    private transient boolean destroyed = false;
    private transient ORB orb;
    private transient String IOR;
    private transient Applet myApplet;

    public AppletHelper(Applet applet) {
        this.myApplet = applet;
        this.IOR = this.myApplet.getParameter("NOI_IOR");
        if (this.IOR == null) {
            if (this.m_debug) {
                System.out.println("In AppletHelper constructor for local access");
            }
            NotesThread.sinitThread();
            this.isLocal = true;
            return;
        }
        if (this.m_debug) {
            System.out.println("In AppletHelper constructor for IIOP access");
        }
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("org.omg.CORBA.ORBClass", "com.ibm.CORBA.iiop.ORB");
            if (this.myApplet.getParameter("NOI_SSL") != null) {
                ((Hashtable)properties).put("com.ibm.CORBA.EnableSSLSecurity", "true");
            }
            if (this.myApplet.getParameter("NOI_SSLDEBUG") != null) {
                ((Hashtable)properties).put("com.ibm.CORBA.SSLDebug", "true");
            }
            this.orb = ORB.init((Applet)this.myApplet, (Properties)properties);
            this.isLocal = false;
            return;
        }
        catch (Exception exception) {
            System.out.println(JavaString.getString("exception_initing_orb"));
            exception.printStackTrace();
            return;
        }
    }

    public Session getSession(String string, String string2) throws NotesException {
        Session session;
        if (this.m_debug) {
            System.out.println("In AppletHelper.getSession");
        }
        try {
            session = this.IOR == null ? NotesFactory.createSession() : NotesFactory.createSession(this.myApplet, this.orb, string, string2);
        }
        catch (NotesException notesException) {
            System.err.println(JavaString.getFormattedString("failed_to_get_session", notesException.text));
            throw notesException;
        }
        return session;
    }

    public Session openSession() throws NotesException {
        if (this.m_debug) {
            System.out.println("In AppletHelper.openSession");
        }
        return this.openSession("", "");
    }

    public Session openSession(String string, String string2) throws NotesException {
        if (this.m_debug) {
            System.out.println("In AppletHelper.openSession");
        }
        if (this.isNotesLocal()) {
            NotesThread.sinitThread();
        }
        return this.getSession(string, string2);
    }

    public void closeSession(Session session) throws NotesException {
        if (this.m_debug) {
            System.out.println("In AppletHelper.closeSession");
        }
        session.recycle();
        if (this.isNotesLocal()) {
            NotesThread.stermThread();
        }
    }

    public void destroy() {
        if (this.m_debug) {
            System.out.println("In AppletHelper.destroy" + this + " destroyed: " + this.destroyed + " thread " + Thread.currentThread());
        }
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.isNotesLocal()) {
            NotesThread.stermThread();
        }
        if (this.m_debug) {
            System.out.println("Leaving AppletHelper.destroy" + this + " destroyed: " + this.destroyed + " thread " + Thread.currentThread());
        }
    }

    public boolean isNotesLocal() {
        return this.isLocal;
    }
}

