/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino;

import com.ibm.xml.parsers.DOMParser;
import com.ibm.xml.parsers.NonValidatingDOMParser;
import java.io.IOException;
import lotus.domino.NotesEntityResolver;
import lotus.domino.Session;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Parser
implements ErrorHandler {
    boolean validating;
    DOMParser Vparser;
    NonValidatingDOMParser NVparser;
    NotesEntityResolver resolver;

    public Parser(boolean bl) {
        this.validating = bl;
        this.resolver = new NotesEntityResolver(null);
        if (this.validating) {
            this.Vparser = new DOMParser();
            this.Vparser.setErrorHandler((ErrorHandler)this);
            this.Vparser.setEntityResolver((EntityResolver)this.resolver);
            return;
        }
        this.NVparser = new NonValidatingDOMParser();
        this.NVparser.setErrorHandler((ErrorHandler)this);
        this.NVparser.setEntityResolver((EntityResolver)this.resolver);
    }

    public Document parse(Session session, InputSource inputSource) throws IOException, SAXException {
        Document document;
        this.resolver.setNotesSession(session);
        try {
            if (this.validating) {
                this.Vparser.parse(inputSource);
                Document document2 = this.Vparser.getDocument();
                Object var5_5 = null;
                this.resolver.setNotesSession(null);
                return document2;
            }
            this.NVparser.parse(inputSource);
            document = this.NVparser.getDocument();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.resolver.setNotesSession(null);
            throw throwable;
        }
        Object var5_6 = null;
        this.resolver.setNotesSession(null);
        return document;
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[WARNING] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[ERROR] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[FATAL ERROR] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n;
            if (string.toLowerCase().startsWith("file:") && (n = string.toLowerCase().indexOf("notes:")) > 0) {
                string = string.substring(n);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(" Line:" + sAXParseException.getLineNumber());
        stringBuffer.append(" Column:" + sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }
}

