/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.ACLEntry;
import lotus.domino.Database;
import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.local.NotesBase;

public class ACL
extends NotesBase
implements lotus.domino.ACL {
    private transient lotus.domino.local.Database database;
    private transient Vector entrylist;
    private transient lotus.domino.local.ACLEntry currEntry;

    private native int NgetFirstEntry();

    private native int NgetNextEntry(ACLEntry var1);

    private native int NgetEntry(String var1);

    private native void Nsave();

    private native void NrenameRole(String var1, String var2);

    private native void NaddRole(String var1);

    private native void NdeleteRole(String var1);

    private native int NcreateACLEntry(String var1, int var2);

    ACL() throws NotesException {
    }

    ACL(lotus.domino.local.Database database, int n) throws NotesException {
        super(n, 13);
        if (database == null) {
            throw new NotesException(4405, JavaString.getString("missing_db_object"));
        }
        this.database = database;
        this.entrylist = new Vector(3);
        database.AddObject(this);
    }

    void InternalFinalize() throws NotesException {
        try {
            try {
                Enumeration enumeration = this.entrylist.elements();
                while (enumeration.hasMoreElements()) {
                    lotus.domino.local.ACLEntry aCLEntry = (lotus.domino.local.ACLEntry)enumeration.nextElement();
                    super.baseDestroyObject(aCLEntry);
                }
            }
            catch (Exception exception) {
            }
            Object var3_3 = null;
            this.entrylist.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.entrylist.removeAllElements();
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public synchronized void finalize() throws NotesException {
        this.database.RemoveObject(this);
        this.InternalFinalize();
    }

    void AddEntry(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.entrylist;
        synchronized (vector) {
            this.entrylist.addElement(object);
            return;
        }
    }

    void RemoveEntry(Object object) throws NotesException {
        Vector vector = this.entrylist;
        synchronized (vector) {
            this.entrylist.removeElement(object);
            return;
        }
    }

    lotus.domino.local.ACLEntry FindOrCreateEntry(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.entrylist;
        synchronized (vector) {
            Enumeration enumeration = this.entrylist.elements();
            while (enumeration.hasMoreElements()) {
                lotus.domino.local.ACLEntry aCLEntry = (lotus.domino.local.ACLEntry)enumeration.nextElement();
                if (!aCLEntry.isEqual(n)) continue;
                lotus.domino.local.ACLEntry aCLEntry2 = aCLEntry;
                Object var5_6 = null;
                return aCLEntry2;
            }
        }
        return new lotus.domino.local.ACLEntry(this, n);
    }

    void InternalRecycle() throws NotesException {
        try {
            try {
                Enumeration enumeration = this.entrylist.elements();
                while (enumeration.hasMoreElements()) {
                    lotus.domino.local.ACLEntry aCLEntry = (lotus.domino.local.ACLEntry)enumeration.nextElement();
                    aCLEntry.InternalFinalize();
                }
            }
            catch (Exception exception) {
            }
            Object var3_3 = null;
            this.entrylist.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.entrylist.removeAllElements();
            super.Recycle();
            throw throwable;
        }
        super.Recycle();
    }

    public synchronized void recycle() throws NotesException {
        try {
            this.database.RemoveObject(this);
            this.InternalRecycle();
            return;
        }
        catch (NotesException notesException) {
            return;
        }
    }

    public ACLEntry getFirstEntry() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            lotus.domino.local.ACLEntry aCLEntry = this.currEntry = this.FindOrCreateEntry(this.NgetFirstEntry());
            Object var3_3 = null;
            return aCLEntry;
        }
    }

    public ACLEntry getNextEntry(ACLEntry aCLEntry) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            if (aCLEntry == null) {
                throw new NotesException(4467, JavaString.getString("missing_aclentry_object"));
            }
            try {
                ((NotesBase)((Object)aCLEntry)).CheckObject();
            }
            catch (NotesException notesException) {
                if (notesException.id == 4376) {
                    throw new NotesException(4466, JavaString.getString("arg_deleted"));
                }
                throw notesException;
            }
            lotus.domino.local.ACLEntry aCLEntry2 = this.currEntry = this.FindOrCreateEntry(this.NgetNextEntry(aCLEntry));
            Object var4_5 = null;
            return aCLEntry2;
        }
    }

    public ACLEntry getNextEntry() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            lotus.domino.local.ACLEntry aCLEntry = this.currEntry = this.FindOrCreateEntry(this.NgetNextEntry(this.currEntry));
            Object var3_3 = null;
            return aCLEntry;
        }
    }

    public ACLEntry getEntry(String string) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            lotus.domino.local.ACLEntry aCLEntry = this.currEntry = this.FindOrCreateEntry(this.NgetEntry(string));
            Object var4_4 = null;
            return aCLEntry;
        }
    }

    public void save() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.Nsave();
            return;
        }
    }

    public void renameRole(String string, String string2) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.NrenameRole(string, string2);
            return;
        }
    }

    public void addRole(String string) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.NaddRole(string);
            return;
        }
    }

    public void deleteRole(String string) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.NdeleteRole(string);
            return;
        }
    }

    public ACLEntry createACLEntry(String string, int n) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            lotus.domino.local.ACLEntry aCLEntry = this.FindOrCreateEntry(this.NcreateACLEntry(string, n));
            Object var5_5 = null;
            return aCLEntry;
        }
    }

    public void removeACLEntry(String string) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            int n = this.NgetEntry(string);
            if (n == 0) {
                throw new NotesException(4429, JavaString.getString("entry_not_in_acl"));
            }
            lotus.domino.local.ACLEntry aCLEntry = this.FindOrCreateEntry(n);
            aCLEntry.remove();
            return;
        }
    }

    public Vector getRoles() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            Vector<String> vector;
            String[] stringArray = this.PropGetStringArray(1400);
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector(stringArray.length, 1);
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            } else {
                vector = new Vector<String>(1);
            }
            Vector<String> vector2 = vector;
            Object var4_6 = null;
            return vector2;
        }
    }

    public Database getParent() throws NotesException {
        this.CheckObject();
        return this.database;
    }

    public boolean isUniformAccess() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            boolean bl = this.PropGetBool(1423);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setUniformAccess(boolean bl) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.PropSetBool(1423, bl);
            return;
        }
    }

    public int getInternetLevel() throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            int n = this.PropGetInt(1463);
            Object var3_3 = null;
            return n;
        }
    }

    public void setInternetLevel(int n) throws NotesException {
        this.CheckObject();
        ACL aCL = this;
        synchronized (aCL) {
            this.PropSetInt(1463, n);
            return;
        }
    }
}

