/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import lotus.domino.Database;
import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.local.DateTime;
import lotus.domino.local.NotesBase;
import lotus.domino.local.Session;

public class Agent
extends NotesBase
implements lotus.domino.Agent {
    private transient lotus.domino.local.Database database;

    private native int Nrun(boolean var1, String var2);

    private native void Nremove();

    private native void Nsave();

    private native String NGetNotesUrl();

    Agent() throws NotesException {
    }

    Agent(lotus.domino.local.Database database, int n) throws NotesException {
        super(n, 9);
        if (database == null) {
            throw new NotesException(4405, JavaString.getString("missing_db_object"));
        }
        this.database = database;
        database.AddObject(this);
    }

    void InternalFinalize() throws NotesException {
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.database.RemoveObject(this);
        this.InternalFinalize();
    }

    void InternalRecycle() throws NotesException {
        super.Recycle();
    }

    public void recycle() throws NotesException {
        try {
            this.database.RemoveObject(this);
            this.InternalRecycle();
            return;
        }
        catch (NotesException notesException) {
            return;
        }
    }

    public void run() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.Nrun(false, null);
            return;
        }
    }

    public void run(String string) throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.Nrun(false, string);
            return;
        }
    }

    public int runOnServer() throws NotesException {
        int n = 0;
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            n = this.Nrun(true, null);
        }
        return n;
    }

    public int runOnServer(String string) throws NotesException {
        int n = 0;
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            n = this.Nrun(true, string);
        }
        return n;
    }

    public void remove() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.Nremove();
            this.database.RemoveObject(this);
            this.finalize();
            return;
        }
    }

    public void save() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.Nsave();
            return;
        }
    }

    public String getName() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1110);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getOwner() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1111);
            Object var3_3 = null;
            return string;
        }
    }

    public lotus.domino.DateTime getLastRun() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            int n = this.PropGetDate(1112);
            if (n == 0) {
                lotus.domino.DateTime dateTime = null;
                Object var4_5 = null;
                return dateTime;
            }
            DateTime dateTime = ((Session)this.database.getParent()).FindOrCreateDateTime(n);
            Object var4_6 = null;
            return dateTime;
        }
    }

    public boolean isEnabled() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            boolean bl = this.PropGetBool(1113);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setEnabled(boolean bl) throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.PropSetBool(1113, bl);
            return;
        }
    }

    public String getServerName() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1114);
            Object var3_3 = null;
            return string;
        }
    }

    public void setServerName(String string) throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            this.PropSetString(1114, string);
            return;
        }
    }

    public String getQuery() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1115);
            Object var3_3 = null;
            return string;
        }
    }

    public String getComment() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1116);
            Object var3_3 = null;
            return string;
        }
    }

    public Database getParent() throws NotesException {
        this.CheckObject();
        return this.database;
    }

    public boolean isPublic() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            boolean bl = this.PropGetBool(1118);
            Object var3_3 = null;
            return bl;
        }
    }

    public String getCommonOwner() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1119);
            Object var3_3 = null;
            return string;
        }
    }

    public int getTrigger() throws NotesException {
        this.CheckObject();
        return this.PropGetInt(1124);
    }

    public int getTarget() throws NotesException {
        this.CheckObject();
        return this.PropGetInt(1125);
    }

    public boolean isNotesAgent() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            boolean bl = this.PropGetBool(1126);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isWebAgent() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            boolean bl = this.PropGetBool(1127);
            Object var3_3 = null;
            return bl;
        }
    }

    public String getURL() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.NGetNotesUrl();
            Object var3_3 = null;
            return string;
        }
    }

    public String getParameterDocID() throws NotesException {
        this.CheckObject();
        Agent agent = this;
        synchronized (agent) {
            String string = this.PropGetString(1129);
            Object var3_3 = null;
            return string;
        }
    }
}

