/*
 * Decompiled with CFR 0.152.
 */
package lotus.domino.local;

import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.JavaString;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.local.ACL;
import lotus.domino.local.Agent;
import lotus.domino.local.AgentContext;
import lotus.domino.local.DateTime;
import lotus.domino.local.Document;
import lotus.domino.local.DocumentCollection;
import lotus.domino.local.Form;
import lotus.domino.local.NotesBase;
import lotus.domino.local.Outline;
import lotus.domino.local.Replication;
import lotus.domino.local.View;

public class Database
extends NotesBase
implements lotus.domino.Database {
    private transient lotus.domino.local.Session session;
    private transient Vector doclist;
    private transient Vector viewlist;
    private transient Vector objlist;

    private native int Ncompact();

    private native int NcreateDocument();

    private native int NcreateCopy(String var1, String var2, int var3);

    private native int NcreateFromTemplate(String var1, String var2, boolean var3, int var4);

    private native int NcreateReplica(String var1, String var2);

    private native int NgetDocumentByID(String var1);

    private native int NgetDocumentByUNID(String var1);

    private native int NgetDocumentByURL(String var1, boolean var2, boolean var3, boolean var4, String var5, String var6, String var7, String var8, String var9, boolean var10);

    private native String NgetURLHeaderInfo(String var1, String var2, String var3, String var4, String var5, String var6);

    private native int NgetView(String var1);

    private native void NgrantAccess(String var1, int var2);

    private native int NqueryAccess(String var1);

    private native void Nremove();

    private native boolean Nreplicate(String var1);

    private native void NrevokeAccess(String var1);

    private native void NupdateFTIndex(boolean var1);

    private native int NFTSearch(String var1, int var2, int var3, int var4);

    private native int Nsearch(String var1, DateTime var2, int var3);

    private native int NgetProfileDocument(String var1, String var2);

    private native int NgetFirstProfileDoc(String var1);

    private native int NgetNextProfileDoc();

    private native int NgetProfileDocumentCollection(String var1);

    private native int NgetAgent(String var1);

    private native int NgetForm(String var1);

    private native boolean Nopen();

    private native int NFTDomainSearch(String var1, int var2, int var3, int var4, String var5, int var6, int var7);

    private native int NgetOutline(String var1);

    private native int NcreateOutline(String var1, boolean var2);

    private native void NenableFolder(String var1);

    private native String NGetNotesUrl();

    Database() throws NotesException {
    }

    Database(lotus.domino.local.Session session, int n) throws NotesException {
        super(n, 2);
        if (session == null) {
            throw new NotesException(4404, JavaString.getString("missing_session_object"));
        }
        this.session = session;
        this.doclist = new Vector(3);
        this.viewlist = new Vector(3);
        this.objlist = new Vector(3);
        session.AddDatabase(this);
    }

    void InternalFinalize() throws NotesException {
        Vector vector;
        block37: {
            try {
                try {
                    Enumeration enumeration;
                    vector = this.doclist;
                    synchronized (vector) {
                        enumeration = this.doclist.elements();
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            super.baseDestroyObject((NotesBase)e);
                        }
                    }
                    vector = this.viewlist;
                    synchronized (vector) {
                        enumeration = this.viewlist.elements();
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            super.baseDestroyObject((NotesBase)e);
                        }
                    }
                    vector = this.objlist;
                    synchronized (vector) {
                        enumeration = this.objlist.elements();
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            super.baseDestroyObject((NotesBase)e);
                        }
                    }
                }
                catch (Exception exception) {
                }
                Object var6_7 = null;
                if (this.doclist == null) break block37;
                vector = this.doclist;
            }
            catch (Throwable throwable) {
                Vector vector2;
                Object var6_8 = null;
                if (this.doclist != null) {
                    vector2 = this.doclist;
                    synchronized (vector2) {
                        this.doclist.removeAllElements();
                        this.doclist = null;
                    }
                }
                if (this.viewlist != null) {
                    vector2 = this.viewlist;
                    synchronized (vector2) {
                        this.viewlist.removeAllElements();
                        this.viewlist = null;
                    }
                }
                if (this.objlist != null) {
                    vector2 = this.objlist;
                    synchronized (vector2) {
                        this.objlist.removeAllElements();
                        this.objlist = null;
                    }
                }
                super.finalize();
                throw throwable;
            }
            synchronized (vector) {
                this.doclist.removeAllElements();
                this.doclist = null;
            }
        }
        if (this.viewlist != null) {
            vector = this.viewlist;
            synchronized (vector) {
                this.viewlist.removeAllElements();
                this.viewlist = null;
            }
        }
        if (this.objlist != null) {
            vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeAllElements();
                this.objlist = null;
            }
        }
        super.finalize();
    }

    public void finalize() throws NotesException {
        this.session.RemoveDatabase(this);
        this.InternalFinalize();
    }

    void AddDocument(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.doclist;
        synchronized (vector) {
            this.doclist.addElement(object);
            return;
        }
    }

    void RemoveDocument(Object object) throws NotesException {
        if (this.doclist != null) {
            Vector vector = this.doclist;
            synchronized (vector) {
                this.doclist.removeElement(object);
                return;
            }
        }
    }

    void AddView(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.viewlist;
        synchronized (vector) {
            this.viewlist.addElement(object);
            return;
        }
    }

    void RemoveView(Object object) throws NotesException {
        if (this.viewlist != null) {
            Vector vector = this.viewlist;
            synchronized (vector) {
                this.viewlist.removeElement(object);
                return;
            }
        }
    }

    void AddObject(Object object) throws NotesException {
        this.CheckObject();
        Vector vector = this.objlist;
        synchronized (vector) {
            this.objlist.addElement(object);
            return;
        }
    }

    void RemoveObject(Object object) throws NotesException {
        if (this.objlist != null) {
            Vector vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeElement(object);
                return;
            }
        }
    }

    Document FindOrCreateDocument(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.doclist;
        synchronized (vector) {
            Enumeration enumeration = this.doclist.elements();
            while (enumeration.hasMoreElements()) {
                Document document = (Document)enumeration.nextElement();
                if (!document.isEqual(n)) continue;
                Document document2 = document;
                Object var5_6 = null;
                return document2;
            }
        }
        return new Document(this, n);
    }

    View FindOrCreateView(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.viewlist;
        synchronized (vector) {
            Enumeration enumeration = this.viewlist.elements();
            while (enumeration.hasMoreElements()) {
                View view = (View)enumeration.nextElement();
                if (!view.isEqual(n)) continue;
                View view2 = view;
                Object var5_6 = null;
                return view2;
            }
        }
        return new View(this, n);
    }

    Agent FindOrCreateAgent(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Agent) || !notesBase.isEqual(n)) continue;
                Agent agent = (Agent)notesBase;
                Object var5_6 = null;
                return agent;
            }
        }
        return new Agent(this, n);
    }

    Form FindOrCreateForm(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof Form) || !notesBase.isEqual(n)) continue;
                Form form = (Form)notesBase;
                Object var5_6 = null;
                return form;
            }
        }
        return new Form(this, n);
    }

    DocumentCollection FindOrCreateDocCollection(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof DocumentCollection) || !notesBase.isEqual(n)) continue;
                DocumentCollection documentCollection = (DocumentCollection)notesBase;
                Object var5_6 = null;
                return documentCollection;
            }
        }
        return new DocumentCollection(this, n);
    }

    ACL FindOrCreateACL(int n) throws NotesException {
        this.CheckObject();
        if (n == 0) {
            return null;
        }
        Vector vector = this.objlist;
        synchronized (vector) {
            Enumeration enumeration = this.objlist.elements();
            while (enumeration.hasMoreElements()) {
                NotesBase notesBase = (NotesBase)enumeration.nextElement();
                if (!(notesBase instanceof ACL) || !notesBase.isEqual(n)) continue;
                ACL aCL = (ACL)notesBase;
                Object var5_6 = null;
                return aCL;
            }
        }
        return new ACL(this, n);
    }

    NotesBase FindObject(Vector vector, int n) throws NotesException {
        this.CheckObject();
        NotesBase notesBase = null;
        if (n != 0) {
            Vector vector2 = vector;
            synchronized (vector2) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements() && notesBase == null) {
                    NotesBase notesBase2 = (NotesBase)enumeration.nextElement();
                    if (!notesBase2.isEqual(n)) continue;
                    notesBase = notesBase2;
                }
            }
        }
        return notesBase;
    }

    Replication FindOrCreateReplicationInstance(int n) throws NotesException {
        Replication replication = null;
        NotesBase notesBase = this.FindObject(this.objlist, n);
        replication = notesBase instanceof Replication ? (Replication)notesBase : new Replication(this, n);
        return replication;
    }

    Outline FindOrCreateOutline(int n) throws NotesException {
        NotesBase notesBase = null;
        if (n != 0) {
            notesBase = this.FindObject(this.objlist, n);
            if (notesBase == null) {
                notesBase = new Outline(this.session, this, n);
            } else if (!(notesBase instanceof Outline)) {
                notesBase = null;
            }
        }
        return (Outline)notesBase;
    }

    void InternalRecycle() throws NotesException {
        Vector vector;
        block37: {
            try {
                try {
                    Enumeration enumeration;
                    vector = this.doclist;
                    synchronized (vector) {
                        enumeration = this.doclist.elements();
                        while (enumeration.hasMoreElements()) {
                            Document document = (Document)enumeration.nextElement();
                            document.InternalFinalize();
                        }
                    }
                    vector = this.viewlist;
                    synchronized (vector) {
                        enumeration = this.viewlist.elements();
                        while (enumeration.hasMoreElements()) {
                            View view = (View)enumeration.nextElement();
                            view.InternalFinalize();
                        }
                    }
                    vector = this.objlist;
                    synchronized (vector) {
                        enumeration = this.objlist.elements();
                        while (enumeration.hasMoreElements()) {
                            NotesBase notesBase = (NotesBase)enumeration.nextElement();
                            notesBase.InternalFinalize();
                        }
                    }
                }
                catch (NotesException notesException) {
                }
                Object var6_7 = null;
                if (this.doclist == null) break block37;
                vector = this.doclist;
            }
            catch (Throwable throwable) {
                Vector vector2;
                Object var6_8 = null;
                if (this.doclist != null) {
                    vector2 = this.doclist;
                    synchronized (vector2) {
                        this.doclist.removeAllElements();
                        this.doclist = null;
                    }
                }
                if (this.viewlist != null) {
                    vector2 = this.viewlist;
                    synchronized (vector2) {
                        this.viewlist.removeAllElements();
                        this.viewlist = null;
                    }
                }
                if (this.objlist != null) {
                    vector2 = this.objlist;
                    synchronized (vector2) {
                        this.objlist.removeAllElements();
                        this.objlist = null;
                    }
                }
                super.Recycle();
                throw throwable;
            }
            synchronized (vector) {
                this.doclist.removeAllElements();
                this.doclist = null;
            }
        }
        if (this.viewlist != null) {
            vector = this.viewlist;
            synchronized (vector) {
                this.viewlist.removeAllElements();
                this.viewlist = null;
            }
        }
        if (this.objlist != null) {
            vector = this.objlist;
            synchronized (vector) {
                this.objlist.removeAllElements();
                this.objlist = null;
            }
        }
        super.Recycle();
    }

    public void recycle() throws NotesException {
        boolean bl = false;
        try {
            AgentContext agentContext = (AgentContext)this.session.getAgentContext();
            if (agentContext != null) {
                Database database = (Database)agentContext.getCurrentDatabase();
                if (this.GetCppObj() == database.GetCppObj()) {
                    bl = true;
                }
            }
            if (!bl) {
                this.session.RemoveDatabase(this);
                this.InternalRecycle();
                return;
            }
        }
        catch (NotesException notesException) {}
    }

    public boolean open() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.Nopen();
            Object var3_3 = null;
            return bl;
        }
    }

    public int compact() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.Ncompact();
            Object var3_3 = null;
            return n;
        }
    }

    public lotus.domino.Database createCopy(String string, String string2) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Database database2 = this.session.FindOrCreateDatabase(this.NcreateCopy(string, string2, 0));
            Object var5_5 = null;
            return database2;
        }
    }

    public lotus.domino.Database createCopy(String string, String string2, int n) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Database database2 = this.session.FindOrCreateDatabase(this.NcreateCopy(string, string2, n));
            Object var6_6 = null;
            return database2;
        }
    }

    public lotus.domino.Document createDocument() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.NcreateDocument();
            Document document = this.FindOrCreateDocument(n);
            Object var3_4 = null;
            return document;
        }
    }

    public lotus.domino.Database createFromTemplate(String string, String string2, boolean bl) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Database database2 = this.session.FindOrCreateDatabase(this.NcreateFromTemplate(string, string2, bl, 0));
            Object var6_6 = null;
            return database2;
        }
    }

    public lotus.domino.Database createFromTemplate(String string, String string2, boolean bl, int n) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Database database2 = this.session.FindOrCreateDatabase(this.NcreateFromTemplate(string, string2, bl, n));
            Object var7_7 = null;
            return database2;
        }
    }

    public lotus.domino.Database createReplica(String string, String string2) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Database database2 = this.session.FindOrCreateDatabase(this.NcreateReplica(string, string2));
            Object var5_5 = null;
            return database2;
        }
    }

    public lotus.domino.Document getDocumentByID(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Document document = this.FindOrCreateDocument(this.NgetDocumentByID(string));
            Object var4_4 = null;
            return document;
        }
    }

    public lotus.domino.Document getDocumentByUNID(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Document document = this.FindOrCreateDocument(this.NgetDocumentByUNID(string));
            Object var4_4 = null;
            return document;
        }
    }

    public lotus.domino.Document getDocumentByURL(String string, boolean bl) throws NotesException {
        return this.getDocumentByURL(string, bl, bl, false, null, null, null, null, null, false);
    }

    public lotus.domino.Document getDocumentByURL(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4, String string5, String string6, boolean bl4) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Document document = this.FindOrCreateDocument(this.NgetDocumentByURL(string, bl, bl2, bl3, string2, string3, string4, string5, string6, bl4));
            Object var13_13 = null;
            return document;
        }
    }

    public String getURLHeaderInfo(String string, String string2, String string3, String string4, String string5, String string6) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string7 = this.NgetURLHeaderInfo(string, string2, string3, string4, string5, string6);
            Object var9_9 = null;
            return string7;
        }
    }

    public lotus.domino.View getView(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.NgetView(string);
            View view = this.FindOrCreateView(n);
            Object var4_5 = null;
            return view;
        }
    }

    public void grantAccess(String string, int n) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.NgrantAccess(string, n);
            return;
        }
    }

    public int queryAccess(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.NqueryAccess(string);
            Object var4_4 = null;
            return n;
        }
    }

    public void remove() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.Nremove();
            this.session.RemoveDatabase(this);
            this.finalize();
            return;
        }
    }

    public boolean replicate(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.Nreplicate(string);
            Object var4_4 = null;
            return bl;
        }
    }

    public void revokeAccess(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.NrevokeAccess(string);
            return;
        }
    }

    public void updateFTIndex(boolean bl) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.NupdateFTIndex(bl);
            return;
        }
    }

    public lotus.domino.DocumentCollection FTSearch(String string, int n) throws NotesException {
        return this.FTSearch(string, n, 0, 0);
    }

    public lotus.domino.DocumentCollection FTSearch(String string) throws NotesException {
        return this.FTSearch(string, 0, 0, 0);
    }

    public lotus.domino.DocumentCollection FTSearch(String string, int n, int n2, int n3) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            DocumentCollection documentCollection = this.FindOrCreateDocCollection(this.NFTSearch(string, n, n2, n3));
            Object var7_7 = null;
            return documentCollection;
        }
    }

    public lotus.domino.DocumentCollection search(String string) throws NotesException {
        return this.search(string, null, 0);
    }

    public lotus.domino.DocumentCollection search(String string, lotus.domino.DateTime dateTime) throws NotesException {
        return this.search(string, dateTime, 0);
    }

    public lotus.domino.DocumentCollection search(String string, lotus.domino.DateTime dateTime, int n) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            DocumentCollection documentCollection = this.FindOrCreateDocCollection(this.Nsearch(string, (DateTime)dateTime, n));
            Object var6_6 = null;
            return documentCollection;
        }
    }

    public lotus.domino.Document getProfileDocument(String string, String string2) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Document document = this.FindOrCreateDocument(this.NgetProfileDocument(string, string2));
            Object var5_5 = null;
            return document;
        }
    }

    private lotus.domino.Document getFirstProfileDoc(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Document document = this.FindOrCreateDocument(this.NgetFirstProfileDoc(string));
            Object var4_4 = null;
            return document;
        }
    }

    private lotus.domino.Document getNextProfileDoc() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Document document = this.FindOrCreateDocument(this.NgetNextProfileDoc());
            Object var3_3 = null;
            return document;
        }
    }

    public lotus.domino.DocumentCollection getProfileDocCollection(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            DocumentCollection documentCollection = this.FindOrCreateDocCollection(this.NgetProfileDocumentCollection(string));
            Object var4_4 = null;
            return documentCollection;
        }
    }

    public lotus.domino.Document FTDomainSearch(String string, int n, int n2, int n3, int n4, int n5, String string2) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Document document = this.FindOrCreateDocument(this.NFTDomainSearch(string, n, n4, n5, string2, n2, n3));
            Object var10_10 = null;
            return document;
        }
    }

    public lotus.domino.Outline getOutline(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Outline outline = this.FindOrCreateOutline(this.NgetOutline(string));
            Object var4_4 = null;
            return outline;
        }
    }

    public lotus.domino.Outline createOutline(String string) throws NotesException {
        return this.createOutline(string, false);
    }

    public lotus.domino.Outline createOutline(String string, boolean bl) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Outline outline = this.FindOrCreateOutline(this.NcreateOutline(string, bl));
            Object var5_5 = null;
            return outline;
        }
    }

    public void enableFolder(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.NenableFolder(string);
            return;
        }
    }

    public lotus.domino.Agent getAgent(String string) throws NotesException {
        this.CheckObject();
        return this.FindOrCreateAgent(this.NgetAgent(string));
    }

    public lotus.domino.Form getForm(String string) throws NotesException {
        this.CheckObject();
        return this.FindOrCreateForm(this.NgetForm(string));
    }

    public String getTitle() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.PropGetString(1001);
            Object var3_3 = null;
            return string;
        }
    }

    public void setTitle(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.PropSetString(1001, string);
            return;
        }
    }

    public String getTemplateName() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.PropGetString(1003);
            Object var3_3 = null;
            return string;
        }
    }

    public String getDesignTemplateName() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.PropGetString(1004);
            Object var3_3 = null;
            return string;
        }
    }

    public String getFileName() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.PropGetString(1005);
            Object var3_3 = null;
            return string;
        }
    }

    public String getFilePath() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.PropGetString(1006);
            Object var3_3 = null;
            return string;
        }
    }

    public String toString() {
        String string;
        try {
            string = this.getFilePath();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getReplicaID() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.PropGetString(1012);
            Object var3_3 = null;
            return string;
        }
    }

    public String getServer() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.PropGetString(1501);
            Object var3_3 = null;
            return string;
        }
    }

    public String getCategories() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.PropGetString(1002);
            Object var3_3 = null;
            return string;
        }
    }

    public void setCategories(String string) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.PropSetString(1002, string);
            return;
        }
    }

    public boolean isFTIndexed() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.PropGetBool(1000);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isOpen() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.PropGetBool(1009);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isPublicAddressBook() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.PropGetBool(1015);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isPrivateAddressBook() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.PropGetBool(1016);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isDelayUpdates() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.PropGetBool(1514);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setDelayUpdates(boolean bl) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.PropSetBool(1514, bl);
            return;
        }
    }

    public boolean isMultiDbSearch() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.PropGetBool(1517);
            Object var3_3 = null;
            return bl;
        }
    }

    public Vector getManagers() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            Vector<String> vector;
            String[] stringArray = this.PropGetStringArray(1008);
            if (stringArray != null && stringArray.length > 0) {
                vector = new Vector(stringArray.length, 1);
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            } else {
                vector = new Vector<String>(1);
            }
            Vector<String> vector2 = vector;
            Object var4_6 = null;
            return vector2;
        }
    }

    public Vector getViews() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int[] nArray = this.PropGetObjArray(1010);
            if (nArray == null) {
                Vector vector = new Vector(0);
                Object var3_5 = null;
                return vector;
            }
            Vector<View> vector = new Vector<View>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                View view = this.FindOrCreateView(nArray[n]);
                vector.addElement(view);
                ++n;
            }
            Vector<View> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }

    public Vector getAgents() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int[] nArray = this.PropGetObjArray(1011);
            if (nArray == null) {
                Vector vector = new Vector(0);
                Object var3_5 = null;
                return vector;
            }
            Vector<Agent> vector = new Vector<Agent>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                Agent agent = this.FindOrCreateAgent(nArray[n]);
                vector.addElement(agent);
                ++n;
            }
            Vector<Agent> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }

    public lotus.domino.DocumentCollection getAllDocuments() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.PropGetAdt(1047);
            DocumentCollection documentCollection = this.FindOrCreateDocCollection(n);
            Object var3_4 = null;
            return documentCollection;
        }
    }

    public Vector getForms() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int[] nArray = this.PropGetObjArray(1515);
            if (nArray == null) {
                Vector vector = new Vector(0);
                Object var3_5 = null;
                return vector;
            }
            Vector<Form> vector = new Vector<Form>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                Form form = this.FindOrCreateForm(nArray[n]);
                vector.addElement(form);
                ++n;
            }
            Vector<Form> vector2 = vector;
            Object var3_6 = null;
            return vector2;
        }
    }

    public Session getParent() throws NotesException {
        this.CheckObject();
        return this.session;
    }

    public int getCurrentAccessLevel() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.PropGetInt(1502);
            Object var3_3 = null;
            return n;
        }
    }

    public int getSizeQuota() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.PropGetInt(1504);
            Object var3_3 = null;
            return n;
        }
    }

    public void setSizeQuota(int n) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.PropSetInt(1504, n);
            return;
        }
    }

    public double getSize() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            double d = this.PropGetDouble(1503);
            Object var4_3 = null;
            return d;
        }
    }

    public long getMaxSize() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            long l = this.PropGetULong(1531);
            Object var4_3 = null;
            return l;
        }
    }

    public double getPercentUsed() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            double d = this.PropGetDouble(1506);
            Object var4_3 = null;
            return d;
        }
    }

    public lotus.domino.DateTime getLastModified() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            DateTime dateTime = this.session.FindOrCreateDateTime(this.PropGetDate(1007));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public lotus.domino.DateTime getLastFTIndexed() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            DateTime dateTime = this.session.FindOrCreateDateTime(this.PropGetDate(1014));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public lotus.domino.DateTime getCreated() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            DateTime dateTime = this.session.FindOrCreateDateTime(this.PropGetDate(1018));
            Object var3_3 = null;
            return dateTime;
        }
    }

    public lotus.domino.ACL getACL() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.PropGetAdt(1017);
            ACL aCL = this.FindOrCreateACL(n);
            Object var3_4 = null;
            return aCL;
        }
    }

    public lotus.domino.Replication getReplicationInfo() throws NotesException {
        Replication replication = null;
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            int n = this.PropGetAdt(1564);
            replication = this.FindOrCreateReplicationInstance(n);
        }
        return replication;
    }

    public boolean getFolderReferencesEnabled() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            boolean bl = this.PropGetBool(1530);
            Object var3_3 = null;
            return bl;
        }
    }

    public void setFolderReferencesEnabled(boolean bl) throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            this.PropSetBool(1530, bl);
            return;
        }
    }

    public String getURL() throws NotesException {
        this.CheckObject();
        Database database = this;
        synchronized (database) {
            String string = this.NGetNotesUrl();
            Object var3_3 = null;
            return string;
        }
    }
}

